/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.util.JRClassLoader;

public class JRBaseExpression
implements JRExpression,
Serializable {
    private static final long serialVersionUID = 10200L;
    public String valueClassName = null;
    public String valueClassRealName = null;
    public int id = 0;
    public transient Class valueClass = null;
    private JRExpressionChunk[] chunks = null;
    private static int lastId = 0;

    public JRBaseExpression() {
    }

    public JRBaseExpression(JRExpression jRExpression, JRBaseObjectFactory jRBaseObjectFactory, Integer n2) {
        jRBaseObjectFactory.put(jRExpression, this);
        this.valueClassName = jRExpression.getValueClassName();
        this.id = n2 == null ? jRExpression.getId() : n2.intValue();
        JRExpressionChunk[] jRExpressionChunkArray = jRExpression.getChunks();
        if (jRExpressionChunkArray != null && jRExpressionChunkArray.length > 0) {
            this.chunks = new JRExpressionChunk[jRExpressionChunkArray.length];
            for (int i2 = 0; i2 < this.chunks.length; ++i2) {
                this.chunks[i2] = jRBaseObjectFactory.getExpressionChunk(jRExpressionChunkArray[i2]);
            }
        }
    }

    public JRBaseExpression(JRExpression jRExpression, JRBaseObjectFactory jRBaseObjectFactory) {
        this(jRExpression, jRBaseObjectFactory, null);
    }

    private static synchronized int getNextId() {
        return lastId++;
    }

    public void regenerateId() {
        this.id = JRBaseExpression.getNextId();
    }

    public Class getValueClass() {
        String string;
        if (this.valueClass == null && (string = this.getValueClassRealName()) != null) {
            try {
                this.valueClass = JRClassLoader.loadClassForName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JRRuntimeException(classNotFoundException);
            }
        }
        return this.valueClass;
    }

    public String getValueClassName() {
        return this.valueClassName;
    }

    private String getValueClassRealName() {
        if (this.valueClassRealName == null) {
            this.valueClassRealName = JRClassLoader.getClassRealName(this.valueClassName);
        }
        return this.valueClassRealName;
    }

    public int getId() {
        return this.id;
    }

    public JRExpressionChunk[] getChunks() {
        return this.chunks;
    }

    public String getText() {
        String string = "";
        this.chunks = this.getChunks();
        if (this.chunks != null && this.chunks.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            block6: for (int i2 = 0; i2 < this.chunks.length; ++i2) {
                switch (this.chunks[i2].getType()) {
                    case 2: {
                        stringBuffer.append("$P{");
                        stringBuffer.append(this.chunks[i2].getText());
                        stringBuffer.append("}");
                        continue block6;
                    }
                    case 3: {
                        stringBuffer.append("$F{");
                        stringBuffer.append(this.chunks[i2].getText());
                        stringBuffer.append("}");
                        continue block6;
                    }
                    case 4: {
                        stringBuffer.append("$V{");
                        stringBuffer.append(this.chunks[i2].getText());
                        stringBuffer.append("}");
                        continue block6;
                    }
                    case 5: {
                        stringBuffer.append("$R{");
                        stringBuffer.append(this.chunks[i2].getText());
                        stringBuffer.append("}");
                        continue block6;
                    }
                    default: {
                        String string2 = this.chunks[i2].getText();
                        String string3 = this.escapeTextChunk(string2);
                        stringBuffer.append(string3);
                        continue block6;
                    }
                }
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public String escapeTextChunk(String string) {
        if (string == null || string.indexOf(36) < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 4);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "$", true);
        boolean bl2 = false;
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (bl2 && (string2.startsWith("P{") || string2.startsWith("F{") || string2.startsWith("V{") || string2.startsWith("R{")) && string2.indexOf(125) > 0) {
                stringBuffer.append('$');
            }
            stringBuffer.append(string2);
            bl2 = string2.equals("$");
        }
        return stringBuffer.toString();
    }

    public Object clone() {
        JRBaseExpression jRBaseExpression = null;
        try {
            jRBaseExpression = (JRBaseExpression)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new JRRuntimeException(cloneNotSupportedException);
        }
        if (this.chunks != null) {
            jRBaseExpression.chunks = new JRExpressionChunk[this.chunks.length];
            for (int i2 = 0; i2 < this.chunks.length; ++i2) {
                jRBaseExpression.chunks[i2] = (JRExpressionChunk)this.chunks[i2].clone();
            }
        }
        return jRBaseExpression;
    }
}

