/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRStyledTextAttributeSelector;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBasePrintElement;
import net.sf.jasperreports.engine.util.JRBoxUtil;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import net.sf.jasperreports.engine.util.LineBoxWrapper;

public class JRBasePrintText
extends JRBasePrintElement
implements JRPrintText {
    private static final long serialVersionUID = 10200L;
    public String text = "";
    public Integer textTruncateIndex;
    public String textTruncateSuffix;
    public transient String truncatedText;
    public float lineSpacingFactor = 0.0f;
    public float leadingOffset = 0.0f;
    public Byte horizontalAlignment = null;
    public Byte verticalAlignment = null;
    public Byte rotation = null;
    public byte runDirection = 0;
    public float textHeight = 0.0f;
    public Byte lineSpacing = null;
    public Boolean isStyledText = null;
    public String anchorName = null;
    public byte hyperlinkType = 0;
    private String linkType;
    public byte hyperlinkTarget = 1;
    public String hyperlinkReference = null;
    public String hyperlinkAnchor = null;
    public Integer hyperlinkPage = null;
    public String hyperlinkTooltip;
    public JRPrintHyperlinkParameters hyperlinkParameters;
    public int bookmarkLevel = 0;
    public JRLineBox lineBox = new JRBaseLineBox(this);
    public JRReportFont reportFont = null;
    public String fontName = null;
    public Boolean isBold = null;
    public Boolean isItalic = null;
    public Boolean isUnderline = null;
    public Boolean isStrikeThrough = null;
    public Integer fontSize = null;
    public String pdfFontName = null;
    public String pdfEncoding = null;
    public Boolean isPdfEmbedded = null;
    public String valueClassName;
    public String pattern;
    public String formatFactoryClass;
    public String localeCode;
    public String timeZoneId;
    private Byte border = null;
    private Byte topBorder = null;
    private Byte leftBorder = null;
    private Byte bottomBorder = null;
    private Byte rightBorder = null;
    private Color borderColor = null;
    private Color topBorderColor = null;
    private Color leftBorderColor = null;
    private Color bottomBorderColor = null;
    private Color rightBorderColor = null;
    private Integer padding = null;
    private Integer topPadding = null;
    private Integer leftPadding = null;
    private Integer bottomPadding = null;
    private Integer rightPadding = null;

    public JRBasePrintText(JRDefaultStyleProvider jRDefaultStyleProvider) {
        super(jRDefaultStyleProvider);
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    public String getText() {
        if (this.truncatedText == null && this.text != null) {
            this.truncatedText = this.getTextTruncateIndex() == null ? this.text : (this.isStyledText() ? JRStyledTextParser.getInstance().write(this.getFullStyledText(JRStyledTextAttributeSelector.ALL), 0, this.getTextTruncateIndex()) : this.text.substring(0, this.getTextTruncateIndex()));
            if (this.textTruncateSuffix != null) {
                this.truncatedText = this.truncatedText + this.textTruncateSuffix;
            }
        }
        return this.truncatedText;
    }

    public void setText(String string) {
        this.text = string;
        this.truncatedText = null;
    }

    public Integer getTextTruncateIndex() {
        return this.textTruncateIndex;
    }

    public void setTextTruncateIndex(Integer n2) {
        this.textTruncateIndex = n2;
        this.truncatedText = null;
    }

    public String getTextTruncateSuffix() {
        return this.textTruncateSuffix;
    }

    public void setTextTruncateSuffix(String string) {
        this.textTruncateSuffix = string;
        this.truncatedText = null;
    }

    public String getFullText() {
        String string = this.text;
        if (this.textTruncateIndex == null && this.textTruncateSuffix != null) {
            string = string + this.textTruncateSuffix;
        }
        return string;
    }

    public String getOriginalText() {
        return this.text;
    }

    public JRStyledText getStyledText(JRStyledTextAttributeSelector jRStyledTextAttributeSelector) {
        if (this.getText() == null) {
            return null;
        }
        return JRStyledTextParser.getInstance().getStyledText(jRStyledTextAttributeSelector.getStyledTextAttributes(this), this.getText(), this.isStyledText());
    }

    public JRStyledText getFullStyledText(JRStyledTextAttributeSelector jRStyledTextAttributeSelector) {
        if (this.getFullText() == null) {
            return null;
        }
        return JRStyledTextParser.getInstance().getStyledText(jRStyledTextAttributeSelector.getStyledTextAttributes(this), this.getFullText(), this.isStyledText());
    }

    public float getLineSpacingFactor() {
        return this.lineSpacingFactor;
    }

    public void setLineSpacingFactor(float f2) {
        this.lineSpacingFactor = f2;
    }

    public float getLeadingOffset() {
        return this.leadingOffset;
    }

    public void setLeadingOffset(float f2) {
        this.leadingOffset = f2;
    }

    public byte getTextAlignment() {
        return this.getHorizontalAlignment();
    }

    public void setTextAlignment(byte by2) {
        this.setHorizontalAlignment(by2);
    }

    public byte getHorizontalAlignment() {
        return JRStyleResolver.getHorizontalAlignment(this);
    }

    public Byte getOwnHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(byte by2) {
        this.horizontalAlignment = new Byte(by2);
    }

    public void setHorizontalAlignment(Byte by2) {
        this.horizontalAlignment = by2;
    }

    public byte getVerticalAlignment() {
        return JRStyleResolver.getVerticalAlignment(this);
    }

    public Byte getOwnVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(byte by2) {
        this.verticalAlignment = new Byte(by2);
    }

    public void setVerticalAlignment(Byte by2) {
        this.verticalAlignment = by2;
    }

    public byte getRotation() {
        return JRStyleResolver.getRotation(this);
    }

    public Byte getOwnRotation() {
        return this.rotation;
    }

    public void setRotation(byte by2) {
        this.rotation = new Byte(by2);
    }

    public void setRotation(Byte by2) {
        this.rotation = by2;
    }

    public byte getRunDirection() {
        return this.runDirection;
    }

    public void setRunDirection(byte by2) {
        this.runDirection = by2;
    }

    public float getTextHeight() {
        return this.textHeight;
    }

    public void setTextHeight(float f2) {
        this.textHeight = f2;
    }

    public byte getLineSpacing() {
        return JRStyleResolver.getLineSpacing(this);
    }

    public Byte getOwnLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(byte by2) {
        this.lineSpacing = new Byte(by2);
    }

    public void setLineSpacing(Byte by2) {
        this.lineSpacing = by2;
    }

    public boolean isStyledText() {
        return JRStyleResolver.isStyledText(this);
    }

    public Boolean isOwnStyledText() {
        return this.isStyledText;
    }

    public void setStyledText(boolean bl2) {
        this.setStyledText(bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setStyledText(Boolean bl2) {
        this.isStyledText = bl2;
    }

    public JRBox getBox() {
        return new LineBoxWrapper(this.getLineBox());
    }

    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    public void setBox(JRBox jRBox) {
        JRBoxUtil.setBoxToLineBox(jRBox, this.lineBox);
    }

    public void copyBox(JRLineBox jRLineBox) {
        this.lineBox = jRLineBox.clone(this);
    }

    public JRFont getFont() {
        return this;
    }

    public void setFont(JRFont jRFont) {
        this.reportFont = jRFont.getReportFont();
        this.fontName = jRFont.getOwnFontName();
        this.isBold = jRFont.isOwnBold();
        this.isItalic = jRFont.isOwnItalic();
        this.isUnderline = jRFont.isOwnUnderline();
        this.isStrikeThrough = jRFont.isOwnStrikeThrough();
        this.fontSize = jRFont.getOwnSize();
        this.pdfFontName = jRFont.getOwnPdfFontName();
        this.pdfEncoding = jRFont.getOwnPdfEncoding();
        this.isPdfEmbedded = jRFont.isOwnPdfEmbedded();
    }

    public String getAnchorName() {
        return this.anchorName;
    }

    public void setAnchorName(String string) {
        this.anchorName = string;
    }

    public byte getHyperlinkType() {
        return JRHyperlinkHelper.getHyperlinkType(this.getLinkType());
    }

    public void setHyperlinkType(byte by2) {
        this.setLinkType(JRHyperlinkHelper.getLinkType(by2));
    }

    public byte getHyperlinkTarget() {
        return this.hyperlinkTarget;
    }

    public void setHyperlinkTarget(byte by2) {
        this.hyperlinkTarget = by2;
    }

    public String getHyperlinkReference() {
        return this.hyperlinkReference;
    }

    public void setHyperlinkReference(String string) {
        this.hyperlinkReference = string;
    }

    public String getHyperlinkAnchor() {
        return this.hyperlinkAnchor;
    }

    public void setHyperlinkAnchor(String string) {
        this.hyperlinkAnchor = string;
    }

    public Integer getHyperlinkPage() {
        return this.hyperlinkPage;
    }

    public void setHyperlinkPage(Integer n2) {
        this.hyperlinkPage = n2;
    }

    public void setHyperlinkPage(String string) {
        this.hyperlinkPage = new Integer(string);
    }

    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    public void setBookmarkLevel(int n2) {
        this.bookmarkLevel = n2;
    }

    public byte getBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getPen());
    }

    public Byte getOwnBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getPen());
    }

    public void setBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getPen());
    }

    public void setBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getPen());
    }

    public Color getBorderColor() {
        return this.lineBox.getPen().getLineColor();
    }

    public Color getOwnBorderColor() {
        return this.lineBox.getPen().getOwnLineColor();
    }

    public void setBorderColor(Color color) {
        this.lineBox.getPen().setLineColor(color);
    }

    public int getPadding() {
        return this.lineBox.getPadding();
    }

    public Integer getOwnPadding() {
        return this.lineBox.getOwnPadding();
    }

    public void setPadding(int n2) {
        this.lineBox.setPadding(n2);
    }

    public void setPadding(Integer n2) {
        this.lineBox.setPadding(n2);
    }

    public byte getTopBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getTopPen());
    }

    public Byte getOwnTopBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getTopPen());
    }

    public void setTopBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getTopPen());
    }

    public void setTopBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getTopPen());
    }

    public Color getTopBorderColor() {
        return this.lineBox.getTopPen().getLineColor();
    }

    public Color getOwnTopBorderColor() {
        return this.lineBox.getTopPen().getOwnLineColor();
    }

    public void setTopBorderColor(Color color) {
        this.lineBox.getTopPen().setLineColor(color);
    }

    public int getTopPadding() {
        return this.lineBox.getTopPadding();
    }

    public Integer getOwnTopPadding() {
        return this.lineBox.getOwnTopPadding();
    }

    public void setTopPadding(int n2) {
        this.lineBox.setTopPadding(n2);
    }

    public void setTopPadding(Integer n2) {
        this.lineBox.setTopPadding(n2);
    }

    public byte getLeftBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getLeftPen());
    }

    public Byte getOwnLeftBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getLeftPen());
    }

    public void setLeftBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getLeftPen());
    }

    public void setLeftBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getLeftPen());
    }

    public Color getLeftBorderColor() {
        return this.lineBox.getLeftPen().getLineColor();
    }

    public Color getOwnLeftBorderColor() {
        return this.lineBox.getLeftPen().getOwnLineColor();
    }

    public void setLeftBorderColor(Color color) {
        this.lineBox.getLeftPen().setLineColor(color);
    }

    public int getLeftPadding() {
        return this.lineBox.getLeftPadding();
    }

    public Integer getOwnLeftPadding() {
        return this.lineBox.getOwnLeftPadding();
    }

    public void setLeftPadding(int n2) {
        this.lineBox.setLeftPadding(n2);
    }

    public void setLeftPadding(Integer n2) {
        this.lineBox.setLeftPadding(n2);
    }

    public byte getBottomBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getBottomPen());
    }

    public Byte getOwnBottomBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getBottomPen());
    }

    public void setBottomBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getBottomPen());
    }

    public void setBottomBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getBottomPen());
    }

    public Color getBottomBorderColor() {
        return this.lineBox.getBottomPen().getLineColor();
    }

    public Color getOwnBottomBorderColor() {
        return this.lineBox.getBottomPen().getOwnLineColor();
    }

    public void setBottomBorderColor(Color color) {
        this.lineBox.getBottomPen().setLineColor(color);
    }

    public int getBottomPadding() {
        return this.lineBox.getBottomPadding();
    }

    public Integer getOwnBottomPadding() {
        return this.lineBox.getOwnBottomPadding();
    }

    public void setBottomPadding(int n2) {
        this.lineBox.setBottomPadding(n2);
    }

    public void setBottomPadding(Integer n2) {
        this.lineBox.setBottomPadding(n2);
    }

    public byte getRightBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getRightPen());
    }

    public Byte getOwnRightBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getRightPen());
    }

    public void setRightBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getRightPen());
    }

    public void setRightBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getRightPen());
    }

    public Color getRightBorderColor() {
        return this.lineBox.getRightPen().getLineColor();
    }

    public Color getOwnRightBorderColor() {
        return this.lineBox.getRightPen().getOwnLineColor();
    }

    public void setRightBorderColor(Color color) {
        this.lineBox.getRightPen().setLineColor(color);
    }

    public int getRightPadding() {
        return this.lineBox.getRightPadding();
    }

    public Integer getOwnRightPadding() {
        return this.lineBox.getOwnRightPadding();
    }

    public void setRightPadding(int n2) {
        this.lineBox.setRightPadding(n2);
    }

    public void setRightPadding(Integer n2) {
        this.lineBox.setRightPadding(n2);
    }

    public JRReportFont getReportFont() {
        return this.reportFont;
    }

    public void setReportFont(JRReportFont jRReportFont) {
        this.reportFont = jRReportFont;
    }

    public String getFontName() {
        return JRStyleResolver.getFontName(this);
    }

    public String getOwnFontName() {
        return this.fontName;
    }

    public void setFontName(String string) {
        this.fontName = string;
    }

    public boolean isBold() {
        return JRStyleResolver.isBold(this);
    }

    public Boolean isOwnBold() {
        return this.isBold;
    }

    public void setBold(boolean bl2) {
        this.setBold(bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setBold(Boolean bl2) {
        this.isBold = bl2;
    }

    public boolean isItalic() {
        return JRStyleResolver.isItalic(this);
    }

    public Boolean isOwnItalic() {
        return this.isItalic;
    }

    public void setItalic(boolean bl2) {
        this.setItalic(bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setItalic(Boolean bl2) {
        this.isItalic = bl2;
    }

    public boolean isUnderline() {
        return JRStyleResolver.isUnderline(this);
    }

    public Boolean isOwnUnderline() {
        return this.isUnderline;
    }

    public void setUnderline(boolean bl2) {
        this.setUnderline(bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setUnderline(Boolean bl2) {
        this.isUnderline = bl2;
    }

    public boolean isStrikeThrough() {
        return JRStyleResolver.isStrikeThrough(this);
    }

    public Boolean isOwnStrikeThrough() {
        return this.isStrikeThrough;
    }

    public void setStrikeThrough(boolean bl2) {
        this.setStrikeThrough(bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setStrikeThrough(Boolean bl2) {
        this.isStrikeThrough = bl2;
    }

    public int getFontSize() {
        return JRStyleResolver.getFontSize(this);
    }

    public Integer getOwnFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int n2) {
        this.setFontSize(new Integer(n2));
    }

    public void setFontSize(Integer n2) {
        this.fontSize = n2;
    }

    public int getSize() {
        return this.getFontSize();
    }

    public Integer getOwnSize() {
        return this.getOwnFontSize();
    }

    public void setSize(int n2) {
        this.setFontSize(n2);
    }

    public void setSize(Integer n2) {
        this.setFontSize(n2);
    }

    public String getPdfFontName() {
        return JRStyleResolver.getPdfFontName(this);
    }

    public String getOwnPdfFontName() {
        return this.pdfFontName;
    }

    public void setPdfFontName(String string) {
        this.pdfFontName = string;
    }

    public String getPdfEncoding() {
        return JRStyleResolver.getPdfEncoding(this);
    }

    public String getOwnPdfEncoding() {
        return this.pdfEncoding;
    }

    public void setPdfEncoding(String string) {
        this.pdfEncoding = string;
    }

    public boolean isPdfEmbedded() {
        return JRStyleResolver.isPdfEmbedded(this);
    }

    public Boolean isOwnPdfEmbedded() {
        return this.isPdfEmbedded;
    }

    public void setPdfEmbedded(boolean bl2) {
        this.setPdfEmbedded(bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setPdfEmbedded(Boolean bl2) {
        this.isPdfEmbedded = bl2;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public String getValueClassName() {
        return this.valueClassName;
    }

    public void setValueClassName(String string) {
        this.valueClassName = string;
    }

    public String getFormatFactoryClass() {
        return this.formatFactoryClass;
    }

    public void setFormatFactoryClass(String string) {
        this.formatFactoryClass = string;
    }

    public String getLocaleCode() {
        return this.localeCode;
    }

    public void setLocaleCode(String string) {
        this.localeCode = string;
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public void setTimeZoneId(String string) {
        this.timeZoneId = string;
    }

    public JRPrintHyperlinkParameters getHyperlinkParameters() {
        return this.hyperlinkParameters;
    }

    public void setHyperlinkParameters(JRPrintHyperlinkParameters jRPrintHyperlinkParameters) {
        this.hyperlinkParameters = jRPrintHyperlinkParameters;
    }

    public void addHyperlinkParameter(JRPrintHyperlinkParameter jRPrintHyperlinkParameter) {
        if (this.hyperlinkParameters == null) {
            this.hyperlinkParameters = new JRPrintHyperlinkParameters();
        }
        this.hyperlinkParameters.addParameter(jRPrintHyperlinkParameter);
    }

    public String getLinkType() {
        return this.linkType;
    }

    public void setLinkType(String string) {
        this.linkType = string;
    }

    public void normalizeLinkType() {
        if (this.linkType == null) {
            this.linkType = JRHyperlinkHelper.getLinkType(this.hyperlinkType);
        }
        this.hyperlinkType = 0;
    }

    public String getHyperlinkTooltip() {
        return this.hyperlinkTooltip;
    }

    public void setHyperlinkTooltip(String string) {
        this.hyperlinkTooltip = string;
    }

    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.lineBox == null) {
            this.lineBox = new JRBaseLineBox(this);
            JRBoxUtil.setToBox(this.border, this.topBorder, this.leftBorder, this.bottomBorder, this.rightBorder, this.borderColor, this.topBorderColor, this.leftBorderColor, this.bottomBorderColor, this.rightBorderColor, this.padding, this.topPadding, this.leftPadding, this.bottomPadding, this.rightPadding, this.lineBox);
            this.border = null;
            this.topBorder = null;
            this.leftBorder = null;
            this.bottomBorder = null;
            this.rightBorder = null;
            this.borderColor = null;
            this.topBorderColor = null;
            this.leftBorderColor = null;
            this.bottomBorderColor = null;
            this.rightBorderColor = null;
            this.padding = null;
            this.topPadding = null;
            this.leftPadding = null;
            this.bottomPadding = null;
            this.rightPadding = null;
        }
        this.normalizeLinkType();
    }
}

