/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;

public class JRBaseReport
implements JRReport,
Serializable,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_WHEN_NO_DATA_TYPE = "whenNoDataType";
    public String name = null;
    public String language = "java";
    public int columnCount = 1;
    public byte printOrder = 1;
    public int pageWidth = 595;
    public int pageHeight = 842;
    public byte orientation = 1;
    public byte whenNoDataType = 1;
    public int columnWidth = 555;
    public int columnSpacing = 0;
    public int leftMargin = 20;
    public int rightMargin = 20;
    public int topMargin = 30;
    public int bottomMargin = 30;
    public boolean isTitleNewPage = false;
    public boolean isSummaryNewPage = false;
    public boolean isFloatColumnFooter = false;
    public boolean ignorePagination = false;
    public String formatFactoryClass = null;
    public Set importsSet = null;
    public JRReportTemplate[] templates;
    public JRReportFont defaultFont = null;
    public JRReportFont[] fonts = null;
    public JRStyle defaultStyle = null;
    public JRStyle[] styles = null;
    public JRDataset mainDataset;
    public JRDataset[] datasets;
    public JRBand background = null;
    public JRBand title = null;
    public JRBand pageHeader = null;
    public JRBand columnHeader = null;
    public JRBand detail = null;
    public JRBand columnFooter = null;
    public JRBand pageFooter = null;
    public JRBand lastPageFooter = null;
    public JRBand summary = null;
    public JRBand noData = null;
    private transient JRPropertyChangeSupport eventSupport;

    public JRBaseReport() {
    }

    public JRBaseReport(JRReport jRReport, JRExpressionCollector jRExpressionCollector) {
        this.name = jRReport.getName();
        this.language = jRReport.getLanguage();
        this.columnCount = jRReport.getColumnCount();
        this.printOrder = jRReport.getPrintOrder();
        this.pageWidth = jRReport.getPageWidth();
        this.pageHeight = jRReport.getPageHeight();
        this.orientation = jRReport.getOrientation();
        this.whenNoDataType = jRReport.getWhenNoDataType();
        this.columnWidth = jRReport.getColumnWidth();
        this.columnSpacing = jRReport.getColumnSpacing();
        this.leftMargin = jRReport.getLeftMargin();
        this.rightMargin = jRReport.getRightMargin();
        this.topMargin = jRReport.getTopMargin();
        this.bottomMargin = jRReport.getBottomMargin();
        this.isTitleNewPage = jRReport.isTitleNewPage();
        this.isSummaryNewPage = jRReport.isSummaryNewPage();
        this.isFloatColumnFooter = jRReport.isFloatColumnFooter();
        this.ignorePagination = jRReport.isIgnorePagination();
        this.formatFactoryClass = jRReport.getFormatFactoryClass();
        String[] stringArray = jRReport.getImports();
        if (stringArray != null && stringArray.length > 0) {
            this.importsSet = new HashSet(stringArray.length);
            this.importsSet.addAll(Arrays.asList(stringArray));
        }
        JRBaseObjectFactory jRBaseObjectFactory = new JRBaseObjectFactory(this, jRExpressionCollector);
        this.copyTemplates(jRReport, jRBaseObjectFactory);
        this.defaultFont = jRBaseObjectFactory.getReportFont(jRReport.getDefaultFont());
        JRReportFont[] jRReportFontArray = jRReport.getFonts();
        if (jRReportFontArray != null && jRReportFontArray.length > 0) {
            this.fonts = new JRReportFont[jRReportFontArray.length];
            for (int i2 = 0; i2 < this.fonts.length; ++i2) {
                this.fonts[i2] = jRBaseObjectFactory.getReportFont(jRReportFontArray[i2]);
            }
        }
        this.defaultStyle = jRBaseObjectFactory.getStyle(jRReport.getDefaultStyle());
        JRStyle[] jRStyleArray = jRReport.getStyles();
        if (jRStyleArray != null && jRStyleArray.length > 0) {
            this.styles = new JRStyle[jRStyleArray.length];
            for (int i3 = 0; i3 < this.styles.length; ++i3) {
                this.styles[i3] = jRBaseObjectFactory.getStyle(jRStyleArray[i3]);
            }
        }
        this.mainDataset = jRBaseObjectFactory.getDataset(jRReport.getMainDataset());
        JRDataset[] jRDatasetArray = jRReport.getDatasets();
        if (jRDatasetArray != null && jRDatasetArray.length > 0) {
            this.datasets = new JRDataset[jRDatasetArray.length];
            for (int i4 = 0; i4 < this.datasets.length; ++i4) {
                this.datasets[i4] = jRBaseObjectFactory.getDataset(jRDatasetArray[i4]);
            }
        }
        this.background = jRBaseObjectFactory.getBand(jRReport.getBackground());
        this.title = jRBaseObjectFactory.getBand(jRReport.getTitle());
        this.pageHeader = jRBaseObjectFactory.getBand(jRReport.getPageHeader());
        this.columnHeader = jRBaseObjectFactory.getBand(jRReport.getColumnHeader());
        this.detail = jRBaseObjectFactory.getBand(jRReport.getDetail());
        this.columnFooter = jRBaseObjectFactory.getBand(jRReport.getColumnFooter());
        this.pageFooter = jRBaseObjectFactory.getBand(jRReport.getPageFooter());
        this.lastPageFooter = jRBaseObjectFactory.getBand(jRReport.getLastPageFooter());
        this.summary = jRBaseObjectFactory.getBand(jRReport.getSummary());
        this.noData = jRBaseObjectFactory.getBand(jRReport.getNoData());
    }

    public void copyTemplates(JRReport jRReport, JRBaseObjectFactory jRBaseObjectFactory) {
        JRReportTemplate[] jRReportTemplateArray = jRReport.getTemplates();
        if (jRReportTemplateArray == null || jRReportTemplateArray.length == 0) {
            this.templates = null;
        } else {
            this.templates = new JRReportTemplate[jRReportTemplateArray.length];
            for (int i2 = 0; i2 < jRReportTemplateArray.length; ++i2) {
                this.templates[i2] = jRBaseObjectFactory.getReportTemplate(jRReportTemplateArray[i2]);
            }
        }
    }

    public JRBaseReport(JRReport jRReport) {
        this(jRReport, null);
    }

    public String getName() {
        return this.name;
    }

    public String getLanguage() {
        return this.language;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public byte getPrintOrder() {
        return this.printOrder;
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    public byte getOrientation() {
        return this.orientation;
    }

    public byte getWhenNoDataType() {
        return this.whenNoDataType;
    }

    public void setWhenNoDataType(byte by2) {
        byte by3 = this.getWhenNoDataType();
        this.whenNoDataType = by2;
        this.getEventSupport().firePropertyChange(PROPERTY_WHEN_NO_DATA_TYPE, by3, this.getWhenNoDataType());
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public int getColumnSpacing() {
        return this.columnSpacing;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public boolean isTitleNewPage() {
        return this.isTitleNewPage;
    }

    public boolean isSummaryNewPage() {
        return this.isSummaryNewPage;
    }

    public boolean isFloatColumnFooter() {
        return this.isFloatColumnFooter;
    }

    public String getScriptletClass() {
        return this.mainDataset.getScriptletClass();
    }

    public String getFormatFactoryClass() {
        return this.formatFactoryClass;
    }

    public String getResourceBundle() {
        return this.mainDataset.getResourceBundle();
    }

    public String[] getPropertyNames() {
        return this.mainDataset.getPropertiesMap().getPropertyNames();
    }

    public String getProperty(String string) {
        return this.mainDataset.getPropertiesMap().getProperty(string);
    }

    public void setProperty(String string, String string2) {
        this.mainDataset.getPropertiesMap().setProperty(string, string2);
    }

    public void removeProperty(String string) {
        this.mainDataset.getPropertiesMap().removeProperty(string);
    }

    public String[] getImports() {
        if (this.importsSet != null) {
            return this.importsSet.toArray(new String[this.importsSet.size()]);
        }
        return null;
    }

    public JRReportFont getDefaultFont() {
        return this.defaultFont;
    }

    public JRReportFont[] getFonts() {
        return this.fonts;
    }

    public JRStyle getDefaultStyle() {
        return this.defaultStyle;
    }

    public JRStyle[] getStyles() {
        return this.styles;
    }

    public JRParameter[] getParameters() {
        return this.mainDataset.getParameters();
    }

    public JRQuery getQuery() {
        return this.mainDataset.getQuery();
    }

    public JRField[] getFields() {
        return this.mainDataset.getFields();
    }

    public JRSortField[] getSortFields() {
        return this.mainDataset.getSortFields();
    }

    public JRVariable[] getVariables() {
        return this.mainDataset.getVariables();
    }

    public JRGroup[] getGroups() {
        return this.mainDataset.getGroups();
    }

    public JRBand getBackground() {
        return this.background;
    }

    public JRBand getTitle() {
        return this.title;
    }

    public JRBand getPageHeader() {
        return this.pageHeader;
    }

    public JRBand getColumnHeader() {
        return this.columnHeader;
    }

    public JRBand getDetail() {
        return this.detail;
    }

    public JRBand getColumnFooter() {
        return this.columnFooter;
    }

    public JRBand getPageFooter() {
        return this.pageFooter;
    }

    public JRBand getLastPageFooter() {
        return this.lastPageFooter;
    }

    public JRBand getSummary() {
        return this.summary;
    }

    public byte getWhenResourceMissingType() {
        return this.mainDataset.getWhenResourceMissingType();
    }

    public void setWhenResourceMissingType(byte by2) {
        this.mainDataset.setWhenResourceMissingType(by2);
    }

    public JRDataset getMainDataset() {
        return this.mainDataset;
    }

    public JRDataset[] getDatasets() {
        return this.datasets;
    }

    public boolean isIgnorePagination() {
        return this.ignorePagination;
    }

    public boolean hasProperties() {
        return this.mainDataset.hasProperties();
    }

    public JRPropertiesMap getPropertiesMap() {
        return this.mainDataset.getPropertiesMap();
    }

    public JRPropertiesHolder getParentProperties() {
        return null;
    }

    public JRReportTemplate[] getTemplates() {
        return this.templates;
    }

    public JRBand getNoData() {
        return this.noData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        JRBaseReport jRBaseReport = this;
        synchronized (jRBaseReport) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }
}

