/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.base.JRBaseElement;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.util.JRBoxUtil;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.LineBoxWrapper;

public abstract class JRBaseTextElement
extends JRBaseElement
implements JRTextElement {
    private static final long serialVersionUID = 10200L;
    public Byte horizontalAlignment;
    public Byte verticalAlignment;
    public Byte rotation;
    public Byte lineSpacing;
    public Boolean isStyledText;
    public JRLineBox lineBox = null;
    public JRReportFont reportFont = null;
    public String fontName = null;
    public Boolean isBold = null;
    public Boolean isItalic = null;
    public Boolean isUnderline = null;
    public Boolean isStrikeThrough = null;
    public Integer fontSize = null;
    public String pdfFontName = null;
    public String pdfEncoding = null;
    public Boolean isPdfEmbedded = null;
    private Byte border = null;
    private Byte topBorder = null;
    private Byte leftBorder = null;
    private Byte bottomBorder = null;
    private Byte rightBorder = null;
    private Color borderColor = null;
    private Color topBorderColor = null;
    private Color leftBorderColor = null;
    private Color bottomBorderColor = null;
    private Color rightBorderColor = null;
    private Integer padding = null;
    private Integer topPadding = null;
    private Integer leftPadding = null;
    private Integer bottomPadding = null;
    private Integer rightPadding = null;

    public JRBaseTextElement(JRTextElement jRTextElement, JRBaseObjectFactory jRBaseObjectFactory) {
        super(jRTextElement, jRBaseObjectFactory);
        this.horizontalAlignment = jRTextElement.getOwnHorizontalAlignment();
        this.verticalAlignment = jRTextElement.getOwnVerticalAlignment();
        this.rotation = jRTextElement.getOwnRotation();
        this.lineSpacing = jRTextElement.getOwnLineSpacing();
        this.isStyledText = jRTextElement.isOwnStyledText();
        this.lineBox = jRTextElement.getLineBox().clone(this);
        this.reportFont = jRBaseObjectFactory.getReportFont(jRTextElement.getReportFont());
        this.fontName = jRTextElement.getOwnFontName();
        this.isBold = jRTextElement.isOwnBold();
        this.isItalic = jRTextElement.isOwnItalic();
        this.isUnderline = jRTextElement.isOwnUnderline();
        this.isStrikeThrough = jRTextElement.isOwnStrikeThrough();
        this.fontSize = jRTextElement.getOwnFontSize();
        this.pdfFontName = jRTextElement.getOwnPdfFontName();
        this.pdfEncoding = jRTextElement.getOwnPdfEncoding();
        this.isPdfEmbedded = jRTextElement.isOwnPdfEmbedded();
    }

    public JRFont getBaseFont() {
        if (this.reportFont != null) {
            return this.reportFont;
        }
        if (this.defaultStyleProvider != null) {
            return this.defaultStyleProvider.getDefaultFont();
        }
        return null;
    }

    public byte getTextAlignment() {
        if (this.horizontalAlignment == null) {
            JRStyle jRStyle = this.getBaseStyle();
            if (jRStyle != null && jRStyle.getHorizontalAlignment() != null) {
                return jRStyle.getHorizontalAlignment();
            }
            return 1;
        }
        return this.horizontalAlignment;
    }

    public void setTextAlignment(byte by2) {
        this.setHorizontalAlignment(new Byte(by2));
    }

    public byte getHorizontalAlignment() {
        return JRStyleResolver.getHorizontalAlignment(this);
    }

    public Byte getOwnHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(byte by2) {
        this.setHorizontalAlignment(new Byte(by2));
    }

    public void setHorizontalAlignment(Byte by2) {
        Byte by3 = this.horizontalAlignment;
        this.horizontalAlignment = by2;
        this.getEventSupport().firePropertyChange("horizontalAlignment", by3, this.horizontalAlignment);
    }

    public byte getVerticalAlignment() {
        return JRStyleResolver.getVerticalAlignment(this);
    }

    public Byte getOwnVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(byte by2) {
        this.setVerticalAlignment(new Byte(by2));
    }

    public void setVerticalAlignment(Byte by2) {
        Byte by3 = this.verticalAlignment;
        this.verticalAlignment = by2;
        this.getEventSupport().firePropertyChange("verticalAlignment", by3, this.verticalAlignment);
    }

    public byte getRotation() {
        return JRStyleResolver.getRotation(this);
    }

    public Byte getOwnRotation() {
        return this.rotation;
    }

    public void setRotation(byte by2) {
        this.setRotation(new Byte(by2));
    }

    public void setRotation(Byte by2) {
        Byte by3 = this.rotation;
        this.rotation = by2;
        this.getEventSupport().firePropertyChange("rotation", by3, this.rotation);
    }

    public byte getLineSpacing() {
        return JRStyleResolver.getLineSpacing(this);
    }

    public Byte getOwnLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(byte by2) {
        this.setLineSpacing(new Byte(by2));
    }

    public void setLineSpacing(Byte by2) {
        Byte by3 = this.lineSpacing;
        this.lineSpacing = by2;
        this.getEventSupport().firePropertyChange("lineSpacing", by3, this.lineSpacing);
    }

    public boolean isStyledText() {
        return JRStyleResolver.isStyledText(this);
    }

    public Boolean isOwnStyledText() {
        return this.isStyledText;
    }

    public void setStyledText(boolean bl2) {
        this.setStyledText(bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setStyledText(Boolean bl2) {
        Boolean bl3 = this.isStyledText;
        this.isStyledText = bl2;
        this.getEventSupport().firePropertyChange("isStyledText", bl3, this.isStyledText);
    }

    public JRBox getBox() {
        return new LineBoxWrapper(this.getLineBox());
    }

    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    public JRFont getFont() {
        return this;
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    public byte getBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getPen());
    }

    public Byte getOwnBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getPen());
    }

    public void setBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getPen());
    }

    public void setBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getPen());
    }

    public Color getBorderColor() {
        return this.lineBox.getPen().getLineColor();
    }

    public Color getOwnBorderColor() {
        return this.lineBox.getPen().getOwnLineColor();
    }

    public void setBorderColor(Color color) {
        this.lineBox.getPen().setLineColor(color);
    }

    public int getPadding() {
        return this.lineBox.getPadding();
    }

    public Integer getOwnPadding() {
        return this.lineBox.getOwnPadding();
    }

    public void setPadding(int n2) {
        this.lineBox.setPadding(n2);
    }

    public void setPadding(Integer n2) {
        this.lineBox.setPadding(n2);
    }

    public byte getTopBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getTopPen());
    }

    public Byte getOwnTopBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getTopPen());
    }

    public void setTopBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getTopPen());
    }

    public void setTopBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getTopPen());
    }

    public Color getTopBorderColor() {
        return this.lineBox.getTopPen().getLineColor();
    }

    public Color getOwnTopBorderColor() {
        return this.lineBox.getTopPen().getOwnLineColor();
    }

    public void setTopBorderColor(Color color) {
        this.lineBox.getTopPen().setLineColor(color);
    }

    public int getTopPadding() {
        return this.lineBox.getTopPadding();
    }

    public Integer getOwnTopPadding() {
        return this.lineBox.getOwnTopPadding();
    }

    public void setTopPadding(int n2) {
        this.lineBox.setTopPadding(n2);
    }

    public void setTopPadding(Integer n2) {
        this.lineBox.setTopPadding(n2);
    }

    public byte getLeftBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getLeftPen());
    }

    public Byte getOwnLeftBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getLeftPen());
    }

    public void setLeftBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getLeftPen());
    }

    public void setLeftBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getLeftPen());
    }

    public Color getLeftBorderColor() {
        return this.lineBox.getLeftPen().getLineColor();
    }

    public Color getOwnLeftBorderColor() {
        return this.lineBox.getLeftPen().getOwnLineColor();
    }

    public void setLeftBorderColor(Color color) {
        this.lineBox.getLeftPen().setLineColor(color);
    }

    public int getLeftPadding() {
        return this.lineBox.getLeftPadding();
    }

    public Integer getOwnLeftPadding() {
        return this.lineBox.getOwnLeftPadding();
    }

    public void setLeftPadding(int n2) {
        this.lineBox.setLeftPadding(n2);
    }

    public void setLeftPadding(Integer n2) {
        this.lineBox.setLeftPadding(n2);
    }

    public byte getBottomBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getBottomPen());
    }

    public Byte getOwnBottomBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getBottomPen());
    }

    public void setBottomBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getBottomPen());
    }

    public void setBottomBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getBottomPen());
    }

    public Color getBottomBorderColor() {
        return this.lineBox.getBottomPen().getLineColor();
    }

    public Color getOwnBottomBorderColor() {
        return this.lineBox.getBottomPen().getOwnLineColor();
    }

    public void setBottomBorderColor(Color color) {
        this.lineBox.getBottomPen().setLineColor(color);
    }

    public int getBottomPadding() {
        return this.lineBox.getBottomPadding();
    }

    public Integer getOwnBottomPadding() {
        return this.lineBox.getOwnBottomPadding();
    }

    public void setBottomPadding(int n2) {
        this.lineBox.setBottomPadding(n2);
    }

    public void setBottomPadding(Integer n2) {
        this.lineBox.setBottomPadding(n2);
    }

    public byte getRightBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getRightPen());
    }

    public Byte getOwnRightBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getRightPen());
    }

    public void setRightBorder(byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getRightPen());
    }

    public void setRightBorder(Byte by2) {
        JRPenUtil.setLinePenFromPen(by2, (JRPen)this.lineBox.getRightPen());
    }

    public Color getRightBorderColor() {
        return this.lineBox.getRightPen().getLineColor();
    }

    public Color getOwnRightBorderColor() {
        return this.lineBox.getRightPen().getOwnLineColor();
    }

    public void setRightBorderColor(Color color) {
        this.lineBox.getRightPen().setLineColor(color);
    }

    public int getRightPadding() {
        return this.lineBox.getRightPadding();
    }

    public Integer getOwnRightPadding() {
        return this.lineBox.getOwnRightPadding();
    }

    public void setRightPadding(int n2) {
        this.lineBox.setRightPadding(n2);
    }

    public void setRightPadding(Integer n2) {
        this.lineBox.setRightPadding(n2);
    }

    public JRReportFont getReportFont() {
        return this.reportFont;
    }

    public void setReportFont(JRReportFont jRReportFont) {
        JRReportFont jRReportFont2 = this.reportFont;
        this.reportFont = jRReportFont;
        this.getEventSupport().firePropertyChange("reportFont", jRReportFont2, this.reportFont);
    }

    public String getFontName() {
        return JRStyleResolver.getFontName(this);
    }

    public String getOwnFontName() {
        return this.fontName;
    }

    public void setFontName(String string) {
        String string2 = this.fontName;
        this.fontName = string;
        this.getEventSupport().firePropertyChange("fontName", string2, this.fontName);
    }

    public boolean isBold() {
        return JRStyleResolver.isBold(this);
    }

    public Boolean isOwnBold() {
        return this.isBold;
    }

    public void setBold(boolean bl2) {
        this.setBold(bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setBold(Boolean bl2) {
        Boolean bl3 = this.isBold;
        this.isBold = bl2;
        this.getEventSupport().firePropertyChange("bold", bl3, this.isBold);
    }

    public boolean isItalic() {
        return JRStyleResolver.isItalic(this);
    }

    public Boolean isOwnItalic() {
        return this.isItalic;
    }

    public void setItalic(boolean bl2) {
        this.setItalic(bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setItalic(Boolean bl2) {
        Boolean bl3 = this.isItalic;
        this.isItalic = bl2;
        this.getEventSupport().firePropertyChange("italic", bl3, this.isItalic);
    }

    public boolean isUnderline() {
        return JRStyleResolver.isUnderline(this);
    }

    public Boolean isOwnUnderline() {
        return this.isUnderline;
    }

    public void setUnderline(boolean bl2) {
        this.setUnderline(bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setUnderline(Boolean bl2) {
        Boolean bl3 = this.isUnderline;
        this.isUnderline = bl2;
        this.getEventSupport().firePropertyChange("underline", bl3, this.isUnderline);
    }

    public boolean isStrikeThrough() {
        return JRStyleResolver.isStrikeThrough(this);
    }

    public Boolean isOwnStrikeThrough() {
        return this.isStrikeThrough;
    }

    public void setStrikeThrough(boolean bl2) {
        this.setStrikeThrough(bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setStrikeThrough(Boolean bl2) {
        Boolean bl3 = this.isStrikeThrough;
        this.isStrikeThrough = bl2;
        this.getEventSupport().firePropertyChange("strikeThrough", bl3, this.isStrikeThrough);
    }

    public int getFontSize() {
        return JRStyleResolver.getFontSize(this);
    }

    public Integer getOwnFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int n2) {
        this.setFontSize(new Integer(n2));
    }

    public void setFontSize(Integer n2) {
        Integer n3 = this.fontSize;
        this.fontSize = n2;
        this.getEventSupport().firePropertyChange("fontSize", n3, this.fontSize);
    }

    public int getSize() {
        return this.getFontSize();
    }

    public Integer getOwnSize() {
        return this.getOwnFontSize();
    }

    public void setSize(int n2) {
        this.setFontSize(n2);
    }

    public void setSize(Integer n2) {
        this.setFontSize(n2);
    }

    public String getPdfFontName() {
        return JRStyleResolver.getPdfFontName(this);
    }

    public String getOwnPdfFontName() {
        return this.pdfFontName;
    }

    public void setPdfFontName(String string) {
        String string2 = this.pdfFontName;
        this.pdfFontName = string;
        this.getEventSupport().firePropertyChange("pdfFontName", string2, this.pdfFontName);
    }

    public String getPdfEncoding() {
        return JRStyleResolver.getPdfEncoding(this);
    }

    public String getOwnPdfEncoding() {
        return this.pdfEncoding;
    }

    public void setPdfEncoding(String string) {
        String string2 = this.pdfEncoding;
        this.pdfEncoding = string;
        this.getEventSupport().firePropertyChange("pdfEncoding", string2, this.pdfEncoding);
    }

    public boolean isPdfEmbedded() {
        return JRStyleResolver.isPdfEmbedded(this);
    }

    public Boolean isOwnPdfEmbedded() {
        return this.isPdfEmbedded;
    }

    public void setPdfEmbedded(boolean bl2) {
        this.setPdfEmbedded(bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setPdfEmbedded(Boolean bl2) {
        Boolean bl3 = this.isPdfEmbedded;
        this.isPdfEmbedded = bl2;
        this.getEventSupport().firePropertyChange("pdfEmbedded", bl3, this.isPdfEmbedded);
    }

    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.lineBox == null) {
            this.lineBox = new JRBaseLineBox(this);
            JRBoxUtil.setToBox(this.border, this.topBorder, this.leftBorder, this.bottomBorder, this.rightBorder, this.borderColor, this.topBorderColor, this.leftBorderColor, this.bottomBorderColor, this.rightBorderColor, this.padding, this.topPadding, this.leftPadding, this.bottomPadding, this.rightPadding, this.lineBox);
            this.border = null;
            this.topBorder = null;
            this.leftBorder = null;
            this.bottomBorder = null;
            this.rightBorder = null;
            this.borderColor = null;
            this.topBorderColor = null;
            this.leftBorderColor = null;
            this.bottomBorderColor = null;
            this.rightBorderColor = null;
            this.padding = null;
            this.topPadding = null;
            this.leftPadding = null;
            this.bottomPadding = null;
            this.rightPadding = null;
        }
    }
}

