/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.convert;

import java.awt.Image;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.base.JRBasePrintImage;
import net.sf.jasperreports.engine.convert.ElementConverter;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import net.sf.jasperreports.engine.util.JRImageLoader;

public class ChartConverter
extends ElementConverter {
    private static final ChartConverter INSTANCE = new ChartConverter();

    private ChartConverter() {
    }

    public static ChartConverter getInstance() {
        return INSTANCE;
    }

    public JRPrintElement convert(ReportConverter reportConverter, JRElement jRElement) {
        JRBasePrintImage jRBasePrintImage = new JRBasePrintImage(reportConverter.getDefaultStyleProvider());
        JRChart jRChart = (JRChart)jRElement;
        this.copyElement(reportConverter, jRChart, jRBasePrintImage);
        jRBasePrintImage.copyBox(jRChart.getLineBox());
        jRBasePrintImage.setAnchorName(JRExpressionUtil.getExpressionText(jRChart.getAnchorNameExpression()));
        jRBasePrintImage.setBookmarkLevel(jRChart.getBookmarkLevel());
        jRBasePrintImage.setLinkType(jRChart.getLinkType());
        jRBasePrintImage.setOnErrorType((byte)3);
        jRBasePrintImage.setRenderer(this.getRenderer(jRChart));
        jRBasePrintImage.setScaleImage((byte)1);
        return jRBasePrintImage;
    }

    private JRRenderable getRenderer(JRChart jRChart) {
        JRRenderable jRRenderable = null;
        Image image = null;
        try {
            image = JRImageLoader.getImage((byte)3);
            jRRenderable = JRImageRenderer.getInstance(image, (byte)1);
            jRChart.setStretchType((byte)0);
        }
        catch (JRException jRException) {
            jRException.printStackTrace();
        }
        return jRRenderable;
    }
}

