/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.convert;

import java.util.List;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRBreak;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JREllipse;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVisitable;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBasePrintElement;
import net.sf.jasperreports.engine.base.JRBasePrintFrame;
import net.sf.jasperreports.engine.base.JRBasePrintGraphicElement;
import net.sf.jasperreports.engine.base.JRBasePrintRectangle;
import net.sf.jasperreports.engine.convert.ChartConverter;
import net.sf.jasperreports.engine.convert.CrosstabConverter;
import net.sf.jasperreports.engine.convert.EllipseConverter;
import net.sf.jasperreports.engine.convert.FrameConverter;
import net.sf.jasperreports.engine.convert.ImageConverter;
import net.sf.jasperreports.engine.convert.LineConverter;
import net.sf.jasperreports.engine.convert.RectangleConverter;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.convert.StaticTextConverter;
import net.sf.jasperreports.engine.convert.SubreportConverter;
import net.sf.jasperreports.engine.convert.TextFieldConverter;

public class ConvertVisitor
implements JRVisitor {
    private ReportConverter reportConverter = null;
    private JRBasePrintFrame parentFrame = null;
    private JRPrintElement printElement = null;

    public ConvertVisitor(ReportConverter reportConverter) {
        this(reportConverter, null);
    }

    public ConvertVisitor(ReportConverter reportConverter, JRBasePrintFrame jRBasePrintFrame) {
        this.reportConverter = reportConverter;
        this.parentFrame = jRBasePrintFrame;
    }

    public JRPrintElement getVisitPrintElement(JRVisitable jRVisitable) {
        if (jRVisitable != null) {
            jRVisitable.visit(this);
            return this.printElement;
        }
        return null;
    }

    public void visitBreak(JRBreak jRBreak) {
    }

    public void visitChart(JRChart jRChart) {
        JRPrintElement jRPrintElement = ChartConverter.getInstance().convert(this.reportConverter, jRChart);
        this.addElement(this.parentFrame, jRPrintElement);
        this.addContour(this.reportConverter, this.parentFrame, jRPrintElement);
    }

    public void visitCrosstab(JRCrosstab jRCrosstab) {
        JRPrintElement jRPrintElement = CrosstabConverter.getInstance().convert(this.reportConverter, jRCrosstab);
        this.addElement(this.parentFrame, jRPrintElement);
        this.addContour(this.reportConverter, this.parentFrame, jRPrintElement);
    }

    public void visitElementGroup(JRElementGroup jRElementGroup) {
        List list = jRElementGroup.getChildren();
        if (list != null && list.size() > 0) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                ((JRChild)list.get(i2)).visit(this);
            }
        }
    }

    public void visitEllipse(JREllipse jREllipse) {
        this.addElement(this.parentFrame, EllipseConverter.getInstance().convert(this.reportConverter, jREllipse));
    }

    public void visitFrame(JRFrame jRFrame) {
        JRPrintElement jRPrintElement = FrameConverter.getInstance().convert(this.reportConverter, jRFrame);
        this.addElement(this.parentFrame, jRPrintElement);
        this.addContour(this.reportConverter, this.parentFrame, jRPrintElement);
    }

    public void visitImage(JRImage jRImage) {
        JRPrintElement jRPrintElement = ImageConverter.getInstance().convert(this.reportConverter, jRImage);
        this.addElement(this.parentFrame, jRPrintElement);
        this.addContour(this.reportConverter, this.parentFrame, jRPrintElement);
    }

    public void visitLine(JRLine jRLine) {
        this.addElement(this.parentFrame, LineConverter.getInstance().convert(this.reportConverter, jRLine));
    }

    public void visitRectangle(JRRectangle jRRectangle) {
        this.addElement(this.parentFrame, RectangleConverter.getInstance().convert(this.reportConverter, jRRectangle));
    }

    public void visitStaticText(JRStaticText jRStaticText) {
        JRPrintElement jRPrintElement = StaticTextConverter.getInstance().convert(this.reportConverter, jRStaticText);
        this.addElement(this.parentFrame, jRPrintElement);
        this.addContour(this.reportConverter, this.parentFrame, jRPrintElement);
    }

    public void visitSubreport(JRSubreport jRSubreport) {
        JRPrintElement jRPrintElement = SubreportConverter.getInstance().convert(this.reportConverter, jRSubreport);
        this.addElement(this.parentFrame, jRPrintElement);
        this.addContour(this.reportConverter, this.parentFrame, jRPrintElement);
    }

    public void visitTextField(JRTextField jRTextField) {
        JRPrintElement jRPrintElement = TextFieldConverter.getInstance().convert(this.reportConverter, jRTextField);
        this.addElement(this.parentFrame, jRPrintElement);
        this.addContour(this.reportConverter, this.parentFrame, jRPrintElement);
    }

    private void addElement(JRBasePrintFrame jRBasePrintFrame, JRPrintElement jRPrintElement) {
        this.printElement = jRPrintElement;
        if (jRBasePrintFrame != null) {
            jRBasePrintFrame.addElement(jRPrintElement);
        }
    }

    private void addContour(ReportConverter reportConverter, JRBasePrintFrame jRBasePrintFrame, JRPrintElement jRPrintElement) {
        if (jRBasePrintFrame != null) {
            JRPrintGraphicElement jRPrintGraphicElement;
            JRLineBox jRLineBox;
            boolean bl2 = false;
            JRLineBox jRLineBox2 = jRLineBox = jRPrintElement instanceof JRBoxContainer ? ((JRBoxContainer)((Object)jRPrintElement)).getLineBox() : null;
            if (jRLineBox == null) {
                jRPrintGraphicElement = jRPrintElement instanceof JRPrintGraphicElement ? (JRPrintGraphicElement)jRPrintElement : null;
                bl2 = jRPrintGraphicElement == null || jRPrintGraphicElement.getLinePen().getLineWidth().floatValue() <= 0.0f;
            } else {
                boolean bl3 = bl2 = jRLineBox.getTopPen().getLineWidth().floatValue() <= 0.0f && jRLineBox.getLeftPen().getLineWidth().floatValue() <= 0.0f && jRLineBox.getRightPen().getLineWidth().floatValue() <= 0.0f && jRLineBox.getBottomPen().getLineWidth().floatValue() <= 0.0f;
            }
            if (bl2) {
                jRPrintGraphicElement = new JRBasePrintRectangle(reportConverter.getDefaultStyleProvider());
                ((JRBasePrintElement)((Object)jRPrintGraphicElement)).setX(jRPrintElement.getX());
                ((JRBasePrintElement)((Object)jRPrintGraphicElement)).setY(jRPrintElement.getY());
                ((JRBasePrintElement)((Object)jRPrintGraphicElement)).setWidth(jRPrintElement.getWidth());
                ((JRBasePrintElement)((Object)jRPrintGraphicElement)).setHeight(jRPrintElement.getHeight());
                ((JRBasePrintGraphicElement)jRPrintGraphicElement).getLinePen().setLineWidth(0.5f);
                ((JRBasePrintGraphicElement)jRPrintGraphicElement).getLinePen().setLineColor(jRPrintElement.getForecolor());
                ((JRBasePrintElement)((Object)jRPrintGraphicElement)).setMode((byte)2);
                jRBasePrintFrame.addElement(jRPrintGraphicElement);
            }
        }
    }
}

