/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.convert;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.JRStyleSetter;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JRTemplateReference;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.base.JRBasePrintFrame;
import net.sf.jasperreports.engine.base.JRBasePrintPage;
import net.sf.jasperreports.engine.convert.ConvertVisitor;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import net.sf.jasperreports.engine.xml.JRXmlTemplateLoader;
import org.apache.commons.collections.SequencedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportConverter {
    private static final Log log = LogFactory.getLog(b == null ? (b = ReportConverter.a("net.sf.jasperreports.engine.convert.ReportConverter")) : b);
    private static final Color GRID_LINE_COLOR = new Color(170, 170, 255);
    private final JRReport report;
    private JasperPrint jasperPrint;
    private JRPrintPage page;
    public int a;
    private int offsetY;
    private int upColumns;
    private int downColumns;
    private List pageElements = new ArrayList();
    private StyleFactory styleFactory;
    public Map stylesMap;
    public static Class b;

    public ReportConverter(JRReport jRReport, boolean bl2) {
        this.report = jRReport;
        if (jRReport instanceof JasperDesign) {
            ((JasperDesign)jRReport).preprocess();
        }
        this.convert(bl2);
    }

    public void convert(boolean bl2) {
        this.jasperPrint = new JasperPrint();
        this.jasperPrint.setDefaultFont(this.report.getDefaultFont());
        this.jasperPrint.setFormatFactoryClass(this.report.getFormatFactoryClass());
        this.jasperPrint.setName(this.report.getName());
        this.jasperPrint.setOrientation(this.report.getOrientation());
        this.jasperPrint.setPageWidth(this.report.getPageWidth());
        this.jasperPrint.setPageHeight(this.report.getPageHeight());
        this.setStyles(this.report);
        if (!bl2) {
            int n2;
            this.a = this.report.getPageWidth();
            this.page = new JRBasePrintPage();
            this.offsetY = this.report.getTopMargin();
            this.addBand(this.report.getBackground());
            this.addBand(this.report.getTitle());
            this.addBand(this.report.getPageHeader());
            this.upColumns = this.offsetY;
            this.addBand(this.report.getColumnHeader());
            JRGroup[] jRGroupArray = this.report.getGroups();
            if (jRGroupArray != null) {
                for (n2 = 0; n2 < jRGroupArray.length; ++n2) {
                    this.addBand(jRGroupArray[n2].getGroupHeader());
                }
            }
            this.addBand(this.report.getDetail());
            if (jRGroupArray != null) {
                for (n2 = 0; n2 < jRGroupArray.length; ++n2) {
                    this.addBand(jRGroupArray[n2].getGroupFooter());
                }
            }
            this.addBand(this.report.getColumnFooter());
            this.downColumns = this.offsetY;
            this.addBand(this.report.getPageFooter());
            this.addBand(this.report.getLastPageFooter());
            this.addBand(this.report.getSummary());
            this.addBand(this.report.getNoData());
            this.jasperPrint.setPageHeight(this.offsetY + this.report.getBottomMargin());
            n2 = this.report.getLeftMargin();
            for (int i2 = 0; i2 < this.report.getColumnCount(); ++i2) {
                this.addColumnSeparator(n2);
                this.addColumnSeparator(n2 += this.report.getColumnWidth());
                n2 += this.report.getColumnSpacing();
            }
            this.addHorizontalGridLine(0, this.report.getTopMargin(), this.a);
            this.addHorizontalGridLine(0, this.offsetY, this.a);
            this.addVerticalGridLine(this.report.getLeftMargin(), 0, this.jasperPrint.getPageHeight());
            this.addVerticalGridLine(this.a - this.report.getRightMargin(), 0, this.jasperPrint.getPageHeight());
            this.page.setElements(this.pageElements);
            this.jasperPrint.addPage(this.page);
        }
    }

    public void setStyles(JRReport jRReport) {
        Object object;
        Object object2;
        this.styleFactory = new StyleFactory(this);
        this.stylesMap = new SequencedHashMap();
        this.loadReportStyles(jRReport);
        try {
            object2 = this.stylesMap.values().iterator();
            while (object2.hasNext()) {
                object = (JRStyle)object2.next();
                this.jasperPrint.addStyle((JRStyle)object);
            }
        }
        catch (JRException jRException) {
            throw new JRRuntimeException(jRException);
        }
        object2 = jRReport.getDefaultStyle();
        object = null;
        if (object2 == null) {
            Iterator iterator = this.stylesMap.values().iterator();
            while (iterator.hasNext()) {
                JRStyle jRStyle = (JRStyle)iterator.next();
                if (!jRStyle.isDefault()) continue;
                object = jRStyle;
            }
        } else {
            object = object2;
        }
        if (object != null) {
            this.jasperPrint.setDefaultStyle((JRStyle)object);
        }
    }

    public void loadReportStyles(JRReport jRReport) {
        JRReportTemplate[] jRReportTemplateArray = jRReport.getTemplates();
        if (jRReportTemplateArray != null) {
            HashSet hashSet = new HashSet();
            for (int i2 = 0; i2 < jRReportTemplateArray.length; ++i2) {
                this.loadReportTemplateStyles(jRReportTemplateArray[i2], hashSet);
            }
        }
        this.collectStyles(jRReport.getStyles());
    }

    public void loadReportTemplateStyles(JRReportTemplate jRReportTemplate, Set set) {
        JRExpression jRExpression = jRReportTemplate.getSourceExpression();
        if (jRExpression != null) {
            String string = JRExpressionUtil.getSimpleExpressionText(jRExpression);
            if (string == null) {
                log.warn("Template source expression " + jRExpression.getText() + "cannot be evaluated; some styles might remain unresolved.");
            } else {
                this.loadTemplateStyles(string, set);
            }
        }
    }

    public void loadTemplateStyles(String string, Set set) {
        JRTemplate jRTemplate;
        if (!set.add(string)) {
            throw new JRRuntimeException("Circular dependency found for template at location " + string);
        }
        try {
            jRTemplate = JRXmlTemplateLoader.load(string);
        }
        catch (Exception exception) {
            log.warn("Could not load template from location " + string + "; some styles might remain unresolved.");
            return;
        }
        JRTemplateReference[] jRTemplateReferenceArray = jRTemplate.getIncludedTemplates();
        if (jRTemplateReferenceArray != null) {
            for (int i2 = 0; i2 < jRTemplateReferenceArray.length; ++i2) {
                JRTemplateReference jRTemplateReference = jRTemplateReferenceArray[i2];
                this.loadTemplateStyles(jRTemplateReference.getLocation(), set);
            }
        }
        this.collectStyles(jRTemplate.getStyles());
    }

    public void collectStyles(JRStyle[] jRStyleArray) {
        if (jRStyleArray != null) {
            for (int i2 = 0; i2 < jRStyleArray.length; ++i2) {
                JRStyle jRStyle = jRStyleArray[i2];
                JRStyle jRStyle2 = this.styleFactory.getStyle(jRStyle);
                this.stylesMap.put(jRStyle2.getName(), jRStyle2);
            }
        }
    }

    private void addBand(JRBand jRBand) {
        if (jRBand != null) {
            JRBasePrintFrame jRBasePrintFrame = new JRBasePrintFrame(null);
            jRBasePrintFrame.setX(this.report.getLeftMargin());
            jRBasePrintFrame.setY(this.offsetY);
            jRBasePrintFrame.setWidth(this.report.getPageWidth() - this.report.getLeftMargin() - this.report.getRightMargin());
            jRBasePrintFrame.setHeight(jRBand.getHeight());
            jRBand.visit(new ConvertVisitor(this, jRBasePrintFrame));
            this.pageElements.add(jRBasePrintFrame);
            this.offsetY += jRBand.getHeight();
            this.addBandSeparator(this.offsetY);
        }
    }

    private void addBandSeparator(int n2) {
        this.addHorizontalGridLine(0, n2, this.a);
    }

    private void addColumnSeparator(int n2) {
        if (this.downColumns > this.upColumns) {
            this.addVerticalGridLine(n2, this.upColumns, this.downColumns - this.upColumns);
        }
    }

    private void addHorizontalGridLine(int n2, int n3, int n4) {
        JRBasePrintFrame jRBasePrintFrame = new JRBasePrintFrame(this.getDefaultStyleProvider());
        jRBasePrintFrame.setX(n2);
        jRBasePrintFrame.setY(n3);
        jRBasePrintFrame.setWidth(n4);
        jRBasePrintFrame.setHeight(1);
        jRBasePrintFrame.getLineBox().getTopPen().setLineWidth(0.1f);
        jRBasePrintFrame.getLineBox().getTopPen().setLineStyle((byte)1);
        jRBasePrintFrame.getLineBox().getTopPen().setLineColor(GRID_LINE_COLOR);
        this.pageElements.add(0, jRBasePrintFrame);
    }

    private void addVerticalGridLine(int n2, int n3, int n4) {
        JRBasePrintFrame jRBasePrintFrame = new JRBasePrintFrame(this.getDefaultStyleProvider());
        jRBasePrintFrame.setX(n2);
        jRBasePrintFrame.setY(n3);
        jRBasePrintFrame.setWidth(1);
        jRBasePrintFrame.setHeight(n4);
        jRBasePrintFrame.getLineBox().getLeftPen().setLineWidth(0.1f);
        jRBasePrintFrame.getLineBox().getLeftPen().setLineStyle((byte)1);
        jRBasePrintFrame.getLineBox().getLeftPen().setLineColor(GRID_LINE_COLOR);
        this.pageElements.add(0, jRBasePrintFrame);
    }

    public JRStyle resolveStyle(JRStyleContainer jRStyleContainer) {
        JRStyle jRStyle;
        JRStyle jRStyle2 = jRStyleContainer.getStyle();
        String string = jRStyleContainer.getStyleNameReference();
        if (jRStyle2 != null) {
            jRStyle = this.styleFactory.getStyle(jRStyle2);
        } else if (string != null) {
            jRStyle = (JRStyle)this.stylesMap.get(string);
            if (jRStyle == null) {
                log.warn("Style " + string + " could not be resolved.");
            }
        } else {
            jRStyle = null;
        }
        return jRStyle;
    }

    public JasperPrint getJasperPrint() {
        return this.jasperPrint;
    }

    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.jasperPrint.getDefaultStyleProvider();
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static Log a() {
        return log;
    }

    protected class StyleFactory
    extends JRBaseObjectFactory {
        private final ReportConverter this$0;

        public StyleFactory(ReportConverter reportConverter) {
            super(reportConverter.getDefaultStyleProvider());
            this.this$0 = reportConverter;
        }

        public JRExpression getExpression(JRExpression jRExpression, boolean bl2) {
            return jRExpression;
        }

        public void handleStyleNameReference(JRStyleSetter jRStyleSetter, String string) {
            JRStyle jRStyle = (JRStyle)this.this$0.stylesMap.get(string);
            if (jRStyle == null) {
                ReportConverter.a().warn("Style " + string + " could not be resolved.");
            } else {
                jRStyleSetter.setStyle(jRStyle);
            }
        }
    }
}

