/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DateFormat;
import java.text.NumberFormat;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataSourceProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRCsvDataSource;

public class JRCsvDataSourceProvider
implements JRDataSourceProvider {
    private Reader reader;
    private DateFormat dateFormat;
    private char fieldDelimiter;
    private String recordDelimiter;
    private String[] columnNames;
    private NumberFormat numberFormat;

    public JRCsvDataSourceProvider(InputStream inputStream) {
        this(new InputStreamReader(inputStream));
    }

    public JRCsvDataSourceProvider(File file) throws FileNotFoundException {
        this(new FileReader(file));
    }

    public JRCsvDataSourceProvider(Reader reader) {
        this.reader = reader;
    }

    public boolean supportsGetFieldsOperation() {
        return false;
    }

    public JRField[] getFields(JasperReport jasperReport) throws JRException, UnsupportedOperationException {
        return null;
    }

    public JRDataSource create(JasperReport jasperReport) throws JRException {
        if (this.reader == null) {
            throw new JRException("Cannot find a source to read the data from");
        }
        JRCsvDataSource jRCsvDataSource = new JRCsvDataSource(this.reader);
        jRCsvDataSource.setDateFormat(this.dateFormat);
        jRCsvDataSource.setNumberFormat(this.numberFormat);
        jRCsvDataSource.setFieldDelimiter(this.fieldDelimiter);
        jRCsvDataSource.setRecordDelimiter(this.recordDelimiter);
        jRCsvDataSource.setColumnNames(this.columnNames);
        return jRCsvDataSource;
    }

    public void dispose(JRDataSource jRDataSource) throws JRException {
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] stringArray) {
        this.columnNames = stringArray;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public char getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public void setFieldDelimiter(char c2) {
        this.fieldDelimiter = c2;
    }

    public String getRecordDelimiter() {
        return this.recordDelimiter;
    }

    public void setRecordDelimiter(String string) {
        this.recordDelimiter = string;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }
}

