/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRCompilationSourceCode;
import net.sf.jasperreports.engine.design.JRCompilationUnit;
import net.sf.jasperreports.engine.design.JRCompiler;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRReportCompileData;
import net.sf.jasperreports.engine.design.JRSourceCompileTask;
import net.sf.jasperreports.engine.design.JRValidationException;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.engine.util.JRStringUtil;

public abstract class JRAbstractCompiler
implements JRCompiler {
    private static final int NAME_SUFFIX_RANDOM_MAX = 1000000;
    private static final Random random = new Random();
    private final boolean needsSourceFiles;

    public JRAbstractCompiler(boolean bl2) {
        this.needsSourceFiles = bl2;
    }

    public static String getUnitName(JasperReport jasperReport, JRDataset jRDataset) {
        return JRAbstractCompiler.getUnitName((JRReport)jasperReport, jRDataset, jasperReport.getCompileNameSuffix());
    }

    public static String getUnitName(JRReport jRReport, JRDataset jRDataset, String string) {
        String string2 = jRDataset.isMainDataset() ? jRReport.getName() : jRReport.getName() + "_" + jRDataset.getName();
        string2 = JRStringUtil.getLiteral(string2) + string;
        return string2;
    }

    public static String getUnitName(JasperReport jasperReport, JRCrosstab jRCrosstab) {
        return JRAbstractCompiler.getUnitName((JRReport)jasperReport, jRCrosstab.getId(), jasperReport.getCompileNameSuffix());
    }

    public static String getUnitName(JRReport jRReport, JRCrosstab jRCrosstab, JRExpressionCollector jRExpressionCollector, String string) {
        Integer n2 = jRExpressionCollector.getCrosstabId(jRCrosstab);
        if (n2 == null) {
            throw new JRRuntimeException("Crosstab ID not found.");
        }
        return JRAbstractCompiler.getUnitName(jRReport, n2, string);
    }

    public static String getUnitName(JRReport jRReport, int n2, String string) {
        return JRStringUtil.getLiteral(jRReport.getName()) + "_CROSSTAB" + n2 + string;
    }

    public final JasperReport compileReport(JasperDesign jasperDesign) throws JRException {
        Object object;
        Object object2;
        this.checkLanguage(jasperDesign.getLanguage());
        JRExpressionCollector jRExpressionCollector = JRExpressionCollector.collector(jasperDesign);
        this.verifyDesign(jasperDesign, jRExpressionCollector);
        String string = JRAbstractCompiler.createNameSuffix();
        boolean bl2 = JRProperties.getBooleanProperty("net.sf.jasperreports.compiler.keep.java.file");
        File file = null;
        if (!(!bl2 && !this.needsSourceFiles || (file = new File((String)(object2 = JRProperties.getProperty("net.sf.jasperreports.compiler.temp.dir")))).exists() && file.isDirectory())) {
            throw new JRException("Temporary directory not found : " + (String)object2);
        }
        object2 = jasperDesign.getDatasetsList();
        List list = jasperDesign.getCrosstabs();
        JRCompilationUnit[] jRCompilationUnitArray = new JRCompilationUnit[object2.size() + list.size() + 1];
        jRCompilationUnitArray[0] = this.createCompileUnit(jasperDesign, jasperDesign.getMainDesignDataset(), jRExpressionCollector, file, string);
        int n2 = 1;
        Object object3 = object2.iterator();
        while (object3.hasNext()) {
            object = (JRDesignDataset)object3.next();
            jRCompilationUnitArray[n2] = this.createCompileUnit(jasperDesign, (JRDesignDataset)object, jRExpressionCollector, file, string);
            ++n2;
        }
        object3 = list.iterator();
        while (object3.hasNext()) {
            object = (JRDesignCrosstab)object3.next();
            jRCompilationUnitArray[n2] = this.createCompileUnit(jasperDesign, (JRDesignCrosstab)object, jRExpressionCollector, file, string);
            ++n2;
        }
        object3 = JRProperties.getProperty("net.sf.jasperreports.compiler.classpath");
        try {
            Object object4;
            object = this.compileUnits(jRCompilationUnitArray, (String)object3, file);
            if (object != null) {
                throw new JRException("Errors were encountered when compiling report expressions class file:\n" + (String)object);
            }
            JRReportCompileData jRReportCompileData = new JRReportCompileData();
            jRReportCompileData.setMainDatasetCompileData(jRCompilationUnitArray[0].getCompileData());
            Object object5 = object2.listIterator();
            while (object5.hasNext()) {
                object4 = (JRDesignDataset)object5.next();
                jRReportCompileData.setDatasetCompileData((JRDataset)object4, jRCompilationUnitArray[object5.nextIndex()].getCompileData());
            }
            object5 = list.listIterator();
            while (object5.hasNext()) {
                object4 = (JRDesignCrosstab)object5.next();
                Integer n3 = jRExpressionCollector.getCrosstabId((JRCrosstab)object4);
                jRReportCompileData.setCrosstabCompileData(n3, jRCompilationUnitArray[object2.size() + object5.nextIndex()].getCompileData());
            }
            object4 = object5 = new JasperReport(jasperDesign, this.getCompilerClass(), jRReportCompileData, jRExpressionCollector, string);
            return object4;
        }
        catch (JRException jRException) {
            throw jRException;
        }
        catch (Exception exception) {
            throw new JRException("Error compiling report design.", exception);
        }
        finally {
            if (this.needsSourceFiles && !bl2) {
                this.deleteSourceFiles(jRCompilationUnitArray);
            }
        }
    }

    private static String createNameSuffix() {
        return "_" + System.currentTimeMillis() + "_" + random.nextInt(1000000);
    }

    public String getCompilerClass() {
        return this.getClass().getName();
    }

    private void verifyDesign(JasperDesign jasperDesign, JRExpressionCollector jRExpressionCollector) throws JRException {
        Collection collection = JRVerifier.verifyDesign(jasperDesign, jRExpressionCollector);
        if (collection != null && collection.size() > 0) {
            throw new JRValidationException(collection);
        }
    }

    private JRCompilationUnit createCompileUnit(JasperDesign jasperDesign, JRDesignDataset jRDesignDataset, JRExpressionCollector jRExpressionCollector, File file, String string) throws JRException {
        String string2 = JRAbstractCompiler.getUnitName((JRReport)jasperDesign, jRDesignDataset, string);
        JRSourceCompileTask jRSourceCompileTask = new JRSourceCompileTask(jasperDesign, jRDesignDataset, jRExpressionCollector, string2);
        JRCompilationSourceCode jRCompilationSourceCode = this.generateSourceCode(jRSourceCompileTask);
        File file2 = this.getSourceFile(file, string2, jRCompilationSourceCode);
        return new JRCompilationUnit(string2, jRCompilationSourceCode, file2, jRExpressionCollector.getExpressions(jRDesignDataset));
    }

    private JRCompilationUnit createCompileUnit(JasperDesign jasperDesign, JRDesignCrosstab jRDesignCrosstab, JRExpressionCollector jRExpressionCollector, File file, String string) throws JRException {
        String string2 = JRAbstractCompiler.getUnitName(jasperDesign, jRDesignCrosstab, jRExpressionCollector, string);
        JRSourceCompileTask jRSourceCompileTask = new JRSourceCompileTask(jasperDesign, jRDesignCrosstab, jRExpressionCollector, string2);
        JRCompilationSourceCode jRCompilationSourceCode = this.generateSourceCode(jRSourceCompileTask);
        File file2 = this.getSourceFile(file, string2, jRCompilationSourceCode);
        return new JRCompilationUnit(string2, jRCompilationSourceCode, file2, jRExpressionCollector.getExpressions(jRDesignCrosstab));
    }

    private File getSourceFile(File file, String string, JRCompilationSourceCode jRCompilationSourceCode) throws JRException {
        File file2 = null;
        if (file != null) {
            String string2 = this.getSourceFileName(string);
            file2 = new File(file, string2);
            JRSaver.saveClassSource(jRCompilationSourceCode.getCode(), file2);
        }
        return file2;
    }

    private void deleteSourceFiles(JRCompilationUnit[] jRCompilationUnitArray) {
        for (int i2 = 0; i2 < jRCompilationUnitArray.length; ++i2) {
            jRCompilationUnitArray[i2].getSourceFile().delete();
        }
    }

    public JREvaluator loadEvaluator(JasperReport jasperReport) throws JRException {
        return this.loadEvaluator(jasperReport, jasperReport.getMainDataset());
    }

    public JREvaluator loadEvaluator(JasperReport jasperReport, JRDataset jRDataset) throws JRException {
        String string = JRAbstractCompiler.getUnitName(jasperReport, jRDataset);
        JRReportCompileData jRReportCompileData = (JRReportCompileData)jasperReport.getCompileData();
        Serializable serializable = jRReportCompileData.getDatasetCompileData(jRDataset);
        return this.loadEvaluator(serializable, string);
    }

    public JREvaluator loadEvaluator(JasperReport jasperReport, JRCrosstab jRCrosstab) throws JRException {
        String string = JRAbstractCompiler.getUnitName(jasperReport, jRCrosstab);
        JRReportCompileData jRReportCompileData = (JRReportCompileData)jasperReport.getCompileData();
        Serializable serializable = jRReportCompileData.getCrosstabCompileData(jRCrosstab);
        return this.loadEvaluator(serializable, string);
    }

    public abstract JREvaluator loadEvaluator(Serializable var1, String var2) throws JRException;

    public abstract void checkLanguage(String var1) throws JRException;

    public abstract JRCompilationSourceCode generateSourceCode(JRSourceCompileTask var1) throws JRException;

    public abstract String compileUnits(JRCompilationUnit[] var1, String var2, File var3) throws JRException;

    public abstract String getSourceFileName(String var1);
}

