/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRCompilationSourceCode;
import net.sf.jasperreports.engine.design.JRDefaultCompilationSourceCode;
import net.sf.jasperreports.engine.design.JRSourceCompileTask;
import net.sf.jasperreports.engine.util.JRStringUtil;

public class JRClassGenerator {
    private static final int EXPR_MAX_COUNT_PER_METHOD = 100;
    public static final String SOURCE_EXPRESSION_ID_START = "$JR_EXPR_ID=";
    public static final int sOURCE_EXPRESSION_ID_START_LENGTH = "$JR_EXPR_ID=".length();
    public static final String SOURCE_EXPRESSION_ID_END = "$";
    private static Map fieldPrefixMap = null;
    private static Map variablePrefixMap = null;
    private static Map methodSuffixMap = null;
    public final JRSourceCompileTask sourceTask;
    public Map parametersMap;
    public Map fieldsMap;
    public Map variablesMap;
    public JRVariable[] variables;

    public JRClassGenerator(JRSourceCompileTask jRSourceCompileTask) {
        this.sourceTask = jRSourceCompileTask;
        this.parametersMap = jRSourceCompileTask.getParametersMap();
        this.fieldsMap = jRSourceCompileTask.getFieldsMap();
        this.variablesMap = jRSourceCompileTask.getVariablesMap();
        this.variables = jRSourceCompileTask.getVariables();
    }

    public static JRCompilationSourceCode generateClass(JRSourceCompileTask jRSourceCompileTask) throws JRException {
        JRClassGenerator jRClassGenerator = new JRClassGenerator(jRSourceCompileTask);
        return jRClassGenerator.generateClass();
    }

    public JRCompilationSourceCode generateClass() throws JRException {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        this.generateClassStart(stringBuffer);
        this.generateDeclarations(stringBuffer);
        this.generateInitMethod(stringBuffer);
        this.generateInitParamsMethod(stringBuffer);
        if (this.fieldsMap != null) {
            this.generateInitFieldsMethod(stringBuffer);
        }
        this.generateInitVarsMethod(stringBuffer);
        List list = this.sourceTask.getExpressions();
        stringBuffer.append(this.generateMethod((byte)3, list));
        if (this.sourceTask.isOnlyDefaultEvaluation()) {
            object = new ArrayList();
            stringBuffer.append(this.generateMethod((byte)1, (List)object));
            stringBuffer.append(this.generateMethod((byte)2, (List)object));
        } else {
            stringBuffer.append(this.generateMethod((byte)1, list));
            stringBuffer.append(this.generateMethod((byte)2, list));
        }
        stringBuffer.append("}\n");
        object = stringBuffer.toString();
        JRExpression[] jRExpressionArray = this.parseSourceLines((String)object);
        return new JRDefaultCompilationSourceCode((String)object, jRExpressionArray);
    }

    private void generateInitMethod(StringBuffer stringBuffer) {
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("    /**\n");
        stringBuffer.append("     *\n");
        stringBuffer.append("     */\n");
        stringBuffer.append("    public void customizedInit(\n");
        stringBuffer.append("        Map pm,\n");
        stringBuffer.append("        Map fm,\n");
        stringBuffer.append("        Map vm\n");
        stringBuffer.append("        )\n");
        stringBuffer.append("    {\n");
        stringBuffer.append("        initParams(pm);\n");
        if (this.fieldsMap != null) {
            stringBuffer.append("        initFields(fm);\n");
        }
        stringBuffer.append("        initVars(vm);\n");
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
    }

    public final void generateClassStart(StringBuffer stringBuffer) {
        stringBuffer.append("/*\n");
        stringBuffer.append(" * Generated by JasperReports - ");
        stringBuffer.append(new SimpleDateFormat().format(new Date()));
        stringBuffer.append("\n");
        stringBuffer.append(" */\n");
        stringBuffer.append("import net.sf.jasperreports.engine.*;\n");
        stringBuffer.append("import net.sf.jasperreports.engine.fill.*;\n");
        stringBuffer.append("\n");
        stringBuffer.append("import java.util.*;\n");
        stringBuffer.append("import java.math.*;\n");
        stringBuffer.append("import java.text.*;\n");
        stringBuffer.append("import java.io.*;\n");
        stringBuffer.append("import java.net.*;\n");
        stringBuffer.append("\n");
        String[] stringArray = this.sourceTask.getImports();
        if (stringArray != null && stringArray.length > 0) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                stringBuffer.append("import ");
                stringBuffer.append(stringArray[i2]);
                stringBuffer.append(";\n");
            }
        }
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("/**\n");
        stringBuffer.append(" *\n");
        stringBuffer.append(" */\n");
        stringBuffer.append("public class ");
        stringBuffer.append(this.sourceTask.getUnitName());
        stringBuffer.append(" extends JREvaluator\n");
        stringBuffer.append("{\n");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("    /**\n");
        stringBuffer.append("     *\n");
        stringBuffer.append("     */\n");
    }

    public final void generateDeclarations(StringBuffer stringBuffer) {
        Iterator iterator;
        Set set;
        if (this.parametersMap != null && this.parametersMap.size() > 0) {
            set = this.parametersMap.keySet();
            iterator = set.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("    private JRFillParameter parameter_");
                stringBuffer.append(JRStringUtil.getLiteral((String)iterator.next()));
                stringBuffer.append(" = null;\n");
            }
        }
        if (this.fieldsMap != null && this.fieldsMap.size() > 0) {
            set = this.fieldsMap.keySet();
            iterator = set.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("    private JRFillField field_");
                stringBuffer.append(JRStringUtil.getLiteral((String)iterator.next()));
                stringBuffer.append(" = null;\n");
            }
        }
        if (this.variables != null && this.variables.length > 0) {
            for (int i2 = 0; i2 < this.variables.length; ++i2) {
                stringBuffer.append("    private JRFillVariable variable_");
                stringBuffer.append(JRStringUtil.getLiteral(this.variables[i2].getName()));
                stringBuffer.append(" = null;\n");
            }
        }
    }

    public final void generateInitParamsMethod(StringBuffer stringBuffer) throws JRException {
        Iterator<Object> iterator = null;
        iterator = this.parametersMap != null && this.parametersMap.size() > 0 ? this.parametersMap.keySet().iterator() : Collections.EMPTY_SET.iterator();
        this.generateInitParamsMethod(stringBuffer, iterator, 0);
    }

    public final void generateInitFieldsMethod(StringBuffer stringBuffer) throws JRException {
        Iterator<Object> iterator = null;
        iterator = this.fieldsMap != null && this.fieldsMap.size() > 0 ? this.fieldsMap.keySet().iterator() : Collections.EMPTY_SET.iterator();
        this.generateInitFieldsMethod(stringBuffer, iterator, 0);
    }

    public final void generateInitVarsMethod(StringBuffer stringBuffer) throws JRException {
        Iterator<Object> iterator = null;
        iterator = this.variables != null && this.variables.length > 0 ? Arrays.asList(this.variables).iterator() : Collections.EMPTY_LIST.iterator();
        this.generateInitVarsMethod(stringBuffer, iterator, 0);
    }

    private void generateInitParamsMethod(StringBuffer stringBuffer, Iterator iterator, int n2) throws JRException {
        stringBuffer.append("    /**\n");
        stringBuffer.append("     *\n");
        stringBuffer.append("     */\n");
        stringBuffer.append("    private void initParams");
        if (n2 > 0) {
            stringBuffer.append(n2);
        }
        stringBuffer.append("(Map pm)\n");
        stringBuffer.append("    {\n");
        for (int i2 = 0; i2 < 100 && iterator.hasNext(); ++i2) {
            String string = (String)iterator.next();
            stringBuffer.append("        parameter_");
            stringBuffer.append(JRStringUtil.getLiteral(string));
            stringBuffer.append(" = (JRFillParameter)pm.get(\"");
            stringBuffer.append(string);
            stringBuffer.append("\");\n");
        }
        if (iterator.hasNext()) {
            stringBuffer.append("        initParams");
            stringBuffer.append(n2 + 1);
            stringBuffer.append("(pm);\n");
        }
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        if (iterator.hasNext()) {
            this.generateInitParamsMethod(stringBuffer, iterator, n2 + 1);
        }
    }

    private void generateInitFieldsMethod(StringBuffer stringBuffer, Iterator iterator, int n2) throws JRException {
        stringBuffer.append("    /**\n");
        stringBuffer.append("     *\n");
        stringBuffer.append("     */\n");
        stringBuffer.append("    private void initFields");
        if (n2 > 0) {
            stringBuffer.append(n2);
        }
        stringBuffer.append("(Map fm)\n");
        stringBuffer.append("    {\n");
        for (int i2 = 0; i2 < 100 && iterator.hasNext(); ++i2) {
            String string = (String)iterator.next();
            stringBuffer.append("        field_");
            stringBuffer.append(JRStringUtil.getLiteral(string));
            stringBuffer.append(" = (JRFillField)fm.get(\"");
            stringBuffer.append(string);
            stringBuffer.append("\");\n");
        }
        if (iterator.hasNext()) {
            stringBuffer.append("        initFields");
            stringBuffer.append(n2 + 1);
            stringBuffer.append("(fm);\n");
        }
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        if (iterator.hasNext()) {
            this.generateInitFieldsMethod(stringBuffer, iterator, n2 + 1);
        }
    }

    private void generateInitVarsMethod(StringBuffer stringBuffer, Iterator iterator, int n2) throws JRException {
        stringBuffer.append("    /**\n");
        stringBuffer.append("     *\n");
        stringBuffer.append("     */\n");
        stringBuffer.append("    private void initVars");
        if (n2 > 0) {
            stringBuffer.append(n2);
        }
        stringBuffer.append("(Map vm)\n");
        stringBuffer.append("    {\n");
        for (int i2 = 0; i2 < 100 && iterator.hasNext(); ++i2) {
            String string = ((JRVariable)iterator.next()).getName();
            stringBuffer.append("        variable_");
            stringBuffer.append(JRStringUtil.getLiteral(string));
            stringBuffer.append(" = (JRFillVariable)vm.get(\"");
            stringBuffer.append(string);
            stringBuffer.append("\");\n");
        }
        if (iterator.hasNext()) {
            stringBuffer.append("        initVars");
            stringBuffer.append(n2 + 1);
            stringBuffer.append("(vm);\n");
        }
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        if (iterator.hasNext()) {
            this.generateInitVarsMethod(stringBuffer, iterator, n2 + 1);
        }
    }

    public final String generateMethod(byte by2, List list) throws JRException {
        StringBuffer stringBuffer = new StringBuffer();
        if (list.size() > 0) {
            stringBuffer.append(this.generateMethod(list.listIterator(), 0, by2));
        } else {
            stringBuffer.append("    /**\n");
            stringBuffer.append("     *\n");
            stringBuffer.append("     */\n");
            stringBuffer.append("    public Object evaluate");
            stringBuffer.append((String)methodSuffixMap.get(new Byte(by2)));
            stringBuffer.append("(int id) throws Throwable\n");
            stringBuffer.append("    {\n");
            stringBuffer.append("        return null;\n");
            stringBuffer.append("    }\n");
            stringBuffer.append("\n");
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private String generateMethod(Iterator iterator, int n2, byte by2) throws JRException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    /**\n");
        stringBuffer.append("     *\n");
        stringBuffer.append("     */\n");
        if (n2 > 0) {
            stringBuffer.append("    private Object evaluate");
            stringBuffer.append((String)methodSuffixMap.get(new Byte(by2)));
            stringBuffer.append(n2);
        } else {
            stringBuffer.append("    public Object evaluate");
            stringBuffer.append((String)methodSuffixMap.get(new Byte(by2)));
        }
        stringBuffer.append("(int id) throws Throwable\n");
        stringBuffer.append("    {\n");
        stringBuffer.append("        Object value = null;\n");
        stringBuffer.append("\n");
        stringBuffer.append("        switch (id)\n");
        stringBuffer.append("        {\n");
        for (int i2 = 0; iterator.hasNext() && i2 < 100; ++i2) {
            JRExpression jRExpression = (JRExpression)iterator.next();
            stringBuffer.append("            case ");
            stringBuffer.append(this.sourceTask.getExpressionId(jRExpression));
            stringBuffer.append(" : \n");
            stringBuffer.append("            {\n");
            stringBuffer.append("                value = (");
            stringBuffer.append(jRExpression.getValueClassName());
            stringBuffer.append(")(");
            stringBuffer.append(this.generateExpression(jRExpression, by2));
            stringBuffer.append(");");
            stringBuffer.append(this.expressionComment(jRExpression));
            stringBuffer.append("\n");
            stringBuffer.append("                break;\n");
            stringBuffer.append("            }\n");
        }
        stringBuffer.append("           default :\n");
        stringBuffer.append("           {\n");
        if (iterator.hasNext()) {
            stringBuffer.append("               value = evaluate");
            stringBuffer.append((String)methodSuffixMap.get(new Byte(by2)));
            stringBuffer.append(n2 + 1);
            stringBuffer.append("(id);\n");
        }
        stringBuffer.append("           }\n");
        stringBuffer.append("        }\n");
        stringBuffer.append("        \n");
        stringBuffer.append("        return value;\n");
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        if (iterator.hasNext()) {
            stringBuffer.append(this.generateMethod(iterator, n2 + 1, by2));
        }
        return stringBuffer.toString();
    }

    private String generateExpression(JRExpression jRExpression, byte by2) {
        JRParameter jRParameter = null;
        JRField jRField = null;
        JRVariable jRVariable = null;
        StringBuffer stringBuffer = new StringBuffer();
        JRExpressionChunk[] jRExpressionChunkArray = jRExpression.getChunks();
        JRExpressionChunk jRExpressionChunk = null;
        String string = null;
        if (jRExpressionChunkArray != null && jRExpressionChunkArray.length > 0) {
            block7: for (int i2 = 0; i2 < jRExpressionChunkArray.length; ++i2) {
                jRExpressionChunk = jRExpressionChunkArray[i2];
                string = jRExpressionChunk.getText();
                if (string == null) {
                    string = "";
                }
                switch (jRExpressionChunk.getType()) {
                    case 1: {
                        this.appendExpressionText(jRExpression, stringBuffer, string);
                        continue block7;
                    }
                    case 2: {
                        jRParameter = (JRParameter)this.parametersMap.get(string);
                        stringBuffer.append("((");
                        stringBuffer.append(jRParameter.getValueClassName());
                        stringBuffer.append(")parameter_");
                        stringBuffer.append(JRStringUtil.getLiteral(string));
                        stringBuffer.append(".getValue())");
                        continue block7;
                    }
                    case 3: {
                        jRField = (JRField)this.fieldsMap.get(string);
                        stringBuffer.append("((");
                        stringBuffer.append(jRField.getValueClassName());
                        stringBuffer.append(")field_");
                        stringBuffer.append(JRStringUtil.getLiteral(string));
                        stringBuffer.append(".get");
                        stringBuffer.append((String)fieldPrefixMap.get(new Byte(by2)));
                        stringBuffer.append("Value())");
                        continue block7;
                    }
                    case 4: {
                        jRVariable = (JRVariable)this.variablesMap.get(string);
                        stringBuffer.append("((");
                        stringBuffer.append(jRVariable.getValueClassName());
                        stringBuffer.append(")variable_");
                        stringBuffer.append(JRStringUtil.getLiteral(string));
                        stringBuffer.append(".get");
                        stringBuffer.append((String)variablePrefixMap.get(new Byte(by2)));
                        stringBuffer.append("Value())");
                        continue block7;
                    }
                    case 5: {
                        stringBuffer.append("str(\"");
                        stringBuffer.append(string);
                        stringBuffer.append("\")");
                    }
                }
            }
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("null");
        }
        return stringBuffer.toString();
    }

    public void appendExpressionText(JRExpression jRExpression, StringBuffer stringBuffer, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        if (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(this.expressionComment(jRExpression));
                stringBuffer.append("\n");
                stringBuffer.append(stringTokenizer.nextToken());
            }
        }
    }

    public String expressionComment(JRExpression jRExpression) {
        StringBuffer stringBuffer = new StringBuffer(24);
        stringBuffer.append("//");
        stringBuffer.append(SOURCE_EXPRESSION_ID_START);
        stringBuffer.append(this.sourceTask.getExpressionId(jRExpression));
        stringBuffer.append(SOURCE_EXPRESSION_ID_END);
        return stringBuffer.toString();
    }

    public JRExpression[] parseSourceLines(String string) {
        ArrayList<JRExpression> arrayList = new ArrayList<JRExpression>();
        int n2 = 0;
        int n3 = string.indexOf(10);
        while (n3 >= 0) {
            JRExpression jRExpression = null;
            if (n2 < n3) {
                String string2 = string.substring(n2, n3);
                jRExpression = this.getLineExpression(string2);
            }
            arrayList.add(jRExpression);
            n2 = n3 + 1;
            n3 = string.indexOf(10, n2);
        }
        return arrayList.toArray(new JRExpression[arrayList.size()]);
    }

    public JRExpression getLineExpression(String string) {
        int n2;
        JRExpression jRExpression = null;
        int n3 = string.indexOf(SOURCE_EXPRESSION_ID_START);
        if (n3 >= 0 && (n2 = string.indexOf(SOURCE_EXPRESSION_ID_END, n3 += sOURCE_EXPRESSION_ID_START_LENGTH)) >= 0) {
            try {
                int n4 = Integer.parseInt(string.substring(n3, n2));
                jRExpression = this.sourceTask.getExpression(n4);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return jRExpression;
    }

    static {
        fieldPrefixMap = new HashMap();
        fieldPrefixMap.put(new Byte(1), "Old");
        fieldPrefixMap.put(new Byte(2), "");
        fieldPrefixMap.put(new Byte(3), "");
        variablePrefixMap = new HashMap();
        variablePrefixMap.put(new Byte(1), "Old");
        variablePrefixMap.put(new Byte(2), "Estimated");
        variablePrefixMap.put(new Byte(3), "");
        methodSuffixMap = new HashMap();
        methodSuffixMap.put(new Byte(1), "Old");
        methodSuffixMap.put(new Byte(2), "Estimated");
        methodSuffixMap.put(new Byte(3), "");
    }
}

