/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.base.JRBaseHyperlink;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;

public class JRDesignHyperlink
extends JRBaseHyperlink
implements JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_HYPERLINK_ANCHOR_EXPRESSION = "hyperlinkAnchorExpression";
    public static final String PROPERTY_HYPERLINK_PAGE_EXPRESSION = "hyperlinkPageExpression";
    public static final String PROPERTY_HYPERLINK_REFERENCE_EXPRESSION = "hyperlinkReferenceExpression";
    public static final String PROPERTY_HYPERLINK_TARGET = "hyperlinkTarget";
    public static final String PROPERTY_HYPERLINK_TOOLTIP_EXPRESSION = "hyperlinkTooltipExpression";
    public static final String PROPERTY_LINK_TYPE = "linkType";
    public static final String PROPERTY_HYPERLINK_PARAMETERS = "hyperlinkParameters";
    private List hyperlinkParameters = new ArrayList();
    private transient JRPropertyChangeSupport eventSupport;

    public void setHyperlinkType(byte by2) {
        this.setLinkType(JRHyperlinkHelper.getLinkType(by2));
    }

    public void setHyperlinkTarget(byte by2) {
        byte by3 = this.hyperlinkTarget;
        this.hyperlinkTarget = by2;
        this.getEventSupport().firePropertyChange(PROPERTY_HYPERLINK_TARGET, by3, this.hyperlinkTarget);
    }

    public void setHyperlinkReferenceExpression(JRExpression jRExpression) {
        JRExpression jRExpression2 = this.hyperlinkReferenceExpression;
        this.hyperlinkReferenceExpression = jRExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_HYPERLINK_REFERENCE_EXPRESSION, jRExpression2, this.hyperlinkReferenceExpression);
    }

    public void setHyperlinkAnchorExpression(JRExpression jRExpression) {
        JRExpression jRExpression2 = this.hyperlinkAnchorExpression;
        this.hyperlinkAnchorExpression = jRExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_HYPERLINK_ANCHOR_EXPRESSION, jRExpression2, this.hyperlinkAnchorExpression);
    }

    public void setHyperlinkPageExpression(JRExpression jRExpression) {
        JRExpression jRExpression2 = this.hyperlinkPageExpression;
        this.hyperlinkPageExpression = jRExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_HYPERLINK_PAGE_EXPRESSION, jRExpression2, this.hyperlinkPageExpression);
    }

    public void setLinkType(String string) {
        String string2 = this.linkType;
        this.linkType = string;
        this.getEventSupport().firePropertyChange(PROPERTY_LINK_TYPE, string2, this.linkType);
    }

    public JRHyperlinkParameter[] getHyperlinkParameters() {
        JRHyperlinkParameter[] jRHyperlinkParameterArray;
        if (this.hyperlinkParameters.isEmpty()) {
            jRHyperlinkParameterArray = null;
        } else {
            jRHyperlinkParameterArray = new JRHyperlinkParameter[this.hyperlinkParameters.size()];
            this.hyperlinkParameters.toArray(jRHyperlinkParameterArray);
        }
        return jRHyperlinkParameterArray;
    }

    public List getHyperlinkParametersList() {
        return this.hyperlinkParameters;
    }

    public void addHyperlinkParameter(JRHyperlinkParameter jRHyperlinkParameter) {
        this.hyperlinkParameters.add(jRHyperlinkParameter);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_HYPERLINK_PARAMETERS, jRHyperlinkParameter, this.hyperlinkParameters.size() - 1);
    }

    public void removeHyperlinkParameter(JRHyperlinkParameter jRHyperlinkParameter) {
        int n2 = this.hyperlinkParameters.indexOf(jRHyperlinkParameter);
        if (n2 >= 0) {
            this.hyperlinkParameters.remove(n2);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_HYPERLINK_PARAMETERS, jRHyperlinkParameter, n2);
        }
    }

    public void removeHyperlinkParameter(String string) {
        ListIterator listIterator = this.hyperlinkParameters.listIterator();
        while (listIterator.hasNext()) {
            JRHyperlinkParameter jRHyperlinkParameter = (JRHyperlinkParameter)listIterator.next();
            if (jRHyperlinkParameter.getName() == null || !jRHyperlinkParameter.getName().equals(string)) continue;
            listIterator.remove();
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_HYPERLINK_PARAMETERS, jRHyperlinkParameter, listIterator.nextIndex());
        }
    }

    public void setHyperlinkTooltipExpression(JRExpression jRExpression) {
        JRExpression jRExpression2 = this.hyperlinkTooltipExpression;
        this.hyperlinkTooltipExpression = jRExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_HYPERLINK_TARGET, jRExpression2, this.hyperlinkTooltipExpression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        JRDesignHyperlink jRDesignHyperlink = this;
        synchronized (jRDesignHyperlink) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }
}

