/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;

public class JRReportCompileData
implements Serializable {
    private static final long serialVersionUID = 10200L;
    private Serializable mainDatasetCompileData;
    private Map datasetCompileData = new HashMap();
    private Map crosstabCompileData = new HashMap();

    public void setMainDatasetCompileData(Serializable serializable) {
        this.mainDatasetCompileData = serializable;
    }

    public void setDatasetCompileData(JRDataset jRDataset, Serializable serializable) {
        if (jRDataset.isMainDataset()) {
            this.setMainDatasetCompileData(serializable);
        } else {
            this.datasetCompileData.put(jRDataset.getName(), serializable);
        }
    }

    public void setCrosstabCompileData(int n2, Serializable serializable) {
        this.crosstabCompileData.put(new Integer(n2), serializable);
    }

    public Serializable getMainDatasetCompileData() {
        return this.mainDatasetCompileData;
    }

    public Serializable getDatasetCompileData(JRDataset jRDataset) throws JRException {
        Serializable serializable;
        if (jRDataset.isMainDataset()) {
            serializable = this.getMainDatasetCompileData();
        } else {
            serializable = (Serializable)this.datasetCompileData.get(jRDataset.getName());
            if (serializable == null) {
                throw new JRException("Compile data for dataset " + jRDataset.getName() + " not found in the report.");
            }
        }
        return serializable;
    }

    public Serializable getCrosstabCompileData(JRCrosstab jRCrosstab) throws JRException {
        Serializable serializable = (Serializable)this.crosstabCompileData.get(new Integer(jRCrosstab.getId()));
        if (serializable == null) {
            throw new JRException("Compile data for crosstab not found in the report.");
        }
        return serializable;
    }
}

