/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.List;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;
import net.sf.jasperreports.engine.export.JROriginExporterFilter;
import net.sf.jasperreports.engine.export.TextRenderer;
import net.sf.jasperreports.engine.export.draw.FrameDrawer;
import net.sf.jasperreports.engine.util.JRGraphEnvInitializer;
import net.sf.jasperreports.engine.util.JRProperties;

public class JRGraphics2DExporter
extends JRAbstractExporter {
    private static final float DEFAULT_ZOOM = 1.0f;
    public static final String MINIMIZE_PRINTER_JOB_SIZE = "net.sf.jasperreports.export.graphics2d.min.job.size";
    private static final String GRAPHICS2D_ORIGIN_EXPORTER_FILTER_PREFIX = "net.sf.jasperreports.export.graphics2d.exclude.origin.";
    public Graphics2D grx = null;
    public JRExportProgressMonitor progressMonitor = null;
    public float zoom = 1.0f;
    public TextRenderer textRenderer = null;
    public FrameDrawer frameDrawer = null;

    public JRGraphics2DExporter() throws JRException {
        JRGraphEnvInitializer.initializeGraphEnv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport() throws JRException {
        this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
        this.setOffset(false);
        try {
            this.setExportContext();
            this.setInput();
            if (!this.parameters.containsKey(JRExporterParameter.FILTER)) {
                this.filter = JROriginExporterFilter.getFilter(this.jasperPrint.getPropertiesMap(), GRAPHICS2D_ORIGIN_EXPORTER_FILTER_PREFIX);
            }
            this.setPageRange();
            this.setTextRenderer();
            this.grx = (Graphics2D)this.parameters.get(JRGraphics2DExporterParameter.GRAPHICS_2D);
            if (this.grx == null) {
                throw new JRException("No output specified for the exporter. java.awt.Graphics2D object expected.");
            }
            this.setDrawers();
            Float f2 = (Float)this.parameters.get(JRGraphics2DExporterParameter.ZOOM_RATIO);
            if (f2 != null) {
                this.zoom = f2.floatValue();
                if (this.zoom <= 0.0f) {
                    throw new JRException("Invalid zoom ratio : " + this.zoom);
                }
            } else {
                this.zoom = 1.0f;
            }
            this.exportReportToGraphics2D();
        }
        finally {
            this.resetExportContext();
        }
    }

    public void setTextRenderer() {
        boolean bl2 = true;
        Boolean bl3 = (Boolean)this.parameters.get(JRGraphics2DExporterParameter.MINIMIZE_PRINTER_JOB_SIZE);
        bl2 = bl3 == null ? JRProperties.getBooleanProperty(MINIMIZE_PRINTER_JOB_SIZE) : bl3;
        this.textRenderer = new TextRenderer(bl2);
    }

    public void setDrawers() {
        this.frameDrawer = new FrameDrawer(this.filter, this.textRenderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReportToGraphics2D() throws JRException {
        this.grx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.grx.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.grx.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(this.globalOffsetX, this.globalOffsetY);
        affineTransform.scale(this.zoom, this.zoom);
        this.grx.transform(affineTransform);
        List list = this.jasperPrint.getPages();
        if (list != null) {
            Shape shape = this.grx.getClip();
            this.grx.clip(new Rectangle(0, 0, this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight()));
            try {
                JRPrintPage jRPrintPage = (JRPrintPage)list.get(this.startPageIndex);
                this.exportPage(jRPrintPage);
            }
            finally {
                this.grx.setClip(shape);
            }
        }
    }

    public void exportPage(JRPrintPage jRPrintPage) throws JRException {
        this.grx.setColor(Color.white);
        this.grx.fillRect(0, 0, this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight());
        this.grx.setColor(Color.black);
        this.grx.setStroke(new BasicStroke(1.0f));
        this.frameDrawer.draw(this.grx, jRPrintPage.getElements(), this.getOffsetX(), this.getOffsetY());
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }
}

