/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRImageMapRenderer;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementIndex;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintImageArea;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRHtmlExporterNature;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import net.sf.jasperreports.engine.export.JROriginExporterFilter;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.Pair;

public class JRHtmlExporter
extends JRAbstractExporter {
    private static final String HTML_ORIGIN_EXPORTER_FILTER_PREFIX = "net.sf.jasperreports.export.html.exclude.origin.";
    public static final String PROPERTY_FRAMES_AS_NESTED_TABLES = "net.sf.jasperreports.export.html.frames.as.nested.tables";
    public static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    public static final String CSS_TEXT_ALIGN_LEFT = "left";
    public static final String CSS_TEXT_ALIGN_RIGHT = "right";
    public static final String CSS_TEXT_ALIGN_CENTER = "center";
    public static final String CSS_TEXT_ALIGN_JUSTIFY = "justify";
    public static final String HTML_VERTICAL_ALIGN_TOP = "top";
    public static final String HTML_VERTICAL_ALIGN_MIDDLE = "middle";
    public static final String HTML_VERTICAL_ALIGN_BOTTOM = "bottom";
    public static final String IMAGE_NAME_PREFIX = "img_";
    public static final int IMAGE_NAME_PREFIX_LEGTH = "img_".length();
    public Writer writer = null;
    public JRExportProgressMonitor progressMonitor = null;
    public Map rendererToImagePathMap = null;
    public Map imageMaps;
    public Map imageNameToImageDataMap = null;
    public List imagesToProcess = null;
    public boolean isPxImageLoaded = false;
    public int reportIndex = 0;
    public int pageIndex = 0;
    public File imagesDir = null;
    public String imagesURI = null;
    public boolean isOutputImagesToDir = false;
    public boolean isRemoveEmptySpace;
    public boolean isWhitePageBackground;
    public String encoding;
    public String sizeUnit = null;
    public boolean isUsingImagesToAlign;
    public boolean isWrapBreakWord;
    public String htmlHeader = null;
    public String betweenPagesHtml = null;
    public String htmlFooter = null;
    public StringProvider emptyCellStringProvider = null;
    public Map fontMap = null;
    private LinkedList backcolorStack = new LinkedList();
    private Color backcolor = null;
    public JRHyperlinkProducerFactory hyperlinkProducerFactory;
    public boolean deepGrid;
    public ExporterNature nature = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport() throws JRException {
        block70: {
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                Object object;
                Object object2;
                String string;
                Object object3;
                this.setExportContext();
                this.setInput();
                if (!this.parameters.containsKey(JRExporterParameter.FILTER)) {
                    this.filter = JROriginExporterFilter.getFilter(this.jasperPrint.getPropertiesMap(), HTML_ORIGIN_EXPORTER_FILTER_PREFIX);
                }
                if (!this.isModeBatch) {
                    this.setPageRange();
                }
                this.htmlHeader = (String)this.parameters.get(JRHtmlExporterParameter.HTML_HEADER);
                this.betweenPagesHtml = (String)this.parameters.get(JRHtmlExporterParameter.BETWEEN_PAGES_HTML);
                this.htmlFooter = (String)this.parameters.get(JRHtmlExporterParameter.HTML_FOOTER);
                this.imagesDir = (File)this.parameters.get(JRHtmlExporterParameter.IMAGES_DIR);
                if (this.imagesDir == null && (object3 = (String)this.parameters.get(JRHtmlExporterParameter.IMAGES_DIR_NAME)) != null) {
                    this.imagesDir = new File((String)object3);
                }
                this.isRemoveEmptySpace = this.getBooleanParameter(JRHtmlExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, "net.sf.jasperreports.export.html.remove.emtpy.space.between.rows", false);
                this.isWhitePageBackground = this.getBooleanParameter(JRHtmlExporterParameter.IS_WHITE_PAGE_BACKGROUND, "net.sf.jasperreports.export.xls.white.page.background", true);
                object3 = (Boolean)this.parameters.get(JRHtmlExporterParameter.IS_OUTPUT_IMAGES_TO_DIR);
                if (object3 != null) {
                    this.isOutputImagesToDir = (Boolean)object3;
                }
                if ((string = (String)this.parameters.get(JRHtmlExporterParameter.IMAGES_URI)) != null) {
                    this.imagesURI = string;
                }
                this.encoding = this.getStringParameterOrDefault(JRExporterParameter.CHARACTER_ENCODING, "net.sf.jasperreports.export.character.encoding");
                this.rendererToImagePathMap = new HashMap();
                this.imageMaps = new HashMap();
                this.imagesToProcess = new ArrayList();
                this.isPxImageLoaded = false;
                this.imageNameToImageDataMap = (Map)this.parameters.get(JRHtmlExporterParameter.IMAGES_MAP);
                this.isWrapBreakWord = this.getBooleanParameter(JRHtmlExporterParameter.IS_WRAP_BREAK_WORD, "net.sf.jasperreports.export.html.wrap.break.word", false);
                this.sizeUnit = this.getStringParameterOrDefault(JRHtmlExporterParameter.SIZE_UNIT, "net.sf.jasperreports.export.html.size.unit");
                this.isUsingImagesToAlign = this.getBooleanParameter(JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, "net.sf.jasperreports.export.html.using.images.to.align", true);
                if (this.isUsingImagesToAlign) {
                    this.emptyCellStringProvider = new StringProvider(this){
                        private final JRHtmlExporter this$0;
                        {
                            this.this$0 = jRHtmlExporter;
                        }

                        public String getStringForCollapsedTD(Object object, int n2, int n3, String string) {
                            return "><img alt=\"\" src=\"" + object + "px\" style=\"width: " + n2 + string + "; height: " + n3 + string + ";\"/>";
                        }

                        public String getStringForEmptyTD(Object object) {
                            return "<img alt=\"\" src=\"" + object + "px\" border=\"0\"/>";
                        }
                    };
                    this.loadPxImage();
                } else {
                    this.emptyCellStringProvider = new StringProvider(this){
                        private final JRHtmlExporter this$0;
                        {
                            this.this$0 = jRHtmlExporter;
                        }

                        public String getStringForCollapsedTD(Object object, int n2, int n3, String string) {
                            return " style=\"width: " + n2 + string + "; height: " + n3 + string + ";\">";
                        }

                        public String getStringForEmptyTD(Object object) {
                            return "";
                        }
                    };
                }
                this.fontMap = (Map)this.parameters.get(JRExporterParameter.FONT_MAP);
                this.setHyperlinkProducerFactory();
                this.setDeepGrid();
                this.nature = new JRHtmlExporterNature(this.filter, this.deepGrid);
                StringBuffer stringBuffer = (StringBuffer)this.parameters.get(JRExporterParameter.OUTPUT_STRING_BUFFER);
                if (stringBuffer != null) {
                    try {
                        this.writer = new StringWriter();
                        this.exportReportToWriter();
                        stringBuffer.append(this.writer.toString());
                    }
                    catch (IOException iOException) {
                        throw new JRException("Error writing to StringBuffer writer : " + this.jasperPrint.getName(), iOException);
                    }
                    finally {
                        if (this.writer != null) {
                            try {
                                this.writer.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                this.writer = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
                if (this.writer != null) {
                    try {
                        this.exportReportToWriter();
                    }
                    catch (IOException iOException) {
                        throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), iOException);
                    }
                }
                Object object4 = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (object4 != null) {
                    try {
                        this.writer = new OutputStreamWriter((OutputStream)object4, this.encoding);
                        this.exportReportToWriter();
                    }
                    catch (IOException iOException) {
                        throw new JRException("Error writing to OutputStream writer : " + this.jasperPrint.getName(), iOException);
                    }
                }
                Object object5 = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (object5 == null) {
                    object2 = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (object2 != null) {
                        object5 = new File((String)object2);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                try {
                    object4 = new FileOutputStream((File)object5);
                    this.writer = new OutputStreamWriter((OutputStream)object4, this.encoding);
                }
                catch (IOException iOException) {
                    throw new JRException("Error creating to file writer : " + this.jasperPrint.getName(), iOException);
                }
                if (this.imagesDir == null) {
                    this.imagesDir = new File(((File)object5).getParent(), ((File)object5).getName() + "_files");
                }
                if (object3 == null) {
                    this.isOutputImagesToDir = true;
                }
                if (this.imagesURI == null) {
                    this.imagesURI = this.imagesDir.getName() + "/";
                }
                try {
                    this.exportReportToWriter();
                }
                catch (IOException iOException) {
                    throw new JRException("Error writing to file writer : " + this.jasperPrint.getName(), iOException);
                }
                finally {
                    if (this.writer != null) {
                        try {
                            this.writer.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (!this.isOutputImagesToDir) break block70;
                if (this.imagesDir == null) {
                    throw new JRException("The images directory was not specified for the exporter.");
                }
                if (!this.isPxImageLoaded && (this.imagesToProcess == null || this.imagesToProcess.size() <= 0)) break block70;
                if (!this.imagesDir.exists()) {
                    this.imagesDir.mkdir();
                }
                if (this.isPxImageLoaded) {
                    object4 = JRImageRenderer.getInstance("net/sf/jasperreports/engine/images/pixel.GIF");
                    object5 = object4.getImageData();
                    object2 = new File(this.imagesDir, "px");
                    object = null;
                    try {
                        object = new FileOutputStream((File)object2);
                        ((FileOutputStream)object).write((byte[])object5, 0, ((Object)object5).length);
                    }
                    catch (IOException iOException) {
                        throw new JRException("Error writing to image file : " + object2, iOException);
                    }
                    finally {
                        if (object != null) {
                            try {
                                ((FileOutputStream)object).close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                object4 = this.imagesToProcess.iterator();
                while (object4.hasNext()) {
                    object5 = (JRPrintElementIndex)object4.next();
                    object2 = JRHtmlExporter.getImage(this.jasperPrintList, (JRPrintElementIndex)object5);
                    object = object2.getRenderer();
                    if (object.getType() == 1) {
                        object = new JRWrappingSvgRenderer((JRRenderable)object, new Dimension(object2.getWidth(), object2.getHeight()), 1 == object2.getMode() ? object2.getBackcolor() : null);
                    }
                    byte[] byArray = object.getImageData();
                    File file = new File(this.imagesDir, JRHtmlExporter.getImageName((JRPrintElementIndex)object5));
                    FileOutputStream fileOutputStream = null;
                    try {
                        fileOutputStream = new FileOutputStream(file);
                        fileOutputStream.write(byArray, 0, byArray.length);
                    }
                    catch (IOException iOException) {
                        throw new JRException("Error writing to image file : " + file, iOException);
                    }
                    finally {
                        if (fileOutputStream == null) continue;
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    public void setHyperlinkProducerFactory() {
        this.hyperlinkProducerFactory = (JRHyperlinkProducerFactory)this.parameters.get(JRExporterParameter.HYPERLINK_PRODUCER_FACTORY);
    }

    public void setDeepGrid() {
        Boolean bl2 = (Boolean)this.parameters.get(JRHtmlExporterParameter.FRAMES_AS_NESTED_TABLES);
        boolean bl3 = bl2 == null ? JRProperties.getBooleanProperty(PROPERTY_FRAMES_AS_NESTED_TABLES) : bl2;
        this.deepGrid = !bl3;
    }

    public static JRPrintImage getImage(List list, String string) {
        return JRHtmlExporter.getImage(list, JRHtmlExporter.getPrintElementIndex(string));
    }

    public static JRPrintImage getImage(List list, JRPrintElementIndex jRPrintElementIndex) {
        JasperPrint jasperPrint = (JasperPrint)list.get(jRPrintElementIndex.getReportIndex());
        JRPrintPage jRPrintPage = (JRPrintPage)jasperPrint.getPages().get(jRPrintElementIndex.getPageIndex());
        Integer[] integerArray = jRPrintElementIndex.getAddressArray();
        Object e2 = jRPrintPage.getElements().get(integerArray[0]);
        for (int i2 = 1; i2 < integerArray.length; ++i2) {
            JRPrintFrame jRPrintFrame = (JRPrintFrame)e2;
            e2 = jRPrintFrame.getElements().get(integerArray[i2]);
        }
        return (JRPrintImage)e2;
    }

    public void exportReportToWriter() throws JRException, IOException {
        if (this.htmlHeader == null) {
            this.writer.write("<html>\n");
            this.writer.write("<head>\n");
            this.writer.write("  <title></title>\n");
            this.writer.write("  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + this.encoding + "\"/>\n");
            this.writer.write("  <style type=\"text/css\">\n");
            this.writer.write("    a {text-decoration: none}\n");
            this.writer.write("  </style>\n");
            this.writer.write("</head>\n");
            this.writer.write("<body text=\"#000000\" link=\"#000000\" alink=\"#000000\" vlink=\"#000000\">\n");
            this.writer.write("<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">\n");
            this.writer.write("<tr><td width=\"50%\">&nbsp;</td><td align=\"center\">\n");
            this.writer.write("\n");
        } else {
            this.writer.write(this.htmlHeader);
        }
        this.reportIndex = 0;
        while (this.reportIndex < this.jasperPrintList.size()) {
            this.jasperPrint = (JasperPrint)this.jasperPrintList.get(this.reportIndex);
            List list = this.jasperPrint.getPages();
            if (list != null && list.size() > 0) {
                if (this.isModeBatch) {
                    this.startPageIndex = 0;
                    this.endPageIndex = list.size() - 1;
                }
                JRPrintPage jRPrintPage = null;
                this.pageIndex = this.startPageIndex;
                while (this.pageIndex <= this.endPageIndex) {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new JRException("Current thread interrupted.");
                    }
                    jRPrintPage = (JRPrintPage)list.get(this.pageIndex);
                    this.writer.write("<a name=\"JR_PAGE_ANCHOR_" + this.reportIndex + "_" + (this.pageIndex + 1) + "\"/>\n");
                    this.exportPage(jRPrintPage);
                    if (this.reportIndex < this.jasperPrintList.size() - 1 || this.pageIndex < this.endPageIndex) {
                        if (this.betweenPagesHtml == null) {
                            this.writer.write("<br/>\n<br/>\n");
                        } else {
                            this.writer.write(this.betweenPagesHtml);
                        }
                    }
                    this.writer.write("\n");
                    ++this.pageIndex;
                }
            }
            ++this.reportIndex;
        }
        if (this.htmlFooter == null) {
            this.writer.write("</td><td width=\"50%\">&nbsp;</td></tr>\n");
            this.writer.write("</table>\n");
            this.writer.write("</body>\n");
            this.writer.write("</html>\n");
        } else {
            this.writer.write(this.htmlFooter);
        }
        this.writer.flush();
    }

    public void exportPage(JRPrintPage jRPrintPage) throws JRException, IOException {
        JRGridLayout jRGridLayout = new JRGridLayout(this.nature, jRPrintPage.getElements(), this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight(), this.globalOffsetX, this.globalOffsetY, null);
        this.exportGrid(jRGridLayout, this.isWhitePageBackground);
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    public void exportGrid(JRGridLayout jRGridLayout, boolean bl2) throws IOException, JRException {
        int n2;
        CutsInfo cutsInfo = jRGridLayout.getXCuts();
        JRExporterGridCell[][] jRExporterGridCellArray = jRGridLayout.getGrid();
        this.writer.write("<table style=\"width: " + jRGridLayout.getWidth() + this.sizeUnit + "\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"");
        if (bl2) {
            this.writer.write(" bgcolor=\"white\"");
        }
        this.writer.write(">\n");
        if (bl2) {
            this.setBackcolor(Color.white);
        }
        this.writer.write("<tr>\n");
        int n3 = 0;
        for (n2 = 1; n2 < cutsInfo.size(); ++n2) {
            n3 = cutsInfo.getCut(n2) - cutsInfo.getCut(n2 - 1);
            this.writer.write("  <td" + this.emptyCellStringProvider.getStringForCollapsedTD(this.imagesURI, n3, 1, this.sizeUnit) + "</td>\n");
        }
        this.writer.write("</tr>\n");
        for (n2 = 0; n2 < jRExporterGridCellArray.length; ++n2) {
            if (!jRGridLayout.getYCuts().isCutSpanned(n2) && this.isRemoveEmptySpace) continue;
            JRExporterGridCell[] jRExporterGridCellArray2 = jRExporterGridCellArray[n2];
            int n4 = JRGridLayout.getRowHeight(jRExporterGridCellArray2);
            boolean bl3 = this.hasEmptyCell(jRExporterGridCellArray2);
            this.writer.write("<tr valign=\"top\"");
            if (!bl3) {
                this.writer.write(" style=\"height:" + n4 + this.sizeUnit + "\"");
            }
            this.writer.write(">\n");
            for (int i2 = 0; i2 < jRExporterGridCellArray2.length; ++i2) {
                JRExporterGridCell jRExporterGridCell = jRExporterGridCellArray2[i2];
                if (jRExporterGridCell.getWrapper() == null) {
                    this.writeEmptyCell(jRExporterGridCell, n4);
                } else {
                    JRPrintElement jRPrintElement = jRExporterGridCell.getWrapper().getElement();
                    if (jRPrintElement instanceof JRPrintLine) {
                        this.exportLine((JRPrintLine)jRPrintElement, jRExporterGridCell);
                    } else if (jRPrintElement instanceof JRPrintRectangle) {
                        this.exportRectangle((JRPrintRectangle)jRPrintElement, jRExporterGridCell);
                    } else if (jRPrintElement instanceof JRPrintEllipse) {
                        this.exportRectangle((JRPrintEllipse)jRPrintElement, jRExporterGridCell);
                    } else if (jRPrintElement instanceof JRPrintImage) {
                        this.exportImage((JRPrintImage)jRPrintElement, jRExporterGridCell);
                    } else if (jRPrintElement instanceof JRPrintText) {
                        this.exportText((JRPrintText)jRPrintElement, jRExporterGridCell);
                    } else if (jRPrintElement instanceof JRPrintFrame) {
                        this.exportFrame((JRPrintFrame)jRPrintElement, jRExporterGridCell);
                    }
                }
                i2 += jRExporterGridCell.getColSpan() - 1;
            }
            this.writer.write("</tr>\n");
        }
        if (bl2) {
            this.restoreBackcolor();
        }
        this.writer.write("</table>\n");
    }

    private boolean hasEmptyCell(JRExporterGridCell[] jRExporterGridCellArray) {
        if (jRExporterGridCellArray[0].getWrapper() == null) {
            return true;
        }
        boolean bl2 = false;
        for (int i2 = 1; i2 < jRExporterGridCellArray.length; ++i2) {
            if (jRExporterGridCellArray[i2].getWrapper() != null) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    public void writeEmptyCell(JRExporterGridCell jRExporterGridCell, int n2) throws IOException {
        this.writer.write("  <td");
        if (jRExporterGridCell.getColSpan() > 1) {
            this.writer.write(" colspan=\"" + jRExporterGridCell.getColSpan() + "\"");
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.appendBackcolorStyle(jRExporterGridCell, stringBuffer);
        this.appendBorderStyle(jRExporterGridCell.getBox(), stringBuffer);
        if (stringBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(stringBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write(this.emptyCellStringProvider.getStringForCollapsedTD(this.imagesURI, jRExporterGridCell.getWidth(), n2, this.sizeUnit));
        this.writer.write("</td>\n");
    }

    public void exportLine(JRPrintLine jRPrintLine, JRExporterGridCell jRExporterGridCell) throws IOException {
        this.writeCellTDStart(jRExporterGridCell);
        Color color = jRPrintLine.getLinePen().getLineColor();
        if (color.getRGB() != Color.white.getRGB()) {
            this.writer.write(" bgcolor=\"#");
            this.writer.write(JRColorUtil.getColorHexa(color));
            this.writer.write("\"");
        }
        this.writer.write(">");
        this.writer.write(this.emptyCellStringProvider.getStringForEmptyTD(this.imagesURI));
        this.writer.write("</td>\n");
    }

    public void writeCellTDStart(JRExporterGridCell jRExporterGridCell) throws IOException {
        this.writer.write("  <td");
        if (jRExporterGridCell.getColSpan() > 1) {
            this.writer.write(" colspan=\"" + jRExporterGridCell.getColSpan() + "\"");
        }
        if (jRExporterGridCell.getRowSpan() > 1) {
            this.writer.write(" rowspan=\"" + jRExporterGridCell.getRowSpan() + "\"");
        }
    }

    public void exportRectangle(JRPrintGraphicElement jRPrintGraphicElement, JRExporterGridCell jRExporterGridCell) throws IOException {
        this.writeCellTDStart(jRExporterGridCell);
        StringBuffer stringBuffer = new StringBuffer();
        this.appendBackcolorStyle(jRExporterGridCell, stringBuffer);
        this.appendPen(stringBuffer, jRPrintGraphicElement.getLinePen(), null);
        if (stringBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(stringBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write(">");
        this.writer.write(this.emptyCellStringProvider.getStringForEmptyTD(this.imagesURI));
        this.writer.write("</td>\n");
    }

    public void exportStyledText(JRStyledText jRStyledText) throws IOException {
        String string = jRStyledText.getText();
        int n2 = 0;
        AttributedCharacterIterator attributedCharacterIterator = jRStyledText.getAttributedString().getIterator();
        while (n2 < jRStyledText.length() && (n2 = attributedCharacterIterator.getRunLimit()) <= jRStyledText.length()) {
            this.exportStyledTextRun(attributedCharacterIterator.getAttributes(), string.substring(attributedCharacterIterator.getIndex(), n2));
            attributedCharacterIterator.setIndex(n2);
        }
    }

    public void exportStyledTextRun(Map map, String string) throws IOException {
        Color color;
        String string2 = (String)map.get(TextAttribute.FAMILY);
        String string3 = this.fontMap != null && this.fontMap.containsKey(string2) ? (String)this.fontMap.get(string2) : string2;
        this.writer.write("<span style=\"font-family: ");
        this.writer.write(string3);
        this.writer.write("; ");
        Color color2 = (Color)map.get(TextAttribute.FOREGROUND);
        if (!Color.black.equals(color2)) {
            this.writer.write("color: #");
            this.writer.write(JRColorUtil.getColorHexa(color2));
            this.writer.write("; ");
        }
        if ((color = (Color)map.get(TextAttribute.BACKGROUND)) != null) {
            this.writer.write("background-color: #");
            this.writer.write(JRColorUtil.getColorHexa(color));
            this.writer.write("; ");
        }
        this.writer.write("font-size: ");
        this.writer.write(String.valueOf(map.get(TextAttribute.SIZE)));
        this.writer.write(this.sizeUnit);
        this.writer.write(";");
        if (TextAttribute.WEIGHT_BOLD.equals(map.get(TextAttribute.WEIGHT))) {
            this.writer.write(" font-weight: bold;");
        }
        if (TextAttribute.POSTURE_OBLIQUE.equals(map.get(TextAttribute.POSTURE))) {
            this.writer.write(" font-style: italic;");
        }
        if (TextAttribute.UNDERLINE_ON.equals(map.get(TextAttribute.UNDERLINE))) {
            this.writer.write(" text-decoration: underline;");
        }
        if (TextAttribute.STRIKETHROUGH_ON.equals(map.get(TextAttribute.STRIKETHROUGH))) {
            this.writer.write(" text-decoration: line-through;");
        }
        if (TextAttribute.SUPERSCRIPT_SUPER.equals(map.get(TextAttribute.SUPERSCRIPT))) {
            this.writer.write(" vertical-align: super;");
        } else if (TextAttribute.SUPERSCRIPT_SUB.equals(map.get(TextAttribute.SUPERSCRIPT))) {
            this.writer.write(" vertical-align: sub;");
        }
        this.writer.write("\">");
        this.writer.write(JRStringUtil.htmlEncode(string));
        this.writer.write("</span>");
    }

    public void exportText(JRPrintText jRPrintText, JRExporterGridCell jRExporterGridCell) throws IOException {
        JRStyledText jRStyledText = this.getStyledText(jRPrintText);
        int n2 = 0;
        if (jRStyledText != null) {
            n2 = jRStyledText.length();
        }
        this.writeCellTDStart(jRExporterGridCell);
        String string = HTML_VERTICAL_ALIGN_TOP;
        switch (jRPrintText.getVerticalAlignment()) {
            case 3: {
                string = HTML_VERTICAL_ALIGN_BOTTOM;
                break;
            }
            case 2: {
                string = HTML_VERTICAL_ALIGN_MIDDLE;
                break;
            }
            default: {
                string = HTML_VERTICAL_ALIGN_TOP;
            }
        }
        if (!string.equals(HTML_VERTICAL_ALIGN_TOP)) {
            this.writer.write(" valign=\"");
            this.writer.write(string);
            this.writer.write("\"");
        }
        if (jRPrintText.getRunDirection() == 1) {
            this.writer.write(" dir=\"rtl\"");
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.appendBackcolorStyle(jRExporterGridCell, stringBuffer);
        this.appendBorderStyle(jRExporterGridCell.getBox(), stringBuffer);
        String string2 = CSS_TEXT_ALIGN_LEFT;
        if (n2 > 0) {
            switch (jRPrintText.getHorizontalAlignment()) {
                case 3: {
                    string2 = CSS_TEXT_ALIGN_RIGHT;
                    break;
                }
                case 2: {
                    string2 = CSS_TEXT_ALIGN_CENTER;
                    break;
                }
                case 4: {
                    string2 = CSS_TEXT_ALIGN_JUSTIFY;
                    break;
                }
                default: {
                    string2 = CSS_TEXT_ALIGN_LEFT;
                }
            }
            if (jRPrintText.getRunDirection() == 0 && !string2.equals(CSS_TEXT_ALIGN_LEFT) || jRPrintText.getRunDirection() == 1 && !string2.equals(CSS_TEXT_ALIGN_RIGHT)) {
                stringBuffer.append("text-align: ");
                stringBuffer.append(string2);
                stringBuffer.append(";");
            }
        }
        if (this.isWrapBreakWord) {
            stringBuffer.append("width: " + jRExporterGridCell.getWidth() + this.sizeUnit + "; ");
            stringBuffer.append("word-wrap: break-word; ");
        }
        if (jRPrintText.getLineSpacing() != 0) {
            stringBuffer.append("line-height: " + jRPrintText.getLineSpacingFactor() + "; ");
        }
        if (stringBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(stringBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write(">");
        if (jRPrintText.getAnchorName() != null) {
            this.writer.write("<a name=\"");
            this.writer.write(jRPrintText.getAnchorName());
            this.writer.write("\"/>");
        }
        boolean bl2 = this.startHyperlink(jRPrintText);
        if (n2 > 0) {
            this.exportStyledText(jRStyledText);
        } else {
            this.writer.write(this.emptyCellStringProvider.getStringForEmptyTD(this.imagesURI));
        }
        if (bl2) {
            this.endHyperlink();
        }
        this.writer.write("</td>\n");
    }

    public boolean startHyperlink(JRPrintHyperlink jRPrintHyperlink) throws IOException {
        String string = this.getHyperlinkURL(jRPrintHyperlink);
        if (string != null) {
            this.writer.write("<a href=\"");
            this.writer.write(string);
            this.writer.write("\"");
            String string2 = this.getHyperlinkTarget(jRPrintHyperlink);
            if (string2 != null) {
                this.writer.write(" target=\"");
                this.writer.write(string2);
                this.writer.write("\"");
            }
            if (jRPrintHyperlink.getHyperlinkTooltip() != null) {
                this.writer.write(" title=\"");
                this.writer.write(JRStringUtil.xmlEncode(jRPrintHyperlink.getHyperlinkTooltip()));
                this.writer.write("\"");
            }
            this.writer.write(">");
        }
        return string != null;
    }

    public String getHyperlinkTarget(JRPrintHyperlink jRPrintHyperlink) {
        String string = null;
        switch (jRPrintHyperlink.getHyperlinkTarget()) {
            case 2: {
                string = "_blank";
                break;
            }
        }
        return string;
    }

    public String getHyperlinkURL(JRPrintHyperlink jRPrintHyperlink) {
        String string;
        block13: {
            JRHyperlinkProducer jRHyperlinkProducer;
            block12: {
                string = null;
                jRHyperlinkProducer = this.getCustomHandler(jRPrintHyperlink);
                if (jRHyperlinkProducer != null) break block12;
                switch (jRPrintHyperlink.getHyperlinkType()) {
                    case 2: {
                        if (jRPrintHyperlink.getHyperlinkReference() != null) {
                            string = jRPrintHyperlink.getHyperlinkReference();
                            break;
                        }
                        break block13;
                    }
                    case 3: {
                        if (jRPrintHyperlink.getHyperlinkAnchor() != null) {
                            string = "#" + jRPrintHyperlink.getHyperlinkAnchor();
                            break;
                        }
                        break block13;
                    }
                    case 4: {
                        if (jRPrintHyperlink.getHyperlinkPage() != null) {
                            string = "#JR_PAGE_ANCHOR_" + this.reportIndex + "_" + jRPrintHyperlink.getHyperlinkPage().toString();
                            break;
                        }
                        break block13;
                    }
                    case 5: {
                        if (jRPrintHyperlink.getHyperlinkReference() != null && jRPrintHyperlink.getHyperlinkAnchor() != null) {
                            string = jRPrintHyperlink.getHyperlinkReference() + "#" + jRPrintHyperlink.getHyperlinkAnchor();
                            break;
                        }
                        break block13;
                    }
                    case 6: {
                        if (jRPrintHyperlink.getHyperlinkReference() != null && jRPrintHyperlink.getHyperlinkPage() != null) {
                            string = jRPrintHyperlink.getHyperlinkReference() + "#" + JR_PAGE_ANCHOR_PREFIX + "0_" + jRPrintHyperlink.getHyperlinkPage().toString();
                            break;
                        }
                        break block13;
                    }
                }
                break block13;
            }
            string = jRHyperlinkProducer.getHyperlink(jRPrintHyperlink);
        }
        return string;
    }

    public JRHyperlinkProducer getCustomHandler(JRPrintHyperlink jRPrintHyperlink) {
        return this.hyperlinkProducerFactory == null ? null : this.hyperlinkProducerFactory.getHandler(jRPrintHyperlink.getLinkType());
    }

    public void endHyperlink() throws IOException {
        this.writer.write("</a>");
    }

    public boolean appendBorderStyle(JRLineBox jRLineBox, StringBuffer stringBuffer) {
        boolean bl2 = false;
        if (jRLineBox != null) {
            bl2 |= this.appendPen(stringBuffer, jRLineBox.getTopPen(), HTML_VERTICAL_ALIGN_TOP);
            bl2 |= this.appendPadding(stringBuffer, jRLineBox.getTopPadding(), HTML_VERTICAL_ALIGN_TOP);
            bl2 |= this.appendPen(stringBuffer, jRLineBox.getLeftPen(), CSS_TEXT_ALIGN_LEFT);
            bl2 |= this.appendPadding(stringBuffer, jRLineBox.getLeftPadding(), CSS_TEXT_ALIGN_LEFT);
            bl2 |= this.appendPen(stringBuffer, jRLineBox.getBottomPen(), HTML_VERTICAL_ALIGN_BOTTOM);
            bl2 |= this.appendPadding(stringBuffer, jRLineBox.getBottomPadding(), HTML_VERTICAL_ALIGN_BOTTOM);
            bl2 |= this.appendPen(stringBuffer, jRLineBox.getRightPen(), CSS_TEXT_ALIGN_RIGHT);
            bl2 |= this.appendPadding(stringBuffer, jRLineBox.getRightPadding(), CSS_TEXT_ALIGN_RIGHT);
        }
        return bl2;
    }

    public Color appendBackcolorStyle(JRExporterGridCell jRExporterGridCell, StringBuffer stringBuffer) {
        Color color = jRExporterGridCell.getCellBackcolor();
        if (color != null && (this.backcolor == null || color.getRGB() != this.backcolor.getRGB())) {
            stringBuffer.append("background-color: #");
            stringBuffer.append(JRColorUtil.getColorHexa(color));
            stringBuffer.append("; ");
            return this.backcolor;
        }
        return null;
    }

    public void exportImage(JRPrintImage jRPrintImage, JRExporterGridCell jRExporterGridCell) throws JRException, IOException {
        JRRenderable jRRenderable;
        this.writeCellTDStart(jRExporterGridCell);
        String string = CSS_TEXT_ALIGN_LEFT;
        switch (jRPrintImage.getHorizontalAlignment()) {
            case 3: {
                string = CSS_TEXT_ALIGN_RIGHT;
                break;
            }
            case 2: {
                string = CSS_TEXT_ALIGN_CENTER;
                break;
            }
            default: {
                string = CSS_TEXT_ALIGN_LEFT;
            }
        }
        if (!string.equals(CSS_TEXT_ALIGN_LEFT)) {
            this.writer.write(" align=\"");
            this.writer.write(string);
            this.writer.write("\"");
        }
        String string2 = HTML_VERTICAL_ALIGN_TOP;
        switch (jRPrintImage.getVerticalAlignment()) {
            case 3: {
                string2 = HTML_VERTICAL_ALIGN_BOTTOM;
                break;
            }
            case 2: {
                string2 = HTML_VERTICAL_ALIGN_MIDDLE;
                break;
            }
            default: {
                string2 = HTML_VERTICAL_ALIGN_TOP;
            }
        }
        if (!string2.equals(HTML_VERTICAL_ALIGN_TOP)) {
            this.writer.write(" valign=\"");
            this.writer.write(string2);
            this.writer.write("\"");
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.appendBackcolorStyle(jRExporterGridCell, stringBuffer);
        boolean bl2 = this.appendBorderStyle(jRExporterGridCell.getBox(), stringBuffer);
        if (!bl2) {
            this.appendPen(stringBuffer, jRPrintImage.getLinePen(), null);
        }
        if (stringBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(stringBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write(">");
        if (jRPrintImage.getAnchorName() != null) {
            this.writer.write("<a name=\"");
            this.writer.write(jRPrintImage.getAnchorName());
            this.writer.write("\"/>");
        }
        JRRenderable jRRenderable2 = jRRenderable = jRPrintImage.getRenderer();
        boolean bl3 = jRRenderable != null && jRRenderable instanceof JRImageMapRenderer;
        boolean bl4 = false;
        if (jRRenderable != null || this.isUsingImagesToAlign) {
            int n2;
            bl4 = !bl3 && this.startHyperlink(jRPrintImage);
            this.writer.write("<img");
            String string3 = null;
            String string4 = null;
            List list = null;
            int n3 = jRPrintImage.getScaleImage();
            if (jRRenderable != null) {
                Object object;
                if (jRRenderable.getType() == 0 && this.rendererToImagePathMap.containsKey(jRRenderable.getId())) {
                    string3 = (String)this.rendererToImagePathMap.get(jRRenderable.getId());
                } else {
                    if (jRPrintImage.isLazy()) {
                        string3 = ((JRImageRenderer)jRRenderable).getImageLocation();
                    } else {
                        object = this.getElementIndex(jRExporterGridCell);
                        this.imagesToProcess.add(object);
                        String string5 = JRHtmlExporter.getImageName((JRPrintElementIndex)object);
                        string3 = this.imagesURI + string5;
                        if (this.imageNameToImageDataMap != null) {
                            if (jRRenderable.getType() == 1) {
                                jRRenderable = new JRWrappingSvgRenderer(jRRenderable, new Dimension(jRPrintImage.getWidth(), jRPrintImage.getHeight()), 1 == jRPrintImage.getMode() ? jRPrintImage.getBackcolor() : null);
                            }
                            this.imageNameToImageDataMap.put(string5, jRRenderable.getImageData());
                        }
                    }
                    this.rendererToImagePathMap.put(jRRenderable.getId(), string3);
                }
                if (bl3) {
                    object = new Rectangle(jRPrintImage.getWidth(), jRPrintImage.getHeight());
                    if (jRRenderable.getType() == 0) {
                        string4 = (String)this.imageMaps.get(new Pair(jRRenderable.getId(), object));
                    }
                    if (string4 == null) {
                        string4 = "map_" + this.getElementIndex(jRExporterGridCell).toString();
                        list = ((JRImageMapRenderer)jRRenderable2).getImageAreaHyperlinks((Rectangle2D)object);
                        if (jRRenderable.getType() == 0) {
                            this.imageMaps.put(new Pair(jRRenderable.getId(), object), string4);
                        }
                    }
                }
            } else {
                this.loadPxImage();
                string3 = this.imagesURI + "px";
                n3 = 2;
            }
            this.writer.write(" src=\"");
            if (string3 != null) {
                this.writer.write(string3);
            }
            this.writer.write("\"");
            int n4 = jRPrintImage.getWidth() - jRPrintImage.getLineBox().getLeftPadding() - jRPrintImage.getLineBox().getRightPadding();
            if (n4 < 0) {
                n4 = 0;
            }
            if ((n2 = jRPrintImage.getHeight() - jRPrintImage.getLineBox().getTopPadding() - jRPrintImage.getLineBox().getBottomPadding()) < 0) {
                n2 = 0;
            }
            switch (n3) {
                case 2: {
                    this.writer.write(" style=\"width: ");
                    this.writer.write(String.valueOf(n4));
                    this.writer.write(this.sizeUnit);
                    this.writer.write("; height: ");
                    this.writer.write(String.valueOf(n2));
                    this.writer.write(this.sizeUnit);
                    this.writer.write("\"");
                    break;
                }
                default: {
                    double d2 = n4;
                    double d3 = n2;
                    if (!jRPrintImage.isLazy()) {
                        Dimension2D dimension2D;
                        JRRenderable jRRenderable3 = JRImageRenderer.getOnErrorRendererForDimension(jRRenderable, jRPrintImage.getOnErrorType());
                        Dimension2D dimension2D2 = dimension2D = jRRenderable3 == null ? null : jRRenderable3.getDimension();
                        if (jRRenderable3 == jRRenderable && dimension2D != null) {
                            d2 = dimension2D.getWidth();
                            d3 = dimension2D.getHeight();
                        }
                    }
                    if (n2 <= 0) break;
                    double d4 = d2 / d3;
                    if (d4 > (double)n4 / (double)n2) {
                        this.writer.write(" style=\"width: ");
                        this.writer.write(String.valueOf(n4));
                        this.writer.write(this.sizeUnit);
                        this.writer.write("\"");
                        break;
                    }
                    this.writer.write(" style=\"height: ");
                    this.writer.write(String.valueOf(n2));
                    this.writer.write(this.sizeUnit);
                    this.writer.write("\"");
                }
            }
            if (string4 != null) {
                this.writer.write(" usemap=\"#" + string4 + "\"");
            }
            this.writer.write(" alt=\"\"/>");
            if (bl4) {
                this.endHyperlink();
            }
            if (list != null) {
                this.writer.write("\n");
                this.writeImageMap(string4, jRPrintImage, list);
            }
        }
        this.writer.write("</td>\n");
    }

    public JRPrintElementIndex getElementIndex(JRExporterGridCell jRExporterGridCell) {
        JRPrintElementIndex jRPrintElementIndex = new JRPrintElementIndex(this.reportIndex, this.pageIndex, jRExporterGridCell.getWrapper().getAddress());
        return jRPrintElementIndex;
    }

    public void writeImageMap(String string, JRPrintImage jRPrintImage, List list) throws IOException {
        this.writer.write("<map name=\"" + string + "\">\n");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JRPrintImageAreaHyperlink jRPrintImageAreaHyperlink = (JRPrintImageAreaHyperlink)iterator.next();
            JRPrintImageArea jRPrintImageArea = jRPrintImageAreaHyperlink.getArea();
            this.writer.write("  <area shape=\"" + JRPrintImageArea.getHtmlShape(jRPrintImageArea.getShape()) + "\"");
            this.writeImageAreaCoordinates(jRPrintImageArea.getCoordinates());
            this.writeImageAreaHyperlink(jRPrintImageAreaHyperlink.getHyperlink());
            this.writer.write("/>\n");
        }
        if (jRPrintImage.getHyperlinkType() != 1) {
            this.writer.write("  <area shape=\"default\"");
            this.writeImageAreaCoordinates(new int[]{0, 0, jRPrintImage.getWidth(), jRPrintImage.getHeight()});
            this.writeImageAreaHyperlink(jRPrintImage);
            this.writer.write("/>\n");
        }
        this.writer.write("</map>\n");
    }

    public void writeImageAreaCoordinates(int[] nArray) throws IOException {
        if (nArray != null && nArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer(nArray.length * 4);
            stringBuffer.append(nArray[0]);
            for (int i2 = 1; i2 < nArray.length; ++i2) {
                stringBuffer.append(',');
                stringBuffer.append(nArray[i2]);
            }
            this.writer.write(" coords=\"" + stringBuffer + "\"");
        }
    }

    public void writeImageAreaHyperlink(JRPrintHyperlink jRPrintHyperlink) throws IOException {
        String string = this.getHyperlinkURL(jRPrintHyperlink);
        if (string == null) {
            this.writer.write(" nohref=\"nohref\"");
        } else {
            this.writer.write(" href=\"" + string + "\"");
            String string2 = this.getHyperlinkTarget(jRPrintHyperlink);
            if (string2 != null) {
                this.writer.write(" target=\"");
                this.writer.write(string2);
                this.writer.write("\"");
            }
        }
        if (jRPrintHyperlink.getHyperlinkTooltip() != null) {
            this.writer.write(" title=\"");
            this.writer.write(JRStringUtil.xmlEncode(jRPrintHyperlink.getHyperlinkTooltip()));
            this.writer.write("\"");
        }
    }

    public void loadPxImage() throws JRException {
        this.isPxImageLoaded = true;
        if (this.imageNameToImageDataMap != null && !this.imageNameToImageDataMap.containsKey("px")) {
            JRRenderable jRRenderable = JRImageRenderer.getInstance("net/sf/jasperreports/engine/images/pixel.GIF");
            this.rendererToImagePathMap.put(jRRenderable.getId(), this.imagesURI + "px");
            this.imageNameToImageDataMap.put("px", jRRenderable.getImageData());
        }
    }

    private boolean appendPadding(StringBuffer stringBuffer, Integer n2, String string) {
        boolean bl2 = false;
        if (n2 > 0) {
            stringBuffer.append("padding");
            if (string != null) {
                stringBuffer.append("-");
                stringBuffer.append(string);
            }
            stringBuffer.append(": ");
            stringBuffer.append(n2);
            stringBuffer.append(this.sizeUnit);
            stringBuffer.append("; ");
            bl2 = true;
        }
        return bl2;
    }

    private boolean appendPen(StringBuffer stringBuffer, JRPen jRPen, String string) {
        boolean bl2 = false;
        float f2 = jRPen.getLineWidth().floatValue();
        if (0.0f < f2 && f2 < 1.0f) {
            f2 = 1.0f;
        }
        String string2 = null;
        switch (jRPen.getLineStyle()) {
            case 1: {
                string2 = "dashed";
                break;
            }
            default: {
                string2 = "solid";
            }
        }
        if (f2 > 0.0f) {
            stringBuffer.append("border");
            if (string != null) {
                stringBuffer.append("-");
                stringBuffer.append(string);
            }
            stringBuffer.append("-style: ");
            stringBuffer.append(string2);
            stringBuffer.append("; ");
            stringBuffer.append("border");
            if (string != null) {
                stringBuffer.append("-");
                stringBuffer.append(string);
            }
            stringBuffer.append("-width: ");
            stringBuffer.append((int)f2);
            stringBuffer.append(this.sizeUnit);
            stringBuffer.append("; ");
            stringBuffer.append("border");
            if (string != null) {
                stringBuffer.append("-");
                stringBuffer.append(string);
            }
            stringBuffer.append("-color: #");
            stringBuffer.append(JRColorUtil.getColorHexa(jRPen.getLineColor()));
            stringBuffer.append("; ");
            bl2 = true;
        }
        return bl2;
    }

    public static String getImageName(JRPrintElementIndex jRPrintElementIndex) {
        return IMAGE_NAME_PREFIX + jRPrintElementIndex.toString();
    }

    public static JRPrintElementIndex getPrintElementIndex(String string) {
        if (!string.startsWith(IMAGE_NAME_PREFIX)) {
            throw new JRRuntimeException("Invalid image name: " + string);
        }
        return JRPrintElementIndex.parsePrintElementIndex(string.substring(IMAGE_NAME_PREFIX_LEGTH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportFrame(JRPrintFrame jRPrintFrame, JRExporterGridCell jRExporterGridCell) throws IOException, JRException {
        this.writeCellTDStart(jRExporterGridCell);
        StringBuffer stringBuffer = new StringBuffer();
        Color color = this.appendBackcolorStyle(jRExporterGridCell, stringBuffer);
        this.appendBorderStyle(jRExporterGridCell.getBox(), stringBuffer);
        if (stringBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(stringBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write(">\n");
        if (color != null) {
            this.setBackcolor(color);
        }
        try {
            this.exportGrid(jRExporterGridCell.getLayout(), false);
        }
        finally {
            if (color != null) {
                this.restoreBackcolor();
            }
        }
        this.writer.write("</td>\n");
    }

    public void setBackcolor(Color color) {
        this.backcolorStack.addLast(this.backcolor);
        this.backcolor = color;
    }

    public void restoreBackcolor() {
        this.backcolor = (Color)this.backcolorStack.removeLast();
    }

    protected static interface StringProvider {
        public String getStringForCollapsedTD(Object var1, int var2, int var3, String var4);

        public String getStringForEmptyTD(Object var1);
    }
}

