/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.export.ResetableExporterFilter;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.fill.JRTemplatePrintElement;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.xml.JRXmlConstants;

public class JROriginExporterFilter
implements ResetableExporterFilter {
    private static final String KEEP_FIRST_PREFIX = "keep.first.";
    private static final String BAND_PREFIX = "band.";
    private static final String GROUP_PREFIX = "group.";
    private static final String REPORT_PREFIX = "report.";
    private Map originsToExclude = new HashMap();
    private Map firstOccurrences = new HashMap();

    public void addOrigin(JROrigin jROrigin) {
        this.addOrigin(jROrigin, false);
    }

    public void addOrigin(JROrigin jROrigin, boolean bl2) {
        this.originsToExclude.put(jROrigin, bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public void removeOrigin(JROrigin jROrigin) {
        this.originsToExclude.remove(jROrigin);
    }

    public void reset() {
        this.firstOccurrences = new HashMap();
    }

    public boolean isToExport(JRPrintElement jRPrintElement) {
        JROrigin jROrigin = jRPrintElement.getOrigin();
        Boolean bl2 = jROrigin == null ? null : (Boolean)this.originsToExclude.get(jROrigin);
        boolean bl3 = bl2 != null;
        return !bl3 || bl2 != false && (!(jRPrintElement instanceof JRTemplatePrintElement) || this.isFirst((JRTemplatePrintElement)jRPrintElement));
    }

    private boolean isFirst(JRTemplatePrintElement jRTemplatePrintElement) {
        JRTemplateElement jRTemplateElement = jRTemplatePrintElement.getTemplate();
        Object v2 = this.firstOccurrences.get(jRTemplateElement);
        if (v2 == null || v2 == jRTemplatePrintElement) {
            this.firstOccurrences.put(jRTemplateElement, jRTemplatePrintElement);
            return true;
        }
        return false;
    }

    public static JROriginExporterFilter getFilter(JRPropertiesMap jRPropertiesMap, String string) {
        JROriginExporterFilter jROriginExporterFilter = null;
        jROriginExporterFilter = JROriginExporterFilter.addOriginsToFilter(jROriginExporterFilter, jRPropertiesMap, string, false);
        jROriginExporterFilter = JROriginExporterFilter.addOriginsToFilter(jROriginExporterFilter, jRPropertiesMap, string + KEEP_FIRST_PREFIX, true);
        return jROriginExporterFilter;
    }

    private static JROriginExporterFilter addOriginsToFilter(JROriginExporterFilter jROriginExporterFilter, JRPropertiesMap jRPropertiesMap, String string, boolean bl2) {
        List list = JRProperties.getProperties(string + BAND_PREFIX);
        list.addAll(JRProperties.getProperties(jRPropertiesMap, string + BAND_PREFIX));
        if (!list.isEmpty()) {
            jROriginExporterFilter = jROriginExporterFilter == null ? new JROriginExporterFilter() : jROriginExporterFilter;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                JRProperties.PropertySuffix propertySuffix = (JRProperties.PropertySuffix)iterator.next();
                String string2 = propertySuffix.getSuffix();
                Byte by2 = (Byte)JRXmlConstants.getBandTypeMap().get(JRProperties.getProperty(jRPropertiesMap, propertySuffix.getKey()));
                if (by2 == null) continue;
                jROriginExporterFilter.addOrigin(new JROrigin(JRProperties.getProperty(jRPropertiesMap, string + REPORT_PREFIX + string2), JRProperties.getProperty(jRPropertiesMap, string + GROUP_PREFIX + string2), by2), bl2);
            }
        }
        return jROriginExporterFilter;
    }
}

