/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRCommonGraphicElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterNature;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.data.BooleanTextValue;
import net.sf.jasperreports.engine.export.data.DateTextValue;
import net.sf.jasperreports.engine.export.data.NumberTextValue;
import net.sf.jasperreports.engine.export.data.StringTextValue;
import net.sf.jasperreports.engine.export.data.TextValue;
import net.sf.jasperreports.engine.export.data.TextValueHandler;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import org.apache.commons.collections.ReferenceMap;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.hssf.util.Region;

public class JRXlsExporter
extends JRXlsAbstractExporter {
    private static Map hssfColorsCache = new ReferenceMap();
    public Map loadedCellStyles = new HashMap();
    public HSSFWorkbook workbook = null;
    public HSSFSheet sheet = null;
    public HSSFRow row = null;
    public HSSFCell cell = null;
    public HSSFCellStyle emptyCellStyle = null;
    public short whiteIndex = new HSSFColor.WHITE().getIndex();
    public short blackIndex = new HSSFColor.BLACK().getIndex();
    public short backgroundMode = 1;
    public HSSFDataFormat dataFormat = null;
    public Map formatPatternsMap = null;
    public ExporterNature nature = null;

    public void setParameters() {
        super.setParameters();
        this.formatPatternsMap = (Map)this.getParameter(JRXlsExporterParameter.FORMAT_PATTERNS_MAP);
        this.nature = new JRXlsExporterNature(this.filter, this.isIgnoreGraphics);
    }

    public void setBackground() {
        if (!this.isWhitePageBackground) {
            this.backgroundMode = 0;
        }
    }

    public void openWorkbook(OutputStream outputStream) {
        this.workbook = new HSSFWorkbook();
        this.emptyCellStyle = this.workbook.createCellStyle();
        this.emptyCellStyle.setFillForegroundColor(new HSSFColor.WHITE().getIndex());
        this.emptyCellStyle.setFillPattern(this.backgroundMode);
        this.dataFormat = this.workbook.createDataFormat();
    }

    public void createSheet(String string) {
        this.sheet = this.workbook.createSheet(string);
    }

    public void closeWorkbook(OutputStream outputStream) throws JRException {
        try {
            this.workbook.write(outputStream);
        }
        catch (IOException iOException) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), iOException);
        }
    }

    public void setColumnWidth(int n2, int n3) {
        this.sheet.setColumnWidth((short)n2, (short)n3);
    }

    public void setRowHeight(int n2, int n3) {
        this.row = this.sheet.getRow(n2);
        if (this.row == null) {
            this.row = this.sheet.createRow(n2);
        }
        this.row.setHeightInPoints((float)n3);
    }

    public void setCell(int n2, int n3) {
        HSSFCell hSSFCell = this.row.getCell((short)n2);
        if (hSSFCell == null) {
            hSSFCell = this.row.createCell((short)n2);
            hSSFCell.setCellStyle(this.emptyCellStyle);
        }
    }

    public void removeColumn(int n2) {
        this.sheet.setColumnHidden((short)n2, true);
    }

    public void addBlankCell(JRExporterGridCell jRExporterGridCell, int n2, int n3) {
        this.cell = this.row.createCell((short)n2);
        short s2 = this.backgroundMode;
        short s3 = this.whiteIndex;
        if (jRExporterGridCell.getCellBackcolor() != null) {
            s2 = 1;
            s3 = JRXlsExporter.getNearestColor(jRExporterGridCell.getCellBackcolor()).getIndex();
        }
        short s4 = this.blackIndex;
        if (jRExporterGridCell.getForecolor() != null) {
            s4 = JRXlsExporter.getNearestColor(jRExporterGridCell.getForecolor()).getIndex();
        }
        HSSFCellStyle hSSFCellStyle = this.getLoadedCellStyle(s2, s3, (short)1, (short)0, (short)0, this.getLoadedFont(this.getDefaultFont(), s4), jRExporterGridCell);
        this.cell.setCellStyle(hSSFCellStyle);
    }

    public void exportLine(JRPrintLine jRPrintLine, JRExporterGridCell jRExporterGridCell, int n2, int n3) {
        short s2 = JRXlsExporter.getNearestColor(jRPrintLine.getLinePen().getLineColor()).getIndex();
        HSSFCellStyle hSSFCellStyle = this.getLoadedCellStyle((short)1, s2, (short)1, (short)0, (short)0, this.getLoadedFont(this.getDefaultFont(), s2), jRExporterGridCell);
        this.createMergeRegion(jRExporterGridCell, n2, n3, hSSFCellStyle);
        this.cell = this.row.createCell((short)n2);
        this.cell.setCellStyle(hSSFCellStyle);
    }

    public void exportRectangle(JRPrintGraphicElement jRPrintGraphicElement, JRExporterGridCell jRExporterGridCell, int n2, int n3) {
        short s2 = JRXlsExporter.getNearestColor(jRPrintGraphicElement.getLinePen().getLineColor()).getIndex();
        short s3 = this.backgroundMode;
        short s4 = this.whiteIndex;
        if (jRExporterGridCell.getCellBackcolor() != null) {
            s3 = 1;
            s4 = JRXlsExporter.getNearestColor(jRExporterGridCell.getCellBackcolor()).getIndex();
        }
        HSSFCellStyle hSSFCellStyle = this.getLoadedCellStyle(s3, s4, (short)1, (short)0, (short)0, this.getLoadedFont(this.getDefaultFont(), s2), jRExporterGridCell);
        this.createMergeRegion(jRExporterGridCell, n2, n3, hSSFCellStyle);
        this.cell = this.row.createCell((short)n2);
        this.cell.setCellStyle(hSSFCellStyle);
    }

    public void exportText(JRPrintText jRPrintText, JRExporterGridCell jRExporterGridCell, int n2, int n3) throws JRException {
        JRStyledText jRStyledText = this.getStyledText(jRPrintText);
        if (jRStyledText == null) {
            return;
        }
        short s2 = JRXlsExporter.getNearestColor(jRPrintText.getForecolor()).getIndex();
        JRXlsAbstractExporter.TextAlignHolder textAlignHolder = JRXlsExporter.getTextAlignHolder(jRPrintText);
        short s3 = this.getHorizontalAlignment(textAlignHolder);
        short s4 = this.getVerticalAlignment(textAlignHolder);
        short s5 = this.getRotation(textAlignHolder);
        short s6 = this.backgroundMode;
        short s7 = this.whiteIndex;
        if (jRExporterGridCell.getCellBackcolor() != null) {
            s6 = 1;
            s7 = JRXlsExporter.getNearestColor(jRExporterGridCell.getCellBackcolor()).getIndex();
        }
        StyleInfo styleInfo = new StyleInfo(s6, s7, s3, s4, s5, this.getLoadedFont(jRPrintText, s2), jRExporterGridCell);
        this.createTextCell(jRPrintText, jRExporterGridCell, n2, n3, jRStyledText, styleInfo);
    }

    public void createTextCell(JRPrintText jRPrintText, JRExporterGridCell jRExporterGridCell, int n2, int n3, JRStyledText jRStyledText, StyleInfo styleInfo) throws JRException {
        String string = jRStyledText.getText();
        if (this.isDetectCellType) {
            TextValue textValue = this.getTextValue(jRPrintText, string);
            textValue.handle(new TextValueHandler(this, jRExporterGridCell, n2, n3, styleInfo){
                private final JRExporterGridCell val$gridCell;
                private final int val$colIndex;
                private final int val$rowIndex;
                private final StyleInfo val$baseStyle;
                private final JRXlsExporter this$0;
                {
                    this.this$0 = jRXlsExporter;
                    this.val$gridCell = jRExporterGridCell;
                    this.val$colIndex = n2;
                    this.val$rowIndex = n3;
                    this.val$baseStyle = styleInfo;
                }

                public void handle(StringTextValue stringTextValue) {
                    HSSFCellStyle hSSFCellStyle = this.this$0.initCreateCell(this.val$gridCell, this.val$colIndex, this.val$rowIndex, this.val$baseStyle);
                    this.this$0.setStringCellValue(stringTextValue.getText());
                    this.this$0.endCreateCell(hSSFCellStyle);
                }

                public void handle(NumberTextValue numberTextValue) {
                    if (numberTextValue.getPattern() != null) {
                        this.val$baseStyle.setDataFormat(this.this$0.dataFormat.getFormat(this.getConvertedPattern(numberTextValue.getPattern())));
                    }
                    HSSFCellStyle hSSFCellStyle = this.this$0.initCreateCell(this.val$gridCell, this.val$colIndex, this.val$rowIndex, this.val$baseStyle);
                    if (numberTextValue.getValue() == null) {
                        this.this$0.cell.setCellType(3);
                    } else {
                        this.this$0.cell.setCellValue(numberTextValue.getValue().doubleValue());
                    }
                    this.this$0.endCreateCell(hSSFCellStyle);
                }

                public void handle(DateTextValue dateTextValue) {
                    this.val$baseStyle.setDataFormat(this.this$0.dataFormat.getFormat(this.getConvertedPattern(dateTextValue.getPattern())));
                    HSSFCellStyle hSSFCellStyle = this.this$0.initCreateCell(this.val$gridCell, this.val$colIndex, this.val$rowIndex, this.val$baseStyle);
                    if (dateTextValue.getValue() == null) {
                        this.this$0.cell.setCellType(3);
                    } else {
                        this.this$0.cell.setCellValue(dateTextValue.getValue());
                    }
                    this.this$0.endCreateCell(hSSFCellStyle);
                }

                public void handle(BooleanTextValue booleanTextValue) {
                    HSSFCellStyle hSSFCellStyle = this.this$0.initCreateCell(this.val$gridCell, this.val$colIndex, this.val$rowIndex, this.val$baseStyle);
                    if (booleanTextValue.getValue() == null) {
                        this.this$0.cell.setCellType(3);
                    } else {
                        this.this$0.cell.setCellValue(booleanTextValue.getValue().booleanValue());
                    }
                    this.this$0.endCreateCell(hSSFCellStyle);
                }

                private String getConvertedPattern(String string) {
                    if (this.this$0.formatPatternsMap != null && this.this$0.formatPatternsMap.containsKey(string)) {
                        return (String)this.this$0.formatPatternsMap.get(string);
                    }
                    return string;
                }
            });
        } else if (this.isAutoDetectCellType) {
            HSSFCellStyle hSSFCellStyle = this.initCreateCell(jRExporterGridCell, n2, n3, styleInfo);
            try {
                this.cell.setCellValue(Double.parseDouble(string));
            }
            catch (NumberFormatException numberFormatException) {
                this.setStringCellValue(string);
            }
            this.endCreateCell(hSSFCellStyle);
        } else {
            HSSFCellStyle hSSFCellStyle = this.initCreateCell(jRExporterGridCell, n2, n3, styleInfo);
            this.setStringCellValue(string);
            this.endCreateCell(hSSFCellStyle);
        }
    }

    public HSSFCellStyle initCreateCell(JRExporterGridCell jRExporterGridCell, int n2, int n3, StyleInfo styleInfo) {
        HSSFCellStyle hSSFCellStyle = this.getLoadedCellStyle(styleInfo);
        this.createMergeRegion(jRExporterGridCell, n2, n3, hSSFCellStyle);
        this.cell = this.row.createCell((short)n2);
        this.cell.setEncoding((short)1);
        return hSSFCellStyle;
    }

    public void endCreateCell(HSSFCellStyle hSSFCellStyle) {
        this.cell.setCellStyle(hSSFCellStyle);
    }

    public final void setStringCellValue(String string) {
        this.cell.setCellValue(JRStringUtil.replaceDosEOL(string));
    }

    public void createMergeRegion(JRExporterGridCell jRExporterGridCell, int n2, int n3, HSSFCellStyle hSSFCellStyle) {
        if (jRExporterGridCell.getColSpan() > 1 || jRExporterGridCell.getRowSpan() > 1) {
            if (this.isCollapseRowSpan) {
                this.sheet.addMergedRegion(new Region(n3, (short)n2, n3, (short)(n2 + jRExporterGridCell.getColSpan() - 1)));
            } else {
                this.sheet.addMergedRegion(new Region(n3, (short)n2, n3 + jRExporterGridCell.getRowSpan() - 1, (short)(n2 + jRExporterGridCell.getColSpan() - 1)));
            }
            for (int i2 = 0; i2 < jRExporterGridCell.getRowSpan(); ++i2) {
                HSSFRow hSSFRow = this.sheet.getRow(n3 + i2);
                if (hSSFRow == null) {
                    hSSFRow = this.sheet.createRow(n3 + i2);
                }
                for (int i3 = 0; i3 < jRExporterGridCell.getColSpan(); ++i3) {
                    HSSFCell hSSFCell = hSSFRow.getCell((short)(n2 + i3));
                    if (hSSFCell == null) {
                        hSSFCell = hSSFRow.createCell((short)(n2 + i3));
                    }
                    hSSFCell.setCellStyle(hSSFCellStyle);
                }
            }
        }
    }

    private short getHorizontalAlignment(JRXlsAbstractExporter.TextAlignHolder textAlignHolder) {
        switch (textAlignHolder.horizontalAlignment) {
            case 3: {
                return 3;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 5;
            }
        }
        return 1;
    }

    private short getVerticalAlignment(JRXlsAbstractExporter.TextAlignHolder textAlignHolder) {
        switch (textAlignHolder.verticalAlignment) {
            case 3: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 3;
            }
        }
        return 0;
    }

    private short getRotation(JRXlsAbstractExporter.TextAlignHolder textAlignHolder) {
        switch (textAlignHolder.rotation) {
            case 1: {
                return 90;
            }
            case 2: {
                return -90;
            }
        }
        return 0;
    }

    public static HSSFColor getNearestColor(Color color) {
        HSSFColor hSSFColor = (HSSFColor)hssfColorsCache.get(color);
        if (hSSFColor == null) {
            Set set;
            Hashtable hashtable = HSSFColor.getTripletHash();
            if (hashtable != null && (set = hashtable.keySet()) != null && set.size() > 0) {
                Object var4_4 = null;
                HSSFColor hSSFColor2 = null;
                short[] sArray = null;
                int n2 = 0;
                int n3 = 999;
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    var4_4 = iterator.next();
                    hSSFColor2 = (HSSFColor)hashtable.get(var4_4);
                    sArray = hSSFColor2.getTriplet();
                    n2 = Math.abs(sArray[0] - color.getRed()) + Math.abs(sArray[1] - color.getGreen()) + Math.abs(sArray[2] - color.getBlue());
                    if (n2 >= n3) continue;
                    n3 = n2;
                    hSSFColor = hSSFColor2;
                }
            }
            hssfColorsCache.put(color, hSSFColor);
        }
        return hSSFColor;
    }

    public HSSFFont getLoadedFont(JRFont jRFont, short s2) {
        short s3;
        HSSFFont hSSFFont = null;
        String string = jRFont.getFontName();
        if (this.fontMap != null && this.fontMap.containsKey(string)) {
            string = (String)this.fontMap.get(string);
        }
        for (s3 = 0; s3 < this.loadedFonts.size(); ++s3) {
            HSSFFont hSSFFont2 = (HSSFFont)this.loadedFonts.get(s3);
            short s4 = (short)jRFont.getFontSize();
            if (this.isFontSizeFixEnabled) {
                s4 = (short)(s4 - 1);
            }
            if (!hSSFFont2.getFontName().equals(string) || hSSFFont2.getColor() != s2 || hSSFFont2.getFontHeightInPoints() != s4 || !(hSSFFont2.getUnderline() == 1 ? jRFont.isUnderline() : !jRFont.isUnderline()) || hSSFFont2.getStrikeout() != jRFont.isStrikeThrough() || !(hSSFFont2.getBoldweight() == 700 ? jRFont.isBold() : !jRFont.isBold()) || hSSFFont2.getItalic() != jRFont.isItalic()) continue;
            hSSFFont = hSSFFont2;
            break;
        }
        if (hSSFFont == null) {
            hSSFFont = this.workbook.createFont();
            hSSFFont.setFontName(string);
            hSSFFont.setColor(s2);
            s3 = (short)jRFont.getFontSize();
            if (this.isFontSizeFixEnabled) {
                s3 = (short)(s3 - 1);
            }
            hSSFFont.setFontHeightInPoints(s3);
            if (jRFont.isUnderline()) {
                hSSFFont.setUnderline((byte)1);
            }
            if (jRFont.isStrikeThrough()) {
                hSSFFont.setStrikeout(true);
            }
            if (jRFont.isBold()) {
                hSSFFont.setBoldweight((short)700);
            }
            if (jRFont.isItalic()) {
                hSSFFont.setItalic(true);
            }
            this.loadedFonts.add(hSSFFont);
        }
        return hSSFFont;
    }

    public HSSFCellStyle getLoadedCellStyle(StyleInfo styleInfo) {
        HSSFCellStyle hSSFCellStyle = (HSSFCellStyle)this.loadedCellStyles.get(styleInfo);
        if (hSSFCellStyle == null) {
            hSSFCellStyle = this.workbook.createCellStyle();
            hSSFCellStyle.setFillForegroundColor(styleInfo.backcolor);
            hSSFCellStyle.setFillPattern(styleInfo.mode);
            hSSFCellStyle.setAlignment(styleInfo.horizontalAlignment);
            hSSFCellStyle.setVerticalAlignment(styleInfo.verticalAlignment);
            hSSFCellStyle.setRotation(styleInfo.rotation);
            hSSFCellStyle.setFont(styleInfo.font);
            hSSFCellStyle.setWrapText(true);
            if (styleInfo.hasDataFormat()) {
                hSSFCellStyle.setDataFormat(styleInfo.getDataFormat());
            }
            if (!this.isIgnoreCellBorder) {
                BoxStyle boxStyle = styleInfo.box;
                hSSFCellStyle.setBorderTop(boxStyle.topBorder);
                hSSFCellStyle.setTopBorderColor(boxStyle.topBorderColour);
                hSSFCellStyle.setBorderLeft(boxStyle.leftBorder);
                hSSFCellStyle.setLeftBorderColor(boxStyle.leftBorderColour);
                hSSFCellStyle.setBorderBottom(boxStyle.bottomBorder);
                hSSFCellStyle.setBottomBorderColor(boxStyle.bottomBorderColour);
                hSSFCellStyle.setBorderRight(boxStyle.rightBorder);
                hSSFCellStyle.setRightBorderColor(boxStyle.rightBorderColour);
            }
            this.loadedCellStyles.put(styleInfo, hSSFCellStyle);
        }
        return hSSFCellStyle;
    }

    public HSSFCellStyle getLoadedCellStyle(short s2, short s3, short s4, short s5, short s6, HSSFFont hSSFFont, JRExporterGridCell jRExporterGridCell) {
        StyleInfo styleInfo = new StyleInfo(s2, s3, s4, s5, s6, hSSFFont, jRExporterGridCell);
        return this.getLoadedCellStyle(styleInfo);
    }

    public static short getBorder(JRPen jRPen) {
        float f2 = jRPen.getLineWidth().floatValue();
        if (f2 > 0.0f) {
            switch (jRPen.getLineStyle()) {
                case 1: {
                    return 3;
                }
            }
            if (f2 >= 2.0f) {
                return 5;
            }
            if (f2 >= 1.0f) {
                return 2;
            }
            if (f2 >= 0.5f) {
                return 1;
            }
            return 4;
        }
        return 0;
    }

    public void exportImage(JRPrintImage jRPrintImage, JRExporterGridCell jRExporterGridCell, int n2, int n3, int n4) {
    }

    public void exportFrame(JRPrintFrame jRPrintFrame, JRExporterGridCell jRExporterGridCell, int n2, int n3) {
        short s2 = this.backgroundMode;
        short s3 = this.whiteIndex;
        if (jRPrintFrame.getMode() == 1) {
            s2 = 1;
            s3 = JRXlsExporter.getNearestColor(jRPrintFrame.getBackcolor()).getIndex();
        }
        short s4 = JRXlsExporter.getNearestColor(jRPrintFrame.getForecolor()).getIndex();
        HSSFCellStyle hSSFCellStyle = this.getLoadedCellStyle(s2, s3, (short)1, (short)0, (short)0, this.getLoadedFont(this.getDefaultFont(), s4), jRExporterGridCell);
        this.createMergeRegion(jRExporterGridCell, n2, n3, hSSFCellStyle);
        this.cell = this.row.createCell((short)n2);
        this.cell.setCellStyle(hSSFCellStyle);
    }

    public ExporterNature getNature() {
        return this.nature;
    }

    protected static class StyleInfo {
        public final short mode;
        public final short backcolor;
        public final short horizontalAlignment;
        public final short verticalAlignment;
        public final short rotation;
        public final HSSFFont font;
        public final BoxStyle box = new BoxStyle();
        private short dataFormat = (short)-1;
        private int hashCode;

        public StyleInfo(short s2, short s3, short s4, short s5, short s6, HSSFFont hSSFFont, JRExporterGridCell jRExporterGridCell) {
            JRPrintElement jRPrintElement;
            this.mode = s2;
            this.backcolor = s3;
            this.horizontalAlignment = s4;
            this.verticalAlignment = s5;
            this.rotation = s6;
            this.font = hSSFFont;
            JRLineBox jRLineBox = jRExporterGridCell.getBox();
            if (jRLineBox != null) {
                this.box.setBox(jRLineBox);
            }
            if ((jRPrintElement = jRExporterGridCell.getElement()) instanceof JRCommonGraphicElement) {
                this.box.setPen(((JRCommonGraphicElement)((Object)jRPrintElement)).getLinePen());
            }
            this.hashCode = this.computeHash();
        }

        public int computeHash() {
            int n2 = this.mode;
            n2 = 31 * n2 + this.backcolor;
            n2 = 31 * n2 + this.horizontalAlignment;
            n2 = 31 * n2 + this.verticalAlignment;
            n2 = 31 * n2 + this.rotation;
            n2 = 31 * n2 + (this.font == null ? 0 : (int)this.font.getIndex());
            n2 = 31 * n2 + (this.box == null ? 0 : this.box.hashCode());
            n2 = 31 * n2 + this.dataFormat;
            return n2;
        }

        public void setDataFormat(short s2) {
            this.dataFormat = s2;
            this.hashCode = this.computeHash();
        }

        public boolean hasDataFormat() {
            return this.dataFormat != -1;
        }

        public short getDataFormat() {
            return this.dataFormat;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            StyleInfo styleInfo = (StyleInfo)object;
            return styleInfo.mode == this.mode && styleInfo.backcolor == this.backcolor && styleInfo.horizontalAlignment == this.horizontalAlignment && styleInfo.verticalAlignment == this.verticalAlignment && styleInfo.rotation == this.rotation && (styleInfo.font == null ? this.font == null : this.font != null && styleInfo.font.getIndex() == this.font.getIndex()) && (styleInfo.box == null ? this.box == null : this.box != null && styleInfo.box.equals(this.box)) && styleInfo.rotation == this.rotation;
        }

        public String toString() {
            return "(" + this.mode + "," + this.backcolor + "," + this.horizontalAlignment + "," + this.verticalAlignment + "," + this.rotation + "," + this.font + "," + this.box + "," + this.dataFormat + ")";
        }
    }

    protected static class BoxStyle {
        public short topBorder;
        public short bottomBorder;
        public short leftBorder;
        public short rightBorder;
        public short topBorderColour;
        public short bottomBorderColour;
        public short leftBorderColour;
        public short rightBorderColour;
        private int hash = this.computeHash();

        public void setBox(JRLineBox jRLineBox) {
            this.topBorder = JRXlsExporter.getBorder(jRLineBox.getTopPen());
            this.topBorderColour = JRXlsExporter.getNearestColor(jRLineBox.getTopPen().getLineColor()).getIndex();
            this.bottomBorder = JRXlsExporter.getBorder(jRLineBox.getBottomPen());
            this.bottomBorderColour = JRXlsExporter.getNearestColor(jRLineBox.getBottomPen().getLineColor()).getIndex();
            this.leftBorder = JRXlsExporter.getBorder(jRLineBox.getLeftPen());
            this.leftBorderColour = JRXlsExporter.getNearestColor(jRLineBox.getLeftPen().getLineColor()).getIndex();
            this.rightBorder = JRXlsExporter.getBorder(jRLineBox.getRightPen());
            this.rightBorderColour = JRXlsExporter.getNearestColor(jRLineBox.getRightPen().getLineColor()).getIndex();
            this.hash = this.computeHash();
        }

        public void setPen(JRPen jRPen) {
            if (this.topBorder == 0 && this.leftBorder == 0 && this.bottomBorder == 0 && this.rightBorder == 0) {
                this.topBorder = JRXlsExporter.getBorder(jRPen);
                this.topBorderColour = JRXlsExporter.getNearestColor(jRPen.getLineColor()).getIndex();
                this.bottomBorder = this.topBorder;
                this.bottomBorderColour = this.topBorderColour;
                this.leftBorder = this.topBorder;
                this.leftBorderColour = this.topBorderColour;
                this.rightBorder = this.topBorder;
                this.rightBorderColour = this.topBorderColour;
            }
            this.hash = this.computeHash();
        }

        private int computeHash() {
            int n2 = this.topBorder;
            n2 = 31 * n2 + this.topBorderColour;
            n2 = 31 * n2 + this.bottomBorder;
            n2 = 31 * n2 + this.bottomBorderColour;
            n2 = 31 * n2 + this.leftBorder;
            n2 = 31 * n2 + this.leftBorderColour;
            n2 = 31 * n2 + this.rightBorder;
            n2 = 31 * n2 + this.rightBorderColour;
            return n2;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            BoxStyle boxStyle = (BoxStyle)object;
            return boxStyle.topBorder == this.topBorder && boxStyle.topBorderColour == this.topBorderColour && boxStyle.bottomBorder == this.bottomBorder && boxStyle.bottomBorderColour == this.bottomBorderColour && boxStyle.leftBorder == this.leftBorder && boxStyle.leftBorderColour == this.leftBorderColour && boxStyle.rightBorder == this.rightBorder && boxStyle.rightBorderColour == this.rightBorderColour;
        }

        public String toString() {
            return "(" + this.topBorder + "/" + this.topBorderColour + "," + this.bottomBorder + "/" + this.bottomBorderColour + "," + this.leftBorder + "/" + this.leftBorderColour + "," + this.rightBorder + "/" + this.rightBorderColour + ")";
        }
    }
}

