/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.draw;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;

public abstract class ElementDrawer {
    public abstract void draw(Graphics2D var1, JRPrintElement var2, int var3, int var4) throws JRException;

    public void drawBox(Graphics2D graphics2D, JRLineBox jRLineBox, JRPrintElement jRPrintElement, int n2, int n3) {
        this.drawTopPen(graphics2D, jRLineBox.getTopPen(), jRLineBox.getLeftPen(), jRLineBox.getRightPen(), jRPrintElement, n2, n3);
        this.drawLeftPen(graphics2D, jRLineBox.getTopPen(), jRLineBox.getLeftPen(), jRLineBox.getBottomPen(), jRPrintElement, n2, n3);
        this.drawBottomPen(graphics2D, jRLineBox.getLeftPen(), jRLineBox.getBottomPen(), jRLineBox.getRightPen(), jRPrintElement, n2, n3);
        this.drawRightPen(graphics2D, jRLineBox.getTopPen(), jRLineBox.getBottomPen(), jRLineBox.getRightPen(), jRPrintElement, n2, n3);
    }

    public void drawPen(Graphics2D graphics2D, JRPen jRPen, JRPrintElement jRPrintElement, int n2, int n3) {
        this.drawTopPen(graphics2D, jRPen, jRPen, jRPen, jRPrintElement, n2, n3);
        this.drawLeftPen(graphics2D, jRPen, jRPen, jRPen, jRPrintElement, n2, n3);
        this.drawBottomPen(graphics2D, jRPen, jRPen, jRPen, jRPrintElement, n2, n3);
        this.drawRightPen(graphics2D, jRPen, jRPen, jRPen, jRPrintElement, n2, n3);
    }

    public void drawTopPen(Graphics2D graphics2D, JRPen jRPen, JRPen jRPen2, JRPen jRPen3, JRPrintElement jRPrintElement, int n2, int n3) {
        Stroke stroke = ElementDrawer.getBorderStroke(jRPen);
        if (stroke != null) {
            graphics2D.setStroke(stroke);
            graphics2D.setColor(jRPen.getLineColor());
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate((float)(jRPrintElement.getX() + n2) - jRPen2.getLineWidth().floatValue() / 2.0f, (double)(jRPrintElement.getY() + n3));
            graphics2D.scale(((float)jRPrintElement.getWidth() + (jRPen2.getLineWidth().floatValue() + jRPen3.getLineWidth().floatValue()) / 2.0f) / (float)jRPrintElement.getWidth(), 1.0);
            graphics2D.drawLine(0, 0, jRPrintElement.getWidth(), 0);
            graphics2D.setTransform(affineTransform);
        }
    }

    public void drawLeftPen(Graphics2D graphics2D, JRPen jRPen, JRPen jRPen2, JRPen jRPen3, JRPrintElement jRPrintElement, int n2, int n3) {
        Stroke stroke = ElementDrawer.getBorderStroke(jRPen2);
        if (stroke != null) {
            graphics2D.setStroke(stroke);
            graphics2D.setColor(jRPen2.getLineColor());
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate((double)(jRPrintElement.getX() + n2), (float)(jRPrintElement.getY() + n3) - jRPen.getLineWidth().floatValue() / 2.0f);
            graphics2D.scale(1.0, ((float)jRPrintElement.getHeight() + (jRPen.getLineWidth().floatValue() + jRPen3.getLineWidth().floatValue()) / 2.0f) / (float)jRPrintElement.getHeight());
            graphics2D.drawLine(0, 0, 0, jRPrintElement.getHeight());
            graphics2D.setTransform(affineTransform);
        }
    }

    public void drawBottomPen(Graphics2D graphics2D, JRPen jRPen, JRPen jRPen2, JRPen jRPen3, JRPrintElement jRPrintElement, int n2, int n3) {
        Stroke stroke = ElementDrawer.getBorderStroke(jRPen2);
        if (stroke != null) {
            graphics2D.setStroke(stroke);
            graphics2D.setColor(jRPen2.getLineColor());
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate((float)(jRPrintElement.getX() + n2) - jRPen.getLineWidth().floatValue() / 2.0f, (double)(jRPrintElement.getY() + n3 + jRPrintElement.getHeight()));
            graphics2D.scale(((float)jRPrintElement.getWidth() + (jRPen.getLineWidth().floatValue() + jRPen3.getLineWidth().floatValue()) / 2.0f) / (float)jRPrintElement.getWidth(), 1.0);
            graphics2D.drawLine(0, 0, jRPrintElement.getWidth(), 0);
            graphics2D.setTransform(affineTransform);
        }
    }

    public void drawRightPen(Graphics2D graphics2D, JRPen jRPen, JRPen jRPen2, JRPen jRPen3, JRPrintElement jRPrintElement, int n2, int n3) {
        Stroke stroke = ElementDrawer.getBorderStroke(jRPen3);
        if (stroke != null) {
            graphics2D.setStroke(stroke);
            graphics2D.setColor(jRPen3.getLineColor());
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate((double)(jRPrintElement.getX() + n2 + jRPrintElement.getWidth()), (float)(jRPrintElement.getY() + n3) - jRPen.getLineWidth().floatValue() / 2.0f);
            graphics2D.scale(1.0, ((float)jRPrintElement.getHeight() + (jRPen.getLineWidth().floatValue() + jRPen2.getLineWidth().floatValue()) / 2.0f) / (float)jRPrintElement.getHeight());
            graphics2D.drawLine(0, 0, 0, jRPrintElement.getHeight());
            graphics2D.setTransform(affineTransform);
        }
    }

    public static Stroke getStroke(JRPen jRPen) {
        float f2 = jRPen.getLineWidth().floatValue();
        if (f2 > 0.0f) {
            byte by2 = jRPen.getLineStyle();
            switch (by2) {
                case 1: {
                    return new BasicStroke(f2, 2, 0, 10.0f, new float[]{5.0f * f2, 3.0f * f2}, 0.0f);
                }
            }
            return new BasicStroke(f2, 2, 0);
        }
        return null;
    }

    public static Stroke getBorderStroke(JRPen jRPen) {
        float f2 = jRPen.getLineWidth().floatValue();
        if (f2 > 0.0f) {
            switch (jRPen.getLineStyle()) {
                case 1: {
                    return new BasicStroke(f2, 0, 0, 10.0f, new float[]{5.0f * f2, 3.0f * f2}, 0.0f);
                }
            }
            return new BasicStroke(f2, 0, 0);
        }
        return null;
    }
}

