/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.io.IOException;
import java.io.Writer;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.export.oasis.Style;
import net.sf.jasperreports.engine.export.oasis.Utility;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class GraphicStyle
extends Style {
    private String backcolor = null;
    private String forecolor = null;
    private String style = null;
    private String width = null;

    public GraphicStyle(Writer writer, JRPrintGraphicElement jRPrintGraphicElement) {
        super(writer);
        if (jRPrintGraphicElement.getMode() == 1) {
            this.backcolor = JRColorUtil.getColorHexa(jRPrintGraphicElement.getBackcolor());
        }
        this.forecolor = JRColorUtil.getColorHexa(jRPrintGraphicElement.getLinePen().getLineColor());
        double d2 = jRPrintGraphicElement.getLinePen().getLineWidth().doubleValue();
        if (d2 < 0.0) {
            this.style = "none";
        } else {
            switch (jRPrintGraphicElement.getLinePen().getLineStyle()) {
                case 1: {
                    this.style = "dash";
                    break;
                }
                default: {
                    this.style = "solid";
                }
            }
        }
        this.width = String.valueOf(Utility.translatePixelsToInchesWithNoRoundOff(d2));
    }

    public String getId() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.backcolor);
        stringBuffer.append("|");
        stringBuffer.append(this.forecolor);
        stringBuffer.append("|");
        stringBuffer.append(this.style);
        stringBuffer.append("|");
        stringBuffer.append(this.width);
        return stringBuffer.toString();
    }

    public void write(String string) throws IOException {
        this.styleWriter.write(" <style:style style:name=\"" + string + "\"");
        this.styleWriter.write(" style:family=\"graphic\">\n");
        this.styleWriter.write("   <style:graphic-properties");
        this.styleWriter.write(" draw:fill-color=\"#" + this.backcolor + "\"");
        this.styleWriter.write(" svg:stroke-color=\"#" + this.forecolor + "\"");
        this.styleWriter.write(" draw:stroke=\"" + this.style + "\"");
        this.styleWriter.write(" draw:stroke-dash=\"Dashed\"");
        this.styleWriter.write(" svg:stroke-width=\"" + this.width + "in\"");
        this.styleWriter.write("/>\n");
        this.styleWriter.write("</style:style>\n");
    }
}

