/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRCommonGraphicElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.export.oasis.CellStyle;
import net.sf.jasperreports.engine.export.oasis.FrameStyle;
import net.sf.jasperreports.engine.export.oasis.GraphicStyle;
import net.sf.jasperreports.engine.export.oasis.ParagraphStyle;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class StyleCache {
    private Writer styleWriter = null;
    private Map fontMap = null;
    private Set fontFaces = new HashSet();
    private Map frameStyles = new HashMap();
    private int frameStylesCounter = 0;
    private Map cellStyles = new HashMap();
    private int cellStylesCounter = 0;
    private Map graphicStyles = new HashMap();
    private int graphicStylesCounter = 0;
    private Map paragraphStyles = new HashMap();
    private int paragraphStylesCounter = 0;
    private Map textSpanStyles = new HashMap();
    private int textSpanStylesCounter = 0;

    public StyleCache(Writer writer, Map map) {
        this.styleWriter = writer;
        this.fontMap = map;
    }

    public Collection getFontFaces() {
        return this.fontFaces;
    }

    public String getFrameStyle(JRPrintText jRPrintText) throws IOException {
        FrameStyle frameStyle = new FrameStyle(this.styleWriter, jRPrintText);
        frameStyle.setBox(jRPrintText.getLineBox());
        String string = frameStyle.getId();
        String string2 = (String)this.frameStyles.get(string);
        if (string2 == null) {
            string2 = "F" + this.frameStylesCounter++;
            this.frameStyles.put(string, string2);
            frameStyle.write(string2);
        }
        return string2;
    }

    public String getFrameStyle(JRPrintElement jRPrintElement) throws IOException {
        FrameStyle frameStyle = new FrameStyle(this.styleWriter, jRPrintElement);
        String string = frameStyle.getId();
        String string2 = (String)this.frameStyles.get(string);
        if (string2 == null) {
            string2 = "F" + this.frameStylesCounter++;
            this.frameStyles.put(string, string2);
            frameStyle.write(string2);
        }
        return string2;
    }

    public String getGraphicStyle(JRPrintGraphicElement jRPrintGraphicElement) throws IOException {
        GraphicStyle graphicStyle = new GraphicStyle(this.styleWriter, jRPrintGraphicElement);
        String string = graphicStyle.getId();
        String string2 = (String)this.cellStyles.get(string);
        if (string2 == null) {
            string2 = "G" + this.graphicStylesCounter++;
            this.graphicStyles.put(string, string2);
            graphicStyle.write(string2);
        }
        return string2;
    }

    public String getCellStyle(JRPrintElement jRPrintElement) throws IOException {
        String string;
        String string2;
        CellStyle cellStyle = new CellStyle(this.styleWriter, jRPrintElement);
        if (jRPrintElement instanceof JRBoxContainer) {
            cellStyle.setBox(((JRBoxContainer)((Object)jRPrintElement)).getLineBox());
        }
        if (jRPrintElement instanceof JRCommonGraphicElement) {
            cellStyle.setPen(((JRCommonGraphicElement)((Object)jRPrintElement)).getLinePen());
        }
        if ((string2 = (String)this.cellStyles.get(string = cellStyle.getId())) == null) {
            string2 = "C" + this.cellStylesCounter++;
            this.cellStyles.put(string, string2);
            cellStyle.write(string2);
        }
        return string2;
    }

    public String getParagraphStyle(JRPrintText jRPrintText) throws IOException {
        ParagraphStyle paragraphStyle = new ParagraphStyle(this.styleWriter, jRPrintText);
        String string = paragraphStyle.getId();
        String string2 = (String)this.paragraphStyles.get(string);
        if (string2 == null) {
            string2 = "P" + this.paragraphStylesCounter++;
            this.paragraphStyles.put(string, string2);
            paragraphStyle.write(string2);
        }
        return string2;
    }

    public String getTextSpanStyle(Map map, String string) throws IOException {
        String string2;
        String string3;
        String string4 = (String)map.get(TextAttribute.FAMILY);
        String string5 = this.fontMap != null && this.fontMap.containsKey(string4) ? (String)this.fontMap.get(string4) : string4;
        this.fontFaces.add(string5);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string5);
        String string6 = null;
        Color color = (Color)map.get(TextAttribute.FOREGROUND);
        if (!Color.black.equals(color)) {
            string6 = JRColorUtil.getColorHexa(color);
            stringBuffer.append(string6);
        }
        String string7 = null;
        Color color2 = (Color)map.get(TextAttribute.BACKGROUND);
        if (color2 != null) {
            string7 = JRColorUtil.getColorHexa(color2);
            stringBuffer.append(string7);
        }
        String string8 = String.valueOf(map.get(TextAttribute.SIZE));
        stringBuffer.append(string8);
        String string9 = null;
        if (TextAttribute.WEIGHT_BOLD.equals(map.get(TextAttribute.WEIGHT))) {
            string9 = "bold";
            stringBuffer.append(string9);
        }
        String string10 = null;
        if (TextAttribute.POSTURE_OBLIQUE.equals(map.get(TextAttribute.POSTURE))) {
            string10 = "italic";
            stringBuffer.append(string10);
        }
        String string11 = null;
        if (TextAttribute.UNDERLINE_ON.equals(map.get(TextAttribute.UNDERLINE))) {
            string11 = "single";
            stringBuffer.append(string11);
        }
        String string12 = null;
        if (TextAttribute.STRIKETHROUGH_ON.equals(map.get(TextAttribute.STRIKETHROUGH))) {
            string12 = "single";
            stringBuffer.append(string12);
        }
        if ((string3 = (String)this.textSpanStyles.get(string2 = stringBuffer.toString())) == null) {
            string3 = "T" + this.textSpanStylesCounter++;
            this.textSpanStyles.put(string2, string3);
            this.styleWriter.write("<style:style style:name=\"" + string3 + "\"");
            this.styleWriter.write(" style:family=\"text\">\n");
            this.styleWriter.write("<style:text-properties");
            if (string6 != null) {
                this.styleWriter.write(" fo:color=\"#" + string6 + "\"");
            }
            this.styleWriter.write(" style:font-name=\"" + string5 + "\"");
            this.styleWriter.write(" fo:font-size=\"" + string8 + "pt\"");
            if (string10 != null) {
                this.styleWriter.write(" fo:font-style=\"" + string10 + "\"");
            }
            if (string9 != null) {
                this.styleWriter.write(" fo:font-weight=\"" + string9 + "\"");
            }
            if (string7 != null) {
                this.styleWriter.write(" fo:background-color=\"#" + string7 + "\"");
            }
            if (string11 != null) {
                this.styleWriter.write(" style:text-underline-type=\"" + string11 + "\"");
            }
            if (string12 != null) {
                this.styleWriter.write(" style:text-line-through-type=\"" + string12 + "\"");
            }
            this.styleWriter.write(">\n");
            this.styleWriter.write("</style:text-properties>\n");
            this.styleWriter.write("</style:style>\n");
        }
        return string3;
    }
}

