/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.sf.jasperreports.engine.export.oasis.zip.EmptyOasisZipEntry;
import net.sf.jasperreports.engine.export.oasis.zip.OasisZipEntry;

public abstract class OasisZip {
    private List oasisZipEntries = new ArrayList();
    private OasisZipEntry contentEntry = this.createEntry("content.xml");
    private OasisZipEntry stylesEntry = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OasisZip() throws IOException {
        this.oasisZipEntries.add(this.contentEntry);
        this.oasisZipEntries.add(new EmptyOasisZipEntry("meta.xml"));
        this.oasisZipEntries.add(new EmptyOasisZipEntry("settings.xml"));
        this.stylesEntry = this.createEntry("styles.xml");
        this.oasisZipEntries.add(this.stylesEntry);
        OasisZipEntry oasisZipEntry = this.createEntry("mimetype");
        Writer writer = null;
        try {
            writer = oasisZipEntry.getWriter();
            writer.write("application/vnd.oasis.opendocument.text");
            writer.flush();
            this.oasisZipEntries.add(oasisZipEntry);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        OasisZipEntry oasisZipEntry2 = this.createEntry("META-INF/manifest.xml");
        Writer writer2 = null;
        try {
            writer2 = oasisZipEntry2.getWriter();
            writer2.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?> \r\n");
            writer2.write("<!DOCTYPE manifest:manifest PUBLIC \"-//OpenOffice.org//DTD Manifest 1.0//EN\" \"Manifest.dtd\"> \r\n");
            writer2.write("<manifest:manifest xmlns:manifest=\"urn:oasis:names:tc:opendocument:xmlns:manifest:1.0\"> \r\n");
            writer2.write("  <manifest:file-entry manifest:media-type=\"application/vnd.oasis.opendocument.text\" manifest:full-path=\"/\"/> \r\n");
            writer2.write("  <manifest:file-entry manifest:media-type=\"application/vnd.sun.xml.ui.configuration\" manifest:full-path=\"Configurations2/\"/> \r\n");
            writer2.write("  <manifest:file-entry manifest:media-type=\"\" manifest:full-path=\"Pictures/\"/> \r\n");
            writer2.write("  <manifest:file-entry manifest:media-type=\"text/xml\" manifest:full-path=\"content.xml\"/> \r\n");
            writer2.write("  <manifest:file-entry manifest:media-type=\"text/xml\" manifest:full-path=\"styles.xml\"/> \r\n");
            writer2.write("  <manifest:file-entry manifest:media-type=\"text/xml\" manifest:full-path=\"meta.xml\"/> \r\n");
            writer2.write("  <manifest:file-entry manifest:media-type=\"\" manifest:full-path=\"Thumbnails/thumbnail.png\"/> \r\n");
            writer2.write("  <manifest:file-entry manifest:media-type=\"\" manifest:full-path=\"Thumbnails/\"/> \r\n");
            writer2.write("  <manifest:file-entry manifest:media-type=\"text/xml\" manifest:full-path=\"settings.xml\"/> \r\n");
            writer2.write("</manifest:manifest> \r\n");
            writer2.flush();
            this.oasisZipEntries.add(oasisZipEntry2);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public abstract OasisZipEntry createEntry(String var1);

    public OasisZipEntry getContentEntry() {
        return this.contentEntry;
    }

    public OasisZipEntry getStylesEntry() {
        return this.stylesEntry;
    }

    public void addEntry(OasisZipEntry oasisZipEntry) {
        this.oasisZipEntries.add(oasisZipEntry);
    }

    public void zipEntries(OutputStream outputStream) throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        zipOutputStream.setMethod(8);
        for (int i2 = 0; i2 < this.oasisZipEntries.size(); ++i2) {
            OasisZipEntry oasisZipEntry = (OasisZipEntry)this.oasisZipEntries.get(i2);
            ZipEntry zipEntry = new ZipEntry(oasisZipEntry.getName());
            zipOutputStream.putNextEntry(zipEntry);
            oasisZipEntry.writeData(zipOutputStream);
        }
        zipOutputStream.flush();
        zipOutputStream.finish();
    }

    public void dispose() {
        for (int i2 = 0; i2 < this.oasisZipEntries.size(); ++i2) {
            OasisZipEntry oasisZipEntry = (OasisZipEntry)this.oasisZipEntries.get(i2);
            oasisZipEntry.dispose();
        }
    }
}

