/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.Serializable;
import java.net.URLStreamHandlerFactory;
import java.sql.Connection;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRAbstractScriptlet;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleSetter;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JRTemplateReference;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.base.JRBasePrintPage;
import net.sf.jasperreports.engine.base.JRVirtualPrintPage;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JREvaluationTime;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRFillBand;
import net.sf.jasperreports.engine.fill.JRFillContext;
import net.sf.jasperreports.engine.fill.JRFillDataset;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillGroup;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillReportTemplate;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JRSubreportRunner;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import net.sf.jasperreports.engine.util.DefaultFormatFactory;
import net.sf.jasperreports.engine.util.FormatFactory;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.engine.util.JRGraphEnvInitializer;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JRBaseFiller
implements JRDefaultStyleProvider,
JRVirtualPrintPage.IdentityDataProvider {
    private static final Log log = LogFactory.getLog(b == null ? (b = JRBaseFiller.a("net.sf.jasperreports.engine.fill.JRBaseFiller")) : b);
    private static final String PROPERTIES_PRINT_TRANSFER_PREFIX = "net.sf.jasperreports.print.transfer.";
    public final String fillerId;
    public JRBaseFiller parentFiller = null;
    private final JRFillObjectFactory factory;
    private JRStyledTextParser styledTextParser = new JRStyledTextParser();
    private boolean isInterrupted = false;
    public String name = null;
    public int columnCount = 1;
    public byte printOrder = 1;
    public int pageWidth = 0;
    public int pageHeight = 0;
    public byte orientation = 1;
    public byte whenNoDataType = 1;
    public int columnWidth = 0;
    public int columnSpacing = 0;
    public int leftMargin = 0;
    public int rightMargin = 0;
    public int topMargin = 0;
    public int bottomMargin = 0;
    public boolean isTitleNewPage = false;
    public boolean isSummaryNewPage = false;
    public boolean isFloatColumnFooter = false;
    public byte whenResourceMissingType = 1;
    public JRFillReportTemplate[] reportTemplates;
    public JRReportFont defaultFont = null;
    public JRReportFont[] fonts = null;
    public JRStyle defaultStyle = null;
    public JRStyle[] styles = null;
    public JRFillDataset mainDataset;
    public JRFillGroup[] groups = null;
    public JRFillBand missingFillBand = null;
    public JRFillBand background = null;
    public JRFillBand title = null;
    public JRFillBand pageHeader = null;
    public JRFillBand columnHeader = null;
    public JRFillBand detail = null;
    public JRFillBand columnFooter = null;
    public JRFillBand pageFooter = null;
    public JRFillBand lastPageFooter = null;
    public JRFillBand summary = null;
    public JRFillBand noData = null;
    public JRVirtualizer virtualizer = null;
    public ClassLoader reportClassLoader = null;
    public FormatFactory formatFactory = null;
    public URLStreamHandlerFactory urlHandlerFactory;
    public JRFillContext fillContext;
    public Map boundElements;
    public JasperPrint jasperPrint = null;
    public JRPrintPage printPage = null;
    public int printPageStretchHeight = 0;
    public List bands;
    public Set subfillers;
    private List identityPages;
    private Thread fillingThread;
    public JRCalculator calculator;
    public JRAbstractScriptlet scriptlet;
    public Map datasetMap;
    public JasperReport jasperReport;
    private boolean bandOverFlowAllowed;
    public boolean isPerPageBoundElements;
    public Map dateFormatCache = new HashMap();
    public Map numberFormatCache = new HashMap();
    private JRSubreportRunner subreportRunner;
    public boolean isCreatingNewPage = false;
    public boolean isNewPage = false;
    public boolean isNewColumn = false;
    public boolean isNewGroup = true;
    public boolean isFirstPageBand = false;
    public boolean isFirstColumnBand = false;
    public int columnIndex = 0;
    public int offsetX = 0;
    public int offsetY = 0;
    public int columnHeaderOffsetY = 0;
    public int columnFooterOffsetY = 0;
    public int lastPageColumnFooterOffsetY = 0;
    public boolean isLastPageFooter = false;
    private final List defaultStyleListeners = new ArrayList();
    private static final JRStyleSetter DUMMY_STYLE_SETTER = new JRStyleSetter(){

        public void setStyle(JRStyle jRStyle) {
        }

        public void setStyleNameReference(String string) {
        }
    };
    public static Class b;
    public static Class c;

    public JRBaseFiller(JasperReport jasperReport, JREvaluator jREvaluator, JRBaseFiller jRBaseFiller) throws JRException {
        this.fillerId = Integer.toString(System.identityHashCode(this));
        if (log.isDebugEnabled()) {
            log.debug("Fill " + this.fillerId + ": created for " + jasperReport.getName());
        }
        JRGraphEnvInitializer.initializeGraphEnv();
        this.jasperReport = jasperReport;
        this.parentFiller = jRBaseFiller;
        this.fillContext = jRBaseFiller == null ? new JRFillContext() : jRBaseFiller.fillContext;
        this.name = jasperReport.getName();
        this.columnCount = jasperReport.getColumnCount();
        this.printOrder = jasperReport.getPrintOrder();
        this.pageWidth = jasperReport.getPageWidth();
        this.pageHeight = jasperReport.getPageHeight();
        this.orientation = jasperReport.getOrientation();
        this.whenNoDataType = jasperReport.getWhenNoDataType();
        this.columnWidth = jasperReport.getColumnWidth();
        this.columnSpacing = jasperReport.getColumnSpacing();
        this.leftMargin = jasperReport.getLeftMargin();
        this.rightMargin = jasperReport.getRightMargin();
        this.topMargin = jasperReport.getTopMargin();
        this.bottomMargin = jasperReport.getBottomMargin();
        this.isTitleNewPage = jasperReport.isTitleNewPage();
        this.isSummaryNewPage = jasperReport.isSummaryNewPage();
        this.isFloatColumnFooter = jasperReport.isFloatColumnFooter();
        this.whenResourceMissingType = jasperReport.getWhenResourceMissingType();
        this.jasperPrint = new JasperPrint();
        List list = JRProperties.getProperties(PROPERTIES_PRINT_TRANSFER_PREFIX);
        JRReportFont[] jRReportFontArray = list.iterator();
        while (jRReportFontArray.hasNext()) {
            JRProperties.PropertySuffix propertySuffix = (JRProperties.PropertySuffix)jRReportFontArray.next();
            String string = propertySuffix.getValue();
            if (string == null || string.length() <= 0) continue;
            List list2 = JRProperties.getProperties(jasperReport.getPropertiesMap(), string);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                JRProperties.PropertySuffix propertySuffix2 = (JRProperties.PropertySuffix)iterator.next();
                String string2 = propertySuffix2.getValue();
                this.jasperPrint.setProperty(propertySuffix2.getKey(), string2);
            }
        }
        this.calculator = jREvaluator == null ? JRFillDataset.createCalculator(jasperReport, jasperReport.getMainDataset()) : new JRCalculator(jREvaluator);
        this.factory = new JRFillObjectFactory(this);
        this.defaultFont = this.factory.getReportFont(jasperReport.getDefaultFont());
        jRReportFontArray = jasperReport.getFonts();
        if (jRReportFontArray != null && jRReportFontArray.length > 0) {
            this.fonts = new JRReportFont[jRReportFontArray.length];
            for (int i2 = 0; i2 < this.fonts.length; ++i2) {
                this.fonts[i2] = this.factory.getReportFont(jRReportFontArray[i2]);
            }
        }
        this.createDatasets();
        this.mainDataset = this.factory.getDataset(jasperReport.getMainDataset());
        this.groups = this.mainDataset.groups;
        this.createReportTemplates(this.factory);
        String string = this.factory.getFiller().isSubreport() ? this.factory.getFiller().getJasperReport().getName() : null;
        this.missingFillBand = this.factory.getBand(null);
        this.background = this.factory.getBand(jasperReport.getBackground());
        if (this.background != this.missingFillBand) {
            this.background.setOrigin(new JROrigin(string, 1));
        }
        this.title = this.factory.getBand(jasperReport.getTitle());
        if (this.title != this.missingFillBand) {
            this.title.setOrigin(new JROrigin(string, 2));
        }
        this.pageHeader = this.factory.getBand(jasperReport.getPageHeader());
        if (this.pageHeader != this.missingFillBand) {
            this.pageHeader.setOrigin(new JROrigin(string, 3));
        }
        this.columnHeader = this.factory.getBand(jasperReport.getColumnHeader());
        if (this.columnHeader != this.missingFillBand) {
            this.columnHeader.setOrigin(new JROrigin(string, 4));
        }
        this.detail = this.factory.getBand(jasperReport.getDetail());
        if (this.detail != this.missingFillBand) {
            this.detail.setOrigin(new JROrigin(string, 6));
        }
        this.columnFooter = this.factory.getBand(jasperReport.getColumnFooter());
        if (this.columnFooter != this.missingFillBand) {
            this.columnFooter.setOrigin(new JROrigin(string, 8));
        }
        this.pageFooter = this.factory.getBand(jasperReport.getPageFooter());
        if (this.pageFooter != this.missingFillBand) {
            this.pageFooter.setOrigin(new JROrigin(string, 9));
        }
        this.lastPageFooter = this.factory.getBand(jasperReport.getLastPageFooter());
        if (this.lastPageFooter != this.missingFillBand) {
            this.lastPageFooter.setOrigin(new JROrigin(string, 10));
        }
        this.summary = this.factory.getBand(jasperReport.getSummary());
        if (this.summary != this.missingFillBand && this.summary.isEmpty()) {
            this.summary = this.missingFillBand;
        }
        if (this.summary != this.missingFillBand) {
            this.summary.setOrigin(new JROrigin(string, 11));
        }
        this.noData = this.factory.getBand(jasperReport.getNoData());
        if (this.noData != this.missingFillBand) {
            this.noData.setOrigin(new JROrigin(string, 12));
        }
        this.mainDataset.initElementDatasets(this.factory);
        this.initDatasets(this.factory);
        this.mainDataset.checkVariableCalculationReqs(this.factory);
        this.mainDataset.setCalculator(this.calculator);
        this.mainDataset.initCalculator();
        this.initBands();
    }

    public Map getParametersMap() {
        return this.mainDataset.parametersMap;
    }

    public Map getFieldsMap() {
        return this.mainDataset.fieldsMap;
    }

    public Map getVariablesMap() {
        return this.mainDataset.variablesMap;
    }

    public JRFillVariable getVariable(String string) {
        return (JRFillVariable)this.mainDataset.variablesMap.get(string);
    }

    public JRFillField getField(String string) {
        return (JRFillField)this.mainDataset.fieldsMap.get(string);
    }

    private void initBands() {
        this.bands = new ArrayList(8 + (this.groups == null ? 0 : 2 * this.groups.length));
        this.bands.add(this.title);
        this.bands.add(this.summary);
        this.bands.add(this.pageHeader);
        this.bands.add(this.pageFooter);
        this.bands.add(this.lastPageFooter);
        this.bands.add(this.columnHeader);
        this.bands.add(this.columnFooter);
        this.bands.add(this.detail);
        this.bands.add(this.noData);
        if (this.groups != null && this.groups.length > 0) {
            for (int i2 = 0; i2 < this.groups.length; ++i2) {
                JRFillGroup jRFillGroup = this.groups[i2];
                this.bands.add(jRFillGroup.getGroupHeader());
                this.bands.add(jRFillGroup.getGroupFooter());
            }
        }
        this.initBandsNowEvaluationTimes();
    }

    private void initBandsNowEvaluationTimes() {
        JREvaluationTime[] jREvaluationTimeArray;
        if (this.groups == null) {
            jREvaluationTimeArray = new JREvaluationTime[]{};
        } else {
            int n2;
            jREvaluationTimeArray = new JREvaluationTime[this.groups.length];
            for (n2 = 0; n2 < this.groups.length; ++n2) {
                jREvaluationTimeArray[n2] = JREvaluationTime.getGroupEvaluationTime(this.groups[n2].getName());
            }
            for (n2 = 0; n2 < this.groups.length; ++n2) {
                JRFillGroup jRFillGroup = this.groups[n2];
                JRFillBand jRFillBand = (JRFillBand)jRFillGroup.getGroupFooter();
                for (int i2 = n2; i2 < jREvaluationTimeArray.length; ++i2) {
                    jRFillBand.addNowEvaluationTime(jREvaluationTimeArray[i2]);
                }
            }
        }
        this.columnFooter.addNowEvaluationTime(JREvaluationTime.EVALUATION_TIME_COLUMN);
        this.pageFooter.addNowEvaluationTime(JREvaluationTime.EVALUATION_TIME_COLUMN);
        this.pageFooter.addNowEvaluationTime(JREvaluationTime.EVALUATION_TIME_PAGE);
        this.summary.addNowEvaluationTimes(jREvaluationTimeArray);
        this.noData.addNowEvaluationTimes(jREvaluationTimeArray);
    }

    public JRStyledTextParser getStyledTextParser() {
        return this.styledTextParser;
    }

    public JasperPrint getJasperPrint() {
        return this.jasperPrint;
    }

    public JRReportFont getDefaultFont() {
        return this.defaultFont;
    }

    public JRStyle getDefaultStyle() {
        return this.defaultStyle;
    }

    public boolean isSubreport() {
        return this.parentFiller != null;
    }

    public boolean isInterrupted() {
        return this.isInterrupted || this.parentFiller != null && this.parentFiller.isInterrupted();
    }

    public void setInterrupted(boolean bl2) {
        this.isInterrupted = bl2;
    }

    public JRPrintPage getCurrentPage() {
        return this.printPage;
    }

    public JRReportFont[] getFonts() {
        return this.fonts;
    }

    public int getCurrentPageStretchHeight() {
        return this.printPageStretchHeight;
    }

    public abstract void setPageHeight(int var1);

    public JasperPrint fill(Map hashMap, Connection connection) throws JRException {
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        this.setConnectionParameterValue(hashMap, connection);
        return this.fill(hashMap);
    }

    public void setConnectionParameterValue(Map map, Connection connection) {
        this.mainDataset.setConnectionParameterValue(map, connection);
    }

    public JasperPrint fill(Map hashMap, JRDataSource jRDataSource) throws JRException {
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        this.setDatasourceParameterValue(hashMap, jRDataSource);
        return this.fill(hashMap);
    }

    public void setDatasourceParameterValue(Map map, JRDataSource jRDataSource) {
        this.mainDataset.setDatasourceParameterValue(map, jRDataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JasperPrint fill(Map hashMap) throws JRException {
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        if (log.isDebugEnabled()) {
            log.debug("Fill " + this.fillerId + ": filling report");
        }
        this.fillingThread = Thread.currentThread();
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            int n2;
            this.setParameters(hashMap);
            bl3 = this.setClassLoader(hashMap);
            bl2 = this.setUrlHandlerFactory(hashMap);
            this.loadStyles();
            if (this.parentFiller != null) {
                this.parentFiller.registerSubfiller(this);
            }
            this.jasperPrint.setName(this.name);
            this.jasperPrint.setPageWidth(this.pageWidth);
            this.jasperPrint.setPageHeight(this.pageHeight);
            this.jasperPrint.setOrientation(this.orientation);
            this.jasperPrint.setDefaultFont(this.defaultFont);
            this.jasperPrint.setFormatFactoryClass(this.jasperReport.getFormatFactoryClass());
            this.jasperPrint.setLocaleCode(JRDataUtils.getLocaleCode(this.getLocale()));
            this.jasperPrint.setTimeZoneId(JRDataUtils.getTimeZoneId(this.getTimeZone()));
            if (this.fonts != null && this.fonts.length > 0) {
                for (n2 = 0; n2 < this.fonts.length; ++n2) {
                    this.jasperPrint.addFont(this.fonts[n2], true);
                }
            }
            this.jasperPrint.setDefaultStyle(this.defaultStyle);
            if (this.styles != null && this.styles.length > 0) {
                for (n2 = 0; n2 < this.styles.length; ++n2) {
                    this.addPrintStyle(this.styles[n2]);
                }
            }
            this.createBoundElemementMaps();
            this.mainDataset.start();
            this.fillReport();
            if (log.isDebugEnabled()) {
                log.debug("Fill " + this.fillerId + ": ended");
            }
            JasperPrint jasperPrint = this.jasperPrint;
            return jasperPrint;
        }
        finally {
            this.mainDataset.closeDatasource();
            if (this.parentFiller != null) {
                this.parentFiller.unregisterSubfiller(this);
            }
            this.fillingThread = null;
            this.killSubfillerThreads();
            if (bl3) {
                JRResourcesUtil.resetClassLoader();
            }
            if (bl2) {
                JRResourcesUtil.resetThreadURLHandlerFactory();
            }
        }
    }

    public void addPrintStyle(JRStyle jRStyle) throws JRException {
        this.jasperPrint.addStyle(jRStyle, true);
    }

    public void addDefaultStyleListener(DefaultStyleListener defaultStyleListener) {
        this.defaultStyleListeners.add(defaultStyleListener);
    }

    public void setDefaultStyle(JRStyle jRStyle) {
        this.defaultStyle = jRStyle;
        Iterator iterator = this.defaultStyleListeners.iterator();
        while (iterator.hasNext()) {
            DefaultStyleListener defaultStyleListener = (DefaultStyleListener)iterator.next();
            defaultStyleListener.defaultStyleSet(jRStyle);
        }
    }

    public void loadStyles() throws JRException {
        List list = this.collectStyles();
        JRStyle jRStyle = this.jasperReport.getDefaultStyle();
        if (jRStyle == null) {
            this.lookupExternalDefaultStyle(list);
        }
        List list2 = this.factory.setStyles(list);
        this.styles = list2.toArray(new JRStyle[list2.size()]);
        if (jRStyle != null) {
            this.setDefaultStyle(this.factory.getStyle(jRStyle));
        }
    }

    public List collectStyles() throws JRException {
        List list = this.collectTemplateStyles();
        JRStyle[] jRStyleArray = this.jasperReport.getStyles();
        if (jRStyleArray != null) {
            this.styles = new JRStyle[jRStyleArray.length];
            for (int i2 = 0; i2 < jRStyleArray.length; ++i2) {
                JRStyle jRStyle = jRStyleArray[i2];
                list.add(jRStyle);
                this.factory.registerDelayedStyleSetter(DUMMY_STYLE_SETTER, jRStyle.getName());
            }
        }
        return list;
    }

    public List collectTemplateStyles() throws JRException {
        Collection collection;
        JRTemplate jRTemplate;
        Object object;
        ArrayList arrayList = new ArrayList();
        HashSet hashSet = new HashSet();
        if (this.reportTemplates != null) {
            for (int i2 = 0; i2 < this.reportTemplates.length; ++i2) {
                object = this.reportTemplates[i2];
                jRTemplate = ((JRFillReportTemplate)object).evaluate();
                this.collectStyles(jRTemplate, arrayList, hashSet);
            }
        }
        if ((collection = (Collection)this.mainDataset.getParameterValue("REPORT_TEMPLATES", true)) != null) {
            object = collection.iterator();
            while (object.hasNext()) {
                jRTemplate = (JRTemplate)object.next();
                this.collectStyles(jRTemplate, arrayList, hashSet);
            }
        }
        return arrayList;
    }

    public void collectStyles(JRTemplate jRTemplate, List list, Set set) throws JRException {
        this.collectIncludedTemplates(jRTemplate, list, set);
        JRStyle[] jRStyleArray = jRTemplate.getStyles();
        if (jRStyleArray != null) {
            for (int i2 = 0; i2 < jRStyleArray.length; ++i2) {
                JRStyle jRStyle = jRStyleArray[i2];
                String string = jRStyle.getName();
                if (string == null) {
                    throw new JRRuntimeException("External style name not set.");
                }
                list.add(jRStyle);
            }
        }
    }

    public void collectIncludedTemplates(JRTemplate jRTemplate, List list, Set set) throws JRException {
        JRTemplateReference[] jRTemplateReferenceArray = jRTemplate.getIncludedTemplates();
        if (jRTemplateReferenceArray != null) {
            for (int i2 = 0; i2 < jRTemplateReferenceArray.length; ++i2) {
                JRTemplateReference jRTemplateReference = jRTemplateReferenceArray[i2];
                String string = jRTemplateReference.getLocation();
                if (!set.add(string)) {
                    throw new JRRuntimeException("Circular dependency found for template at location " + string);
                }
                JRTemplate jRTemplate2 = JRFillReportTemplate.loadTemplate(string, c == null ? JRBaseFiller.a("java.lang.String") : c, this.fillContext);
                this.collectStyles(jRTemplate2, list, set);
            }
        }
    }

    public void lookupExternalDefaultStyle(Collection collection) {
        JRStyle jRStyle = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            JRStyle jRStyle2 = (JRStyle)iterator.next();
            if (!jRStyle2.isDefault()) continue;
            jRStyle = jRStyle2;
        }
        if (jRStyle != null) {
            this.factory.registerDelayedStyleSetter(new JRStyleSetter(this){
                private final JRBaseFiller this$0;
                {
                    this.this$0 = jRBaseFiller;
                }

                public void setStyle(JRStyle jRStyle) {
                    if (jRStyle.isDefault()) {
                        this.this$0.setDefaultStyle(jRStyle);
                    }
                }

                public void setStyleNameReference(String string) {
                }
            }, jRStyle.getName());
        }
    }

    private void createBoundElemementMaps() {
        this.boundElements = new HashMap();
        this.createBoundElementMaps(JREvaluationTime.EVALUATION_TIME_REPORT);
        this.createBoundElementMaps(JREvaluationTime.EVALUATION_TIME_PAGE);
        this.createBoundElementMaps(JREvaluationTime.EVALUATION_TIME_COLUMN);
        if (this.groups != null) {
            for (int i2 = 0; i2 < this.groups.length; ++i2) {
                this.createBoundElementMaps(JREvaluationTime.getGroupEvaluationTime(this.groups[i2].getName()));
            }
        }
        Iterator iterator = this.bands.iterator();
        while (iterator.hasNext()) {
            JRFillBand jRFillBand = (JRFillBand)iterator.next();
            this.createBoundElementMaps(JREvaluationTime.getBandEvaluationTime(jRFillBand));
        }
    }

    private void createBoundElementMaps(JREvaluationTime jREvaluationTime) {
        BoundElementMap boundElementMap = new BoundElementMap(this);
        this.boundElements.put(jREvaluationTime, boundElementMap);
    }

    private void killSubfillerThreads() {
        if (this.subfillers != null && !this.subfillers.isEmpty()) {
            Iterator iterator = this.subfillers.iterator();
            while (iterator.hasNext()) {
                JRBaseFiller jRBaseFiller = (JRBaseFiller)iterator.next();
                if (jRBaseFiller.fillingThread == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Fill " + this.fillerId + ": Interrupting subfiller thread " + jRBaseFiller.fillingThread);
                }
                jRBaseFiller.fillingThread.interrupt();
            }
        }
    }

    public abstract void fillReport() throws JRException;

    public void setParameters(Map map) throws JRException {
        if (!this.isSubreport()) {
            this.virtualizer = (JRVirtualizer)map.get("REPORT_VIRTUALIZER");
            if (this.virtualizer != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Fill " + this.fillerId + ": using virtualizer " + this.virtualizer);
                }
                this.fillContext.setUsingVirtualizer(true);
                this.fillContext.setPerPageBoundElements(true);
                JRVirtualizationContext.register(this.fillContext.getVirtualizationContext(), this.jasperPrint);
            }
        }
        this.isPerPageBoundElements = this.fillContext.isPerPageBoundElements();
        this.setFormatFactory(map);
        this.setIgnorePagination(map);
        this.mainDataset.setParameterValues(map);
        this.mainDataset.initDatasource();
        this.scriptlet = this.mainDataset.scriptlet;
        if (!this.isSubreport()) {
            this.fillContext.setMasterFormatFactory(this.getFormatFactory());
            this.fillContext.setMasterLocale(this.getLocale());
            this.fillContext.setMasterTimeZone(this.getTimeZone());
        }
    }

    private void setFormatFactory(Map map) {
        this.formatFactory = (FormatFactory)map.get("REPORT_FORMAT_FACTORY");
        if (this.formatFactory == null) {
            this.formatFactory = DefaultFormatFactory.createFormatFactory(this.jasperReport.getFormatFactoryClass());
            map.put("REPORT_FORMAT_FACTORY", this.formatFactory);
        }
    }

    private boolean setClassLoader(Map map) {
        boolean bl2;
        this.reportClassLoader = (ClassLoader)map.get("REPORT_CLASS_LOADER");
        boolean bl3 = bl2 = this.reportClassLoader != null;
        if (bl2) {
            JRResourcesUtil.setThreadClassLoader(this.reportClassLoader);
        }
        return bl2;
    }

    private boolean setUrlHandlerFactory(Map map) {
        boolean bl2;
        this.urlHandlerFactory = (URLStreamHandlerFactory)map.get("REPORT_URL_HANDLER_FACTORY");
        boolean bl3 = bl2 = this.urlHandlerFactory != null;
        if (bl2) {
            JRResourcesUtil.setThreadURLHandlerFactory(this.urlHandlerFactory);
        }
        return bl2;
    }

    private void setIgnorePagination(Map map) {
        if (this.parentFiller == null) {
            Boolean bl2 = (Boolean)map.get("IS_IGNORE_PAGINATION");
            if (bl2 != null) {
                this.fillContext.setIgnorePagination(bl2);
            } else {
                boolean bl3 = this.jasperReport.isIgnorePagination();
                this.fillContext.setIgnorePagination(bl3);
                map.put("IS_IGNORE_PAGINATION", bl3 ? Boolean.TRUE : Boolean.FALSE);
            }
        } else {
            boolean bl4 = this.fillContext.isIgnorePagination();
            map.put("IS_IGNORE_PAGINATION", bl4 ? Boolean.TRUE : Boolean.FALSE);
        }
        if (this.fillContext.isIgnorePagination()) {
            this.isTitleNewPage = false;
            this.isSummaryNewPage = false;
            if (this.groups != null) {
                for (int i2 = 0; i2 < this.groups.length; ++i2) {
                    this.groups[i2].setStartNewPage(false);
                    this.groups[i2].setResetPageNumber(false);
                    this.groups[i2].setStartNewColumn(false);
                }
            }
            this.setPageHeight(Integer.MAX_VALUE);
        }
    }

    public Locale getLocale() {
        return this.mainDataset.locale;
    }

    public TimeZone getTimeZone() {
        return this.mainDataset.timeZone;
    }

    public FormatFactory getFormatFactory() {
        return this.formatFactory;
    }

    public Format getDateFormat(String string) {
        Locale locale = this.getLocale();
        TimeZone timeZone = this.getTimeZone();
        String string2 = string + "|" + JRDataUtils.getLocaleCode(locale) + "|" + JRDataUtils.getTimeZoneId(timeZone);
        Format format = (Format)this.dateFormatCache.get(string2);
        if (format == null && (format = this.getFormatFactory().createDateFormat(string, locale, timeZone)) != null) {
            this.dateFormatCache.put(string2, format);
        }
        return format;
    }

    public Format getNumberFormat(String string) {
        Locale locale = this.getLocale();
        String string2 = string + "|" + JRDataUtils.getLocaleCode(locale);
        Format format = (Format)this.numberFormatCache.get(string2);
        if (format == null && (format = this.getFormatFactory().createNumberFormat(string, locale)) != null) {
            this.numberFormatCache.put(string2, format);
        }
        return format;
    }

    public boolean hasMasterFormatFactory() {
        return !this.isSubreport() || this.getFormatFactory().getClass().getName().equals(this.fillContext.getMasterFormatFactory().getClass().getName());
    }

    public boolean hasMasterLocale() {
        return !this.isSubreport() || this.getLocale().equals(this.fillContext.getMasterLocale());
    }

    public boolean hasMasterTimeZone() {
        return !this.isSubreport() || this.getTimeZone().equals(this.fillContext.getMasterTimeZone());
    }

    public void setParameter(String string, Object object) throws JRException {
        this.mainDataset.setParameter(string, object);
    }

    public void setParameter(JRFillParameter jRFillParameter, Object object) throws JRException {
        this.mainDataset.setParameter(jRFillParameter, object);
    }

    public boolean next() throws JRException {
        return this.mainDataset.next();
    }

    private void resolveBoundElements(Map map, byte by2, JREvaluationTime jREvaluationTime) throws JRException {
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                JRPrintElement jRPrintElement = (JRPrintElement)entry.getKey();
                JRFillElement jRFillElement = (JRFillElement)entry.getValue();
                jRFillElement.resolveElement(jRPrintElement, by2, jREvaluationTime);
            }
        }
    }

    public void resolveBoundElements(JREvaluationTime jREvaluationTime, byte by2) throws JRException {
        BoundElementMap boundElementMap = (BoundElementMap)this.boundElements.get(jREvaluationTime);
        if (this.isPerPageBoundElements) {
            Map map = boundElementMap.getMap();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                JRPrintPage jRPrintPage = (JRPrintPage)entry.getKey();
                jRPrintPage.getElements();
                Map map2 = (Map)entry.getValue();
                this.resolveBoundElements(map2, by2, jREvaluationTime);
            }
            boundElementMap.clear();
        } else {
            this.resolveBoundElements(boundElementMap.getMap(), by2, jREvaluationTime);
            boundElementMap.clear();
        }
    }

    public void resolveReportBoundElements() throws JRException {
        this.resolveBoundElements(JREvaluationTime.EVALUATION_TIME_REPORT, (byte)3);
    }

    public void resolvePageBoundElements(byte by2) throws JRException {
        this.resolveBoundElements(JREvaluationTime.EVALUATION_TIME_PAGE, by2);
    }

    public void resolveColumnBoundElements(byte by2) throws JRException {
        this.resolveBoundElements(JREvaluationTime.EVALUATION_TIME_COLUMN, by2);
    }

    public void resolveGroupBoundElements(byte by2, boolean bl2) throws JRException {
        if (this.groups != null && this.groups.length > 0) {
            for (int i2 = 0; i2 < this.groups.length; ++i2) {
                JRFillGroup jRFillGroup = this.groups[i2];
                if ((!jRFillGroup.hasChanged() || !jRFillGroup.isFooterPrinted()) && !bl2) continue;
                String string = jRFillGroup.getName();
                this.resolveBoundElements(JREvaluationTime.getGroupEvaluationTime(string), by2);
            }
        }
    }

    public JRPrintPage newPage() {
        Serializable serializable;
        if (this.virtualizer != null) {
            JRVirtualPrintPage jRVirtualPrintPage = new JRVirtualPrintPage(this.jasperPrint, this.virtualizer, this.fillContext.getVirtualizationContext());
            JRBaseFiller.addIdentityDataProviders(jRVirtualPrintPage, this);
            serializable = jRVirtualPrintPage;
        } else {
            serializable = new JRBasePrintPage();
        }
        return serializable;
    }

    public Object getVariableValue(String string) {
        return this.mainDataset.getVariableValue(string);
    }

    public void resolveBandBoundElements(JRFillBand jRFillBand, byte by2) throws JRException {
        this.resolveBoundElements(JREvaluationTime.getBandEvaluationTime(jRFillBand), by2);
    }

    public void addVariableCalculationReq(String string, byte by2) {
        this.mainDataset.addVariableCalculationReq(string, by2);
    }

    public void cancelFill() throws JRException {
        if (log.isDebugEnabled()) {
            log.debug("Fill " + this.fillerId + ": cancelling");
        }
        if (this.fillContext.cancelRunningQuery()) {
            if (log.isDebugEnabled()) {
                log.debug("Fill " + this.fillerId + ": query cancelled");
            }
        } else {
            Thread thread = this.fillingThread;
            if (thread != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Fill " + this.fillerId + ": Interrupting thread " + thread);
                }
                thread.interrupt();
            }
        }
    }

    public void registerSubfiller(JRBaseFiller jRBaseFiller) {
        if (this.subfillers == null) {
            this.subfillers = new HashSet();
        }
        if (this.subfillers.add(jRBaseFiller) && this.fillContext.isUsingVirtualizer()) {
            jRBaseFiller.identityPages = new ArrayList();
            JRVirtualPrintPage jRVirtualPrintPage = (JRVirtualPrintPage)this.fillContext.getPrintPage();
            jRBaseFiller.identityPages.add(jRVirtualPrintPage);
            JRBaseFiller.addIdentityDataProviders(jRVirtualPrintPage, jRBaseFiller);
        }
    }

    public void unregisterSubfiller(JRBaseFiller jRBaseFiller) {
        if (this.subfillers != null && this.subfillers.remove(jRBaseFiller) && this.fillContext.isUsingVirtualizer()) {
            this.removeIdentityDataProviders(jRBaseFiller);
        }
    }

    private static void addIdentityDataProviders(JRVirtualPrintPage jRVirtualPrintPage, JRBaseFiller jRBaseFiller) {
        jRVirtualPrintPage.addIdentityDataProvider(jRBaseFiller);
        if (jRBaseFiller.subfillers != null) {
            Iterator iterator = jRBaseFiller.subfillers.iterator();
            while (iterator.hasNext()) {
                JRBaseFiller jRBaseFiller2 = (JRBaseFiller)iterator.next();
                jRBaseFiller2.identityPages.add(jRVirtualPrintPage);
                JRBaseFiller.addIdentityDataProviders(jRVirtualPrintPage, jRBaseFiller2);
            }
        }
    }

    private void removeIdentityDataProviders(JRBaseFiller jRBaseFiller) {
        if (jRBaseFiller.identityPages != null) {
            Iterator iterator = jRBaseFiller.identityPages.iterator();
            while (iterator.hasNext()) {
                JRVirtualPrintPage jRVirtualPrintPage = (JRVirtualPrintPage)iterator.next();
                jRVirtualPrintPage.removeIdentityDataProvider(jRBaseFiller);
            }
            jRBaseFiller.identityPages = null;
        }
    }

    public void addPage(JRPrintPage jRPrintPage) {
        if (!this.isSubreport()) {
            if (log.isDebugEnabled()) {
                log.debug("Fill " + this.fillerId + ": adding page " + (this.jasperPrint.getPages().size() + 1));
            }
            this.jasperPrint.addPage(jRPrintPage);
            this.fillContext.setPrintPage(jRPrintPage);
        }
    }

    public void addPageIdentityDataProvider() {
        JRVirtualPrintPage.IdentityDataProvider identityDataProvider = PageIdentityDataProvider.getIdentityDataProvider(this.printPage);
        JRVirtualPrintPage jRVirtualPrintPage = (JRVirtualPrintPage)this.fillContext.getPrintPage();
        jRVirtualPrintPage.addIdentityDataProvider(identityDataProvider);
    }

    public void removePageIdentityDataProvider() {
        JRVirtualPrintPage.IdentityDataProvider identityDataProvider = PageIdentityDataProvider.removeIdentityDataProvider(this.printPage);
        if (identityDataProvider != null) {
            ((JRVirtualPrintPage)this.fillContext.getPrintPage()).removeIdentityDataProvider(identityDataProvider);
        }
    }

    public Object evaluateExpression(JRExpression jRExpression, byte by2) throws JRException {
        return this.mainDataset.calculator.evaluate(jRExpression, by2);
    }

    private void createDatasets() throws JRException {
        this.datasetMap = new HashMap();
        JRDataset[] jRDatasetArray = this.jasperReport.getDatasets();
        if (jRDatasetArray != null && jRDatasetArray.length > 0) {
            for (int i2 = 0; i2 < jRDatasetArray.length; ++i2) {
                JRFillDataset jRFillDataset = this.factory.getDataset(jRDatasetArray[i2]);
                jRFillDataset.createCalculator(this.jasperReport);
                this.datasetMap.put(jRDatasetArray[i2].getName(), jRFillDataset);
            }
        }
    }

    private void initDatasets(JRFillObjectFactory jRFillObjectFactory) {
        Iterator iterator = this.datasetMap.values().iterator();
        while (iterator.hasNext()) {
            JRFillDataset jRFillDataset = (JRFillDataset)iterator.next();
            jRFillDataset.inheritFromMain();
            jRFillDataset.initElementDatasets(jRFillObjectFactory);
        }
    }

    public byte getWhenResourceMissingType() {
        return this.mainDataset.whenResourceMissingType;
    }

    public JasperReport getJasperReport() {
        return this.jasperReport;
    }

    public boolean isBandOverFlowAllowed() {
        return this.bandOverFlowAllowed;
    }

    public void setBandOverFlowAllowed(boolean bl2) {
        this.bandOverFlowAllowed = bl2;
    }

    public int getMasterColumnCount() {
        JRBaseFiller jRBaseFiller = this.parentFiller;
        int n2 = 1;
        while (jRBaseFiller != null) {
            n2 *= jRBaseFiller.columnCount;
            jRBaseFiller = jRBaseFiller.parentFiller;
        }
        return n2;
    }

    public JRFillDataset getMainDataset() {
        return this.mainDataset;
    }

    public void addBoundElement(JRFillElement jRFillElement, JRPrintElement jRPrintElement, byte by2, JRGroup jRGroup, JRFillBand jRFillBand) {
        JREvaluationTime jREvaluationTime = JREvaluationTime.getEvaluationTime(by2, jRGroup, jRFillBand);
        this.addBoundElement(jRFillElement, jRPrintElement, jREvaluationTime);
    }

    public void addBoundElement(JRFillElement jRFillElement, JRPrintElement jRPrintElement, JREvaluationTime jREvaluationTime) {
        BoundElementMap boundElementMap = (BoundElementMap)this.boundElements.get(jREvaluationTime);
        boundElementMap.put(jRPrintElement, jRFillElement);
    }

    public JRVirtualPrintPage.ObjectIDPair[] getIdentityData(JRVirtualPrintPage jRVirtualPrintPage) {
        HashMap hashMap = new HashMap();
        ArrayList<JRVirtualPrintPage.ObjectIDPair> arrayList = new ArrayList<JRVirtualPrintPage.ObjectIDPair>();
        JRVirtualPrintPage.ObjectIDPair[] objectIDPairArray = this.boundElements.values().iterator();
        while (objectIDPairArray.hasNext()) {
            BoundElementMap boundElementMap = (BoundElementMap)objectIDPairArray.next();
            Map map = boundElementMap.getMap(jRVirtualPrintPage);
            if (map == null || map.isEmpty()) continue;
            HashMap hashMap2 = new HashMap();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k2 = entry.getKey();
                Integer n2 = (Integer)hashMap.get(k2);
                if (n2 == null) {
                    JRVirtualPrintPage.ObjectIDPair objectIDPair = new JRVirtualPrintPage.ObjectIDPair(k2);
                    arrayList.add(objectIDPair);
                    n2 = new Integer(objectIDPair.getIdentity());
                    hashMap.put(k2, n2);
                }
                hashMap2.put(n2, entry.getValue());
            }
            boundElementMap.putMap(jRVirtualPrintPage, hashMap2);
        }
        objectIDPairArray = null;
        if (!arrayList.isEmpty()) {
            objectIDPairArray = new JRVirtualPrintPage.ObjectIDPair[arrayList.size()];
            arrayList.toArray(objectIDPairArray);
        }
        return objectIDPairArray;
    }

    public void setIdentityData(JRVirtualPrintPage jRVirtualPrintPage, JRVirtualPrintPage.ObjectIDPair[] objectIDPairArray) {
        if (objectIDPairArray == null || objectIDPairArray.length == 0) {
            return;
        }
        Iterator iterator = this.boundElements.values().iterator();
        while (iterator.hasNext()) {
            BoundElementMap boundElementMap = (BoundElementMap)iterator.next();
            Map map = boundElementMap.getMap(jRVirtualPrintPage);
            if (map == null || map.isEmpty()) continue;
            HashMap hashMap = new HashMap();
            for (int i2 = 0; i2 < objectIDPairArray.length; ++i2) {
                JRVirtualPrintPage.ObjectIDPair objectIDPair = objectIDPairArray[i2];
                Integer n2 = new Integer(objectIDPair.getIdentity());
                Object v2 = map.get(n2);
                if (v2 == null) continue;
                hashMap.put(objectIDPair.getObject(), v2);
            }
            boundElementMap.putMap(jRVirtualPrintPage, hashMap);
        }
    }

    public void setSubreportRunner(JRSubreportRunner jRSubreportRunner) {
        this.subreportRunner = jRSubreportRunner;
    }

    public void suspendSubreportRunner() throws JRException {
        if (this.subreportRunner == null) {
            throw new JRRuntimeException("No subreport runner set.");
        }
        if (log.isDebugEnabled()) {
            log.debug("Fill " + this.fillerId + ": suspeding subreport runner");
        }
        this.subreportRunner.suspend();
    }

    public void createReportTemplates(JRFillObjectFactory jRFillObjectFactory) {
        JRReportTemplate[] jRReportTemplateArray = this.jasperReport.getTemplates();
        if (jRReportTemplateArray != null) {
            this.reportTemplates = new JRFillReportTemplate[jRReportTemplateArray.length];
            for (int i2 = 0; i2 < jRReportTemplateArray.length; ++i2) {
                JRReportTemplate jRReportTemplate = jRReportTemplateArray[i2];
                this.reportTemplates[i2] = jRFillObjectFactory.getReportTemplate(jRReportTemplate);
            }
        }
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static final class PageIdentityDataProvider
    implements JRVirtualPrintPage.IdentityDataProvider {
        private static final Map providers = new HashMap();
        private final JRPrintPage printPage;

        public PageIdentityDataProvider(JRPrintPage jRPrintPage) {
            this.printPage = jRPrintPage;
        }

        public JRVirtualPrintPage.ObjectIDPair[] getIdentityData(JRVirtualPrintPage jRVirtualPrintPage) {
            return null;
        }

        public void setIdentityData(JRVirtualPrintPage jRVirtualPrintPage, JRVirtualPrintPage.ObjectIDPair[] objectIDPairArray) {
            if (objectIDPairArray != null && objectIDPairArray.length > 0) {
                HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
                for (int i2 = 0; i2 < objectIDPairArray.length; ++i2) {
                    hashMap.put(new Integer(objectIDPairArray[i2].getIdentity()), objectIDPairArray[i2].getObject());
                }
                ListIterator listIterator = this.printPage.getElements().listIterator();
                while (listIterator.hasNext()) {
                    Object e2 = listIterator.next();
                    Integer n2 = new Integer(System.identityHashCode(e2));
                    Object v2 = hashMap.get(n2);
                    if (v2 == null) continue;
                    listIterator.set(v2);
                }
            }
        }

        public static JRVirtualPrintPage.IdentityDataProvider getIdentityDataProvider(JRPrintPage jRPrintPage) {
            JRVirtualPrintPage.IdentityDataProvider identityDataProvider = (JRVirtualPrintPage.IdentityDataProvider)providers.get(jRPrintPage);
            if (identityDataProvider == null) {
                identityDataProvider = new PageIdentityDataProvider(jRPrintPage);
                providers.put(jRPrintPage, identityDataProvider);
            }
            return identityDataProvider;
        }

        public static JRVirtualPrintPage.IdentityDataProvider removeIdentityDataProvider(JRPrintPage jRPrintPage) {
            JRVirtualPrintPage.IdentityDataProvider identityDataProvider = (JRVirtualPrintPage.IdentityDataProvider)providers.remove(jRPrintPage);
            return identityDataProvider;
        }
    }

    protected static interface DefaultStyleListener {
        public void defaultStyleSet(JRStyle var1);
    }

    public class BoundElementMap {
        private static final long serialVersionUID = 10200L;
        private final Map map;
        private final JRBaseFiller this$0;

        public BoundElementMap(JRBaseFiller jRBaseFiller) {
            this.this$0 = jRBaseFiller;
            this.map = new HashMap();
        }

        public Object put(Object object, Object object2, JRPrintPage jRPrintPage) {
            HashMap<Object, Object> hashMap = (HashMap<Object, Object>)this.map.get(jRPrintPage);
            if (hashMap == null) {
                hashMap = new HashMap<Object, Object>();
                this.map.put(jRPrintPage, hashMap);
            }
            return hashMap.put(object, object2);
        }

        public Object put(Object object, Object object2) {
            if (this.this$0.isPerPageBoundElements) {
                return this.put(object, object2, this.this$0.fillContext.getPrintPage());
            }
            return this.map.put(object, object2);
        }

        public void clear() {
            this.map.clear();
        }

        public Map getMap() {
            return this.map;
        }

        public Map getMap(JRPrintPage jRPrintPage) {
            return (Map)this.map.get(jRPrintPage);
        }

        public Map putMap(JRPrintPage jRPrintPage, Map map) {
            return this.map.put(jRPrintPage, map);
        }
    }
}

