/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.Map;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillDataset;
import net.sf.jasperreports.engine.fill.JRFillElementDataset;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillGroup;
import net.sf.jasperreports.engine.fill.JRFillVariable;

public class JRCalculator
implements JRFillExpressionEvaluator {
    public Map parsm = null;
    public Map fldsm = null;
    public Map varsm = null;
    public JRFillVariable[] variables = null;
    public JRFillGroup[] groups = null;
    public JRFillElementDataset[] datasets = null;
    private JRFillVariable pageNumber = null;
    private JRFillVariable columnNumber = null;
    private final JREvaluator evaluator;

    public JRCalculator(JREvaluator jREvaluator) {
        this.evaluator = jREvaluator;
    }

    public void init(JRFillDataset jRFillDataset) throws JRException {
        this.parsm = jRFillDataset.parametersMap;
        this.fldsm = jRFillDataset.fieldsMap;
        this.varsm = jRFillDataset.variablesMap;
        this.variables = jRFillDataset.variables;
        this.groups = jRFillDataset.groups;
        this.datasets = jRFillDataset.elementDatasets;
        this.pageNumber = (JRFillVariable)this.varsm.get("PAGE_NUMBER");
        this.columnNumber = (JRFillVariable)this.varsm.get("COLUMN_NUMBER");
        byte by2 = jRFillDataset.getWhenResourceMissingType();
        this.evaluator.init(this.parsm, this.fldsm, this.varsm, by2);
    }

    public JRFillVariable getPageNumber() {
        return this.pageNumber;
    }

    public JRFillVariable getColumnNumber() {
        return this.columnNumber;
    }

    public void calculateVariables() throws JRException {
        JRCloneable jRCloneable;
        int n2;
        if (this.variables != null && this.variables.length > 0) {
            for (n2 = 0; n2 < this.variables.length; ++n2) {
                jRCloneable = this.variables[n2];
                Object object = this.evaluate(((JRFillVariable)jRCloneable).getExpression());
                Object object2 = ((JRFillVariable)jRCloneable).getIncrementer().increment((JRFillVariable)jRCloneable, object, AbstractValueProvider.getCurrentValueProvider());
                ((JRFillVariable)jRCloneable).setValue(object2);
                ((JRFillVariable)jRCloneable).setInitialized(false);
                if (((JRFillVariable)jRCloneable).getIncrementType() != 5) continue;
                ((JRFillVariable)jRCloneable).setIncrementedValue(((JRFillVariable)jRCloneable).getValue());
            }
        }
        if (this.datasets != null && this.datasets.length > 0) {
            for (n2 = 0; n2 < this.datasets.length; ++n2) {
                jRCloneable = this.datasets[n2];
                ((JRFillElementDataset)jRCloneable).evaluate(this);
                if (((JRFillElementDataset)jRCloneable).getIncrementType() != 5) continue;
                ((JRFillElementDataset)jRCloneable).increment();
            }
        }
    }

    public void estimateVariables() throws JRException {
        if (this.variables != null && this.variables.length > 0) {
            JRFillVariable jRFillVariable = null;
            Object object = null;
            Object object2 = null;
            for (int i2 = 0; i2 < this.variables.length; ++i2) {
                jRFillVariable = this.variables[i2];
                object = this.evaluateEstimated(jRFillVariable.getExpression());
                object2 = jRFillVariable.getIncrementer().increment(jRFillVariable, object, AbstractValueProvider.getEstimatedValueProvider());
                jRFillVariable.setEstimatedValue(object2);
            }
        }
    }

    public void estimateGroupRuptures() throws JRException {
        JRFillGroup jRFillGroup = null;
        Object object = null;
        Object object2 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.groups != null && this.groups.length > 0) {
            for (int i2 = 0; i2 < this.groups.length; ++i2) {
                jRFillGroup = this.groups[i2];
                bl3 = false;
                if (!bl2) {
                    object = this.evaluateOld(jRFillGroup.getExpression());
                    object2 = this.evaluateEstimated(jRFillGroup.getExpression());
                    if (object == null && object2 != null || object != null && !object.equals(object2)) {
                        bl2 = true;
                        bl3 = true;
                    }
                }
                jRFillGroup.setHasChanged(bl2);
                jRFillGroup.setTopLevelChange(bl3);
            }
        }
    }

    public void initializeVariables(byte by2) throws JRException {
        int n2;
        if (this.variables != null && this.variables.length > 0) {
            for (n2 = 0; n2 < this.variables.length; ++n2) {
                this.incrementVariable(this.variables[n2], by2);
                this.initializeVariable(this.variables[n2], by2);
            }
        }
        if (this.datasets != null && this.datasets.length > 0) {
            for (n2 = 0; n2 < this.datasets.length; ++n2) {
                this.incrementDataset(this.datasets[n2], by2);
                this.initializeDataset(this.datasets[n2], by2);
            }
        }
    }

    private void incrementVariable(JRFillVariable jRFillVariable, byte by2) {
        if (jRFillVariable.getIncrementType() != 5) {
            boolean bl2 = false;
            switch (by2) {
                case 1: {
                    bl2 = true;
                    break;
                }
                case 2: {
                    bl2 = jRFillVariable.getIncrementType() == 2 || jRFillVariable.getIncrementType() == 3;
                    break;
                }
                case 3: {
                    bl2 = jRFillVariable.getIncrementType() == 3;
                    break;
                }
                case 4: {
                    if (jRFillVariable.getIncrementType() != 4) break;
                    JRFillGroup jRFillGroup = (JRFillGroup)jRFillVariable.getIncrementGroup();
                    bl2 = jRFillGroup.hasChanged();
                    break;
                }
            }
            if (bl2) {
                jRFillVariable.setIncrementedValue(jRFillVariable.getValue());
            }
        } else {
            jRFillVariable.setIncrementedValue(jRFillVariable.getValue());
        }
    }

    private void incrementDataset(JRFillElementDataset jRFillElementDataset, byte by2) {
        if (jRFillElementDataset.getIncrementType() != 5) {
            boolean bl2 = false;
            switch (by2) {
                case 1: {
                    bl2 = true;
                    break;
                }
                case 2: {
                    bl2 = jRFillElementDataset.getIncrementType() == 2 || jRFillElementDataset.getIncrementType() == 3;
                    break;
                }
                case 3: {
                    bl2 = jRFillElementDataset.getIncrementType() == 3;
                    break;
                }
                case 4: {
                    if (jRFillElementDataset.getIncrementType() != 4) break;
                    JRFillGroup jRFillGroup = (JRFillGroup)jRFillElementDataset.getIncrementGroup();
                    bl2 = jRFillGroup.hasChanged();
                    break;
                }
            }
            if (bl2) {
                jRFillElementDataset.increment();
            }
        }
    }

    private void initializeVariable(JRFillVariable jRFillVariable, byte by2) throws JRException {
        if (jRFillVariable.getResetType() != 5) {
            boolean bl2 = false;
            switch (by2) {
                case 1: {
                    bl2 = true;
                    break;
                }
                case 2: {
                    bl2 = jRFillVariable.getResetType() == 2 || jRFillVariable.getResetType() == 3;
                    break;
                }
                case 3: {
                    bl2 = jRFillVariable.getResetType() == 3;
                    break;
                }
                case 4: {
                    if (jRFillVariable.getResetType() != 4) break;
                    JRFillGroup jRFillGroup = (JRFillGroup)jRFillVariable.getResetGroup();
                    bl2 = jRFillGroup.hasChanged();
                    break;
                }
            }
            if (bl2) {
                jRFillVariable.setValue(this.evaluate(jRFillVariable.getInitialValueExpression()));
                jRFillVariable.setInitialized(true);
                jRFillVariable.setIncrementedValue(null);
            }
        } else {
            jRFillVariable.setValue(this.evaluate(jRFillVariable.getExpression()));
            jRFillVariable.setIncrementedValue(jRFillVariable.getValue());
        }
    }

    private void initializeDataset(JRFillElementDataset jRFillElementDataset, byte by2) {
        boolean bl2 = false;
        switch (by2) {
            case 1: {
                bl2 = true;
                break;
            }
            case 2: {
                bl2 = jRFillElementDataset.getResetType() == 2 || jRFillElementDataset.getResetType() == 3;
                break;
            }
            case 3: {
                bl2 = jRFillElementDataset.getResetType() == 3;
                break;
            }
            case 4: {
                if (jRFillElementDataset.getResetType() != 4) break;
                JRFillGroup jRFillGroup = (JRFillGroup)jRFillElementDataset.getResetGroup();
                bl2 = jRFillGroup.hasChanged();
                break;
            }
        }
        if (bl2) {
            jRFillElementDataset.initialize();
        }
    }

    public Object evaluate(JRExpression jRExpression, byte by2) throws JRException {
        Object object = null;
        switch (by2) {
            case 1: {
                object = this.evaluateOld(jRExpression);
                break;
            }
            case 2: {
                object = this.evaluateEstimated(jRExpression);
                break;
            }
            default: {
                object = this.evaluate(jRExpression);
            }
        }
        return object;
    }

    public Object evaluateOld(JRExpression jRExpression) throws JRExpressionEvalException {
        return this.evaluator.evaluateOld(jRExpression);
    }

    public Object evaluateEstimated(JRExpression jRExpression) throws JRExpressionEvalException {
        return this.evaluator.evaluateEstimated(jRExpression);
    }

    public Object evaluate(JRExpression jRExpression) throws JRExpressionEvalException {
        return this.evaluator.evaluate(jRExpression);
    }
}

