/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.fill.JRAbstractLRUVirtualizer;
import net.sf.jasperreports.engine.util.JRProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRFileVirtualizer
extends JRAbstractLRUVirtualizer {
    private static final Log log = LogFactory.getLog(b == null ? (b = JRFileVirtualizer.a("net.sf.jasperreports.engine.fill.JRFileVirtualizer")) : b);
    public static final String PROPERTY_TEMP_FILES_SET_DELETE_ON_EXIT = "net.sf.jasperreports.virtualizer.files.delete.on.exit";
    private final String directory;
    public static Class b;

    public JRFileVirtualizer(int n2) {
        this(n2, null);
    }

    public JRFileVirtualizer(int n2, String string) {
        super(n2);
        this.directory = string;
    }

    private String makeFilename(JRVirtualizable jRVirtualizable) {
        String string = jRVirtualizable.getUID();
        return "virt" + string;
    }

    private String makeFilename(String string) {
        return "virt" + string;
    }

    public void pageOut(JRVirtualizable jRVirtualizable) throws IOException {
        String string = this.makeFilename(jRVirtualizable);
        File file = new File(this.directory, string);
        if (file.createNewFile()) {
            if (JRProperties.getBooleanProperty(PROPERTY_TEMP_FILES_SET_DELETE_ON_EXIT)) {
                file.deleteOnExit();
            }
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                this.writeData(jRVirtualizable, bufferedOutputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                log.error("Error virtualizing object", fileNotFoundException);
                throw new JRRuntimeException(fileNotFoundException);
            }
            finally {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
        } else if (!this.isReadOnly(jRVirtualizable)) {
            throw new IllegalStateException("Cannot virtualize data because the file \"" + string + "\" already exists.");
        }
    }

    public void pageIn(JRVirtualizable jRVirtualizable) throws IOException {
        String string = this.makeFilename(jRVirtualizable);
        File file = new File(this.directory, string);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            this.readData(jRVirtualizable, bufferedInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error("Error devirtualizing object", fileNotFoundException);
            throw new JRRuntimeException(fileNotFoundException);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        if (!this.isReadOnly(jRVirtualizable)) {
            file.delete();
        }
    }

    public void dispose(String string) {
        String string2 = this.makeFilename(string);
        File file = new File(this.directory, string2);
        file.delete();
    }

    public synchronized void cleanup() {
        this.disposeAll();
        this.reset();
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

