/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRAbstractScriptlet;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDefaultScriptlet;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRSortableDataSource;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRFillElementDataset;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillGroup;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.query.JRQueryExecuter;
import net.sf.jasperreports.engine.query.JRQueryExecuterFactory;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRQueryExecuterUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRFillDataset
implements JRDataset {
    private static final Log log = LogFactory.getLog(a == null ? (a = JRFillDataset.a("net.sf.jasperreports.engine.fill.JRFillDataset")) : a);
    private final JRBaseFiller filler;
    private final JRDataset parent;
    private final boolean isMain;
    public JRQuery query = null;
    private boolean useDatasourceParamValue = false;
    private boolean useConnectionParamValue = false;
    public JRFillParameter[] parameters = null;
    public Map parametersMap = null;
    public JRFillField[] fields = null;
    public Map fieldsMap = null;
    public JRFillVariable[] variables = null;
    public Map variablesMap = null;
    public Set variableCalculationReqs;
    public JRFillElementDataset[] elementDatasets;
    public JRFillElementDataset[] origElementDatasets;
    public JRFillGroup[] groups = null;
    public String resourceBundleBaseName = null;
    public byte whenResourceMissingType;
    public String scriptletClassName = null;
    public JRDataSource dataSource = null;
    public Locale locale = null;
    public ResourceBundle resourceBundle = null;
    public TimeZone timeZone = null;
    public int reportCount = 0;
    public JRCalculator calculator = null;
    public JRAbstractScriptlet scriptlet = null;
    public Integer reportMaxCount = null;
    private JRQueryExecuter queryExecuter;
    public static Class a;
    public static Class c;
    public static Class b;

    public JRFillDataset(JRBaseFiller jRBaseFiller, JRDataset jRDataset, JRFillObjectFactory jRFillObjectFactory) {
        jRFillObjectFactory.put(jRDataset, this);
        this.filler = jRBaseFiller;
        this.parent = jRDataset;
        this.isMain = jRDataset.isMainDataset();
        this.scriptletClassName = jRDataset.getScriptletClass();
        this.resourceBundleBaseName = jRDataset.getResourceBundle();
        this.whenResourceMissingType = jRDataset.getWhenResourceMissingType();
        this.query = jRDataset.getQuery();
        this.setParameters(jRDataset, jRFillObjectFactory);
        this.setFields(jRDataset, jRFillObjectFactory);
        this.setVariables(jRDataset, jRFillObjectFactory);
        this.setGroups(jRDataset, jRFillObjectFactory);
    }

    private void setParameters(JRDataset jRDataset, JRFillObjectFactory jRFillObjectFactory) {
        JRParameter[] jRParameterArray = jRDataset.getParameters();
        if (jRParameterArray != null && jRParameterArray.length > 0) {
            this.parameters = new JRFillParameter[jRParameterArray.length];
            this.parametersMap = new HashMap();
            for (int i2 = 0; i2 < this.parameters.length; ++i2) {
                this.parameters[i2] = jRFillObjectFactory.getParameter(jRParameterArray[i2]);
                this.parametersMap.put(this.parameters[i2].getName(), this.parameters[i2]);
            }
        }
    }

    private void setGroups(JRDataset jRDataset, JRFillObjectFactory jRFillObjectFactory) {
        JRGroup[] jRGroupArray = jRDataset.getGroups();
        if (jRGroupArray != null && jRGroupArray.length > 0) {
            this.groups = new JRFillGroup[jRGroupArray.length];
            for (int i2 = 0; i2 < this.groups.length; ++i2) {
                this.groups[i2] = jRFillObjectFactory.getGroup(jRGroupArray[i2]);
            }
        }
    }

    private void setVariables(JRDataset jRDataset, JRFillObjectFactory jRFillObjectFactory) {
        JRVariable[] jRVariableArray = jRDataset.getVariables();
        if (jRVariableArray != null && jRVariableArray.length > 0) {
            ArrayList arrayList = new ArrayList(jRVariableArray.length * 3);
            this.variablesMap = new HashMap();
            for (int i2 = 0; i2 < jRVariableArray.length; ++i2) {
                this.addVariable(jRVariableArray[i2], arrayList, jRFillObjectFactory);
            }
            this.setVariables(arrayList);
        }
    }

    private JRFillVariable addVariable(JRVariable jRVariable, List list, JRFillObjectFactory jRFillObjectFactory) {
        JRFillVariable jRFillVariable = jRFillObjectFactory.getVariable(jRVariable);
        byte by2 = jRFillVariable.getCalculation();
        switch (by2) {
            case 3: 
            case 7: {
                JRVariable jRVariable2 = this.createHelperVariable(jRVariable, "_COUNT", (byte)1);
                JRFillVariable jRFillVariable2 = this.addVariable(jRVariable2, list, jRFillObjectFactory);
                jRFillVariable.setHelperVariable(jRFillVariable2, (byte)0);
                JRVariable jRVariable3 = this.createHelperVariable(jRVariable, "_SUM", (byte)2);
                JRFillVariable jRFillVariable3 = this.addVariable(jRVariable3, list, jRFillObjectFactory);
                jRFillVariable.setHelperVariable(jRFillVariable3, (byte)1);
                break;
            }
            case 6: {
                JRVariable jRVariable4 = this.createHelperVariable(jRVariable, "_VARIANCE", (byte)7);
                JRFillVariable jRFillVariable4 = this.addVariable(jRVariable4, list, jRFillObjectFactory);
                jRFillVariable.setHelperVariable(jRFillVariable4, (byte)2);
                break;
            }
            case 10: {
                JRVariable jRVariable5 = this.createDistinctCountHelperVariable(jRVariable);
                JRFillVariable jRFillVariable5 = this.addVariable(jRVariable5, list, jRFillObjectFactory);
                jRFillVariable.setHelperVariable(jRFillVariable5, (byte)0);
                break;
            }
        }
        list.add(jRFillVariable);
        return jRFillVariable;
    }

    private JRVariable createHelperVariable(JRVariable jRVariable, String string, byte by2) {
        JRDesignVariable jRDesignVariable = new JRDesignVariable();
        jRDesignVariable.setName(jRVariable.getName() + string);
        jRDesignVariable.setValueClassName(jRVariable.getValueClassName());
        jRDesignVariable.setIncrementerFactoryClassName(jRVariable.getIncrementerFactoryClassName());
        jRDesignVariable.setResetType(jRVariable.getResetType());
        jRDesignVariable.setResetGroup(jRVariable.getResetGroup());
        jRDesignVariable.setIncrementType(jRVariable.getIncrementType());
        jRDesignVariable.setIncrementGroup(jRVariable.getIncrementGroup());
        jRDesignVariable.setCalculation(by2);
        jRDesignVariable.setSystemDefined(true);
        jRDesignVariable.setExpression(jRVariable.getExpression());
        return jRDesignVariable;
    }

    private JRVariable createDistinctCountHelperVariable(JRVariable jRVariable) {
        JRDesignVariable jRDesignVariable = new JRDesignVariable();
        jRDesignVariable.setName(jRVariable.getName() + "_DISTINCT_COUNT");
        jRDesignVariable.setValueClassName(jRVariable.getValueClassName());
        jRDesignVariable.setIncrementerFactoryClassName((c == null ? (c = JRFillDataset.a("net.sf.jasperreports.engine.fill.JRDistinctCountIncrementerFactory")) : c).getName());
        jRDesignVariable.setResetType((byte)1);
        if (jRVariable.getIncrementType() != 5) {
            jRDesignVariable.setResetType(jRVariable.getIncrementType());
        }
        jRDesignVariable.setResetGroup(jRVariable.getIncrementGroup());
        jRDesignVariable.setCalculation((byte)0);
        jRDesignVariable.setSystemDefined(true);
        jRDesignVariable.setExpression(jRVariable.getExpression());
        return jRDesignVariable;
    }

    private void setVariables(List list) {
        this.variables = new JRFillVariable[list.size()];
        this.variables = list.toArray(this.variables);
        for (int i2 = 0; i2 < this.variables.length; ++i2) {
            this.variablesMap.put(this.variables[i2].getName(), this.variables[i2]);
        }
    }

    private void setFields(JRDataset jRDataset, JRFillObjectFactory jRFillObjectFactory) {
        JRField[] jRFieldArray = jRDataset.getFields();
        if (jRFieldArray != null && jRFieldArray.length > 0) {
            this.fields = new JRFillField[jRFieldArray.length];
            this.fieldsMap = new HashMap();
            for (int i2 = 0; i2 < this.fields.length; ++i2) {
                this.fields[i2] = jRFillObjectFactory.getField(jRFieldArray[i2]);
                this.fieldsMap.put(this.fields[i2].getName(), this.fields[i2]);
            }
        }
    }

    public void createCalculator(JasperReport jasperReport) throws JRException {
        this.setCalculator(JRFillDataset.createCalculator(jasperReport, this));
    }

    public void setCalculator(JRCalculator jRCalculator) {
        this.calculator = jRCalculator;
    }

    public static JRCalculator createCalculator(JasperReport jasperReport, JRDataset jRDataset) throws JRException {
        JREvaluator jREvaluator = JasperCompileManager.loadEvaluator(jasperReport, jRDataset);
        return new JRCalculator(jREvaluator);
    }

    public void initCalculator() throws JRException {
        this.calculator.init(this);
    }

    public void inheritFromMain() {
        if (this.resourceBundleBaseName == null && !this.isMain) {
            this.resourceBundleBaseName = this.filler.mainDataset.resourceBundleBaseName;
            this.whenResourceMissingType = this.filler.mainDataset.whenResourceMissingType;
        }
    }

    public JRAbstractScriptlet createScriptlet() throws JRException {
        JRAbstractScriptlet jRAbstractScriptlet = null;
        if (this.scriptletClassName != null) {
            try {
                Class clazz = JRClassLoader.loadClassForName(this.scriptletClassName);
                jRAbstractScriptlet = (JRAbstractScriptlet)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JRException("Error loading scriptlet class : " + this.scriptletClassName, classNotFoundException);
            }
            catch (Exception exception) {
                throw new JRException("Error creating scriptlet class instance : " + this.scriptletClassName, exception);
            }
        } else {
            jRAbstractScriptlet = new JRDefaultScriptlet();
        }
        return jRAbstractScriptlet;
    }

    public void initElementDatasets(JRFillObjectFactory jRFillObjectFactory) {
        this.elementDatasets = jRFillObjectFactory.getElementDatasets(this);
    }

    public void filterElementDatasets(JRFillElementDataset jRFillElementDataset) {
        this.origElementDatasets = this.elementDatasets;
        this.elementDatasets = new JRFillElementDataset[]{jRFillElementDataset};
    }

    public void restoreElementDatasets() {
        if (this.origElementDatasets != null) {
            this.elementDatasets = this.origElementDatasets;
            this.origElementDatasets = null;
        }
    }

    public ResourceBundle loadResourceBundle() {
        ResourceBundle resourceBundle = null;
        if (this.resourceBundleBaseName != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                try {
                    resourceBundle = ResourceBundle.getBundle(this.resourceBundleBaseName, this.locale, classLoader);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            if (resourceBundle == null) {
                classLoader = (b == null ? (b = JRFillDataset.a("net.sf.jasperreports.engine.util.JRClassLoader")) : b).getClassLoader();
                resourceBundle = classLoader == null ? ResourceBundle.getBundle(this.resourceBundleBaseName, this.locale) : ResourceBundle.getBundle(this.resourceBundleBaseName, this.locale, classLoader);
            }
        }
        return resourceBundle;
    }

    public void setParameterValues(Map map) throws JRException {
        map.put("REPORT_PARAMETERS_MAP", map);
        this.reportMaxCount = (Integer)map.get("REPORT_MAX_COUNT");
        this.locale = (Locale)map.get("REPORT_LOCALE");
        if (this.locale == null) {
            this.locale = Locale.getDefault();
            map.put("REPORT_LOCALE", this.locale);
        }
        this.resourceBundle = (ResourceBundle)map.get("REPORT_RESOURCE_BUNDLE");
        if (this.resourceBundle == null) {
            this.resourceBundle = this.loadResourceBundle();
            if (this.resourceBundle != null) {
                map.put("REPORT_RESOURCE_BUNDLE", this.resourceBundle);
            }
        }
        this.timeZone = (TimeZone)map.get("REPORT_TIME_ZONE");
        if (this.timeZone == null) {
            this.timeZone = TimeZone.getDefault();
            map.put("REPORT_TIME_ZONE", this.timeZone);
        }
        this.scriptlet = (JRAbstractScriptlet)map.get("REPORT_SCRIPTLET");
        if (this.scriptlet == null) {
            this.scriptlet = this.createScriptlet();
            map.put("REPORT_SCRIPTLET", this.scriptlet);
        }
        this.scriptlet.setData(this.parametersMap, this.fieldsMap, this.variablesMap, this.groups);
        this.setFillParameterValues(map);
    }

    public void initDatasource() throws JRException {
        JRSortField[] jRSortFieldArray;
        this.queryExecuter = null;
        this.dataSource = (JRDataSource)this.getParameterValue("REPORT_DATA_SOURCE");
        if (!this.useDatasourceParamValue && (this.useConnectionParamValue || this.dataSource == null)) {
            this.dataSource = this.createQueryDatasource();
            this.setParameter("REPORT_DATA_SOURCE", (Object)this.dataSource);
        }
        if ((jRSortFieldArray = this.getSortFields()) != null && jRSortFieldArray.length > 0) {
            this.dataSource = new JRSortableDataSource(this.dataSource, this.fields, jRSortFieldArray, this.locale);
            this.setParameter("REPORT_DATA_SOURCE", (Object)this.dataSource);
        }
    }

    private void setFillParameterValues(Map map) throws JRException {
        if (this.parameters != null && this.parameters.length > 0) {
            for (int i2 = 0; i2 < this.parameters.length; ++i2) {
                Object object = null;
                if (map.containsKey(this.parameters[i2].getName())) {
                    object = map.get(this.parameters[i2].getName());
                } else if (!this.parameters[i2].isSystemDefined() && (object = this.calculator.evaluate(this.parameters[i2].getDefaultValueExpression(), (byte)3)) != null) {
                    map.put(this.parameters[i2].getName(), object);
                }
                this.setParameter(this.parameters[i2], object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JRDataSource createQueryDatasource() throws JRException {
        if (this.query == null) {
            return null;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("Fill " + this.filler.fillerId + ": Creating " + this.query.getLanguage() + " query executer");
            }
            JRQueryExecuterFactory jRQueryExecuterFactory = JRQueryExecuterUtils.getQueryExecuterFactory(this.query.getLanguage());
            this.queryExecuter = jRQueryExecuterFactory.createQueryExecuter(this.parent, this.parametersMap);
            this.filler.fillContext.setRunningQueryExecuter(this.queryExecuter);
            JRDataSource jRDataSource = this.queryExecuter.createDatasource();
            return jRDataSource;
        }
        finally {
            this.filler.fillContext.clearRunningQueryExecuter();
        }
    }

    public void reset() {
        this.useDatasourceParamValue = false;
        this.useConnectionParamValue = false;
    }

    public void setDatasourceParameterValue(Map map, JRDataSource jRDataSource) {
        this.useDatasourceParamValue = true;
        if (jRDataSource != null) {
            map.put("REPORT_DATA_SOURCE", jRDataSource);
        }
    }

    public void setConnectionParameterValue(Map map, Connection connection) {
        this.useConnectionParamValue = true;
        if (connection != null) {
            map.put("REPORT_CONNECTION", connection);
        }
    }

    public void closeDatasource() {
        if (this.queryExecuter != null) {
            if (log.isDebugEnabled()) {
                log.debug("Fill " + this.filler.fillerId + ": closing query executer");
            }
            this.queryExecuter.close();
            this.queryExecuter = null;
        }
        this.reset();
    }

    public void start() {
        this.reportCount = 0;
    }

    public boolean next() throws JRException {
        boolean bl2 = false;
        if (this.dataSource != null) {
            boolean bl3 = true;
            JRExpression jRExpression = this.getFilterExpression();
            do {
                if (!(bl2 = this.advanceDataSource())) continue;
                this.setOldValues();
                this.calculator.estimateVariables();
                if (jRExpression != null) {
                    Boolean bl4 = (Boolean)this.calculator.evaluate(jRExpression, (byte)2);
                    boolean bl5 = bl3 = bl4 != null && bl4 != false;
                }
                if (bl3) continue;
                this.revertToOldValues();
            } while (bl2 && !bl3);
            if (bl2) {
                ++this.reportCount;
            }
        }
        return bl2;
    }

    public void setOldValues() throws JRException {
        JRCloneable jRCloneable;
        int n2;
        if (this.fields != null && this.fields.length > 0) {
            for (n2 = 0; n2 < this.fields.length; ++n2) {
                jRCloneable = this.fields[n2];
                ((JRFillField)jRCloneable).setPreviousOldValue(((JRFillField)jRCloneable).getOldValue());
                ((JRFillField)jRCloneable).setOldValue(((JRFillField)jRCloneable).getValue());
                ((JRFillField)jRCloneable).setValue(this.dataSource.getFieldValue((JRField)jRCloneable));
            }
        }
        if (this.variables != null && this.variables.length > 0) {
            for (n2 = 0; n2 < this.variables.length; ++n2) {
                jRCloneable = this.variables[n2];
                ((JRFillVariable)jRCloneable).setPreviousOldValue(((JRFillVariable)jRCloneable).getOldValue());
                ((JRFillVariable)jRCloneable).setOldValue(((JRFillVariable)jRCloneable).getValue());
            }
        }
    }

    public void revertToOldValues() {
        JRCloneable jRCloneable;
        int n2;
        if (this.fields != null && this.fields.length > 0) {
            for (n2 = 0; n2 < this.fields.length; ++n2) {
                jRCloneable = this.fields[n2];
                ((JRFillField)jRCloneable).setValue(((JRFillField)jRCloneable).getOldValue());
                ((JRFillField)jRCloneable).setOldValue(((JRFillField)jRCloneable).getPreviousOldValue());
            }
        }
        if (this.variables != null && this.variables.length > 0) {
            for (n2 = 0; n2 < this.variables.length; ++n2) {
                jRCloneable = this.variables[n2];
                ((JRFillVariable)jRCloneable).setValue(((JRFillVariable)jRCloneable).getOldValue());
                ((JRFillVariable)jRCloneable).setOldValue(((JRFillVariable)jRCloneable).getPreviousOldValue());
            }
        }
    }

    public boolean advanceDataSource() throws JRException {
        boolean bl2 = (this.reportMaxCount == null || this.reportMaxCount > this.reportCount) && this.dataSource.next();
        return bl2;
    }

    public void setParameter(String string, Object object) throws JRException {
        JRFillParameter jRFillParameter = (JRFillParameter)this.parametersMap.get(string);
        if (jRFillParameter != null) {
            this.setParameter(jRFillParameter, object);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setParameter(JRFillParameter jRFillParameter, Object object) throws JRException {
        if (object != null) {
            if (!jRFillParameter.getValueClass().isInstance(object)) throw new JRException("Incompatible " + object.getClass().getName() + " value assigned to parameter " + jRFillParameter.getName() + " in the " + this.getName() + " dataset.");
            jRFillParameter.setValue(object);
            return;
        } else {
            jRFillParameter.setValue(object);
        }
    }

    public Object getVariableValue(String string) {
        JRFillVariable jRFillVariable = (JRFillVariable)this.variablesMap.get(string);
        if (jRFillVariable == null) {
            throw new JRRuntimeException("No such variable " + string);
        }
        return jRFillVariable.getValue();
    }

    public Object getParameterValue(String string) {
        return this.getParameterValue(string, false);
    }

    public Object getParameterValue(String string, boolean bl2) {
        Object object;
        JRFillParameter jRFillParameter = (JRFillParameter)this.parametersMap.get(string);
        if (jRFillParameter == null) {
            if (!bl2) {
                throw new JRRuntimeException("No such parameter " + string);
            }
            object = null;
        } else {
            object = jRFillParameter.getValue();
        }
        return object;
    }

    public Object getFieldValue(String string) {
        JRFillField jRFillField = (JRFillField)this.fieldsMap.get(string);
        if (jRFillField == null) {
            throw new JRRuntimeException("No such field " + string);
        }
        return jRFillField.getValue();
    }

    public void addVariableCalculationReq(String string, byte by2) {
        if (this.variableCalculationReqs == null) {
            this.variableCalculationReqs = new HashSet();
        }
        this.variableCalculationReqs.add(new VariableCalculationReq(string, by2));
    }

    public void checkVariableCalculationReqs(JRFillObjectFactory jRFillObjectFactory) {
        if (this.variableCalculationReqs != null && !this.variableCalculationReqs.isEmpty()) {
            ArrayList arrayList = new ArrayList(this.variables.length * 2);
            for (int i2 = 0; i2 < this.variables.length; ++i2) {
                JRFillVariable jRFillVariable = this.variables[i2];
                this.checkVariableCalculationReq(jRFillVariable, arrayList, jRFillObjectFactory);
            }
            this.setVariables(arrayList);
        }
    }

    private void checkVariableCalculationReq(JRFillVariable jRFillVariable, List list, JRFillObjectFactory jRFillObjectFactory) {
        JRFillVariable jRFillVariable2;
        JRVariable jRVariable;
        if (this.hasVariableCalculationReq(jRFillVariable, (byte)3) || this.hasVariableCalculationReq(jRFillVariable, (byte)7)) {
            if (jRFillVariable.getHelperVariable((byte)0) == null) {
                jRVariable = this.createHelperVariable(jRFillVariable, "_COUNT", (byte)1);
                jRFillVariable2 = jRFillObjectFactory.getVariable(jRVariable);
                this.checkVariableCalculationReq(jRFillVariable2, list, jRFillObjectFactory);
                jRFillVariable.setHelperVariable(jRFillVariable2, (byte)0);
            }
            if (jRFillVariable.getHelperVariable((byte)1) == null) {
                jRVariable = this.createHelperVariable(jRFillVariable, "_SUM", (byte)2);
                jRFillVariable2 = jRFillObjectFactory.getVariable(jRVariable);
                this.checkVariableCalculationReq(jRFillVariable2, list, jRFillObjectFactory);
                jRFillVariable.setHelperVariable(jRFillVariable2, (byte)1);
            }
        }
        if (this.hasVariableCalculationReq(jRFillVariable, (byte)6) && jRFillVariable.getHelperVariable((byte)2) == null) {
            jRVariable = this.createHelperVariable(jRFillVariable, "_VARIANCE", (byte)7);
            jRFillVariable2 = jRFillObjectFactory.getVariable(jRVariable);
            this.checkVariableCalculationReq(jRFillVariable2, list, jRFillObjectFactory);
            jRFillVariable.setHelperVariable(jRFillVariable2, (byte)2);
        }
        if (this.hasVariableCalculationReq(jRFillVariable, (byte)10) && jRFillVariable.getHelperVariable((byte)0) == null) {
            jRVariable = this.createDistinctCountHelperVariable(jRFillVariable);
            jRFillVariable2 = jRFillObjectFactory.getVariable(jRVariable);
            this.checkVariableCalculationReq(jRFillVariable2, list, jRFillObjectFactory);
            jRFillVariable.setHelperVariable(jRFillVariable2, (byte)0);
        }
        list.add(jRFillVariable);
    }

    private boolean hasVariableCalculationReq(JRVariable jRVariable, byte by2) {
        return this.variableCalculationReqs.contains(new VariableCalculationReq(jRVariable.getName(), by2));
    }

    public String getName() {
        return this.parent.getName();
    }

    public String getScriptletClass() {
        return this.parent.getScriptletClass();
    }

    public JRParameter[] getParameters() {
        return this.parameters;
    }

    public Map getParametersMap() {
        return this.parametersMap;
    }

    public JRQuery getQuery() {
        return this.query;
    }

    public JRField[] getFields() {
        return this.fields;
    }

    public JRSortField[] getSortFields() {
        return this.parent.getSortFields();
    }

    public JRVariable[] getVariables() {
        return this.variables;
    }

    public JRGroup[] getGroups() {
        return this.groups;
    }

    public boolean isMainDataset() {
        return this.isMain;
    }

    public String getResourceBundle() {
        return this.parent.getResourceBundle();
    }

    public byte getWhenResourceMissingType() {
        return this.whenResourceMissingType;
    }

    public void setWhenResourceMissingType(byte by2) {
        this.whenResourceMissingType = by2;
    }

    public boolean hasProperties() {
        return this.parent.hasProperties();
    }

    public JRPropertiesMap getPropertiesMap() {
        return this.parent.getPropertiesMap();
    }

    public JRPropertiesHolder getParentProperties() {
        return null;
    }

    public JRExpression getFilterExpression() {
        return this.parent.getFilterExpression();
    }

    public Object clone() {
        return null;
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class VariableCalculationReq {
        public String b;
        public byte a;

        public VariableCalculationReq(String string, byte by2) {
            this.b = string;
            this.a = by2;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof VariableCalculationReq)) {
                return false;
            }
            VariableCalculationReq variableCalculationReq = (VariableCalculationReq)object;
            return this.b.equals(variableCalculationReq.b) && this.a == variableCalculationReq.a;
        }

        public int hashCode() {
            return 31 * this.a + this.b.hashCode();
        }
    }
}

