/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.TimeZone;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillDataset;
import net.sf.jasperreports.engine.fill.JRFillDatasetRun;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;

public abstract class JRFillElementDataset
implements JRElementDataset {
    public JRElementDataset parent = null;
    private final JRBaseFiller filler;
    public JRGroup resetGroup = null;
    public JRGroup incrementGroup = null;
    private boolean isIncremented = true;
    public JRFillDatasetRun datasetRun;
    private boolean increment = false;

    public JRFillElementDataset(JRElementDataset jRElementDataset, JRFillObjectFactory jRFillObjectFactory) {
        jRFillObjectFactory.put(jRElementDataset, this);
        this.parent = jRElementDataset;
        this.filler = jRFillObjectFactory.getFiller();
        this.resetGroup = jRFillObjectFactory.getGroup(jRElementDataset.getResetGroup());
        this.incrementGroup = jRFillObjectFactory.getGroup(jRElementDataset.getIncrementGroup());
        this.datasetRun = jRFillObjectFactory.getDatasetRun(jRElementDataset.getDatasetRun());
    }

    public byte getResetType() {
        return this.parent.getResetType();
    }

    public byte getIncrementType() {
        return this.parent.getIncrementType();
    }

    public JRGroup getResetGroup() {
        return this.resetGroup;
    }

    public JRGroup getIncrementGroup() {
        return this.incrementGroup;
    }

    public TimeZone getTimeZone() {
        return this.filler.getTimeZone();
    }

    public void initialize() {
        this.customInitialize();
        this.isIncremented = false;
        this.increment = false;
    }

    public void evaluate(JRCalculator jRCalculator) throws JRExpressionEvalException {
        this.evaluateIncrementWhenExpression(jRCalculator);
        if (this.increment) {
            this.customEvaluate(jRCalculator);
        }
        this.isIncremented = false;
    }

    public void evaluateIncrementWhenExpression(JRCalculator jRCalculator) throws JRExpressionEvalException {
        Boolean bl2;
        JRExpression jRExpression = this.getIncrementWhenExpression();
        this.increment = jRExpression == null ? true : (bl2 = (Boolean)jRCalculator.evaluate(jRExpression)) != null && bl2 != false;
    }

    public void increment() {
        if (!this.isIncremented && this.increment) {
            this.customIncrement();
        }
        this.isIncremented = true;
    }

    public abstract void customInitialize();

    public abstract void customEvaluate(JRCalculator var1) throws JRExpressionEvalException;

    public abstract void customIncrement();

    public JRDatasetRun getDatasetRun() {
        return this.datasetRun;
    }

    public void evaluateDatasetRun(byte by2) throws JRException {
        if (this.datasetRun != null) {
            this.datasetRun.evaluate(this, by2);
        }
    }

    public JRFillDataset getInputDataset() {
        JRFillDataset jRFillDataset = this.datasetRun != null ? this.datasetRun.getDataset() : this.filler.mainDataset;
        return jRFillDataset;
    }

    public JRExpression getIncrementWhenExpression() {
        return this.parent.getIncrementWhenExpression();
    }

    public Object clone() {
        return null;
    }
}

