/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRCalculable;
import net.sf.jasperreports.engine.fill.JRShortIncrementerFactory;

public class JRShortCountIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRShortCountIncrementer mainInstance = new JRShortCountIncrementer();

    private JRShortCountIncrementer() {
    }

    public static JRShortCountIncrementer getInstance() {
        return mainInstance;
    }

    public Object increment(JRCalculable jRCalculable, Object object, AbstractValueProvider abstractValueProvider) {
        Number number = (Number)jRCalculable.getIncrementedValue();
        if (number == null || jRCalculable.isInitialized()) {
            number = JRShortIncrementerFactory.ZERO;
        }
        if (object == null) {
            return number;
        }
        return new Short((short)(number.shortValue() + 1));
    }

    public Object combine(JRCalculable jRCalculable, JRCalculable jRCalculable2, AbstractValueProvider abstractValueProvider) {
        Number number = (Number)jRCalculable.getIncrementedValue();
        Number number2 = (Number)jRCalculable2.getValue();
        if (number == null || jRCalculable.isInitialized()) {
            number = JRShortIncrementerFactory.ZERO;
        }
        if (number2 == null) {
            return number;
        }
        return new Short((short)(number.shortValue() + number2.shortValue()));
    }

    public Object initialValue() {
        return JRShortIncrementerFactory.ZERO;
    }
}

