/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRFillBand;
import net.sf.jasperreports.engine.fill.JRFillGroup;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JRPrintBand;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRVerticalFiller
extends JRBaseFiller {
    private static final Log log = LogFactory.getLog(a == null ? (a = JRVerticalFiller.a("net.sf.jasperreports.engine.fill.JRVerticalFiller")) : a);
    public static Class a;

    public JRVerticalFiller(JasperReport jasperReport) throws JRException {
        this(jasperReport, null, null);
    }

    public JRVerticalFiller(JasperReport jasperReport, JRBaseFiller jRBaseFiller) throws JRException {
        super(jasperReport, null, jRBaseFiller);
        this.setPageHeight(this.pageHeight);
    }

    public JRVerticalFiller(JasperReport jasperReport, JREvaluator jREvaluator, JRBaseFiller jRBaseFiller) throws JRException {
        super(jasperReport, jREvaluator, jRBaseFiller);
        this.setPageHeight(this.pageHeight);
    }

    public void setPageHeight(int n2) {
        this.pageHeight = n2;
        this.columnFooterOffsetY = n2 - this.bottomMargin;
        if (this.pageFooter != null) {
            this.columnFooterOffsetY -= this.pageFooter.getHeight();
        }
        if (this.columnFooter != null) {
            this.columnFooterOffsetY -= this.columnFooter.getHeight();
        }
        this.lastPageColumnFooterOffsetY = n2 - this.bottomMargin;
        if (this.lastPageFooter != null) {
            this.lastPageColumnFooterOffsetY -= this.lastPageFooter.getHeight();
        }
        if (this.columnFooter != null) {
            this.lastPageColumnFooterOffsetY -= this.columnFooter.getHeight();
        }
    }

    public synchronized void fillReport() throws JRException {
        this.setLastPageFooter(false);
        if (this.next()) {
            this.fillReportStart();
            while (this.next()) {
                this.fillReportContent();
            }
            this.fillReportEnd();
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Fill " + this.fillerId + ": no data");
            }
            switch (this.whenNoDataType) {
                case 3: {
                    if (log.isDebugEnabled()) {
                        log.debug("Fill " + this.fillerId + ": all sections");
                    }
                    this.scriptlet.callBeforeReportInit();
                    this.calculator.initializeVariables((byte)1);
                    this.scriptlet.callAfterReportInit();
                    this.printPage = this.newPage();
                    this.addPage(this.printPage);
                    this.setFirstColumn();
                    this.offsetY = this.topMargin;
                    this.fillBackground();
                    this.fillTitle();
                    this.fillPageHeader((byte)3);
                    this.fillColumnHeader((byte)3);
                    this.fillGroupHeaders(true);
                    this.fillGroupFooters(true);
                    this.fillSummary();
                    break;
                }
                case 2: {
                    if (log.isDebugEnabled()) {
                        log.debug("Fill " + this.fillerId + ": blank page");
                    }
                    this.printPage = this.newPage();
                    this.addPage(this.printPage);
                    break;
                }
                case 4: {
                    if (log.isDebugEnabled()) {
                        log.debug("Fill " + this.fillerId + ": all sections");
                    }
                    this.scriptlet.callBeforeReportInit();
                    this.calculator.initializeVariables((byte)1);
                    this.scriptlet.callAfterReportInit();
                    this.printPage = this.newPage();
                    this.addPage(this.printPage);
                    this.setFirstColumn();
                    this.offsetY = this.topMargin;
                    this.fillBackground();
                    this.fillNoData();
                    break;
                }
                default: {
                    if (!log.isDebugEnabled()) break;
                    log.debug("Fill " + this.fillerId + ": no pages");
                }
            }
        }
        if (this.isSubreport()) {
            this.printPageStretchHeight = this.offsetY + this.bottomMargin;
            if (this.fillContext.isUsingVirtualizer()) {
                this.removePageIdentityDataProvider();
            }
        }
        if (this.fillContext.isIgnorePagination()) {
            this.jasperPrint.setPageHeight(this.offsetY + this.bottomMargin);
        }
    }

    private void fillReportStart() throws JRException {
        this.scriptlet.callBeforeReportInit();
        this.calculator.initializeVariables((byte)1);
        this.scriptlet.callAfterReportInit();
        this.printPage = this.newPage();
        this.addPage(this.printPage);
        this.setFirstColumn();
        this.offsetY = this.topMargin;
        this.fillBackground();
        this.fillTitle();
        this.fillPageHeader((byte)3);
        this.fillColumnHeader((byte)3);
        this.fillGroupHeaders(true);
        this.fillDetail();
    }

    private void fillReportContent() throws JRException {
        this.calculator.estimateGroupRuptures();
        this.fillGroupFooters(false);
        this.resolveGroupBoundElements((byte)1, false);
        this.scriptlet.callBeforeGroupInit();
        this.calculator.initializeVariables((byte)4);
        this.scriptlet.callAfterGroupInit();
        this.fillGroupHeaders(false);
        this.fillDetail();
    }

    private void fillReportEnd() throws JRException {
        this.fillGroupFooters(true);
        this.fillSummary();
    }

    private void fillTitle() throws JRException {
        if (log.isDebugEnabled() && !this.title.isEmpty()) {
            log.debug("Fill " + this.fillerId + ": title");
        }
        this.title.evaluatePrintWhenExpression((byte)3);
        if (this.title.isToPrint()) {
            while (this.title.getHeight() > this.pageHeight - this.bottomMargin - this.offsetY) {
                this.addPage(false);
            }
            this.title.evaluate((byte)3);
            JRPrintBand jRPrintBand = this.title.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.title.getHeight());
            if (this.title.willOverflow() && !this.title.isSplitAllowed() && this.isSubreport()) {
                this.resolveGroupBoundElements((byte)3, false);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                jRPrintBand = this.title.refill(this.pageHeight - this.bottomMargin - this.offsetY - this.title.getHeight());
            }
            this.fillBand(jRPrintBand);
            this.offsetY += jRPrintBand.getHeight();
            while (this.title.willOverflow()) {
                this.resolveGroupBoundElements((byte)3, false);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                jRPrintBand = this.title.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.title.getHeight());
                this.fillBand(jRPrintBand);
                this.offsetY += jRPrintBand.getHeight();
            }
            this.resolveBandBoundElements(this.title, (byte)3);
            if (this.isTitleNewPage) {
                this.resolveGroupBoundElements((byte)3, false);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
            }
        }
    }

    private void fillPageHeader(byte by2) throws JRException {
        if (log.isDebugEnabled() && !this.pageHeader.isEmpty()) {
            log.debug("Fill " + this.fillerId + ": page header");
        }
        this.setNewPageColumnInBands();
        this.pageHeader.evaluatePrintWhenExpression((byte)3);
        if (this.pageHeader.isToPrint()) {
            int n2 = this.getMasterColumnCount();
            if (this.isCreatingNewPage) {
                --n2;
            }
            boolean bl2 = this.fillBandNoOverflow(this.pageHeader, by2);
            for (int i2 = 0; !bl2 && i2 < n2; ++i2) {
                this.resolveGroupBoundElements(by2, false);
                this.resolveColumnBoundElements(by2);
                this.resolvePageBoundElements(by2);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                bl2 = this.fillBandNoOverflow(this.pageHeader, by2);
            }
            if (!bl2) {
                throw new JRRuntimeException("Infinite loop creating new page due to page header overflow.");
            }
        }
        this.columnHeaderOffsetY = this.offsetY;
        this.isNewPage = true;
        this.isFirstPageBand = true;
    }

    private boolean fillBandNoOverflow(JRFillBand jRFillBand, byte by2) throws JRException {
        boolean bl2;
        int n2 = this.columnFooterOffsetY - this.offsetY - jRFillBand.getHeight();
        boolean bl3 = bl2 = n2 < 0;
        if (!bl2) {
            jRFillBand.evaluate(by2);
            JRPrintBand jRPrintBand = jRFillBand.fill(n2);
            bl2 = jRFillBand.willOverflow();
            if (bl2) {
                jRFillBand.rewind();
            } else {
                this.fillBand(jRPrintBand);
                this.offsetY += jRPrintBand.getHeight();
                this.resolveBandBoundElements(jRFillBand, by2);
            }
        }
        return !bl2;
    }

    private void fillColumnHeader(byte by2) throws JRException {
        if (log.isDebugEnabled() && !this.columnHeader.isEmpty()) {
            log.debug("Fill " + this.fillerId + ": column header");
        }
        this.setNewPageColumnInBands();
        this.columnHeader.evaluatePrintWhenExpression(by2);
        if (this.columnHeader.isToPrint()) {
            int n2 = this.getMasterColumnCount();
            if (this.isCreatingNewPage) {
                --n2;
            }
            boolean bl2 = this.fillBandNoOverflow(this.columnHeader, by2);
            for (int i2 = 0; !bl2 && i2 < n2; ++i2) {
                while (this.columnIndex < this.columnCount - 1) {
                    this.resolveGroupBoundElements(by2, false);
                    this.resolveColumnBoundElements(by2);
                    this.scriptlet.callBeforeColumnInit();
                    this.calculator.initializeVariables((byte)3);
                    this.scriptlet.callAfterColumnInit();
                    ++this.columnIndex;
                    this.offsetX = this.leftMargin + this.columnIndex * (this.columnSpacing + this.columnWidth);
                    this.offsetY = this.columnHeaderOffsetY;
                    this.setColumnNumberVar();
                }
                this.fillPageFooter(by2);
                this.resolveGroupBoundElements(by2, false);
                this.resolveColumnBoundElements(by2);
                this.resolvePageBoundElements(by2);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                this.fillPageHeader(by2);
                bl2 = this.fillBandNoOverflow(this.columnHeader, by2);
            }
            if (!bl2) {
                throw new JRRuntimeException("Infinite loop creating new page due to column header overflow.");
            }
        }
        this.isNewColumn = true;
        this.isFirstColumnBand = true;
    }

    private void fillGroupHeaders(boolean bl2) throws JRException {
        if (this.groups != null && this.groups.length > 0) {
            for (int i2 = 0; i2 < this.groups.length; ++i2) {
                if (bl2) {
                    this.fillGroupHeader(this.groups[i2]);
                    continue;
                }
                if (!this.groups[i2].hasChanged()) continue;
                this.fillGroupHeader(this.groups[i2]);
            }
        }
    }

    private void fillGroupHeader(JRFillGroup jRFillGroup) throws JRException {
        byte by2;
        JRFillBand jRFillBand = (JRFillBand)jRFillGroup.getGroupHeader();
        if (log.isDebugEnabled() && !jRFillBand.isEmpty()) {
            log.debug("Fill " + this.fillerId + ": " + jRFillGroup.getName() + " header");
        }
        byte by3 = by2 = jRFillGroup.isTopLevelChange() ? (byte)1 : 3;
        if ((jRFillGroup.isStartNewPage() || jRFillGroup.isResetPageNumber()) && !this.isNewPage) {
            this.fillPageBreak(jRFillGroup.isResetPageNumber(), by2, (byte)3, true);
        } else if (jRFillGroup.isStartNewColumn() && !this.isNewColumn) {
            this.fillColumnBreak(by2, (byte)3);
        }
        jRFillBand.evaluatePrintWhenExpression((byte)3);
        if (jRFillBand.isToPrint()) {
            while (jRFillBand.getHeight() > this.columnFooterOffsetY - this.offsetY || jRFillGroup.getMinHeightToStartNewPage() > this.columnFooterOffsetY - this.offsetY) {
                this.fillColumnBreak(by2, (byte)3);
            }
        }
        this.setNewGroupInBands(jRFillGroup);
        jRFillGroup.setFooterPrinted(false);
        if (jRFillBand.isToPrint()) {
            this.fillColumnBand(jRFillBand, (byte)3);
        }
        jRFillGroup.setHeaderPrinted(true);
        this.isNewGroup = true;
        this.isFirstPageBand = false;
        this.isFirstColumnBand = false;
    }

    private void fillGroupHeadersReprint(byte by2) throws JRException {
        if (this.groups != null && this.groups.length > 0) {
            for (int i2 = 0; i2 < this.groups.length; ++i2) {
                this.fillGroupHeaderReprint(this.groups[i2], by2);
            }
        }
    }

    private void fillGroupHeaderReprint(JRFillGroup jRFillGroup, byte by2) throws JRException {
        if (jRFillGroup.isReprintHeaderOnEachPage() && (!jRFillGroup.hasChanged() || jRFillGroup.hasChanged() && jRFillGroup.isHeaderPrinted())) {
            JRFillBand jRFillBand = (JRFillBand)jRFillGroup.getGroupHeader();
            jRFillBand.evaluatePrintWhenExpression(by2);
            if (jRFillBand.isToPrint()) {
                while (jRFillBand.getHeight() > this.columnFooterOffsetY - this.offsetY || jRFillGroup.getMinHeightToStartNewPage() > this.columnFooterOffsetY - this.offsetY) {
                    this.fillColumnBreak(by2, by2);
                }
                this.fillColumnBand(jRFillBand, by2);
            }
            this.isFirstPageBand = false;
            this.isFirstColumnBand = false;
        }
    }

    private void fillDetail() throws JRException {
        if (log.isDebugEnabled() && !this.detail.isEmpty()) {
            log.debug("Fill " + this.fillerId + ": detail");
        }
        if (!this.detail.isPrintWhenExpressionNull()) {
            this.calculator.estimateVariables();
            this.detail.evaluatePrintWhenExpression((byte)2);
        }
        if (this.detail.isToPrint()) {
            while (this.detail.getHeight() > this.columnFooterOffsetY - this.offsetY) {
                byte by2 = this.isNewGroup ? (byte)3 : 1;
                this.fillColumnBreak(by2, (byte)3);
            }
        }
        this.scriptlet.callBeforeDetailEval();
        this.calculator.calculateVariables();
        this.scriptlet.callAfterDetailEval();
        if (!this.detail.isPrintWhenExpressionNull()) {
            this.detail.evaluatePrintWhenExpression((byte)3);
        }
        if (this.detail.isToPrint()) {
            this.fillColumnBand(this.detail, (byte)3);
        }
        this.isNewPage = false;
        this.isNewColumn = false;
        this.isNewGroup = false;
        this.isFirstPageBand = false;
        this.isFirstColumnBand = false;
    }

    private void fillGroupFooters(boolean bl2) throws JRException {
        if (this.groups != null && this.groups.length > 0) {
            byte by2 = bl2 ? (byte)3 : 1;
            for (int i2 = this.groups.length - 1; i2 >= 0; --i2) {
                if (bl2) {
                    this.fillGroupFooter(this.groups[i2], by2);
                    continue;
                }
                if (!this.groups[i2].hasChanged()) continue;
                this.fillGroupFooter(this.groups[i2], by2);
            }
        }
    }

    private void fillGroupFooter(JRFillGroup jRFillGroup, byte by2) throws JRException {
        JRFillBand jRFillBand = (JRFillBand)jRFillGroup.getGroupFooter();
        if (log.isDebugEnabled() && !jRFillBand.isEmpty()) {
            log.debug("Fill " + this.fillerId + ": " + jRFillGroup.getName() + " footer");
        }
        jRFillBand.evaluatePrintWhenExpression(by2);
        if (jRFillBand.isToPrint()) {
            if (jRFillBand.getHeight() > this.columnFooterOffsetY - this.offsetY) {
                this.fillColumnBreak(by2, by2);
            }
            this.fillColumnBand(jRFillBand, by2);
        }
        this.isNewPage = false;
        this.isNewColumn = false;
        this.isFirstPageBand = false;
        this.isFirstColumnBand = false;
        jRFillGroup.setHeaderPrinted(false);
        jRFillGroup.setFooterPrinted(true);
    }

    private void fillColumnFooter(byte by2) throws JRException {
        if (log.isDebugEnabled() && !this.columnFooter.isEmpty()) {
            log.debug("Fill " + this.fillerId + ": column footer");
        }
        if (this.isSubreport() && this.columnIndex == 0) {
            this.columnFooterOffsetY = this.offsetY;
        }
        int n2 = this.offsetY;
        if (!this.isFloatColumnFooter && !this.fillContext.isIgnorePagination()) {
            this.offsetY = this.columnFooterOffsetY;
        }
        this.columnFooter.evaluatePrintWhenExpression(by2);
        if (this.columnFooter.isToPrint()) {
            this.fillFixedBand(this.columnFooter, by2);
        }
        if (this.isFloatColumnFooter && !this.fillContext.isIgnorePagination()) {
            this.offsetY += this.columnFooterOffsetY - n2;
        }
    }

    private void fillPageFooter(byte by2) throws JRException {
        JRFillBand jRFillBand = this.getCurrentPageFooter();
        if (log.isDebugEnabled() && !jRFillBand.isEmpty()) {
            log.debug("Fill " + this.fillerId + ": " + (this.isLastPageFooter ? "last " : "") + "page footer");
        }
        this.offsetX = this.leftMargin;
        if (!this.isSubreport() && !this.fillContext.isIgnorePagination()) {
            this.offsetY = this.pageHeight - jRFillBand.getHeight() - this.bottomMargin;
        }
        jRFillBand.evaluatePrintWhenExpression(by2);
        if (jRFillBand.isToPrint()) {
            this.fillFixedBand(jRFillBand, by2);
        }
    }

    private void fillSummary() throws JRException {
        if (log.isDebugEnabled() && !this.summary.isEmpty()) {
            log.debug("Fill " + this.fillerId + ": summary");
        }
        if (this.lastPageFooter == this.missingFillBand) {
            if (!this.isSummaryNewPage && this.columnIndex == 0 && this.summary.getHeight() <= this.columnFooterOffsetY - this.offsetY) {
                this.fillSummarySamePage();
            } else {
                this.fillSummaryNewPage();
            }
        } else if (!this.isSummaryNewPage && this.columnIndex == 0 && this.summary.getHeight() <= this.lastPageColumnFooterOffsetY - this.offsetY) {
            this.setLastPageFooter(true);
            this.fillSummarySamePage();
        } else if (!this.isSummaryNewPage && this.columnIndex == 0 && this.summary.getHeight() <= this.columnFooterOffsetY - this.offsetY) {
            this.fillSummarySamePageMixedFooters();
        } else if (this.columnIndex == 0 && this.offsetY <= this.lastPageColumnFooterOffsetY) {
            this.setLastPageFooter(true);
            this.fillSummaryNewPage();
        } else {
            this.fillPageBreak(false, (byte)3, (byte)3, false);
            this.setLastPageFooter(true);
            if (this.isSummaryNewPage) {
                this.fillSummaryNewPage();
            } else {
                this.fillSummarySamePage();
            }
        }
        this.resolveGroupBoundElements((byte)3, true);
        this.resolveColumnBoundElements((byte)3);
        this.resolvePageBoundElements((byte)3);
        this.resolveReportBoundElements();
    }

    private void fillSummarySamePage() throws JRException {
        this.summary.evaluatePrintWhenExpression((byte)3);
        if (this.summary != this.missingFillBand && this.summary.isToPrint()) {
            this.summary.evaluate((byte)3);
            JRPrintBand jRPrintBand = this.summary.fill(this.columnFooterOffsetY - this.offsetY - this.summary.getHeight());
            if (this.summary.willOverflow() && !this.summary.isSplitAllowed()) {
                this.fillColumnFooter((byte)3);
                this.fillPageFooter((byte)3);
                this.resolveGroupBoundElements((byte)3, true);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                jRPrintBand = this.summary.refill(this.pageHeight - this.bottomMargin - this.offsetY - this.summary.getHeight());
                this.fillBand(jRPrintBand);
                this.offsetY += jRPrintBand.getHeight();
            } else {
                this.fillBand(jRPrintBand);
                this.offsetY += jRPrintBand.getHeight();
                this.fillColumnFooter((byte)3);
                this.fillPageFooter((byte)3);
            }
            while (this.summary.willOverflow()) {
                this.resolveGroupBoundElements((byte)3, true);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                jRPrintBand = this.summary.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.summary.getHeight());
                this.fillBand(jRPrintBand);
                this.offsetY += jRPrintBand.getHeight();
            }
            this.resolveBandBoundElements(this.summary, (byte)3);
        } else {
            this.fillColumnFooter((byte)3);
            this.fillPageFooter((byte)3);
        }
    }

    private void fillSummarySamePageMixedFooters() throws JRException {
        this.summary.evaluatePrintWhenExpression((byte)3);
        if (this.summary != this.missingFillBand && this.summary.isToPrint()) {
            this.summary.evaluate((byte)3);
            JRPrintBand jRPrintBand = this.summary.fill(this.columnFooterOffsetY - this.offsetY - this.summary.getHeight());
            if (this.summary.willOverflow() && !this.summary.isSplitAllowed()) {
                if (this.offsetY <= this.lastPageColumnFooterOffsetY) {
                    this.setLastPageFooter(true);
                    this.fillColumnFooter((byte)3);
                    this.fillPageFooter((byte)3);
                    this.resolveGroupBoundElements((byte)3, true);
                    this.resolveColumnBoundElements((byte)3);
                    this.resolvePageBoundElements((byte)3);
                    this.scriptlet.callBeforePageInit();
                    this.calculator.initializeVariables((byte)2);
                    this.scriptlet.callAfterPageInit();
                    this.addPage(false);
                    jRPrintBand = this.summary.refill(this.pageHeight - this.bottomMargin - this.offsetY - this.summary.getHeight());
                    this.fillBand(jRPrintBand);
                    this.offsetY += jRPrintBand.getHeight();
                } else {
                    this.fillPageBreak(false, (byte)3, (byte)3, false);
                    this.setLastPageFooter(true);
                    jRPrintBand = this.summary.refill(this.lastPageColumnFooterOffsetY - this.offsetY - this.summary.getHeight());
                    this.fillBand(jRPrintBand);
                    this.offsetY += jRPrintBand.getHeight();
                    this.fillColumnFooter((byte)3);
                    this.fillPageFooter((byte)3);
                }
            } else {
                this.fillBand(jRPrintBand);
                this.offsetY += jRPrintBand.getHeight();
                this.fillPageBreak(false, (byte)3, (byte)3, false);
                this.setLastPageFooter(true);
                if (this.summary.willOverflow()) {
                    jRPrintBand = this.summary.fill(this.lastPageColumnFooterOffsetY - this.offsetY - this.summary.getHeight());
                    this.fillBand(jRPrintBand);
                    this.offsetY += jRPrintBand.getHeight();
                }
                this.fillColumnFooter((byte)3);
                this.fillPageFooter((byte)3);
            }
            while (this.summary.willOverflow()) {
                this.resolveGroupBoundElements((byte)3, true);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                jRPrintBand = this.summary.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.summary.getHeight());
                this.fillBand(jRPrintBand);
                this.offsetY += jRPrintBand.getHeight();
            }
            this.resolveBandBoundElements(this.summary, (byte)3);
        } else {
            if (this.offsetY > this.lastPageColumnFooterOffsetY) {
                this.fillPageBreak(false, (byte)3, (byte)3, false);
            }
            this.setLastPageFooter(true);
            this.fillColumnFooter((byte)3);
            this.fillPageFooter((byte)3);
        }
    }

    private void fillSummaryNewPage() throws JRException {
        this.fillColumnFooter((byte)3);
        this.fillPageFooter((byte)3);
        this.summary.evaluatePrintWhenExpression((byte)3);
        if (this.summary != this.missingFillBand && this.summary.isToPrint()) {
            this.resolveGroupBoundElements((byte)3, true);
            this.resolveColumnBoundElements((byte)3);
            this.resolvePageBoundElements((byte)3);
            this.scriptlet.callBeforePageInit();
            this.calculator.initializeVariables((byte)2);
            this.scriptlet.callAfterPageInit();
            this.addPage(false);
            this.columnIndex = -1;
            this.summary.evaluate((byte)3);
            JRPrintBand jRPrintBand = this.summary.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.summary.getHeight());
            if (this.summary.willOverflow() && !this.summary.isSplitAllowed() && this.isSubreport()) {
                this.resolveGroupBoundElements((byte)3, true);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                jRPrintBand = this.summary.refill(this.pageHeight - this.bottomMargin - this.offsetY - this.summary.getHeight());
            }
            this.fillBand(jRPrintBand);
            this.offsetY += jRPrintBand.getHeight();
            while (this.summary.willOverflow()) {
                this.resolveGroupBoundElements((byte)3, true);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                jRPrintBand = this.summary.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.summary.getHeight());
                this.fillBand(jRPrintBand);
                this.offsetY += jRPrintBand.getHeight();
            }
            this.resolveBandBoundElements(this.summary, (byte)3);
        }
    }

    private void fillBackground() throws JRException {
        if (log.isDebugEnabled() && !this.background.isEmpty()) {
            log.debug("Fill " + this.fillerId + ": background");
        }
        if (this.background.getHeight() <= this.pageHeight - this.bottomMargin - this.offsetY) {
            this.background.evaluatePrintWhenExpression((byte)3);
            if (this.background.isToPrint()) {
                this.background.evaluate((byte)3);
                JRPrintBand jRPrintBand = this.background.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.background.getHeight());
                this.fillBand(jRPrintBand);
            }
        }
    }

    private void addPage(boolean bl2) throws JRException {
        if (this.isSubreport()) {
            if (!this.parentFiller.isBandOverFlowAllowed()) {
                throw new JRRuntimeException("Subreport overflowed on a band that does not support overflow.");
            }
            this.printPageStretchHeight = this.offsetY + this.bottomMargin;
            if (this.fillContext.isUsingVirtualizer()) {
                this.removePageIdentityDataProvider();
            }
            this.suspendSubreportRunner();
        }
        this.printPage = this.newPage();
        if (this.isSubreport() && this.fillContext.isUsingVirtualizer()) {
            this.addPageIdentityDataProvider();
        }
        if (bl2) {
            this.calculator.getPageNumber().setValue(new Integer(1));
        } else {
            this.calculator.getPageNumber().setValue(new Integer(((Number)this.calculator.getPageNumber().getValue()).intValue() + 1));
        }
        this.calculator.getPageNumber().setOldValue(this.calculator.getPageNumber().getValue());
        this.addPage(this.printPage);
        this.setFirstColumn();
        this.offsetY = this.topMargin;
        this.fillBackground();
    }

    private void setFirstColumn() {
        this.columnIndex = 0;
        this.offsetX = this.leftMargin;
        this.setColumnNumberVar();
    }

    private void setColumnNumberVar() {
        JRFillVariable jRFillVariable = this.calculator.getColumnNumber();
        jRFillVariable.setValue(new Integer(this.columnIndex + 1));
        jRFillVariable.setOldValue(jRFillVariable.getValue());
    }

    private void fillPageBreak(boolean bl2, byte by2, byte by3, boolean bl3) throws JRException {
        if (this.isCreatingNewPage) {
            throw new JRException("Infinite loop creating new page.");
        }
        this.isCreatingNewPage = true;
        this.fillColumnFooter(by2);
        this.fillPageFooter(by2);
        this.resolveGroupBoundElements(by2, false);
        this.resolveColumnBoundElements(by2);
        this.resolvePageBoundElements(by2);
        this.scriptlet.callBeforePageInit();
        this.calculator.initializeVariables((byte)2);
        this.scriptlet.callAfterPageInit();
        this.addPage(bl2);
        this.fillPageHeader(by3);
        this.fillColumnHeader(by3);
        if (bl3) {
            this.fillGroupHeadersReprint(by3);
        }
        this.isCreatingNewPage = false;
    }

    private void fillColumnBreak(byte by2, byte by3) throws JRException {
        if (this.columnIndex == this.columnCount - 1) {
            this.fillPageBreak(false, by2, by3, true);
        } else {
            this.fillColumnFooter(by2);
            this.resolveGroupBoundElements(by2, false);
            this.resolveColumnBoundElements(by2);
            this.scriptlet.callBeforeColumnInit();
            this.calculator.initializeVariables((byte)3);
            this.scriptlet.callAfterColumnInit();
            ++this.columnIndex;
            this.offsetX = this.leftMargin + this.columnIndex * (this.columnSpacing + this.columnWidth);
            this.offsetY = this.columnHeaderOffsetY;
            this.setColumnNumberVar();
            this.fillColumnHeader(by3);
        }
    }

    public void fillPageBand(JRFillBand jRFillBand, byte by2) throws JRException {
        jRFillBand.evaluate(by2);
        JRPrintBand jRPrintBand = jRFillBand.fill(this.columnFooterOffsetY - this.offsetY - jRFillBand.getHeight());
        if (jRFillBand.willOverflow() && !jRFillBand.isSplitAllowed()) {
            this.fillPageBreak(false, by2, by2, true);
            jRPrintBand = jRFillBand.refill(this.columnFooterOffsetY - this.offsetY - jRFillBand.getHeight());
        }
        this.fillBand(jRPrintBand);
        this.offsetY += jRPrintBand.getHeight();
        while (jRFillBand.willOverflow()) {
            this.fillPageBreak(false, by2, by2, true);
            jRPrintBand = jRFillBand.fill(this.columnFooterOffsetY - this.offsetY - jRFillBand.getHeight());
            this.fillBand(jRPrintBand);
            this.offsetY += jRPrintBand.getHeight();
        }
        this.resolveBandBoundElements(jRFillBand, by2);
    }

    public void fillColumnBand(JRFillBand jRFillBand, byte by2) throws JRException {
        jRFillBand.evaluate(by2);
        JRPrintBand jRPrintBand = jRFillBand.fill(this.columnFooterOffsetY - this.offsetY - jRFillBand.getHeight());
        if (jRFillBand.willOverflow() && !jRFillBand.isSplitAllowed()) {
            this.fillColumnBreak(by2, by2);
            jRPrintBand = jRFillBand.refill(this.columnFooterOffsetY - this.offsetY - jRFillBand.getHeight());
        }
        this.fillBand(jRPrintBand);
        this.offsetY += jRPrintBand.getHeight();
        while (jRFillBand.willOverflow()) {
            this.fillColumnBreak(by2, by2);
            jRPrintBand = jRFillBand.fill(this.columnFooterOffsetY - this.offsetY - jRFillBand.getHeight());
            this.fillBand(jRPrintBand);
            this.offsetY += jRPrintBand.getHeight();
        }
        this.resolveBandBoundElements(jRFillBand, by2);
    }

    public void fillFixedBand(JRFillBand jRFillBand, byte by2) throws JRException {
        jRFillBand.evaluate(by2);
        JRPrintBand jRPrintBand = jRFillBand.fill();
        this.fillBand(jRPrintBand);
        this.offsetY += jRPrintBand.getHeight();
        this.resolveBandBoundElements(jRFillBand, by2);
    }

    public void fillBand(JRPrintBand jRPrintBand) {
        List list = jRPrintBand.getElements();
        if (list != null && list.size() > 0) {
            JRPrintElement jRPrintElement = null;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                jRPrintElement = (JRPrintElement)iterator.next();
                jRPrintElement.setX(jRPrintElement.getX() + this.offsetX);
                jRPrintElement.setY(jRPrintElement.getY() + this.offsetY);
                this.printPage.addElement(jRPrintElement);
            }
        }
    }

    private void setNewPageColumnInBands() {
        this.title.setNewPageColumn(true);
        this.pageHeader.setNewPageColumn(true);
        this.columnHeader.setNewPageColumn(true);
        this.detail.setNewPageColumn(true);
        this.columnFooter.setNewPageColumn(true);
        this.pageFooter.setNewPageColumn(true);
        this.lastPageFooter.setNewPageColumn(true);
        this.summary.setNewPageColumn(true);
        this.noData.setNewPageColumn(true);
        if (this.groups != null && this.groups.length > 0) {
            for (int i2 = 0; i2 < this.groups.length; ++i2) {
                ((JRFillBand)this.groups[i2].getGroupHeader()).setNewPageColumn(true);
                ((JRFillBand)this.groups[i2].getGroupFooter()).setNewPageColumn(true);
            }
        }
    }

    private void setNewGroupInBands(JRGroup jRGroup) {
        this.title.setNewGroup(jRGroup, true);
        this.pageHeader.setNewGroup(jRGroup, true);
        this.columnHeader.setNewGroup(jRGroup, true);
        this.detail.setNewGroup(jRGroup, true);
        this.columnFooter.setNewGroup(jRGroup, true);
        this.pageFooter.setNewGroup(jRGroup, true);
        this.lastPageFooter.setNewGroup(jRGroup, true);
        this.summary.setNewGroup(jRGroup, true);
        this.noData.setNewGroup(jRGroup, true);
        if (this.groups != null && this.groups.length > 0) {
            for (int i2 = 0; i2 < this.groups.length; ++i2) {
                ((JRFillBand)this.groups[i2].getGroupHeader()).setNewGroup(jRGroup, true);
                ((JRFillBand)this.groups[i2].getGroupFooter()).setNewGroup(jRGroup, true);
            }
        }
    }

    private JRFillBand getCurrentPageFooter() {
        return this.isLastPageFooter ? this.lastPageFooter : this.pageFooter;
    }

    private void setLastPageFooter(boolean bl2) {
        this.isLastPageFooter = bl2;
        if (bl2) {
            this.columnFooterOffsetY = this.lastPageColumnFooterOffsetY;
        }
    }

    private void fillNoData() throws JRException {
        if (log.isDebugEnabled() && !this.noData.isEmpty()) {
            log.debug("Fill " + this.fillerId + ": noData");
        }
        this.noData.evaluatePrintWhenExpression((byte)3);
        if (this.noData.isToPrint()) {
            while (this.noData.getHeight() > this.pageHeight - this.bottomMargin - this.offsetY) {
                this.addPage(false);
            }
            this.noData.evaluate((byte)3);
            JRPrintBand jRPrintBand = this.noData.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.noData.getHeight());
            if (this.noData.willOverflow() && !this.noData.isSplitAllowed() && this.isSubreport()) {
                this.resolveGroupBoundElements((byte)3, false);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                jRPrintBand = this.noData.refill(this.pageHeight - this.bottomMargin - this.offsetY - this.noData.getHeight());
            }
            this.fillBand(jRPrintBand);
            this.offsetY += jRPrintBand.getHeight();
            while (this.noData.willOverflow()) {
                this.resolveGroupBoundElements((byte)3, false);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                jRPrintBand = this.noData.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.noData.getHeight());
                this.fillBand(jRPrintBand);
                this.offsetY += jRPrintBand.getHeight();
            }
            this.resolveBandBoundElements(this.noData, (byte)3);
        }
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

