/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRQueryChunk;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.query.JRClauseFunction;
import net.sf.jasperreports.engine.query.JRClauseTokens;
import net.sf.jasperreports.engine.query.JRQueryClauseContext;
import net.sf.jasperreports.engine.query.JRQueryExecuter;
import net.sf.jasperreports.engine.util.JRQueryChunkHandler;
import net.sf.jasperreports.engine.util.JRQueryParser;

public abstract class JRAbstractQueryExecuter
implements JRQueryExecuter {
    public static final int CLAUSE_POSITION_ID = 0;
    public final Map clauseFunctions = new HashMap();
    public final JRDataset dataset;
    private final Map parametersMap;
    private String queryString;
    private List queryParameters;
    private Set parameterClauseStack;

    public JRAbstractQueryExecuter(JRDataset jRDataset, Map map) {
        this.dataset = jRDataset;
        this.parametersMap = map;
        this.queryString = "";
        this.queryParameters = new ArrayList();
    }

    public void registerClauseFunction(String string, JRClauseFunction jRClauseFunction) {
        this.clauseFunctions.put(string, jRClauseFunction);
    }

    public void unregisterClauseFunction(String string) {
        this.clauseFunctions.remove(string);
    }

    public JRClauseFunction resolveFunction(String string) {
        JRClauseFunction jRClauseFunction = (JRClauseFunction)this.clauseFunctions.get(string);
        if (jRClauseFunction == null) {
            throw new JRRuntimeException("No clause function for id " + string + " found");
        }
        return jRClauseFunction;
    }

    public void parseQuery() {
        JRQueryChunk[] jRQueryChunkArray;
        this.parameterClauseStack = new HashSet();
        JRQuery jRQuery = this.dataset.getQuery();
        if (jRQuery != null && (jRQueryChunkArray = jRQuery.getChunks()) != null && jRQueryChunkArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < jRQueryChunkArray.length; ++i2) {
                JRQueryChunk jRQueryChunk = jRQueryChunkArray[i2];
                this.appendQueryChunk(stringBuffer, jRQueryChunk);
            }
            this.queryString = stringBuffer.toString();
        }
    }

    public void appendQueryChunk(StringBuffer stringBuffer, JRQueryChunk jRQueryChunk) {
        switch (jRQueryChunk.getType()) {
            case 3: {
                this.appendParameterClauseChunk(stringBuffer, jRQueryChunk.getText());
                break;
            }
            case 2: {
                this.appendParameterChunk(stringBuffer, jRQueryChunk.getText());
                break;
            }
            case 4: {
                this.appendClauseChunk(stringBuffer, jRQueryChunk.getTokens());
                break;
            }
            default: {
                this.appendTextChunk(stringBuffer, jRQueryChunk.getText());
            }
        }
    }

    public void appendTextChunk(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string);
    }

    public void appendParameterChunk(StringBuffer stringBuffer, String string) {
        String string2 = string;
        this.checkParameter(string2);
        stringBuffer.append(this.getParameterReplacement(string2));
        this.addQueryParameter(string);
    }

    public void addQueryParameter(String string) {
        QueryParameter queryParameter = new QueryParameter(string);
        this.queryParameters.add(queryParameter);
    }

    public void addQueryMultiParameters(String string, int n2) {
        QueryParameter queryParameter = new QueryParameter(string, n2);
        this.queryParameters.add(queryParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendParameterClauseChunk(StringBuffer stringBuffer, String string) {
        String string2 = string;
        this.checkParameter(string2);
        if (!this.parameterClauseStack.add(string2)) {
            throw new JRRuntimeException("The query contains circularly nested parameter clauses starting with " + string2);
        }
        try {
            Object object = this.getParameterValue(string2);
            String string3 = String.valueOf(object);
            JRQueryChunkHandler jRQueryChunkHandler = new JRQueryChunkHandler(this, stringBuffer){
                private final StringBuffer val$sbuffer;
                private final JRAbstractQueryExecuter this$0;
                {
                    this.this$0 = jRAbstractQueryExecuter;
                    this.val$sbuffer = stringBuffer;
                }

                public void handleParameterChunk(String string) {
                    this.this$0.appendParameterChunk(this.val$sbuffer, string);
                }

                public void handleParameterClauseChunk(String string) {
                    this.this$0.appendParameterClauseChunk(this.val$sbuffer, string);
                }

                public void handleTextChunk(String string) {
                    this.this$0.appendTextChunk(this.val$sbuffer, string);
                }

                public void handleClauseChunk(String[] stringArray) {
                    this.this$0.appendClauseChunk(this.val$sbuffer, stringArray);
                }
            };
            JRQueryParser.instance().parse(string3, jRQueryChunkHandler);
        }
        finally {
            this.parameterClauseStack.remove(string2);
        }
    }

    public void appendClauseChunk(StringBuffer stringBuffer, String[] stringArray) {
        JRClauseTokens jRClauseTokens = new JRClauseTokens(stringArray);
        String string = jRClauseTokens.getToken(0);
        if (string == null) {
            throw new JRRuntimeException("Query clause ID/first token missing");
        }
        JRClauseFunction jRClauseFunction = this.resolveFunction(string);
        this.applyClause(jRClauseFunction, jRClauseTokens, stringBuffer);
    }

    public void applyClause(JRClauseFunction jRClauseFunction, JRClauseTokens jRClauseTokens, StringBuffer stringBuffer) {
        jRClauseFunction.apply(jRClauseTokens, new JRQueryClauseContext(this, stringBuffer){
            private final StringBuffer val$sbuffer;
            private final JRAbstractQueryExecuter this$0;
            {
                this.this$0 = jRAbstractQueryExecuter;
                this.val$sbuffer = stringBuffer;
            }

            public void addQueryMultiParameters(String string, int n2) {
                this.this$0.addQueryMultiParameters(string, n2);
            }

            public void addQueryParameter(String string) {
                this.this$0.addQueryParameter(string);
            }

            public JRValueParameter getValueParameter(String string) {
                return this.this$0.getValueParameter(string);
            }

            public StringBuffer queryBuffer() {
                return this.val$sbuffer;
            }
        });
    }

    public String getQueryString() {
        return this.queryString;
    }

    public List getCollectedParameterNames() {
        ArrayList<String> arrayList = new ArrayList<String>(this.queryParameters.size());
        Iterator iterator = this.queryParameters.iterator();
        while (iterator.hasNext()) {
            QueryParameter queryParameter = (QueryParameter)iterator.next();
            arrayList.add(queryParameter.getName());
        }
        return arrayList;
    }

    public List getCollectedParameters() {
        return this.queryParameters;
    }

    public Object getParameterValue(String string, boolean bl2) {
        if (bl2) {
            JRValueParameter jRValueParameter = this.getValueParameter("REPORT_PARAMETERS_MAP", false);
            return ((Map)jRValueParameter.getValue()).get(string);
        }
        JRValueParameter jRValueParameter = this.getValueParameter(string, bl2);
        return jRValueParameter == null ? null : jRValueParameter.getValue();
    }

    public Object getParameterValue(String string) {
        return this.getParameterValue(string, false);
    }

    public JRFillParameter getParameter(String string) {
        JRFillParameter jRFillParameter = (JRFillParameter)this.parametersMap.get(string);
        if (jRFillParameter == null) {
            throw new JRRuntimeException("Parameter \"" + string + "\" does not exist.");
        }
        return jRFillParameter;
    }

    public void checkParameter(String string) {
        if (!this.parametersMap.containsKey(string)) {
            throw new JRRuntimeException("Parameter \"" + string + "\" does not exist.");
        }
    }

    public JRValueParameter getValueParameter(String string, boolean bl2) {
        JRValueParameter jRValueParameter = (JRValueParameter)this.parametersMap.get(string);
        if (jRValueParameter == null && !bl2) {
            throw new JRRuntimeException("Parameter \"" + string + "\" does not exist.");
        }
        return jRValueParameter;
    }

    public JRValueParameter getValueParameter(String string) {
        return this.getValueParameter(string, false);
    }

    public abstract String getParameterReplacement(String var1);

    protected static class QueryParameter {
        public static final int COUNT_SINGLE = -1;
        private final String name;
        private final int count;

        public QueryParameter(String string) {
            this(string, -1);
        }

        public QueryParameter(String string, int n2) {
            this.name = string;
            this.count = n2;
        }

        public boolean isMulti() {
            return this.count != -1;
        }

        public int getCount() {
            return this.count;
        }

        public String getName() {
            return this.name;
        }
    }
}

