/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import com.lowagie.text.SplitCharacter;
import com.lowagie.text.pdf.PdfChunk;
import java.text.BreakIterator;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import net.sf.jasperreports.engine.JRRuntimeException;

public class BreakIteratorSplitCharacter
implements SplitCharacter {
    private char[] chars;
    private int start;
    private int end;
    private boolean[] boundary;
    private int lastBoundary;
    private final BreakIterator breakIter;

    public BreakIteratorSplitCharacter() {
        this(BreakIterator.getLineInstance());
    }

    public BreakIteratorSplitCharacter(BreakIterator breakIterator) {
        this.breakIter = breakIterator;
    }

    public boolean isSplitCharacter(int n2, int n3, int n4, char[] cArray, PdfChunk[] pdfChunkArray) {
        if (++n3 == n4) {
            return false;
        }
        if (this.chars != cArray || this.start != n2 || this.end != n4) {
            this.chars = cArray;
            this.start = n2;
            this.end = n4;
            this.breakIter.setText(new ArrayCharIterator(cArray, n2, n4));
            this.boundary = new boolean[n4 - n2 + 1];
            this.lastBoundary = this.breakIter.first();
            if (this.lastBoundary != -1) {
                this.boundary[this.lastBoundary - n2] = true;
            }
        }
        while (n3 > this.lastBoundary) {
            this.lastBoundary = this.breakIter.next();
            if (this.lastBoundary == -1) {
                this.lastBoundary = Integer.MAX_VALUE;
                continue;
            }
            this.boundary[this.lastBoundary - n2] = true;
        }
        return this.boundary[n3 - n2];
    }

    protected static class ArrayCharIterator
    implements CharacterIterator {
        private char[] chars;
        private int start;
        private int end;
        private int curr;

        public ArrayCharIterator(char[] cArray, int n2, int n3) {
            this.chars = cArray;
            this.start = n2;
            this.end = n3;
        }

        public char first() {
            this.curr = this.start;
            return this.current();
        }

        public char last() {
            this.curr = this.end == this.start ? this.end : this.end - 1;
            return this.current();
        }

        public char setIndex(int n2) {
            if (n2 < this.start || n2 > this.end) {
                throw new JRRuntimeException("Invalid index " + n2 + " (start = " + this.start + ", end = " + this.end + ")");
            }
            this.curr = n2;
            return this.current();
        }

        public char current() {
            if (this.curr < this.start || this.curr >= this.end) {
                return '\uffff';
            }
            return this.chars[this.curr];
        }

        public char next() {
            if (this.curr >= this.end - 1) {
                this.curr = this.end;
                return '\uffff';
            }
            ++this.curr;
            return this.chars[this.curr];
        }

        public char previous() {
            if (this.curr <= this.start) {
                return '\uffff';
            }
            --this.curr;
            return this.chars[this.curr];
        }

        public int getBeginIndex() {
            return this.start;
        }

        public int getEndIndex() {
            return this.end;
        }

        public int getIndex() {
            return this.curr;
        }

        public Object clone() {
            try {
                StringCharacterIterator stringCharacterIterator = (StringCharacterIterator)super.clone();
                return stringCharacterIterator;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }
    }
}

