/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import net.sf.jasperreports.engine.JRPen;

public class JRPenUtil {
    public static void setLinePenFromPen(byte by2, JRPen jRPen) {
        JRPenUtil.setLinePenFromPen(new Byte(by2), jRPen);
    }

    public static void setLinePenFromPen(Byte by2, JRPen jRPen) {
        if (by2 != null) {
            switch (by2) {
                case 5: {
                    jRPen.setLineWidth(0.5f);
                    jRPen.setLineStyle((byte)0);
                    break;
                }
                case 1: {
                    jRPen.setLineWidth(1.0f);
                    jRPen.setLineStyle((byte)0);
                    break;
                }
                case 2: {
                    jRPen.setLineWidth(2.0f);
                    jRPen.setLineStyle((byte)0);
                    break;
                }
                case 3: {
                    jRPen.setLineWidth(4.0f);
                    jRPen.setLineStyle((byte)0);
                    break;
                }
                case 4: {
                    jRPen.setLineWidth(1.0f);
                    jRPen.setLineStyle((byte)1);
                    break;
                }
                case 0: {
                    jRPen.setLineWidth(0.0f);
                    jRPen.setLineStyle((byte)0);
                }
            }
        }
    }

    public static byte getPenFromLinePen(JRPen jRPen) {
        float f2 = jRPen.getLineWidth().floatValue();
        if (f2 <= 0.0f) {
            return 0;
        }
        if (0.0f < f2 && f2 < 1.0f) {
            return 5;
        }
        if (1.0f <= f2 && f2 < 2.0f) {
            if (jRPen.getLineStyle() == 1) {
                return 4;
            }
            return 1;
        }
        if (2.0f <= f2 && f2 < 4.0f) {
            return 2;
        }
        return 3;
    }

    public static Byte getOwnPenFromLinePen(JRPen jRPen) {
        if (jRPen.getOwnLineWidth() == null && jRPen.getOwnLineStyle() == null) {
            return null;
        }
        return new Byte(JRPenUtil.getPenFromLinePen(jRPen));
    }
}

