/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.ArrayList;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRQueryChunk;
import net.sf.jasperreports.engine.util.JRQueryChunkHandler;

public class JRQueryParser {
    public static final String CLAUSE_TOKEN_SEPARATOR = ",";
    private static final JRQueryParser singleton = new JRQueryParser();

    public static JRQueryParser instance() {
        return singleton;
    }

    public void parse(String string, JRQueryChunkHandler jRQueryChunkHandler) {
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "$", true);
            boolean bl2 = false;
            while (stringTokenizer.hasMoreTokens()) {
                String string2;
                int n2;
                String string3 = stringTokenizer.nextToken();
                if (string3.equals("$")) {
                    if (bl2) {
                        stringBuffer.append("$");
                    }
                    bl2 = true;
                    continue;
                }
                if (string3.startsWith("P{") && bl2) {
                    n2 = string3.indexOf(125);
                    if (n2 > 0) {
                        if (stringBuffer.length() > 0) {
                            jRQueryChunkHandler.handleTextChunk(stringBuffer.toString());
                        }
                        string2 = string3.substring(2, n2);
                        jRQueryChunkHandler.handleParameterChunk(string2);
                        stringBuffer = new StringBuffer(string3.substring(n2 + 1));
                    } else {
                        if (bl2) {
                            stringBuffer.append("$");
                        }
                        stringBuffer.append(string3);
                    }
                } else if (string3.startsWith("P!{") && bl2) {
                    n2 = string3.indexOf(125);
                    if (n2 > 0) {
                        if (stringBuffer.length() > 0) {
                            jRQueryChunkHandler.handleTextChunk(stringBuffer.toString());
                        }
                        string2 = string3.substring(3, n2);
                        jRQueryChunkHandler.handleParameterClauseChunk(string2);
                        stringBuffer = new StringBuffer(string3.substring(n2 + 1));
                    } else {
                        if (bl2) {
                            stringBuffer.append("$");
                        }
                        stringBuffer.append(string3);
                    }
                } else if (string3.startsWith("X{") && bl2) {
                    n2 = string3.indexOf(125);
                    if (n2 > 0) {
                        if (stringBuffer.length() > 0) {
                            jRQueryChunkHandler.handleTextChunk(stringBuffer.toString());
                        }
                        string2 = string3.substring(2, n2);
                        String[] stringArray = this.parseClause(string2);
                        jRQueryChunkHandler.handleClauseChunk(stringArray);
                        stringBuffer = new StringBuffer(string3.substring(n2 + 1));
                    } else {
                        if (bl2) {
                            stringBuffer.append("$");
                        }
                        stringBuffer.append(string3);
                    }
                } else {
                    if (bl2) {
                        stringBuffer.append("$");
                    }
                    stringBuffer.append(string3);
                }
                bl2 = false;
            }
            if (bl2) {
                stringBuffer.append("$");
            }
            if (stringBuffer.length() > 0) {
                jRQueryChunkHandler.handleTextChunk(stringBuffer.toString());
            }
        }
    }

    public String[] parseClause(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, CLAUSE_TOKEN_SEPARATOR, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(CLAUSE_TOKEN_SEPARATOR)) {
                if (!bl2) {
                    arrayList.add("");
                }
                bl2 = false;
                continue;
            }
            arrayList.add(string2);
            bl2 = true;
        }
        if (!bl2) {
            arrayList.add("");
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String asText(JRQueryChunk[] jRQueryChunkArray) {
        String string = "";
        if (jRQueryChunkArray != null && jRQueryChunkArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            block5: for (int i2 = 0; i2 < jRQueryChunkArray.length; ++i2) {
                JRQueryChunk jRQueryChunk = jRQueryChunkArray[i2];
                switch (jRQueryChunk.getType()) {
                    case 2: {
                        stringBuffer.append("$P{");
                        stringBuffer.append(jRQueryChunk.getText());
                        stringBuffer.append("}");
                        continue block5;
                    }
                    case 3: {
                        stringBuffer.append("$P!{");
                        stringBuffer.append(jRQueryChunk.getText());
                        stringBuffer.append("}");
                        continue block5;
                    }
                    case 4: {
                        stringBuffer.append("$X{");
                        stringBuffer.append(jRQueryChunk.getText());
                        stringBuffer.append("}");
                        continue block5;
                    }
                    default: {
                        stringBuffer.append(jRQueryChunk.getText());
                    }
                }
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public String asClauseText(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray != null && stringArray.length > 0) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string;
                if (i2 > 0) {
                    stringBuffer.append(',');
                }
                if ((string = stringArray[i2]) == null) continue;
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }
}

