/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRSwapFile {
    private static final Log log = LogFactory.getLog(a == null ? (a = JRSwapFile.a("net.sf.jasperreports.engine.util.JRSwapFile")) : a);
    public static final String PROPERTY_DELETE_ON_EXIT = "net.sf.jasperreports.virtualizer.files.delete.on.exit";
    private final File swapFile;
    public final RandomAccessFile file;
    private final int blockSize;
    private final int minGrowCount;
    private final LongQueue freeBlocks;
    public static Class a;

    public JRSwapFile(String string, int n2, int n3) {
        try {
            String string2 = "swap_" + System.identityHashCode(this) + "_" + System.currentTimeMillis();
            this.swapFile = new File(string, string2);
            if (log.isDebugEnabled()) {
                log.debug("Creating swap file " + this.swapFile.getPath());
            }
            boolean bl2 = this.swapFile.exists();
            if (JRProperties.getBooleanProperty(PROPERTY_DELETE_ON_EXIT)) {
                this.swapFile.deleteOnExit();
            }
            this.file = new RandomAccessFile(this.swapFile, "rw");
            this.blockSize = n2;
            this.minGrowCount = n3;
            this.freeBlocks = new LongQueue(n3);
            if (bl2) {
                this.file.setLength(0L);
                if (log.isDebugEnabled()) {
                    log.debug("Swap file " + this.swapFile.getPath() + " exists, truncating");
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new JRRuntimeException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new JRRuntimeException(iOException);
        }
    }

    public SwapHandle write(byte[] byArray) throws IOException {
        int n2 = (byArray.length - 1) / this.blockSize + 1;
        long[] lArray = this.reserveFreeBlocks(n2);
        int n3 = (byArray.length - 1) % this.blockSize + 1;
        SwapHandle swapHandle = new SwapHandle(lArray, n3);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = i2 < n2 - 1 ? this.blockSize : n3;
            int n5 = i2 * this.blockSize;
            this.write(byArray, n4, n5, lArray[i2]);
        }
        return swapHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray, int n2, int n3, long l2) throws IOException {
        JRSwapFile jRSwapFile = this;
        synchronized (jRSwapFile) {
            this.file.seek(l2);
            this.file.write(byArray, n3, n2);
        }
    }

    public byte[] read(SwapHandle swapHandle, boolean bl2) throws IOException {
        long[] lArray = swapHandle.getOffsets();
        int n2 = (lArray.length - 1) * this.blockSize + swapHandle.getLastSize();
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            int n3 = i2 * this.blockSize;
            int n4 = i2 < lArray.length - 1 ? this.blockSize : swapHandle.getLastSize();
            this.read(byArray, n3, n4, lArray[i2]);
        }
        if (bl2) {
            this.freeBlocks(lArray);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(byte[] byArray, int n2, int n3, long l2) throws IOException {
        JRSwapFile jRSwapFile = this;
        synchronized (jRSwapFile) {
            this.file.seek(l2);
            this.file.readFully(byArray, n2, n3);
        }
    }

    public void free(SwapHandle swapHandle) {
        this.freeBlocks(swapHandle.getOffsets());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        JRSwapFile jRSwapFile = this;
        synchronized (jRSwapFile) {
            if (this.swapFile.exists()) {
                if (log.isDebugEnabled()) {
                    log.debug("Disposing swap file " + this.swapFile.getPath());
                }
                try {
                    this.file.close();
                }
                catch (IOException iOException) {
                    log.warn("Not able to close swap file " + this.swapFile.getPath());
                }
                if (!this.swapFile.delete()) {
                    log.warn("Not able to delete swap file " + this.swapFile.getPath());
                }
            }
        }
    }

    public void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public synchronized long[] reserveFreeBlocks(int n2) throws IOException {
        int n3 = n2 - this.freeBlocks.size();
        if (n3 > 0) {
            if (n3 < this.minGrowCount) {
                n3 = this.minGrowCount;
            }
            long l2 = this.file.length();
            long l3 = l2 + (long)(n3 * this.blockSize);
            if (log.isDebugEnabled()) {
                log.debug("Growing swap file " + this.swapFile.getPath() + " with " + n3 + " blocks x " + this.blockSize + " bytes to size " + l3);
            }
            this.file.setLength(l3);
            for (int i2 = 0; i2 < n3; ++i2) {
                this.freeBlocks.addLast(l2 + (long)(i2 * this.blockSize));
            }
        }
        long[] lArray = new long[n2];
        for (int i3 = 0; i3 < n2; ++i3) {
            lArray[i3] = this.freeBlocks.popFirst();
        }
        return lArray;
    }

    public synchronized void freeBlocks(long[] lArray) {
        for (int i2 = lArray.length - 1; i2 >= 0; --i2) {
            this.freeBlocks.addFirst(lArray[i2]);
        }
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class SwapHandle {
        private final long[] offsets;
        private final int lastSize;

        public SwapHandle(long[] lArray, int n2) {
            this.offsets = lArray;
            this.lastSize = n2;
        }

        public long[] getOffsets() {
            return this.offsets;
        }

        public int getLastSize() {
            return this.lastSize;
        }
    }

    protected static class LongQueue {
        private final int minGrowCount;
        private long[] vals;
        private int size;
        private int first;
        private int last;

        public LongQueue(int n2) {
            this.minGrowCount = n2;
            this.vals = new long[n2];
            this.size = 0;
            this.first = 0;
            this.last = 0;
        }

        public void addFirst(long l2) {
            this.growIfFull();
            --this.first;
            if (this.first == -1) {
                this.first = this.vals.length - 1;
            }
            this.vals[this.first] = l2;
            ++this.size;
        }

        public void addLast(long l2) {
            this.growIfFull();
            this.vals[this.last] = l2;
            ++this.size;
            ++this.last;
            if (this.last == this.vals.length) {
                this.last = 0;
            }
        }

        public long popFirst() {
            if (this.size == 0) {
                throw new JRRuntimeException("Queue underflow");
            }
            long l2 = this.vals[this.first];
            ++this.first;
            if (this.first == this.vals.length) {
                this.first = 0;
            }
            --this.size;
            return l2;
        }

        public void growIfFull() {
            int n2 = this.vals.length;
            if (this.size == n2) {
                int n3 = n2 * 3 / 2 + 1;
                if (n3 - n2 < this.minGrowCount) {
                    n3 = n2 + this.minGrowCount;
                }
                long[] lArray = new long[n3];
                System.arraycopy(this.vals, this.first, lArray, 0, n2 - this.first);
                if (this.last > 0) {
                    System.arraycopy(this.vals, 0, lArray, n2 - this.first, this.last);
                }
                this.vals = lArray;
                this.first = 0;
                this.last = n2;
            }
        }

        public int size() {
            return this.size;
        }
    }
}

