/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.xml.JRXPathExecuter;
import org.apache.commons.collections.ReferenceMap;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JaxenXPathExecuter
implements JRXPathExecuter {
    private final Map cachedXPaths = new ReferenceMap();

    public XPath getXPath(String string) throws JRException {
        XPath xPath = (XPath)this.cachedXPaths.get(string);
        if (xPath == null) {
            try {
                xPath = new DOMXPath(string);
            }
            catch (JaxenException jaxenException) {
                throw new JRException("XPath compilation failed. Expression: " + string, jaxenException);
            }
            this.cachedXPaths.put(string, xPath);
        }
        return xPath;
    }

    public NodeList selectNodeList(Node node, String string) throws JRException {
        try {
            ArrayList<Object> arrayList;
            XPath xPath = this.getXPath(string);
            Object object = xPath.evaluate((Object)node);
            if (object instanceof List) {
                arrayList = (ArrayList<Object>)object;
            } else {
                arrayList = new ArrayList<Object>();
                arrayList.add(object);
            }
            return new NodeListWrapper(arrayList);
        }
        catch (JaxenException jaxenException) {
            throw new JRException("XPath selection failed. Expression: " + string, jaxenException);
        }
    }

    public Object selectObject(Node node, String string) throws JRException {
        try {
            List list;
            DOMXPath dOMXPath = new DOMXPath(string);
            Object object = dOMXPath.evaluate((Object)node);
            Object object2 = object instanceof List ? ((list = (List)object).isEmpty() ? null : list.get(0)) : (object instanceof Number || object instanceof Boolean ? object : object.toString());
            return object2;
        }
        catch (JaxenException jaxenException) {
            throw new JRException("XPath selection failed. Expression: " + string, jaxenException);
        }
    }

    protected static final class NodeListWrapper
    implements NodeList {
        private final List nodes;

        public NodeListWrapper(List list) {
            this.nodes = list;
        }

        public int getLength() {
            return this.nodes.size();
        }

        public Node item(int n2) {
            return (Node)this.nodes.get(n2);
        }
    }
}

