/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.io.IOException;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.xml.JRXmlConstants;

public abstract class JRXmlBaseWriter {
    public JRXmlWriteHelper writer;

    public void useWriter(JRXmlWriteHelper jRXmlWriteHelper) {
        this.writer = jRXmlWriteHelper;
    }

    public void writeStyle(JRStyle jRStyle) throws IOException {
        this.writer.startElement("style");
        this.writer.addEncodedAttribute("name", jRStyle.getName());
        this.writer.addAttribute("isDefault", jRStyle.isDefault());
        this.writeStyleReferenceAttr(jRStyle);
        this.writer.addAttribute("mode", jRStyle.getOwnMode(), JRXmlConstants.getModeMap());
        this.writer.addAttribute("forecolor", jRStyle.getOwnForecolor());
        this.writer.addAttribute("backcolor", jRStyle.getOwnBackcolor());
        this.writer.addAttribute("fill", jRStyle.getOwnFill(), JRXmlConstants.getFillMap());
        this.writer.addAttribute("radius", jRStyle.getOwnRadius());
        this.writer.addAttribute("scaleImage", jRStyle.getOwnScaleImage(), JRXmlConstants.getScaleImageMap());
        this.writer.addAttribute("hAlign", jRStyle.getOwnHorizontalAlignment(), JRXmlConstants.getHorizontalAlignMap());
        this.writer.addAttribute("vAlign", jRStyle.getOwnVerticalAlignment(), JRXmlConstants.getVerticalAlignMap());
        this.writer.addAttribute("rotation", jRStyle.getOwnRotation(), JRXmlConstants.getRotationMap());
        this.writer.addAttribute("lineSpacing", jRStyle.getOwnLineSpacing(), JRXmlConstants.getLineSpacingMap());
        this.writer.addAttribute("isStyledText", jRStyle.isOwnStyledText());
        this.writer.addEncodedAttribute("pattern", jRStyle.getOwnPattern());
        this.writer.addAttribute("isBlankWhenNull", jRStyle.isOwnBlankWhenNull());
        this.writer.addEncodedAttribute("fontName", jRStyle.getOwnFontName());
        this.writer.addAttribute("fontSize", jRStyle.getOwnFontSize());
        this.writer.addAttribute("isBold", jRStyle.isOwnBold());
        this.writer.addAttribute("isItalic", jRStyle.isOwnItalic());
        this.writer.addAttribute("isUnderline", jRStyle.isOwnUnderline());
        this.writer.addAttribute("isStrikeThrough", jRStyle.isOwnStrikeThrough());
        this.writer.addEncodedAttribute("pdfFontName", jRStyle.getOwnPdfFontName());
        this.writer.addEncodedAttribute("pdfEncoding", jRStyle.getOwnPdfEncoding());
        this.writer.addAttribute("isPdfEmbedded", jRStyle.isOwnPdfEmbedded());
        this.writePen(jRStyle.getLinePen());
        this.writeBox(jRStyle.getLineBox());
        if (this.toWriteConditionalStyles()) {
            JRConditionalStyle[] jRConditionalStyleArray = jRStyle.getConditionalStyles();
            if (!(jRStyle instanceof JRConditionalStyle) && jRConditionalStyleArray != null) {
                for (int i2 = 0; i2 < jRConditionalStyleArray.length; ++i2) {
                    this.writeConditionalStyle(jRConditionalStyleArray[i2]);
                }
            }
        }
        this.writer.closeElement();
    }

    public void writeStyleReferenceAttr(JRStyleContainer jRStyleContainer) {
        if (jRStyleContainer.getStyle() != null) {
            this.writer.addEncodedAttribute("style", jRStyleContainer.getStyle().getName());
        } else if (jRStyleContainer.getStyleNameReference() != null) {
            this.writer.addEncodedAttribute("style", jRStyleContainer.getStyleNameReference());
        }
    }

    public abstract boolean toWriteConditionalStyles();

    public void writeConditionalStyle(JRConditionalStyle jRConditionalStyle) throws IOException {
        this.writer.startElement("conditionalStyle");
        this.writer.writeExpression("conditionExpression", jRConditionalStyle.getConditionExpression(), false);
        this.writeStyle(jRConditionalStyle);
        this.writer.closeElement();
    }

    public void writePen(JRPen jRPen) throws IOException {
        this.writePen("pen", jRPen);
    }

    private void writePen(String string, JRPen jRPen) throws IOException {
        this.writer.startElement(string);
        this.writer.addAttribute("lineWidth", jRPen.getOwnLineWidth());
        this.writer.addAttribute("lineStyle", jRPen.getOwnLineStyle(), JRXmlConstants.getLineStyleMap());
        this.writer.addAttribute("lineColor", jRPen.getOwnLineColor());
        this.writer.closeElement(true);
    }

    public void writeBox(JRLineBox jRLineBox) throws IOException {
        if (jRLineBox != null) {
            this.writer.startElement("box");
            this.writePen("pen", jRLineBox.getPen());
            this.writePen("topPen", jRLineBox.getTopPen());
            this.writePen("leftPen", jRLineBox.getLeftPen());
            this.writePen("bottomPen", jRLineBox.getBottomPen());
            this.writePen("rightPen", jRLineBox.getRightPen());
            this.writer.closeElement(true);
        }
    }
}

