/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JRTemplateReference;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.xml.JRXmlBaseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRXmlTemplateWriter
extends JRXmlBaseWriter {
    private static final Log log = LogFactory.getLog(a == null ? (a = JRXmlTemplateWriter.a("net.sf.jasperreports.engine.xml.JRXmlTemplateWriter")) : a);
    public static final String DEFAULT_ENCODING = "UTF-8";
    private final JRTemplate template;
    private final String encoding;
    public static Class a;

    public static String writeTemplate(JRTemplate jRTemplate) {
        return JRXmlTemplateWriter.writeTemplate(jRTemplate, DEFAULT_ENCODING);
    }

    public static String writeTemplate(JRTemplate jRTemplate, String string) {
        StringWriter stringWriter = new StringWriter();
        try {
            JRXmlTemplateWriter.writeTemplate(jRTemplate, stringWriter, string);
        }
        catch (IOException iOException) {
            throw new JRRuntimeException(iOException);
        }
        return stringWriter.toString();
    }

    public static void writeTemplate(JRTemplate jRTemplate, OutputStream outputStream) {
        JRXmlTemplateWriter.writeTemplate(jRTemplate, outputStream, DEFAULT_ENCODING);
    }

    public static void writeTemplate(JRTemplate jRTemplate, OutputStream outputStream, String string) {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
            JRXmlTemplateWriter.writeTemplate(jRTemplate, outputStreamWriter, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new JRRuntimeException(unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new JRRuntimeException(iOException);
        }
    }

    public static void writeTemplateToFile(JRTemplate jRTemplate, String string) {
        JRXmlTemplateWriter.writeTemplateToFile(jRTemplate, string, DEFAULT_ENCODING);
    }

    public static void writeTemplateToFile(JRTemplate jRTemplate, String string, String string2) {
        BufferedOutputStream bufferedOutputStream = null;
        boolean bl2 = true;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            JRXmlTemplateWriter.writeTemplate(jRTemplate, bufferedOutputStream, string2);
            bufferedOutputStream.flush();
            bl2 = false;
            bufferedOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new JRRuntimeException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new JRRuntimeException(iOException);
        }
        finally {
            if (bufferedOutputStream != null && bl2) {
                try {
                    bufferedOutputStream.close();
                }
                catch (IOException iOException) {
                    log.warn("Could not close file " + string, iOException);
                }
            }
        }
    }

    public static void writeTemplate(JRTemplate jRTemplate, Writer writer, String string) throws IOException {
        JRXmlTemplateWriter jRXmlTemplateWriter = new JRXmlTemplateWriter(jRTemplate, writer, string);
        jRXmlTemplateWriter.write();
        writer.flush();
    }

    public JRXmlTemplateWriter(JRTemplate jRTemplate, Writer writer, String string) {
        this.template = jRTemplate;
        this.encoding = string;
        this.useWriter(new JRXmlWriteHelper(writer));
    }

    public void write() throws IOException {
        this.writer.writeProlog(this.encoding);
        this.writer.writePublicDoctype("jasperTemplate", "-//JasperReports//DTD Template//EN", "http://jasperreports.sourceforge.net/dtds/jaspertemplate.dtd");
        this.writer.startElement("jasperTemplate");
        this.writeIncludedTemplates();
        this.writeStyles();
        this.writer.closeElement();
    }

    public void writeIncludedTemplates() throws IOException {
        JRTemplateReference[] jRTemplateReferenceArray = this.template.getIncludedTemplates();
        if (jRTemplateReferenceArray != null) {
            for (int i2 = 0; i2 < jRTemplateReferenceArray.length; ++i2) {
                JRTemplateReference jRTemplateReference = jRTemplateReferenceArray[i2];
                this.writeIncludedTemplate(jRTemplateReference);
            }
        }
    }

    public void writeIncludedTemplate(JRTemplateReference jRTemplateReference) throws IOException {
        this.writer.writeCDATAElement("template", jRTemplateReference.getLocation());
    }

    public void writeStyles() throws IOException {
        JRStyle[] jRStyleArray = this.template.getStyles();
        if (jRStyleArray != null) {
            for (int i2 = 0; i2 < jRStyleArray.length; ++i2) {
                JRStyle jRStyle = jRStyleArray[i2];
                this.writeStyle(jRStyle);
            }
        }
    }

    public boolean toWriteConditionalStyles() {
        return false;
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

