/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.olap.xmla;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.olap.result.JROlapHierarchy;
import net.sf.jasperreports.olap.result.JROlapMemberTuple;
import net.sf.jasperreports.olap.result.JROlapResultAxis;
import net.sf.jasperreports.olap.xmla.JRXmlaHierarchy;
import net.sf.jasperreports.olap.xmla.JRXmlaMember;
import net.sf.jasperreports.olap.xmla.JRXmlaMemberTuple;

public class JRXmlaResultAxis
implements JROlapResultAxis {
    private final String axisName;
    private final List hierarchyList;
    private JRXmlaHierarchy[] hierarchies;
    private final List tuples;

    public JRXmlaResultAxis(String string) {
        this.axisName = string;
        this.hierarchyList = new ArrayList();
        this.tuples = new ArrayList();
    }

    public String getAxisName() {
        return this.axisName;
    }

    public JROlapHierarchy[] getHierarchiesOnAxis() {
        return this.ensureHierarchyArray();
    }

    public JROlapMemberTuple getTuple(int n2) {
        if (n2 < 0 || n2 >= this.tuples.size()) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + this.tuples.size());
        }
        return (JROlapMemberTuple)this.tuples.get(n2);
    }

    public int getTupleCount() {
        return this.tuples.size();
    }

    public void addHierarchy(JRXmlaHierarchy jRXmlaHierarchy) {
        this.hierarchyList.add(jRXmlaHierarchy);
        this.resetHierarchyArray();
    }

    public void addTuple(JRXmlaMemberTuple jRXmlaMemberTuple) {
        this.tuples.add(jRXmlaMemberTuple);
        this.copyLevelInfo(jRXmlaMemberTuple);
    }

    public void copyLevelInfo(JRXmlaMemberTuple jRXmlaMemberTuple) {
        JRXmlaMember[] jRXmlaMemberArray = jRXmlaMemberTuple.getXmlaMembers();
        Iterator iterator = this.hierarchyList.iterator();
        for (int i2 = 0; iterator.hasNext() && i2 < jRXmlaMemberArray.length; ++i2) {
            JRXmlaHierarchy jRXmlaHierarchy = (JRXmlaHierarchy)iterator.next();
            JRXmlaMember jRXmlaMember = jRXmlaMemberArray[i2];
            if (!jRXmlaHierarchy.getDimensionName().equals(jRXmlaMember.getDimensionName())) continue;
            jRXmlaHierarchy.setLevel(jRXmlaMember.getLevelName(), jRXmlaMember.getDepth());
        }
    }

    public JRXmlaHierarchy[] ensureHierarchyArray() {
        if (this.hierarchies == null) {
            this.hierarchies = new JRXmlaHierarchy[this.hierarchyList.size()];
            this.hierarchies = this.hierarchyList.toArray(this.hierarchies);
        }
        return this.hierarchies;
    }

    public void resetHierarchyArray() {
        this.hierarchies = null;
    }
}

