/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JRViewer;

public class JasperViewer
extends JFrame {
    private static final long serialVersionUID = 10200L;
    public JRViewer viewer = null;
    private boolean isExitOnClose = true;
    private JPanel pnlMain;

    public JasperViewer(String string, boolean bl2) throws JRException {
        this(string, bl2, true);
    }

    public JasperViewer(InputStream inputStream, boolean bl2) throws JRException {
        this(inputStream, bl2, true);
    }

    public JasperViewer(JasperPrint jasperPrint) {
        this(jasperPrint, true);
    }

    public JasperViewer(String string, boolean bl2, boolean bl3) throws JRException {
        this(string, bl2, bl3, null);
    }

    public JasperViewer(InputStream inputStream, boolean bl2, boolean bl3) throws JRException {
        this(inputStream, bl2, bl3, null);
    }

    public JasperViewer(JasperPrint jasperPrint, boolean bl2) {
        this(jasperPrint, bl2, null);
    }

    public JasperViewer(String string, boolean bl2, boolean bl3, Locale locale) throws JRException {
        if (locale != null) {
            this.setLocale(locale);
        }
        this.isExitOnClose = bl3;
        this.initComponents();
        this.viewer = new JRViewer(string, bl2, locale);
        this.pnlMain.add((Component)this.viewer, "Center");
    }

    public JasperViewer(InputStream inputStream, boolean bl2, boolean bl3, Locale locale) throws JRException {
        if (locale != null) {
            this.setLocale(locale);
        }
        this.isExitOnClose = bl3;
        this.initComponents();
        this.viewer = new JRViewer(inputStream, bl2, locale);
        this.pnlMain.add((Component)this.viewer, "Center");
    }

    public JasperViewer(JasperPrint jasperPrint, boolean bl2, Locale locale) {
        if (locale != null) {
            this.setLocale(locale);
        }
        this.isExitOnClose = bl2;
        this.initComponents();
        this.viewer = new JRViewer(jasperPrint, locale);
        this.pnlMain.add((Component)this.viewer, "Center");
    }

    private void initComponents() {
        int n2;
        this.pnlMain = new JPanel();
        this.setTitle("JasperViewer");
        this.setIconImage(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/jricon.GIF")).getImage());
        this.addWindowListener(new WindowAdapter(this){
            private final JasperViewer this$0;
            {
                this.this$0 = jasperViewer;
            }

            public void windowClosing(WindowEvent windowEvent) {
                this.this$0.a();
            }
        });
        this.pnlMain.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.pnlMain, "Center");
        this.pack();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n3 = toolkit.getScreenResolution();
        float f2 = (float)n3 / 72.0f;
        int n4 = (int)(550.0f * f2);
        if ((double)n4 > dimension.getHeight()) {
            n4 = (int)dimension.getHeight();
        }
        if ((double)(n2 = (int)(750.0f * f2)) > dimension.getWidth()) {
            n2 = (int)dimension.getWidth();
        }
        Dimension dimension2 = new Dimension(n2, n4);
        this.setSize(dimension2);
        this.setLocation((dimension.width - n2) / 2, (dimension.height - n4) / 2);
    }

    public void a() {
        if (this.isExitOnClose) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.viewer.clear();
            this.viewer = null;
            this.getContentPane().removeAll();
            this.dispose();
        }
    }

    public void setZoomRatio(float f2) {
        this.viewer.setZoomRatio(f2);
    }

    public void setFitWidthZoomRatio() {
        this.viewer.setFitWidthZoomRatio();
    }

    public void setFitPageZoomRatio() {
        this.viewer.setFitPageZoomRatio();
    }

    public static void main(String[] stringArray) {
        String string = null;
        boolean bl2 = false;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].startsWith("-XML")) {
                bl2 = true;
                continue;
            }
            string = stringArray[i2].startsWith("-F") ? stringArray[i2].substring(2) : stringArray[i2];
        }
        if (string == null) {
            JasperViewer.usage();
            return;
        }
        if (!bl2 && string.endsWith(".jrpxml")) {
            bl2 = true;
        }
        try {
            JasperViewer.viewReport(string, bl2);
        }
        catch (JRException jRException) {
            jRException.printStackTrace();
            System.exit(1);
        }
    }

    private static void usage() {
        System.out.println("JasperViewer usage:");
        System.out.println("\tjava JasperViewer [-XML] file");
    }

    public static void viewReport(String string, boolean bl2) throws JRException {
        JasperViewer.viewReport(string, bl2, true, null);
    }

    public static void viewReport(InputStream inputStream, boolean bl2) throws JRException {
        JasperViewer.viewReport(inputStream, bl2, true, null);
    }

    public static void viewReport(JasperPrint jasperPrint) {
        JasperViewer.viewReport(jasperPrint, true, null);
    }

    public static void viewReport(String string, boolean bl2, boolean bl3) throws JRException {
        JasperViewer.viewReport(string, bl2, bl3, null);
    }

    public static void viewReport(InputStream inputStream, boolean bl2, boolean bl3) throws JRException {
        JasperViewer.viewReport(inputStream, bl2, bl3, null);
    }

    public static void viewReport(JasperPrint jasperPrint, boolean bl2) {
        JasperViewer.viewReport(jasperPrint, bl2, null);
    }

    public static void viewReport(String string, boolean bl2, boolean bl3, Locale locale) throws JRException {
        JasperViewer jasperViewer = new JasperViewer(string, bl2, bl3, locale);
        jasperViewer.setVisible(true);
    }

    public static void viewReport(InputStream inputStream, boolean bl2, boolean bl3, Locale locale) throws JRException {
        JasperViewer jasperViewer = new JasperViewer(inputStream, bl2, bl3, locale);
        jasperViewer.setVisible(true);
    }

    public static void viewReport(JasperPrint jasperPrint, boolean bl2, Locale locale) {
        JasperViewer jasperViewer = new JasperViewer(jasperPrint, bl2, locale);
        jasperViewer.setVisible(true);
    }
}

