/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.LazyDynaClass;
import org.apache.commons.beanutils.MutableDynaClass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LazyDynaBean
implements DynaBean,
Serializable {
    private static Log logger = LogFactory.getLog(m == null ? (m = LazyDynaBean.a("org.apache.commons.beanutils.LazyDynaBean")) : m);
    public static final BigInteger BigInteger_ZERO = new BigInteger("0");
    public static final BigDecimal BigDecimal_ZERO = new BigDecimal("0");
    public static final Character Character_SPACE = new Character(' ');
    public static final Byte Byte_ZERO = new Byte(0);
    public static final Short Short_ZERO = new Short(0);
    public static final Integer Integer_ZERO = new Integer(0);
    public static final Long Long_ZERO = new Long(0L);
    public static final Float Float_ZERO = new Float(0.0f);
    public static final Double Double_ZERO = new Double(0.0);
    public Map values = this.newMap();
    public MutableDynaClass dynaClass;
    public static Class m;
    public static Class a;
    public static Class n;
    public static Class k;
    public static Class l;
    public static Class c;
    public static Class o;
    public static Class i;
    public static Class e;
    public static Class d;
    public static Class b;
    public static Class g;
    public static Class j;
    public static Class f;
    public static Class h;

    public LazyDynaBean() {
        this(new LazyDynaClass());
    }

    public LazyDynaBean(String string) {
        this(new LazyDynaClass(string));
    }

    public LazyDynaBean(DynaClass dynaClass) {
        this.dynaClass = dynaClass instanceof MutableDynaClass ? (MutableDynaClass)dynaClass : new LazyDynaClass(dynaClass.getName(), dynaClass.getDynaProperties());
    }

    public Map getMap() {
        return this.values;
    }

    public int size(String string) {
        if (string == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        Object v2 = this.values.get(string);
        if (v2 == null) {
            return 0;
        }
        if (v2 instanceof Map) {
            return ((Map)v2).size();
        }
        if (v2 instanceof List) {
            return ((List)v2).size();
        }
        if (v2.getClass().isArray()) {
            return Array.getLength(v2);
        }
        return 0;
    }

    public boolean contains(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        Object v2 = this.values.get(string);
        if (v2 == null) {
            return false;
        }
        if (v2 instanceof Map) {
            return ((Map)v2).containsKey(string2);
        }
        return false;
    }

    public Object get(String string) {
        if (string == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        Object object = this.values.get(string);
        if (object != null) {
            return object;
        }
        if (!this.isDynaProperty(string)) {
            return null;
        }
        object = this.createProperty(string, this.dynaClass.getDynaProperty(string).getType());
        if (object != null) {
            this.set(string, object);
        }
        return object;
    }

    public Object get(String string, int n2) {
        if (!this.isDynaProperty(string)) {
            this.set(string, this.defaultIndexedProperty(string));
        }
        Object object = this.get(string);
        if (!this.dynaClass.getDynaProperty(string).isIndexed()) {
            throw new IllegalArgumentException("Non-indexed property for '" + string + "[" + n2 + "]' " + this.dynaClass.getDynaProperty(string).getName());
        }
        if ((object = this.growIndexedProperty(string, object, n2)).getClass().isArray()) {
            return Array.get(object, n2);
        }
        if (object instanceof List) {
            return ((List)object).get(n2);
        }
        throw new IllegalArgumentException("Non-indexed property for '" + string + "[" + n2 + "]' " + object.getClass().getName());
    }

    public Object get(String string, String string2) {
        if (!this.isDynaProperty(string)) {
            this.set(string, this.defaultMappedProperty(string));
        }
        Object object = this.get(string);
        if (!this.dynaClass.getDynaProperty(string).isMapped()) {
            throw new IllegalArgumentException("Non-mapped property for '" + string + "(" + string2 + ")' " + this.dynaClass.getDynaProperty(string).getType().getName());
        }
        if (object instanceof Map) {
            return ((Map)object).get(string2);
        }
        throw new IllegalArgumentException("Non-mapped property for '" + string + "(" + string2 + ")'" + object.getClass().getName());
    }

    public DynaClass getDynaClass() {
        return this.dynaClass;
    }

    public void remove(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        Object v2 = this.values.get(string);
        if (v2 == null) {
            return;
        }
        if (!(v2 instanceof Map)) {
            throw new IllegalArgumentException("Non-mapped property for '" + string + "(" + string2 + ")'" + v2.getClass().getName());
        }
        ((Map)v2).remove(string2);
    }

    public void set(String string, Object object) {
        if (!this.isDynaProperty(string)) {
            if (this.dynaClass.isRestricted()) {
                throw new IllegalArgumentException("Invalid property name '" + string + "' (DynaClass is restricted)");
            }
            if (object == null) {
                this.dynaClass.add(string);
            } else {
                this.dynaClass.add(string, object.getClass());
            }
        }
        DynaProperty dynaProperty = this.dynaClass.getDynaProperty(string);
        if (object == null) {
            if (dynaProperty.getType().isPrimitive()) {
                throw new NullPointerException("Primitive value for '" + string + "'");
            }
        } else if (!this.isAssignable(dynaProperty.getType(), object.getClass())) {
            throw new ConversionException("Cannot assign value of type '" + object.getClass().getName() + "' to property '" + string + "' of type '" + dynaProperty.getType().getName() + "'");
        }
        this.values.put(string, object);
    }

    public void set(String string, int n2, Object object) {
        if (!this.isDynaProperty(string)) {
            this.set(string, this.defaultIndexedProperty(string));
        }
        Object object2 = this.get(string);
        if (!this.dynaClass.getDynaProperty(string).isIndexed()) {
            throw new IllegalArgumentException("Non-indexed property for '" + string + "[" + n2 + "]'" + this.dynaClass.getDynaProperty(string).getType().getName());
        }
        if ((object2 = this.growIndexedProperty(string, object2, n2)).getClass().isArray()) {
            Array.set(object2, n2, object);
        } else if (object2 instanceof List) {
            ((List)object2).set(n2, object);
        } else {
            throw new IllegalArgumentException("Non-indexed property for '" + string + "[" + n2 + "]' " + object2.getClass().getName());
        }
    }

    public void set(String string, String string2, Object object) {
        if (!this.isDynaProperty(string)) {
            this.set(string, this.defaultMappedProperty(string));
        }
        Object object2 = this.get(string);
        if (!this.dynaClass.getDynaProperty(string).isMapped()) {
            throw new IllegalArgumentException("Non-mapped property for '" + string + "(" + string2 + ")'" + this.dynaClass.getDynaProperty(string).getType().getName());
        }
        ((Map)object2).put(string2, object);
    }

    public Object growIndexedProperty(String string, Object object, int n2) {
        int n3;
        if (object instanceof List) {
            List list = (List)object;
            while (n2 >= list.size()) {
                list.add(null);
            }
        }
        if (object.getClass().isArray() && n2 >= (n3 = Array.getLength(object))) {
            Class<?> clazz = object.getClass().getComponentType();
            Object object2 = Array.newInstance(clazz, n2 + 1);
            System.arraycopy(object, 0, object2, 0, n3);
            object = object2;
            this.set(string, object);
            int n4 = Array.getLength(object);
            int n5 = n3;
            while (n5 < n4) {
                Array.set(object, n5, this.createProperty(string + "[" + n5 + "]", clazz));
                ++n5;
            }
        }
        return object;
    }

    public Object createProperty(String string, Class clazz) {
        if (clazz.isArray() || (a == null ? (a = LazyDynaBean.a("java.util.List")) : a).isAssignableFrom(clazz)) {
            return this.createIndexedProperty(string, clazz);
        }
        if ((n == null ? (n = LazyDynaBean.a("java.util.Map")) : n).isAssignableFrom(clazz)) {
            return this.createMappedProperty(string, clazz);
        }
        if ((k == null ? (k = LazyDynaBean.a("org.apache.commons.beanutils.DynaBean")) : k).isAssignableFrom(clazz)) {
            return this.createDynaBeanProperty(string, clazz);
        }
        if (clazz.isPrimitive()) {
            return this.createPrimitiveProperty(string, clazz);
        }
        if ((l == null ? (l = LazyDynaBean.a("java.lang.Number")) : l).isAssignableFrom(clazz)) {
            return this.createNumberProperty(string, clazz);
        }
        return this.createOtherProperty(string, clazz);
    }

    public Object createIndexedProperty(String string, Class clazz) {
        Object object = null;
        if (clazz == null) {
            object = this.defaultIndexedProperty(string);
        } else if (clazz.isArray()) {
            object = Array.newInstance(clazz.getComponentType(), 0);
        } else if ((a == null ? (a = LazyDynaBean.a("java.util.List")) : a).isAssignableFrom(clazz)) {
            if (clazz.isInterface()) {
                object = this.defaultIndexedProperty(string);
            } else {
                try {
                    object = clazz.newInstance();
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Error instantiating indexed property of type '" + clazz.getName() + "' for '" + string + "' " + exception);
                }
            }
        } else {
            throw new IllegalArgumentException("Non-indexed property of type '" + clazz.getName() + "' for '" + string + "'");
        }
        return object;
    }

    public Object createMappedProperty(String string, Class clazz) {
        Map map = null;
        if (clazz == null) {
            map = this.defaultMappedProperty(string);
        } else if (clazz.isInterface()) {
            map = this.defaultMappedProperty(string);
        } else if ((n == null ? (n = LazyDynaBean.a("java.util.Map")) : n).isAssignableFrom(clazz)) {
            try {
                map = clazz.newInstance();
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Error instantiating mapped property of type '" + clazz.getName() + "' for '" + string + "' " + exception);
            }
        } else {
            throw new IllegalArgumentException("Non-mapped property of type '" + clazz.getName() + "' for '" + string + "'");
        }
        return map;
    }

    public Object createDynaBeanProperty(String string, Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            if (logger.isWarnEnabled()) {
                logger.warn("Error instantiating DynaBean property of type '" + clazz.getName() + "' for '" + string + "' " + exception);
            }
            return null;
        }
    }

    public Object createPrimitiveProperty(String string, Class clazz) {
        if (clazz == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (clazz == Integer.TYPE) {
            return Integer_ZERO;
        }
        if (clazz == Long.TYPE) {
            return Long_ZERO;
        }
        if (clazz == Double.TYPE) {
            return Double_ZERO;
        }
        if (clazz == Float.TYPE) {
            return Float_ZERO;
        }
        if (clazz == Byte.TYPE) {
            return Byte_ZERO;
        }
        if (clazz == Short.TYPE) {
            return Short_ZERO;
        }
        if (clazz == Character.TYPE) {
            return Character_SPACE;
        }
        return null;
    }

    public Object createNumberProperty(String string, Class clazz) {
        return null;
    }

    public Object createOtherProperty(String string, Class clazz) {
        if (clazz == (c == null ? (c = LazyDynaBean.a("java.lang.String")) : c) || clazz == (o == null ? (o = LazyDynaBean.a("java.lang.Boolean")) : o) || clazz == (i == null ? (i = LazyDynaBean.a("java.lang.Character")) : i) || (e == null ? (e = LazyDynaBean.a("java.util.Date")) : e).isAssignableFrom(clazz)) {
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            if (logger.isWarnEnabled()) {
                logger.warn("Error instantiating property of type '" + clazz.getName() + "' for '" + string + "' " + exception);
            }
            return null;
        }
    }

    public Object defaultIndexedProperty(String string) {
        return new ArrayList();
    }

    public Map defaultMappedProperty(String string) {
        return new HashMap();
    }

    public boolean isDynaProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        if (this.dynaClass instanceof LazyDynaClass) {
            return ((LazyDynaClass)this.dynaClass).isDynaProperty(string);
        }
        return this.dynaClass.getDynaProperty(string) != null;
    }

    public boolean isAssignable(Class clazz, Class clazz2) {
        return clazz.isAssignableFrom(clazz2) || clazz == Boolean.TYPE && clazz2 == (o == null ? (o = LazyDynaBean.a("java.lang.Boolean")) : o) || clazz == Byte.TYPE && clazz2 == (d == null ? (d = LazyDynaBean.a("java.lang.Byte")) : d) || clazz == Character.TYPE && clazz2 == (i == null ? (i = LazyDynaBean.a("java.lang.Character")) : i) || clazz == Double.TYPE && clazz2 == (b == null ? (b = LazyDynaBean.a("java.lang.Double")) : b) || clazz == Float.TYPE && clazz2 == (g == null ? (g = LazyDynaBean.a("java.lang.Float")) : g) || clazz == Integer.TYPE && clazz2 == (j == null ? (j = LazyDynaBean.a("java.lang.Integer")) : j) || clazz == Long.TYPE && clazz2 == (f == null ? (f = LazyDynaBean.a("java.lang.Long")) : f) || clazz == Short.TYPE && clazz2 == (h == null ? (h = LazyDynaBean.a("java.lang.Short")) : h);
    }

    public Map newMap() {
        return new HashMap();
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

