/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.locale;

import java.lang.reflect.Array;
import java.util.Locale;
import org.apache.commons.beanutils.locale.LocaleBeanUtilsBean;
import org.apache.commons.beanutils.locale.LocaleConverter;
import org.apache.commons.beanutils.locale.converters.BigDecimalLocaleConverter;
import org.apache.commons.beanutils.locale.converters.BigIntegerLocaleConverter;
import org.apache.commons.beanutils.locale.converters.ByteLocaleConverter;
import org.apache.commons.beanutils.locale.converters.DoubleLocaleConverter;
import org.apache.commons.beanutils.locale.converters.FloatLocaleConverter;
import org.apache.commons.beanutils.locale.converters.IntegerLocaleConverter;
import org.apache.commons.beanutils.locale.converters.LongLocaleConverter;
import org.apache.commons.beanutils.locale.converters.ShortLocaleConverter;
import org.apache.commons.beanutils.locale.converters.SqlDateLocaleConverter;
import org.apache.commons.beanutils.locale.converters.SqlTimeLocaleConverter;
import org.apache.commons.beanutils.locale.converters.SqlTimestampLocaleConverter;
import org.apache.commons.beanutils.locale.converters.StringLocaleConverter;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocaleConvertUtilsBean {
    private Locale defaultLocale = Locale.getDefault();
    private boolean applyLocalized = false;
    private Log log = LogFactory.getLog(h == null ? (h = LocaleConvertUtilsBean.a("org.apache.commons.beanutils.locale.LocaleConvertUtils")) : h);
    private FastHashMap mapConverters = new FastHashMap();
    public static Class h;
    public static Class k;
    public static Class f;
    public static Class g;
    public static Class l;
    public static Class b;
    public static Class d;
    public static Class j;
    public static Class a;
    public static Class e;
    public static Class i;
    public static Class c;
    public static Class m;

    public static LocaleConvertUtilsBean getInstance() {
        return LocaleBeanUtilsBean.getLocaleBeanUtilsInstance().getLocaleConvertUtils();
    }

    public LocaleConvertUtilsBean() {
        this.deregister();
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(Locale locale) {
        this.defaultLocale = locale == null ? Locale.getDefault() : locale;
    }

    public boolean getApplyLocalized() {
        return this.applyLocalized;
    }

    public void setApplyLocalized(boolean bl2) {
        this.applyLocalized = bl2;
    }

    public String convert(Object object) {
        return this.convert(object, this.defaultLocale, null);
    }

    public String convert(Object object, String string) {
        return this.convert(object, this.defaultLocale, string);
    }

    public String convert(Object object, Locale locale, String string) {
        LocaleConverter localeConverter = this.lookup(k == null ? (k = LocaleConvertUtilsBean.a("java.lang.String")) : k, locale);
        return (String)localeConverter.convert(k == null ? (k = LocaleConvertUtilsBean.a("java.lang.String")) : k, object, string);
    }

    public Object convert(String string, Class clazz) {
        return this.convert(string, clazz, this.defaultLocale, null);
    }

    public Object convert(String string, Class clazz, String string2) {
        return this.convert(string, clazz, this.defaultLocale, string2);
    }

    public Object convert(String string, Class clazz, Locale locale, String string2) {
        LocaleConverter localeConverter;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Convert string " + string + " to class " + clazz.getName() + " using " + locale.toString() + " locale and " + string2 + " pattern");
        }
        if ((localeConverter = this.lookup(clazz, locale)) == null) {
            localeConverter = this.lookup(k == null ? (k = LocaleConvertUtilsBean.a("java.lang.String")) : k, locale);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("  Using converter " + localeConverter);
        }
        return localeConverter.convert(clazz, string, string2);
    }

    public Object convert(String[] stringArray, Class clazz, String string) {
        return this.convert(stringArray, clazz, this.getDefaultLocale(), string);
    }

    public Object convert(String[] stringArray, Class clazz) {
        return this.convert(stringArray, clazz, this.getDefaultLocale(), null);
    }

    public Object convert(String[] stringArray, Class clazz, Locale locale, String string) {
        Class<?> clazz2 = clazz;
        if (clazz.isArray()) {
            clazz2 = clazz.getComponentType();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Convert String[" + stringArray.length + "] to class " + clazz2.getName() + "[] using " + locale.toString() + " locale and " + string + " pattern");
        }
        Object object = Array.newInstance(clazz2, stringArray.length);
        int n2 = 0;
        while (n2 < stringArray.length) {
            Array.set(object, n2, this.convert(stringArray[n2], clazz2, locale, string));
            ++n2;
        }
        return object;
    }

    public void register(LocaleConverter localeConverter, Class clazz, Locale locale) {
        this.lookup(locale).put(clazz, localeConverter);
    }

    public void deregister() {
        FastHashMap fastHashMap = this.lookup(this.defaultLocale);
        this.mapConverters.setFast(false);
        this.mapConverters.clear();
        this.mapConverters.put(this.defaultLocale, fastHashMap);
        this.mapConverters.setFast(true);
    }

    public void deregister(Locale locale) {
        this.mapConverters.remove(locale);
    }

    public void deregister(Class clazz, Locale locale) {
        this.lookup(locale).remove(clazz);
    }

    public LocaleConverter lookup(Class clazz, Locale locale) {
        LocaleConverter localeConverter = (LocaleConverter)this.lookup(locale).get(clazz);
        if (this.log.isTraceEnabled()) {
            this.log.trace("LocaleConverter:" + localeConverter);
        }
        return localeConverter;
    }

    public FastHashMap lookup(Locale locale) {
        FastHashMap fastHashMap;
        if (locale == null) {
            fastHashMap = (FastHashMap)this.mapConverters.get(this.defaultLocale);
        } else {
            fastHashMap = (FastHashMap)this.mapConverters.get(locale);
            if (fastHashMap == null) {
                fastHashMap = this.create(locale);
                this.mapConverters.put(locale, fastHashMap);
            }
        }
        return fastHashMap;
    }

    public FastHashMap create(Locale locale) {
        FastHashMap fastHashMap = new FastHashMap();
        fastHashMap.setFast(false);
        fastHashMap.put(f == null ? (f = LocaleConvertUtilsBean.a("java.math.BigDecimal")) : f, new BigDecimalLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(g == null ? (g = LocaleConvertUtilsBean.a("java.math.BigInteger")) : g, new BigIntegerLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(l == null ? (l = LocaleConvertUtilsBean.a("java.lang.Byte")) : l, new ByteLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(Byte.TYPE, new ByteLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(b == null ? (b = LocaleConvertUtilsBean.a("java.lang.Double")) : b, new DoubleLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(Double.TYPE, new DoubleLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(d == null ? (d = LocaleConvertUtilsBean.a("java.lang.Float")) : d, new FloatLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(Float.TYPE, new FloatLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(j == null ? (j = LocaleConvertUtilsBean.a("java.lang.Integer")) : j, new IntegerLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(Integer.TYPE, new IntegerLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(a == null ? (a = LocaleConvertUtilsBean.a("java.lang.Long")) : a, new LongLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(Long.TYPE, new LongLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(e == null ? (e = LocaleConvertUtilsBean.a("java.lang.Short")) : e, new ShortLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(Short.TYPE, new ShortLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(k == null ? (k = LocaleConvertUtilsBean.a("java.lang.String")) : k, new StringLocaleConverter(locale, this.applyLocalized));
        fastHashMap.put(i == null ? (i = LocaleConvertUtilsBean.a("java.sql.Date")) : i, new SqlDateLocaleConverter(locale, "yyyy-MM-dd"));
        fastHashMap.put(c == null ? (c = LocaleConvertUtilsBean.a("java.sql.Time")) : c, new SqlTimeLocaleConverter(locale, "HH:mm:ss"));
        fastHashMap.put(m == null ? (m = LocaleConvertUtilsBean.a("java.sql.Timestamp")) : m, new SqlTimestampLocaleConverter(locale, "yyyy-MM-dd HH:mm:ss.S"));
        fastHashMap.setFast(true);
        return fastHashMap;
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

