/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.locale.converters;

import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.locale.converters.DecimalLocaleConverter;

public class ByteLocaleConverter
extends DecimalLocaleConverter {
    public ByteLocaleConverter() {
        this(false);
    }

    public ByteLocaleConverter(boolean bl2) {
        this(Locale.getDefault(), bl2);
    }

    public ByteLocaleConverter(Locale locale) {
        this(locale, false);
    }

    public ByteLocaleConverter(Locale locale, boolean bl2) {
        this(locale, (String)null, bl2);
    }

    public ByteLocaleConverter(Locale locale, String string) {
        this(locale, string, false);
    }

    public ByteLocaleConverter(Locale locale, String string, boolean bl2) {
        super(locale, string, bl2);
    }

    public ByteLocaleConverter(Object object) {
        this(object, false);
    }

    public ByteLocaleConverter(Object object, boolean bl2) {
        this(object, Locale.getDefault(), bl2);
    }

    public ByteLocaleConverter(Object object, Locale locale) {
        this(object, locale, false);
    }

    public ByteLocaleConverter(Object object, Locale locale, boolean bl2) {
        this(object, locale, null, bl2);
    }

    public ByteLocaleConverter(Object object, Locale locale, String string) {
        this(object, locale, string, false);
    }

    public ByteLocaleConverter(Object object, Locale locale, String string, boolean bl2) {
        super(object, locale, string);
    }

    public Object parse(Object object, String string) throws ParseException {
        Number number = (Number)super.parse(object, string);
        if (number.longValue() != (long)number.byteValue()) {
            throw new ConversionException("Supplied number is not of type Byte: " + number.longValue());
        }
        return new Byte(number.byteValue());
    }
}

