/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.AbstractCollection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUnderflowException;
import org.apache.commons.collections.PriorityQueue;

public final class BinaryHeap
extends AbstractCollection
implements PriorityQueue,
Buffer {
    private static final int DEFAULT_CAPACITY = 13;
    public int d;
    public Object[] c;
    public boolean b;
    public Comparator a;

    public BinaryHeap() {
        this(13, true);
    }

    public BinaryHeap(int n2) {
        this(n2, true);
    }

    public BinaryHeap(int n2, Comparator comparator) {
        this(n2);
        this.a = comparator;
    }

    public BinaryHeap(int n2, boolean bl2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("invalid capacity");
        }
        this.b = bl2;
        this.c = new Object[n2 + 1];
    }

    public BinaryHeap(int n2, boolean bl2, Comparator comparator) {
        this(n2, bl2);
        this.a = comparator;
    }

    public BinaryHeap(Comparator comparator) {
        this();
        this.a = comparator;
    }

    public BinaryHeap(boolean bl2) {
        this(13, bl2);
    }

    public BinaryHeap(boolean bl2, Comparator comparator) {
        this(bl2);
        this.a = comparator;
    }

    public boolean add(Object object) {
        this.insert(object);
        return true;
    }

    public void clear() {
        this.c = new Object[this.c.length];
        this.d = 0;
    }

    private int compare(Object object, Object object2) {
        if (this.a != null) {
            return this.a.compare(object, object2);
        }
        return ((Comparable)object).compareTo(object2);
    }

    public Object get() {
        try {
            return this.peek();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new BufferUnderflowException();
        }
    }

    public void grow() {
        Object[] objectArray = new Object[this.c.length * 2];
        System.arraycopy(this.c, 0, objectArray, 0, this.c.length);
        this.c = objectArray;
    }

    public void insert(Object object) {
        if (this.isFull()) {
            this.grow();
        }
        if (this.b) {
            this.percolateUpMinHeap(object);
        } else {
            this.percolateUpMaxHeap(object);
        }
    }

    public boolean isEmpty() {
        return this.d == 0;
    }

    public boolean isFull() {
        return this.c.length == this.d + 1;
    }

    public Iterator iterator() {
        return new Iterator(this){
            private final BinaryHeap this$0;
            private int index;
            private int lastReturnedIndex;
            {
                this.this$0 = binaryHeap;
                this.index = 1;
                this.lastReturnedIndex = -1;
            }

            public boolean hasNext() {
                return this.index <= this.this$0.d;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.lastReturnedIndex = this.index++;
                return this.this$0.c[this.lastReturnedIndex];
            }

            public void remove() {
                if (this.lastReturnedIndex == -1) {
                    throw new IllegalStateException();
                }
                this.this$0.c[this.lastReturnedIndex] = this.this$0.c[this.this$0.d];
                this.this$0.c[this.this$0.d] = null;
                --this.this$0.d;
                if (this.this$0.d != 0) {
                    if (this.this$0.b) {
                        this.this$0.percolateDownMinHeap(this.lastReturnedIndex);
                    } else {
                        this.this$0.percolateDownMaxHeap(this.lastReturnedIndex);
                    }
                }
                --this.index;
                this.lastReturnedIndex = -1;
            }
        };
    }

    public Object peek() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.c[1];
    }

    public void percolateDownMaxHeap(int n2) {
        Object object = this.c[n2];
        int n3 = n2;
        while (n3 * 2 <= this.d) {
            int n4 = n3 * 2;
            if (n4 != this.d && this.compare(this.c[n4 + 1], this.c[n4]) > 0) {
                ++n4;
            }
            if (this.compare(this.c[n4], object) <= 0) break;
            this.c[n3] = this.c[n4];
            n3 = n4;
        }
        this.c[n3] = object;
    }

    public void percolateDownMinHeap(int n2) {
        Object object = this.c[n2];
        int n3 = n2;
        while (n3 * 2 <= this.d) {
            int n4 = n3 * 2;
            if (n4 != this.d && this.compare(this.c[n4 + 1], this.c[n4]) < 0) {
                ++n4;
            }
            if (this.compare(this.c[n4], object) >= 0) break;
            this.c[n3] = this.c[n4];
            n3 = n4;
        }
        this.c[n3] = object;
    }

    public void percolateUpMaxHeap(Object object) {
        int n2 = ++this.d;
        while (n2 > 1 && this.compare(object, this.c[n2 / 2]) > 0) {
            int n3 = n2 / 2;
            this.c[n2] = this.c[n3];
            n2 = n3;
        }
        this.c[n2] = object;
    }

    public void percolateUpMinHeap(Object object) {
        int n2 = ++this.d;
        this.c[n2] = object;
        while (n2 > 1 && this.compare(object, this.c[n2 / 2]) < 0) {
            int n3 = n2 / 2;
            this.c[n2] = this.c[n3];
            n2 = n3;
        }
        this.c[n2] = object;
    }

    public Object pop() throws NoSuchElementException {
        Object object = this.peek();
        this.c[1] = this.c[this.d--];
        this.c[this.d + 1] = null;
        if (this.d != 0) {
            if (this.b) {
                this.percolateDownMinHeap(1);
            } else {
                this.percolateDownMaxHeap(1);
            }
        }
        return object;
    }

    public Object remove() {
        try {
            return this.pop();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new BufferUnderflowException();
        }
    }

    public int size() {
        return this.d;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ");
        int n2 = 1;
        while (n2 < this.d + 1) {
            if (n2 != 1) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.c[n2]);
            ++n2;
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }
}

