/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections.CursorableLinkedList;

public class CursorableSubList
extends CursorableLinkedList
implements List {
    public CursorableLinkedList _list = null;
    public CursorableLinkedList.Listable _pre = null;
    public CursorableLinkedList.Listable _post = null;

    public CursorableSubList(CursorableLinkedList cursorableLinkedList, int n2, int n3) {
        if (n2 < 0 || cursorableLinkedList.size() < n3) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 > n3) {
            throw new IllegalArgumentException();
        }
        this._list = cursorableLinkedList;
        if (n2 < cursorableLinkedList.size()) {
            this._head.b(this._list.getListableAt(n2));
            this._pre = this._head.c() == null ? null : this._head.c().b();
        } else {
            this._pre = this._list.getListableAt(n2 - 1);
        }
        if (n2 == n3) {
            this._head.b(null);
            this._head.a(null);
            this._post = n3 < cursorableLinkedList.size() ? this._list.getListableAt(n3) : null;
        } else {
            this._head.a(this._list.getListableAt(n3 - 1));
            this._post = this._head.b().c();
        }
        this._size = n3 - n2;
        this._modCount = this._list._modCount;
    }

    public void add(int n2, Object object) {
        this.checkForComod();
        super.add(n2, object);
    }

    public boolean add(Object object) {
        this.checkForComod();
        return super.add(object);
    }

    public boolean addAll(int n2, Collection collection) {
        this.checkForComod();
        return super.addAll(n2, collection);
    }

    public boolean addAll(Collection collection) {
        this.checkForComod();
        return super.addAll(collection);
    }

    public boolean addFirst(Object object) {
        this.checkForComod();
        return super.addFirst(object);
    }

    public boolean addLast(Object object) {
        this.checkForComod();
        return super.addLast(object);
    }

    public void checkForComod() throws ConcurrentModificationException {
        if (this._modCount != this._list._modCount) {
            throw new ConcurrentModificationException();
        }
    }

    public void clear() {
        this.checkForComod();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public boolean contains(Object object) {
        this.checkForComod();
        return super.contains(object);
    }

    public boolean containsAll(Collection collection) {
        this.checkForComod();
        return super.containsAll(collection);
    }

    public boolean equals(Object object) {
        this.checkForComod();
        return super.equals(object);
    }

    public Object get(int n2) {
        this.checkForComod();
        return super.get(n2);
    }

    public Object getFirst() {
        this.checkForComod();
        return super.getFirst();
    }

    public Object getLast() {
        this.checkForComod();
        return super.getLast();
    }

    public int hashCode() {
        this.checkForComod();
        return super.hashCode();
    }

    public int indexOf(Object object) {
        this.checkForComod();
        return super.indexOf(object);
    }

    public CursorableLinkedList.Listable insertListable(CursorableLinkedList.Listable listable, CursorableLinkedList.Listable listable2, Object object) {
        ++this._modCount;
        ++this._size;
        CursorableLinkedList.Listable listable3 = this._list.insertListable(listable == null ? this._pre : listable, listable2 == null ? this._post : listable2, object);
        if (this._head.c() == null) {
            this._head.b(listable3);
            this._head.a(listable3);
        }
        if (listable == this._head.b()) {
            this._head.a(listable3);
        }
        if (listable2 == this._head.c()) {
            this._head.b(listable3);
        }
        this.broadcastListableInserted(listable3);
        return listable3;
    }

    public boolean isEmpty() {
        this.checkForComod();
        return super.isEmpty();
    }

    public Iterator iterator() {
        this.checkForComod();
        return super.iterator();
    }

    public int lastIndexOf(Object object) {
        this.checkForComod();
        return super.lastIndexOf(object);
    }

    public ListIterator listIterator() {
        this.checkForComod();
        return super.listIterator();
    }

    public ListIterator listIterator(int n2) {
        this.checkForComod();
        return super.listIterator(n2);
    }

    public Object remove(int n2) {
        this.checkForComod();
        return super.remove(n2);
    }

    public boolean remove(Object object) {
        this.checkForComod();
        return super.remove(object);
    }

    public boolean removeAll(Collection collection) {
        this.checkForComod();
        return super.removeAll(collection);
    }

    public Object removeFirst() {
        this.checkForComod();
        return super.removeFirst();
    }

    public Object removeLast() {
        this.checkForComod();
        return super.removeLast();
    }

    public void removeListable(CursorableLinkedList.Listable listable) {
        ++this._modCount;
        --this._size;
        if (this._head.c() == listable && this._head.b() == listable) {
            this._head.b(null);
            this._head.a(null);
        }
        if (this._head.c() == listable) {
            this._head.b(listable.c());
        }
        if (this._head.b() == listable) {
            this._head.a(listable.b());
        }
        this._list.removeListable(listable);
        this.broadcastListableRemoved(listable);
    }

    public boolean retainAll(Collection collection) {
        this.checkForComod();
        return super.retainAll(collection);
    }

    public Object set(int n2, Object object) {
        this.checkForComod();
        return super.set(n2, object);
    }

    public int size() {
        this.checkForComod();
        return super.size();
    }

    public List subList(int n2, int n3) {
        this.checkForComod();
        return super.subList(n2, n3);
    }

    public Object[] toArray() {
        this.checkForComod();
        return super.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        this.checkForComod();
        return super.toArray(objectArray);
    }
}

