/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class ExtendedProperties
extends Hashtable {
    private ExtendedProperties defaults;
    public String file;
    public String basePath;
    public String fileSeparator = System.getProperty("file.separator");
    public boolean isInitialized = false;
    public static String include = "include";
    public ArrayList keysAsListed = new ArrayList();
    public static final String START_TOKEN = "${";
    public static final String END_TOKEN = "}";

    public ExtendedProperties() {
    }

    public ExtendedProperties(String string) throws IOException {
        this(string, null);
    }

    public ExtendedProperties(String string, String string2) throws IOException {
        this.file = string;
        this.basePath = new File(string).getAbsolutePath();
        this.basePath = this.basePath.substring(0, this.basePath.lastIndexOf(this.fileSeparator) + 1);
        this.load(new FileInputStream(string));
        if (string2 != null) {
            this.defaults = new ExtendedProperties(string2);
        }
    }

    public void addProperty(String string, Object object) {
        Object v2 = this.get(string);
        if (v2 instanceof String) {
            Vector<Object> vector = new Vector<Object>(2);
            vector.addElement(v2);
            vector.addElement(object);
            this.put(string, vector);
        } else if (v2 instanceof Vector) {
            ((Vector)v2).addElement(object);
        } else if (object instanceof String && ((String)object).indexOf(",") > 0) {
            PropertiesTokenizer propertiesTokenizer = new PropertiesTokenizer(this, (String)object);
            while (propertiesTokenizer.hasMoreTokens()) {
                String string2 = propertiesTokenizer.nextToken();
                this.addStringProperty(string, string2);
            }
        } else {
            this.addPropertyDirect(string, object);
        }
    }

    private void addPropertyDirect(String string, Object object) {
        if (!this.containsKey(string)) {
            this.keysAsListed.add(string);
        }
        this.put(string, object);
    }

    private void addStringProperty(String string, String string2) {
        Object v2 = this.get(string);
        if (v2 instanceof String) {
            Vector<Object> vector = new Vector<Object>(2);
            vector.addElement(v2);
            vector.addElement(string2);
            this.put(string, vector);
        } else if (v2 instanceof Vector) {
            ((Vector)v2).addElement(string2);
        } else {
            this.addPropertyDirect(string, string2);
        }
    }

    public void clearProperty(String string) {
        if (this.containsKey(string)) {
            int n2 = 0;
            while (n2 < this.keysAsListed.size()) {
                if (((String)this.keysAsListed.get(n2)).equals(string)) {
                    this.keysAsListed.remove(n2);
                    break;
                }
                ++n2;
            }
            this.remove(string);
        }
    }

    public void combine(ExtendedProperties extendedProperties) {
        Iterator iterator = extendedProperties.getKeys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.setProperty(string, extendedProperties.get(string));
        }
    }

    public static ExtendedProperties convertProperties(Properties properties) {
        ExtendedProperties extendedProperties = new ExtendedProperties();
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            extendedProperties.setProperty(string, properties.getProperty(string));
        }
        return extendedProperties;
    }

    public void display() {
        Iterator iterator = this.getKeys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v2 = this.get(string);
            System.out.println(String.valueOf(string) + " => " + v2);
        }
    }

    public boolean getBoolean(String string) {
        Boolean bl2 = this.getBoolean(string, null);
        if (bl2 != null) {
            return bl2;
        }
        throw new NoSuchElementException(String.valueOf('\'') + string + "' doesn't map to an existing object");
    }

    public Boolean getBoolean(String string, Boolean bl2) {
        Object v2 = this.get(string);
        if (v2 instanceof Boolean) {
            return (Boolean)v2;
        }
        if (v2 instanceof String) {
            String string2 = this.testBoolean((String)v2);
            Boolean bl3 = new Boolean(string2);
            this.put(string, bl3);
            return bl3;
        }
        if (v2 == null) {
            if (this.defaults != null) {
                return this.defaults.getBoolean(string, bl2);
            }
            return bl2;
        }
        throw new ClassCastException(String.valueOf('\'') + string + "' doesn't map to a Boolean object");
    }

    public boolean getBoolean(String string, boolean bl2) {
        return this.getBoolean(string, new Boolean(bl2));
    }

    public byte getByte(String string) {
        Byte by2 = this.getByte(string, null);
        if (by2 != null) {
            return by2;
        }
        throw new NoSuchElementException(String.valueOf('\'') + string + " doesn't map to an existing object");
    }

    public byte getByte(String string, byte by2) {
        return this.getByte(string, new Byte(by2));
    }

    public Byte getByte(String string, Byte by2) {
        Object v2 = this.get(string);
        if (v2 instanceof Byte) {
            return (Byte)v2;
        }
        if (v2 instanceof String) {
            Byte by3 = new Byte((String)v2);
            this.put(string, by3);
            return by3;
        }
        if (v2 == null) {
            if (this.defaults != null) {
                return this.defaults.getByte(string, by2);
            }
            return by2;
        }
        throw new ClassCastException(String.valueOf('\'') + string + "' doesn't map to a Byte object");
    }

    public double getDouble(String string) {
        Double d2 = this.getDouble(string, null);
        if (d2 != null) {
            return d2;
        }
        throw new NoSuchElementException(String.valueOf('\'') + string + "' doesn't map to an existing object");
    }

    public double getDouble(String string, double d2) {
        return this.getDouble(string, new Double(d2));
    }

    public Double getDouble(String string, Double d2) {
        Object v2 = this.get(string);
        if (v2 instanceof Double) {
            return (Double)v2;
        }
        if (v2 instanceof String) {
            Double d3 = new Double((String)v2);
            this.put(string, d3);
            return d3;
        }
        if (v2 == null) {
            if (this.defaults != null) {
                return this.defaults.getDouble(string, d2);
            }
            return d2;
        }
        throw new ClassCastException(String.valueOf('\'') + string + "' doesn't map to a Double object");
    }

    public float getFloat(String string) {
        Float f2 = this.getFloat(string, null);
        if (f2 != null) {
            return f2.floatValue();
        }
        throw new NoSuchElementException(String.valueOf('\'') + string + "' doesn't map to an existing object");
    }

    public float getFloat(String string, float f2) {
        return this.getFloat(string, new Float(f2)).floatValue();
    }

    public Float getFloat(String string, Float f2) {
        Object v2 = this.get(string);
        if (v2 instanceof Float) {
            return (Float)v2;
        }
        if (v2 instanceof String) {
            Float f3 = new Float((String)v2);
            this.put(string, f3);
            return f3;
        }
        if (v2 == null) {
            if (this.defaults != null) {
                return this.defaults.getFloat(string, f2);
            }
            return f2;
        }
        throw new ClassCastException(String.valueOf('\'') + string + "' doesn't map to a Float object");
    }

    public String getInclude() {
        return include;
    }

    public int getInt(String string) {
        return this.getInteger(string);
    }

    public int getInt(String string, int n2) {
        return this.getInteger(string, n2);
    }

    public int getInteger(String string) {
        Integer n2 = this.getInteger(string, null);
        if (n2 != null) {
            return n2;
        }
        throw new NoSuchElementException(String.valueOf('\'') + string + "' doesn't map to an existing object");
    }

    public int getInteger(String string, int n2) {
        Integer n3 = this.getInteger(string, null);
        if (n3 == null) {
            return n2;
        }
        return n3;
    }

    public Integer getInteger(String string, Integer n2) {
        Object v2 = this.get(string);
        if (v2 instanceof Integer) {
            return (Integer)v2;
        }
        if (v2 instanceof String) {
            Integer n3 = new Integer((String)v2);
            this.put(string, n3);
            return n3;
        }
        if (v2 == null) {
            if (this.defaults != null) {
                return this.defaults.getInteger(string, n2);
            }
            return n2;
        }
        throw new ClassCastException(String.valueOf('\'') + string + "' doesn't map to a Integer object");
    }

    public Iterator getKeys() {
        return ((AbstractList)this.keysAsListed).iterator();
    }

    public Iterator getKeys(String string) {
        Iterator iterator = this.getKeys();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof String) || !((String)e2).startsWith(string)) continue;
            arrayList.add(e2);
        }
        return ((AbstractList)arrayList).iterator();
    }

    public long getLong(String string) {
        Long l2 = this.getLong(string, null);
        if (l2 != null) {
            return l2;
        }
        throw new NoSuchElementException(String.valueOf('\'') + string + "' doesn't map to an existing object");
    }

    public long getLong(String string, long l2) {
        return this.getLong(string, new Long(l2));
    }

    public Long getLong(String string, Long l2) {
        Object v2 = this.get(string);
        if (v2 instanceof Long) {
            return (Long)v2;
        }
        if (v2 instanceof String) {
            Long l3 = new Long((String)v2);
            this.put(string, l3);
            return l3;
        }
        if (v2 == null) {
            if (this.defaults != null) {
                return this.defaults.getLong(string, l2);
            }
            return l2;
        }
        throw new ClassCastException(String.valueOf('\'') + string + "' doesn't map to a Long object");
    }

    public Properties getProperties(String string) {
        return this.getProperties(string, new Properties());
    }

    public Properties getProperties(String string, Properties properties) {
        String[] stringArray = this.getStringArray(string);
        Properties properties2 = new Properties(properties);
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string2 = stringArray[n2];
            int n3 = string2.indexOf(61);
            if (n3 <= 0) {
                throw new IllegalArgumentException(String.valueOf('\'') + string2 + "' does not contain " + "an equals sign");
            }
            String string3 = string2.substring(0, n3).trim();
            String string4 = string2.substring(n3 + 1).trim();
            ((Hashtable)properties2).put(string3, string4);
            ++n2;
        }
        return properties2;
    }

    public Object getProperty(String string) {
        Object v2 = this.get(string);
        if (v2 == null && this.defaults != null) {
            v2 = this.defaults.get(string);
        }
        return v2;
    }

    public short getShort(String string) {
        Short s2 = this.getShort(string, null);
        if (s2 != null) {
            return s2;
        }
        throw new NoSuchElementException(String.valueOf('\'') + string + "' doesn't map to an existing object");
    }

    public Short getShort(String string, Short s2) {
        Object v2 = this.get(string);
        if (v2 instanceof Short) {
            return (Short)v2;
        }
        if (v2 instanceof String) {
            Short s3 = new Short((String)v2);
            this.put(string, s3);
            return s3;
        }
        if (v2 == null) {
            if (this.defaults != null) {
                return this.defaults.getShort(string, s2);
            }
            return s2;
        }
        throw new ClassCastException(String.valueOf('\'') + string + "' doesn't map to a Short object");
    }

    public short getShort(String string, short s2) {
        return this.getShort(string, new Short(s2));
    }

    public String getString(String string) {
        return this.getString(string, null);
    }

    public String getString(String string, String string2) {
        Object v2 = this.get(string);
        if (v2 instanceof String) {
            return this.interpolate((String)v2);
        }
        if (v2 == null) {
            if (this.defaults != null) {
                return this.interpolate(this.defaults.getString(string, string2));
            }
            return this.interpolate(string2);
        }
        if (v2 instanceof Vector) {
            return this.interpolate((String)((Vector)v2).get(0));
        }
        throw new ClassCastException(String.valueOf('\'') + string + "' doesn't map to a String object");
    }

    public String[] getStringArray(String string) {
        Vector vector;
        Object v2 = this.get(string);
        if (v2 instanceof String) {
            vector = new Vector(1);
            vector.addElement(v2);
        } else if (v2 instanceof Vector) {
            vector = (Vector)v2;
        } else {
            if (v2 == null) {
                if (this.defaults != null) {
                    return this.defaults.getStringArray(string);
                }
                return new String[0];
            }
            throw new ClassCastException(String.valueOf('\'') + string + "' doesn't map to a String/Vector object");
        }
        String[] stringArray = new String[vector.size()];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    public Vector getVector(String string) {
        return this.getVector(string, null);
    }

    public Vector getVector(String string, Vector vector) {
        Object v2 = this.get(string);
        if (v2 instanceof Vector) {
            return (Vector)v2;
        }
        if (v2 instanceof String) {
            Vector<String> vector2 = new Vector<String>(1);
            vector2.addElement((String)v2);
            this.put(string, vector2);
            return vector2;
        }
        if (v2 == null) {
            if (this.defaults != null) {
                return this.defaults.getVector(string, vector);
            }
            return vector == null ? new Vector() : vector;
        }
        throw new ClassCastException(String.valueOf('\'') + string + "' doesn't map to a Vector object");
    }

    private void init(ExtendedProperties extendedProperties) throws IOException {
        this.isInitialized = true;
    }

    public String interpolate(String string) {
        if (string == null) {
            return null;
        }
        int n2 = -1;
        int n3 = -1;
        int n4 = -END_TOKEN.length();
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = string.indexOf(START_TOKEN, n4 + END_TOKEN.length())) > -1 && (n3 = string.indexOf(END_TOKEN, n2)) > -1) {
            stringBuffer.append(string.substring(n4 + END_TOKEN.length(), n2));
            string2 = string.substring(n2 + START_TOKEN.length(), n3);
            if (this.get(string2) != null) {
                stringBuffer.append(this.get(string2));
            }
            n4 = n3;
        }
        stringBuffer.append(string.substring(n4 + END_TOKEN.length(), string.length()));
        return stringBuffer.toString();
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void load(InputStream inputStream) throws IOException {
        this.load(inputStream, null);
    }

    public synchronized void load(InputStream inputStream, String string) throws IOException {
        PropertiesReader propertiesReader = null;
        if (string != null) {
            try {
                propertiesReader = new PropertiesReader(this, new InputStreamReader(inputStream, string));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        if (propertiesReader == null) {
            propertiesReader = new PropertiesReader(this, new InputStreamReader(inputStream));
        }
        try {
            while (true) {
                String string2;
                int n2;
                if ((n2 = (string2 = propertiesReader.readProperty()).indexOf(61)) <= 0) {
                    continue;
                }
                String string3 = string2.substring(0, n2).trim();
                String string4 = string2.substring(n2 + 1).trim();
                if ("".equals(string4)) continue;
                if (this.getInclude() != null && string3.equalsIgnoreCase(this.getInclude())) {
                    File file = null;
                    if (string4.startsWith(this.fileSeparator)) {
                        file = new File(string4);
                    } else {
                        if (string4.startsWith("." + this.fileSeparator)) {
                            string4 = string4.substring(2);
                        }
                        file = new File(String.valueOf(this.basePath) + string4);
                    }
                    if (file == null || !file.exists() || !file.canRead()) continue;
                    this.load(new FileInputStream(file));
                    continue;
                }
                this.addProperty(string3, string4);
            }
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
    }

    public synchronized void save(OutputStream outputStream, String string) throws IOException {
        if (outputStream != null) {
            PrintWriter printWriter = new PrintWriter(outputStream);
            if (string != null) {
                printWriter.println(string);
            }
            Enumeration enumeration = this.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Object v2 = this.get(string2);
                if (v2 != null) {
                    Serializable serializable;
                    if (v2 instanceof String) {
                        serializable = new StringBuffer();
                        ((StringBuffer)serializable).append(string2);
                        ((StringBuffer)serializable).append("=");
                        ((StringBuffer)serializable).append((String)v2);
                        printWriter.println(((StringBuffer)serializable).toString());
                    } else if (v2 instanceof Vector) {
                        serializable = (Vector)v2;
                        Enumeration enumeration2 = ((Vector)serializable).elements();
                        while (enumeration2.hasMoreElements()) {
                            String string3 = (String)enumeration2.nextElement();
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(string2);
                            stringBuffer.append("=");
                            stringBuffer.append(string3);
                            printWriter.println(stringBuffer.toString());
                        }
                    }
                }
                printWriter.println();
                printWriter.flush();
            }
        }
    }

    public void setInclude(String string) {
        include = string;
    }

    public void setProperty(String string, Object object) {
        this.clearProperty(string);
        this.addProperty(string, object);
    }

    public ExtendedProperties subset(String string) {
        ExtendedProperties extendedProperties = new ExtendedProperties();
        Iterator iterator = this.getKeys();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof String) || !((String)e2).startsWith(string)) continue;
            if (!bl2) {
                bl2 = true;
            }
            String string2 = null;
            string2 = ((String)e2).length() == string.length() ? string : ((String)e2).substring(string.length() + 1);
            extendedProperties.addPropertyDirect(string2, this.get(e2));
        }
        if (bl2) {
            return extendedProperties;
        }
        return null;
    }

    public String testBoolean(String string) {
        String string2 = string.toLowerCase();
        if (string2.equals("true") || string2.equals("on") || string2.equals("yes")) {
            return "true";
        }
        if (string2.equals("false") || string2.equals("off") || string2.equals("no")) {
            return "false";
        }
        return null;
    }

    public class PropertiesReader
    extends LineNumberReader {
        private final ExtendedProperties this$0;

        public PropertiesReader(ExtendedProperties extendedProperties, Reader reader) {
            super(reader);
            this.this$0 = extendedProperties;
        }

        public String readProperty() throws IOException {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                String string;
                while (true) {
                    if ((string = this.readLine().trim()).length() == 0 || string.charAt(0) == '#') {
                        continue;
                    }
                    if (!string.endsWith("\\")) break;
                    string = string.substring(0, string.length() - 1);
                    stringBuffer.append(string);
                }
                stringBuffer.append(string);
            }
            catch (NullPointerException nullPointerException) {
                return null;
            }
            return stringBuffer.toString();
        }
    }

    public class PropertiesTokenizer
    extends StringTokenizer {
        private final ExtendedProperties this$0;

        public PropertiesTokenizer(ExtendedProperties extendedProperties, String string) {
            super(string, ",");
            this.this$0 = extendedProperties;
        }

        public boolean hasMoreTokens() {
            return super.hasMoreTokens();
        }

        public String nextToken() {
            StringBuffer stringBuffer = new StringBuffer();
            while (this.hasMoreTokens()) {
                String string = super.nextToken();
                if (string.endsWith("\\")) {
                    stringBuffer.append(string.substring(0, string.length() - 1));
                    stringBuffer.append(",");
                    continue;
                }
                stringBuffer.append(string);
                break;
            }
            return stringBuffer.toString().trim();
        }
    }
}

