/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import org.apache.commons.collections.SequencedHashMap;

public class LRUMap
extends SequencedHashMap
implements Externalizable {
    private int maximumSize = 0;
    private static final long serialVersionUID = 2197433140769957051L;

    public LRUMap() {
        this(100);
    }

    public LRUMap(int n2) {
        super(n2);
        this.maximumSize = n2;
    }

    public Object get(Object object) {
        if (!this.containsKey(object)) {
            return null;
        }
        Object object2 = this.remove(object);
        super.put(object, object2);
        return object2;
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public void processRemovedLRU(Object object, Object object2) {
    }

    public Object put(Object object, Object object2) {
        int n2 = this.size();
        Object object3 = null;
        if (n2 >= this.maximumSize && !this.containsKey(object)) {
            this.removeLRU();
        }
        object3 = super.put(object, object2);
        return object3;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.maximumSize = objectInput.readInt();
        int n2 = objectInput.readInt();
        int n3 = 0;
        while (n3 < n2) {
            Object object = objectInput.readObject();
            Object object2 = objectInput.readObject();
            this.put(object, object2);
            ++n3;
        }
    }

    public void removeLRU() {
        Object object = this.getFirstKey();
        Object object2 = super.get(object);
        this.remove(object);
        this.processRemovedLRU(object, object2);
    }

    public void setMaximumSize(int n2) {
        this.maximumSize = n2;
        while (this.size() > n2) {
            this.removeLRU();
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.maximumSize);
        objectOutput.writeInt(this.size());
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            objectOutput.writeObject(e2);
            Object object = super.get(e2);
            objectOutput.writeObject(object);
        }
    }
}

