/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections.DefaultMapEntry;

public class ReferenceMap
extends AbstractMap {
    private static final long serialVersionUID = -3370601314380922368L;
    public static final int HARD = 0;
    public static final int SOFT = 1;
    public static final int WEAK = 2;
    private int keyType;
    private int valueType;
    private float loadFactor;
    private transient ReferenceQueue queue = new ReferenceQueue();
    private transient Entry[] table;
    private transient int size;
    private transient int threshold;
    private volatile transient int modCount;
    private transient Set keySet;
    private transient Set entrySet;
    private transient Collection values;

    public ReferenceMap() {
        this(0, 1);
    }

    public ReferenceMap(int n2, int n3) {
        this(n2, n3, 16, 0.75f);
    }

    public ReferenceMap(int n2, int n3, int n4, float f2) {
        ReferenceMap.verify("keyType", n2);
        ReferenceMap.verify("valueType", n3);
        if (n4 <= 0) {
            throw new IllegalArgumentException("capacity must be positive");
        }
        if (f2 <= 0.0f || f2 >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and less than 1.");
        }
        this.keyType = n2;
        this.valueType = n3;
        int n5 = 1;
        while (n5 < n4) {
            n5 *= 2;
        }
        this.table = new Entry[n5];
        this.loadFactor = f2;
        this.threshold = (int)((float)n5 * f2);
    }

    public static Entry a(ReferenceMap referenceMap, Object object) {
        return referenceMap.getEntry(object);
    }

    public static int d(ReferenceMap referenceMap) {
        return referenceMap.size;
    }

    public static int b(ReferenceMap referenceMap) {
        return referenceMap.keyType;
    }

    public static int e(ReferenceMap referenceMap) {
        return referenceMap.valueType;
    }

    public static Object a(ReferenceMap referenceMap, int n2, Object object, int n3) {
        return referenceMap.toReference(n2, object, n3);
    }

    public static Entry[] c(ReferenceMap referenceMap) {
        return referenceMap.table;
    }

    public static int a(ReferenceMap referenceMap) {
        return referenceMap.modCount;
    }

    public void clear() {
        Arrays.fill(this.table, null);
        this.size = 0;
        while (this.queue.poll() != null) {
        }
    }

    public boolean containsKey(Object object) {
        this.purge();
        Entry entry = this.getEntry(object);
        if (entry == null) {
            return false;
        }
        return entry.getValue() != null;
    }

    public Set entrySet() {
        if (this.entrySet != null) {
            return this.entrySet;
        }
        this.entrySet = new AbstractSet(this){
            private final ReferenceMap this$0;
            {
                this.this$0 = referenceMap;
            }

            public void clear() {
                this.this$0.clear();
            }

            public boolean contains(Object object) {
                if (object == null) {
                    return false;
                }
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Entry entry2 = ReferenceMap.a(this.this$0, entry.getKey());
                return entry2 != null && entry.equals(entry2);
            }

            public Iterator iterator() {
                return new EntryIterator(this.this$0);
            }

            public boolean remove(Object object) {
                boolean bl2 = this.contains(object);
                if (bl2) {
                    Map.Entry entry = (Map.Entry)object;
                    this.this$0.remove(entry.getKey());
                }
                return bl2;
            }

            public int size() {
                return this.this$0.size();
            }

            public Object[] toArray() {
                return this.toArray(new Object[0]);
            }

            public Object[] toArray(Object[] objectArray) {
                ArrayList<DefaultMapEntry> arrayList = new ArrayList<DefaultMapEntry>();
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    Entry entry = (Entry)iterator.next();
                    arrayList.add(new DefaultMapEntry(entry.getKey(), entry.getValue()));
                }
                return arrayList.toArray(objectArray);
            }
        };
        return this.entrySet;
    }

    public Object get(Object object) {
        this.purge();
        Entry entry = this.getEntry(object);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    private Entry getEntry(Object object) {
        if (object == null) {
            return null;
        }
        int n2 = object.hashCode();
        int n3 = this.indexFor(n2);
        Entry entry = this.table[n3];
        while (entry != null) {
            if (entry.d == n2 && object.equals(entry.getKey())) {
                return entry;
            }
            entry = entry.c;
        }
        return null;
    }

    private int indexFor(int n2) {
        n2 += ~(n2 << 15);
        n2 ^= n2 >>> 10;
        n2 += n2 << 3;
        n2 ^= n2 >>> 6;
        n2 += ~(n2 << 11);
        n2 ^= n2 >>> 16;
        return n2 & this.table.length - 1;
    }

    public boolean isEmpty() {
        this.purge();
        return this.size == 0;
    }

    public Set keySet() {
        if (this.keySet != null) {
            return this.keySet;
        }
        this.keySet = new AbstractSet(this){
            private final ReferenceMap this$0;
            {
                this.this$0 = referenceMap;
            }

            public void clear() {
                this.this$0.clear();
            }

            public boolean contains(Object object) {
                return this.this$0.containsKey(object);
            }

            public Iterator iterator() {
                return new KeyIterator(this.this$0);
            }

            public boolean remove(Object object) {
                Object object2 = this.this$0.remove(object);
                return object2 != null;
            }

            public int size() {
                return ReferenceMap.d(this.this$0);
            }
        };
        return this.keySet;
    }

    private void purge() {
        Reference reference = this.queue.poll();
        while (reference != null) {
            this.purge(reference);
            reference = this.queue.poll();
        }
    }

    private void purge(Reference reference) {
        int n2 = reference.hashCode();
        int n3 = this.indexFor(n2);
        Entry entry = null;
        Entry entry2 = this.table[n3];
        while (entry2 != null) {
            if (entry2.a(reference)) {
                if (entry == null) {
                    this.table[n3] = entry2.c;
                } else {
                    entry.c = entry2.c;
                }
                --this.size;
                return;
            }
            entry = entry2;
            entry2 = entry2.c;
        }
    }

    public Object put(Object object, Object object2) {
        if (object == null) {
            throw new NullPointerException("null keys not allowed");
        }
        if (object2 == null) {
            throw new NullPointerException("null values not allowed");
        }
        this.purge();
        if (this.size + 1 > this.threshold) {
            this.resize();
        }
        int n2 = object.hashCode();
        int n3 = this.indexFor(n2);
        Entry entry = this.table[n3];
        while (entry != null) {
            if (n2 == entry.d && object.equals(entry.getKey())) {
                Object object3 = entry.getValue();
                entry.setValue(object2);
                return object3;
            }
            entry = entry.c;
        }
        ++this.size;
        ++this.modCount;
        object = this.toReference(this.keyType, object, n2);
        object2 = this.toReference(this.valueType, object2, n2);
        this.table[n3] = new Entry(this, object, n2, object2, this.table[n3]);
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.table = new Entry[objectInputStream.readInt()];
        this.threshold = (int)((float)this.table.length * this.loadFactor);
        this.queue = new ReferenceQueue();
        Object object = objectInputStream.readObject();
        while (object != null) {
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
            object = objectInputStream.readObject();
        }
    }

    public Object remove(Object object) {
        if (object == null) {
            return null;
        }
        this.purge();
        int n2 = object.hashCode();
        int n3 = this.indexFor(n2);
        Entry entry = null;
        Entry entry2 = this.table[n3];
        while (entry2 != null) {
            if (n2 == entry2.d && object.equals(entry2.getKey())) {
                if (entry == null) {
                    this.table[n3] = entry2.c;
                } else {
                    entry.c = entry2.c;
                }
                --this.size;
                ++this.modCount;
                return entry2.getValue();
            }
            entry = entry2;
            entry2 = entry2.c;
        }
        return null;
    }

    private void resize() {
        Entry[] entryArray = this.table;
        this.table = new Entry[entryArray.length * 2];
        int n2 = 0;
        while (n2 < entryArray.length) {
            Entry entry = entryArray[n2];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.c;
                int n3 = this.indexFor(entry2.d);
                entry2.c = this.table[n3];
                this.table[n3] = entry2;
            }
            entryArray[n2] = null;
            ++n2;
        }
        this.threshold = (int)((float)this.table.length * this.loadFactor);
    }

    public int size() {
        this.purge();
        return this.size;
    }

    private Object toReference(int n2, Object object, int n3) {
        switch (n2) {
            case 0: {
                return object;
            }
            case 1: {
                return new SoftRef(n3, object, this.queue);
            }
            case 2: {
                return new WeakRef(n3, object, this.queue);
            }
        }
        throw new Error();
    }

    public Collection values() {
        if (this.values != null) {
            return this.values;
        }
        this.values = new AbstractCollection(this){
            private final ReferenceMap this$0;
            {
                this.this$0 = referenceMap;
            }

            public void clear() {
                this.this$0.clear();
            }

            public Iterator iterator() {
                return new ValueIterator(this.this$0);
            }

            public int size() {
                return ReferenceMap.d(this.this$0);
            }
        };
        return this.values;
    }

    private static void verify(String string, int n2) {
        if (n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException(String.valueOf(string) + " must be HARD, SOFT, WEAK.");
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            objectOutputStream.writeObject(entry.getKey());
            objectOutputStream.writeObject(entry.getValue());
        }
        objectOutputStream.writeObject(null);
    }

    private class Entry
    implements Map.Entry {
        private final ReferenceMap this$0;
        public Object a;
        public Object b;
        public int d;
        public Entry c;

        public Entry(ReferenceMap referenceMap, Object object, int n2, Object object2, Entry entry) {
            this.this$0 = referenceMap;
            this.a = object;
            this.d = n2;
            this.b = object2;
            this.c = entry;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k2 = entry.getKey();
            Object v2 = entry.getValue();
            if (k2 == null || v2 == null) {
                return false;
            }
            return k2.equals(this.getKey()) && v2.equals(this.getValue());
        }

        public Object getKey() {
            return ReferenceMap.b(this.this$0) > 0 ? ((Reference)this.a).get() : this.a;
        }

        public Object getValue() {
            return ReferenceMap.e(this.this$0) > 0 ? ((Reference)this.b).get() : this.b;
        }

        public int hashCode() {
            Object object = this.getValue();
            return this.d ^ (object == null ? 0 : object.hashCode());
        }

        public boolean a(Reference reference) {
            boolean bl2 = ReferenceMap.b(this.this$0) > 0 && this.a == reference;
            boolean bl3 = bl2 = bl2 || ReferenceMap.e(this.this$0) > 0 && this.b == reference;
            if (bl2) {
                if (ReferenceMap.b(this.this$0) > 0) {
                    ((Reference)this.a).clear();
                }
                if (ReferenceMap.e(this.this$0) > 0) {
                    ((Reference)this.b).clear();
                }
            }
            return bl2;
        }

        public Object setValue(Object object) {
            Object object2 = this.getValue();
            if (ReferenceMap.e(this.this$0) > 0) {
                ((Reference)this.b).clear();
            }
            this.b = ReferenceMap.a(this.this$0, ReferenceMap.e(this.this$0), object, this.d);
            return object2;
        }

        public String toString() {
            return String.valueOf(String.valueOf(this.getKey())) + "=" + this.getValue();
        }
    }

    private class EntryIterator
    implements Iterator {
        private final ReferenceMap this$0;
        public int b;
        public Entry f;
        public Entry e;
        public Object a;
        public Object g;
        public Object h;
        public Object d;
        public int c;

        public EntryIterator(ReferenceMap referenceMap) {
            this.this$0 = referenceMap;
            this.b = referenceMap.size() != 0 ? ReferenceMap.c(referenceMap).length : 0;
            this.c = ReferenceMap.a(referenceMap);
        }

        private void checkMod() {
            if (ReferenceMap.a(this.this$0) != this.c) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean hasNext() {
            this.checkMod();
            while (this.nextNull()) {
                Entry entry = this.f;
                int n2 = this.b;
                while (entry == null && n2 > 0) {
                    entry = ReferenceMap.c(this.this$0)[--n2];
                }
                this.f = entry;
                this.b = n2;
                if (entry == null) {
                    this.h = null;
                    this.d = null;
                    return false;
                }
                this.a = entry.getKey();
                this.g = entry.getValue();
                if (!this.nextNull()) continue;
                this.f = this.f.c;
            }
            return true;
        }

        public Object next() {
            return this.nextEntry();
        }

        public Entry nextEntry() {
            this.checkMod();
            if (this.nextNull() && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.e = this.f;
            this.f = this.f.c;
            this.h = this.a;
            this.d = this.g;
            this.a = null;
            this.g = null;
            return this.e;
        }

        private boolean nextNull() {
            return this.a == null || this.g == null;
        }

        public void remove() {
            this.checkMod();
            if (this.e == null) {
                throw new IllegalStateException();
            }
            this.this$0.remove(this.h);
            this.e = null;
            this.h = null;
            this.d = null;
            this.c = ReferenceMap.a(this.this$0);
        }
    }

    private class ValueIterator
    extends EntryIterator {
        private final ReferenceMap this$0;

        public ValueIterator(ReferenceMap referenceMap) {
            super(referenceMap);
            this.this$0 = referenceMap;
        }

        public Object next() {
            return this.nextEntry().getValue();
        }
    }

    private class KeyIterator
    extends EntryIterator {
        private final ReferenceMap this$0;

        public KeyIterator(ReferenceMap referenceMap) {
            super(referenceMap);
            this.this$0 = referenceMap;
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    private static class SoftRef
    extends SoftReference {
        private int hash;

        public SoftRef(int n2, Object object, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
            this.hash = n2;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static class WeakRef
    extends WeakReference {
        private int hash;

        public WeakRef(int n2, Object object, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
            this.hash = n2;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

