/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class SequencedHashMap
implements Map,
Cloneable,
Externalizable {
    private Entry sentinel = SequencedHashMap.createSentinel();
    private HashMap entries;
    private transient long modCount = 0L;
    private static final int KEY = 0;
    private static final int VALUE = 1;
    private static final int ENTRY = 2;
    private static final int REMOVED_MASK = Integer.MIN_VALUE;
    private static final long serialVersionUID = 3380552487888102930L;

    public SequencedHashMap() {
        this.entries = new HashMap();
    }

    public SequencedHashMap(int n2) {
        this.entries = new HashMap(n2);
    }

    public SequencedHashMap(int n2, float f2) {
        this.entries = new HashMap(n2, f2);
    }

    public SequencedHashMap(Map map) {
        this();
        this.putAll(map);
    }

    public static Entry a(SequencedHashMap sequencedHashMap, Object object) {
        return sequencedHashMap.removeImpl(object);
    }

    public static Entry b(SequencedHashMap sequencedHashMap) {
        return sequencedHashMap.sentinel;
    }

    public static HashMap a(SequencedHashMap sequencedHashMap) {
        return sequencedHashMap.entries;
    }

    public static long c(SequencedHashMap sequencedHashMap) {
        return sequencedHashMap.modCount;
    }

    public void clear() {
        ++this.modCount;
        this.entries.clear();
        this.sentinel.b = this.sentinel;
        this.sentinel.a = this.sentinel;
    }

    public Object clone() throws CloneNotSupportedException {
        SequencedHashMap sequencedHashMap = (SequencedHashMap)super.clone();
        sequencedHashMap.sentinel = SequencedHashMap.createSentinel();
        sequencedHashMap.entries = new HashMap();
        sequencedHashMap.putAll((Map)this);
        return sequencedHashMap;
    }

    public boolean containsKey(Object object) {
        return this.entries.containsKey(object);
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            Entry entry = this.sentinel.b;
            while (entry != this.sentinel) {
                if (entry.getValue() == null) {
                    return true;
                }
                entry = entry.b;
            }
        } else {
            Entry entry = this.sentinel.b;
            while (entry != this.sentinel) {
                if (object.equals(entry.getValue())) {
                    return true;
                }
                entry = entry.b;
            }
        }
        return false;
    }

    private static final Entry createSentinel() {
        Entry entry;
        entry.a = entry = new Entry(null, null);
        entry.b = entry;
        return entry;
    }

    public Set entrySet() {
        return new AbstractSet(this){
            private final SequencedHashMap this$0;
            {
                this.this$0 = sequencedHashMap;
            }

            public void clear() {
                this.this$0.clear();
            }

            public boolean contains(Object object) {
                return this.findEntry(object) != null;
            }

            private Entry findEntry(Object object) {
                if (object == null) {
                    return null;
                }
                if (!(object instanceof Map.Entry)) {
                    return null;
                }
                Map.Entry entry = (Map.Entry)object;
                Entry entry2 = (Entry)SequencedHashMap.a(this.this$0).get(entry.getKey());
                if (entry2 != null && entry2.equals(entry)) {
                    return entry2;
                }
                return null;
            }

            public boolean isEmpty() {
                return this.this$0.isEmpty();
            }

            public Iterator iterator() {
                return new OrderedIterator(this.this$0, 2);
            }

            public boolean remove(Object object) {
                Entry entry = this.findEntry(object);
                if (entry == null) {
                    return false;
                }
                return SequencedHashMap.a(this.this$0, entry.getKey()) != null;
            }

            public int size() {
                return this.this$0.size();
            }
        };
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        return this.entrySet().equals(((Map)object).entrySet());
    }

    public Object get(int n2) {
        return this.getEntry(n2).getKey();
    }

    public Object get(Object object) {
        Entry entry = (Entry)this.entries.get(object);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    private Map.Entry getEntry(int n2) {
        Entry entry = this.sentinel;
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n2) + " < 0");
        }
        int n3 = -1;
        while (n3 < n2 - 1 && entry.b != this.sentinel) {
            ++n3;
            entry = entry.b;
        }
        if (entry.b == this.sentinel) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n2) + " >= " + (n3 + 1));
        }
        return entry.b;
    }

    public Map.Entry getFirst() {
        return this.isEmpty() ? null : this.sentinel.b;
    }

    public Object getFirstKey() {
        return this.sentinel.b.getKey();
    }

    public Object getFirstValue() {
        return this.sentinel.b.getValue();
    }

    public Map.Entry getLast() {
        return this.isEmpty() ? null : this.sentinel.a;
    }

    public Object getLastKey() {
        return this.sentinel.a.getKey();
    }

    public Object getLastValue() {
        return this.sentinel.a.getValue();
    }

    public Object getValue(int n2) {
        return this.getEntry(n2).getValue();
    }

    public int hashCode() {
        return this.entrySet().hashCode();
    }

    public int indexOf(Object object) {
        Entry entry = (Entry)this.entries.get(object);
        int n2 = 0;
        while (entry.a != this.sentinel) {
            ++n2;
            entry = entry.a;
        }
        return n2;
    }

    private void insertEntry(Entry entry) {
        entry.b = this.sentinel;
        entry.a = this.sentinel.a;
        this.sentinel.a.b = entry;
        this.sentinel.a = entry;
    }

    public boolean isEmpty() {
        return this.sentinel.b == this.sentinel;
    }

    public Iterator iterator() {
        return this.keySet().iterator();
    }

    public Set keySet() {
        return new AbstractSet(this){
            private final SequencedHashMap this$0;
            {
                this.this$0 = sequencedHashMap;
            }

            public void clear() {
                this.this$0.clear();
            }

            public boolean contains(Object object) {
                return this.this$0.containsKey(object);
            }

            public boolean isEmpty() {
                return this.this$0.isEmpty();
            }

            public Iterator iterator() {
                return new OrderedIterator(this.this$0, 0);
            }

            public boolean remove(Object object) {
                Entry entry = SequencedHashMap.a(this.this$0, object);
                return entry != null;
            }

            public int size() {
                return this.this$0.size();
            }
        };
    }

    public int lastIndexOf(Object object) {
        return this.indexOf(object);
    }

    public Object put(Object object, Object object2) {
        ++this.modCount;
        Object object3 = null;
        Entry entry = (Entry)this.entries.get(object);
        if (entry != null) {
            this.removeEntry(entry);
            object3 = entry.setValue(object2);
        } else {
            entry = new Entry(object, object2);
            this.entries.put(object, entry);
        }
        this.insertEntry(entry);
        return object3;
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n2 = objectInput.readInt();
        int n3 = 0;
        while (n3 < n2) {
            Object object = objectInput.readObject();
            Object object2 = objectInput.readObject();
            this.put(object, object2);
            ++n3;
        }
    }

    public Object remove(int n2) {
        return this.remove(this.get(n2));
    }

    public Object remove(Object object) {
        Entry entry = this.removeImpl(object);
        return entry == null ? null : entry.getValue();
    }

    private void removeEntry(Entry entry) {
        entry.b.a = entry.a;
        entry.a.b = entry.b;
    }

    private Entry removeImpl(Object object) {
        Entry entry = (Entry)this.entries.remove(object);
        if (entry == null) {
            return null;
        }
        ++this.modCount;
        this.removeEntry(entry);
        return entry;
    }

    public List sequence() {
        ArrayList arrayList = new ArrayList(this.size());
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public int size() {
        return this.entries.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        Entry entry = this.sentinel.b;
        while (entry != this.sentinel) {
            stringBuffer.append(entry.getKey());
            stringBuffer.append('=');
            stringBuffer.append(entry.getValue());
            if (entry.b != this.sentinel) {
                stringBuffer.append(',');
            }
            entry = entry.b;
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public Collection values() {
        return new AbstractCollection(this){
            private final SequencedHashMap this$0;
            {
                this.this$0 = sequencedHashMap;
            }

            public void clear() {
                this.this$0.clear();
            }

            public boolean contains(Object object) {
                return this.this$0.containsValue(object);
            }

            public boolean isEmpty() {
                return this.this$0.isEmpty();
            }

            public Iterator iterator() {
                return new OrderedIterator(this.this$0, 1);
            }

            public boolean remove(Object object) {
                if (object == null) {
                    Entry entry = SequencedHashMap.b((SequencedHashMap)this.this$0).b;
                    while (entry != SequencedHashMap.b(this.this$0)) {
                        if (entry.getValue() == null) {
                            SequencedHashMap.a(this.this$0, entry.getKey());
                            return true;
                        }
                        entry = entry.b;
                    }
                } else {
                    Entry entry = SequencedHashMap.b((SequencedHashMap)this.this$0).b;
                    while (entry != SequencedHashMap.b(this.this$0)) {
                        if (object.equals(entry.getValue())) {
                            SequencedHashMap.a(this.this$0, entry.getKey());
                            return true;
                        }
                        entry = entry.b;
                    }
                }
                return false;
            }

            public int size() {
                return this.this$0.size();
            }
        };
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.size());
        Entry entry = this.sentinel.b;
        while (entry != this.sentinel) {
            objectOutput.writeObject(entry.getKey());
            objectOutput.writeObject(entry.getValue());
            entry = entry.b;
        }
    }

    private static class Entry
    implements Map.Entry {
        private final Object key;
        private Object value;
        public Entry b = null;
        public Entry a = null;

        public Entry(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            if (this.getKey() == null) {
                if (entry.getKey() != null) {
                    return false;
                }
            } else {
                boolean bl2 = this.getKey().equals(entry.getKey());
                if (!bl2) return false;
            }
            if (this.getValue() == null) {
                if (entry.getValue() == null) return true;
                return false;
            }
            boolean bl3 = this.getValue().equals(entry.getValue());
            if (bl3) return true;
            return false;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public String toString() {
            return "[" + this.getKey() + "=" + this.getValue() + "]";
        }
    }

    private class OrderedIterator
    implements Iterator {
        private final SequencedHashMap this$0;
        private int returnType;
        private Entry pos;
        private transient long expectedModCount;

        public OrderedIterator(SequencedHashMap sequencedHashMap, int n2) {
            this.this$0 = sequencedHashMap;
            this.pos = SequencedHashMap.b(this.this$0);
            this.expectedModCount = SequencedHashMap.c(this.this$0);
            this.returnType = n2 | Integer.MIN_VALUE;
        }

        public boolean hasNext() {
            return this.pos.b != SequencedHashMap.b(this.this$0);
        }

        public Object next() {
            if (SequencedHashMap.c(this.this$0) != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.pos.b == SequencedHashMap.b(this.this$0)) {
                throw new NoSuchElementException();
            }
            this.returnType &= Integer.MAX_VALUE;
            this.pos = this.pos.b;
            switch (this.returnType) {
                case 0: {
                    return this.pos.getKey();
                }
                case 1: {
                    return this.pos.getValue();
                }
                case 2: {
                    return this.pos;
                }
            }
            throw new Error("bad iterator type: " + this.returnType);
        }

        public void remove() {
            if ((this.returnType & Integer.MIN_VALUE) != 0) {
                throw new IllegalStateException("remove() must follow next()");
            }
            if (SequencedHashMap.c(this.this$0) != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            SequencedHashMap.a(this.this$0, this.pos.getKey());
            ++this.expectedModCount;
            this.returnType |= Integer.MIN_VALUE;
        }
    }
}

