/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SoftRefHashMap
implements Map {
    private Map hashMap = new HashMap();

    public void clear() {
        this.getMap().clear();
    }

    public boolean containsKey(Object object) {
        return this.getMap().containsKey(object);
    }

    public boolean containsValue(Object object) {
        Collection collection = this.getMap().values();
        if (collection == null) {
            return false;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object t2;
            Reference reference = (Reference)iterator.next();
            if (reference == null || (t2 = reference.get()) != object) continue;
            return true;
        }
        return false;
    }

    public Reference createReference(Object object) {
        return new SoftReference<Object>(object);
    }

    public Set entrySet() {
        HashSet<Entry> hashSet = new HashSet<Entry>();
        if (this.size() == 0) {
            return hashSet;
        }
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            Object object = this.get(e2);
            Entry entry = new Entry(this, e2, object);
            hashSet.add(entry);
        }
        return hashSet;
    }

    public boolean equals(Object object) {
        return this.getMap().equals(object);
    }

    public Object get(Object object) {
        Reference reference = (Reference)this.getMap().get(object);
        if (reference == null) {
            return null;
        }
        return reference.get();
    }

    public Map getMap() {
        return this.hashMap;
    }

    public int hashCode() {
        return this.getMap().hashCode();
    }

    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    public Set keySet() {
        return this.getMap().keySet();
    }

    public void purge() {
        Map map = this.getMap();
        Set set = map.keySet();
        if (set == null) {
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object k2 = iterator.next();
            Reference reference = (Reference)map.get(k2);
            if (reference.get() != null) continue;
            map.remove(k2);
        }
    }

    public Object put(Object object, Object object2) {
        Reference reference = this.getMap().put(object, this.createReference(object2));
        if (reference != null) {
            return reference.get();
        }
        return null;
    }

    public void putAll(Map map) {
        if (map == null || map.size() == 0) {
            return;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k2 = iterator.next();
            this.put(k2, map.get(k2));
        }
    }

    public Object remove(Object object) {
        Reference reference = (Reference)this.getMap().remove(object);
        if (reference != null) {
            return reference.get();
        }
        return null;
    }

    public int size() {
        return this.getMap().size();
    }

    public Collection values() {
        Set set = (Set)this.getMap().values();
        TreeSet treeSet = new TreeSet();
        if (set == null) {
            return treeSet;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Reference reference = (Reference)iterator.next();
            if (reference == null) continue;
            treeSet.add(reference.get());
        }
        return treeSet;
    }

    public class Entry
    implements Map.Entry {
        private final SoftRefHashMap this$0;
        private Object key;
        private Object value;

        public Entry(SoftRefHashMap softRefHashMap, Object object, Object object2) {
            this.this$0 = softRefHashMap;
            this.key = object;
            this.value = object2;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public Object setValue(Object object) {
            this.value = object;
            this.this$0.put(this.key, object);
            return object;
        }
    }
}

