/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class StaticBucketMap
implements Map {
    private static final int DEFAULT_BUCKETS = 255;
    private Node[] m_buckets;
    private Lock[] m_locks;

    public StaticBucketMap() {
        this(255);
    }

    public StaticBucketMap(int n2) {
        int n3 = Math.max(17, n2);
        if (n3 % 2 == 0) {
            --n3;
        }
        this.m_buckets = new Node[n3];
        this.m_locks = new Lock[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.m_locks[n4] = new Lock();
            ++n4;
        }
    }

    public static Node[] b(StaticBucketMap staticBucketMap) {
        return staticBucketMap.m_buckets;
    }

    public static Lock[] a(StaticBucketMap staticBucketMap) {
        return staticBucketMap.m_locks;
    }

    public static int a(StaticBucketMap staticBucketMap, Object object) {
        return staticBucketMap.getHash(object);
    }

    public void atomic(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        this.atomic(runnable, 0);
    }

    private void atomic(Runnable runnable, int n2) {
        if (n2 >= this.m_buckets.length) {
            runnable.run();
            return;
        }
        Lock lock = this.m_locks[n2];
        synchronized (lock) {
            this.atomic(runnable, n2 + 1);
        }
    }

    public final void clear() {
        int n2 = 0;
        while (n2 < this.m_buckets.length) {
            Lock lock;
            Lock lock2 = lock = this.m_locks[n2];
            synchronized (lock2) {
                this.m_buckets[n2] = null;
                lock.size = 0;
            }
            ++n2;
        }
    }

    public boolean containsKey(Object object) {
        int n2 = this.getHash(object);
        Lock lock = this.m_locks[n2];
        synchronized (lock) {
            Node node = this.m_buckets[n2];
            while (node != null) {
                if (node.key == null || node.key != null && node.key.equals(object)) {
                    boolean bl2 = true;
                    Object var5_6 = null;
                    return bl2;
                }
                node = node.next;
            }
        }
        return false;
    }

    public boolean containsValue(Object object) {
        int n2 = 0;
        while (n2 < this.m_buckets.length) {
            Lock lock = this.m_locks[n2];
            synchronized (lock) {
                Node node = this.m_buckets[n2];
                while (node != null) {
                    if (node.value == object || node.value != null && node.value.equals(object)) {
                        boolean bl2 = true;
                        Object var5_6 = null;
                        return bl2;
                    }
                    node = node.next;
                }
            }
            ++n2;
        }
        return false;
    }

    public Set entrySet() {
        return new EntrySet(this);
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        return this.entrySet().equals(map.entrySet());
    }

    public Object get(Object object) {
        int n2 = this.getHash(object);
        Lock lock = this.m_locks[n2];
        synchronized (lock) {
            Node node = this.m_buckets[n2];
            while (node != null) {
                if (node.key == object || node.key != null && node.key.equals(object)) {
                    Object object2 = node.value;
                    Object var5_6 = null;
                    return object2;
                }
                node = node.next;
            }
        }
        return null;
    }

    private final int getHash(Object object) {
        if (object == null) {
            return 0;
        }
        int n2 = object.hashCode();
        n2 += ~(n2 << 15);
        n2 ^= n2 >>> 10;
        n2 += n2 << 3;
        n2 ^= n2 >>> 6;
        n2 += ~(n2 << 11);
        n2 ^= n2 >>> 16;
        return (n2 %= this.m_buckets.length) < 0 ? n2 * -1 : n2;
    }

    public final int hashCode() {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.m_buckets.length) {
            Lock lock = this.m_locks[n3];
            synchronized (lock) {
                Node node = this.m_buckets[n3];
                while (node != null) {
                    n2 += node.hashCode();
                    node = node.next;
                }
            }
            ++n3;
        }
        return n2;
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new KeySet(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object put(Object object, Object object2) {
        int n2 = this.getHash(object);
        Lock lock = this.m_locks[n2];
        synchronized (lock) {
            Node node = this.m_buckets[n2];
            if (node == null) {
                node = new Node(this);
                node.key = object;
                node.value = object2;
                this.m_buckets[n2] = node;
                ++this.m_locks[n2].size;
                return null;
            }
            Node node2 = node;
            while (node2 != null) {
                node = node2;
                if (node.key == object || node.key != null && node.key.equals(object)) {
                    Object object3 = node.value;
                    node.value = object2;
                    return object3;
                }
                node2 = node2.next;
            }
            Node node3 = new Node(this);
            node3.key = object;
            node3.value = object2;
            node.next = node3;
            ++this.m_locks[n2].size;
            return null;
        }
    }

    public void putAll(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k2 = iterator.next();
            this.put(k2, map.get(k2));
        }
    }

    public Object remove(Object object) {
        int n2 = this.getHash(object);
        Lock lock = this.m_locks[n2];
        synchronized (lock) {
            Node node = this.m_buckets[n2];
            Node node2 = null;
            while (node != null) {
                if (node.key == null || node.key != null && node.key.equals(object)) {
                    if (node2 == null) {
                        this.m_buckets[n2] = node.next;
                    } else {
                        node2.next = node.next;
                    }
                    --this.m_locks[n2].size;
                    Object object2 = node.value;
                    Object var5_7 = null;
                    return object2;
                }
                node2 = node;
                node = node.next;
            }
        }
        return null;
    }

    public int size() {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.m_buckets.length) {
            n2 += this.m_locks[n3].size;
            ++n3;
        }
        return n2;
    }

    public Collection values() {
        return new Values(this);
    }

    private final class Node
    implements Map.Entry {
        private final StaticBucketMap this$0;
        public Object key;
        public Object value;
        public Node next;

        public Node(StaticBucketMap staticBucketMap) {
            this.this$0 = staticBucketMap;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            if (this.key == null) {
                if (entry.getKey() != null) {
                    return false;
                }
            } else {
                boolean bl2 = this.key.equals(entry.getKey());
                if (!bl2) return false;
            }
            if (this.value == null) {
                if (entry.getValue() == null) return true;
                return false;
            }
            boolean bl3 = this.value.equals(entry.getValue());
            if (bl3) return true;
            return false;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }
    }

    private static final class Lock {
        public int size;
    }

    private class EntryIterator
    implements Iterator {
        private final StaticBucketMap this$0;
        private ArrayList current;
        private int bucket;
        private Map.Entry last;

        public EntryIterator(StaticBucketMap staticBucketMap) {
            this.this$0 = staticBucketMap;
            this.current = new ArrayList();
        }

        /*
         * Unable to fully structure code
         */
        public boolean hasNext() {
            if (this.current.size() <= 0) ** GOTO lbl21
            return true;
lbl-1000:
            // 1 sources

            {
                var2_1 = StaticBucketMap.a(this.this$0)[this.bucket];
                synchronized (var2_1) {
                    var4_2 = StaticBucketMap.b(this.this$0)[this.bucket];
                    while (var4_2 != null) {
                        this.current.add(var4_2);
                        var4_2 = var4_2.next;
                    }
                    ++this.bucket;
                    if (this.current.size() > 0) {
                        var1_3 = true;
                        var3_4 = null;
                        return var1_3;
                    }
                    continue;
                }
lbl21:
                // 2 sources

                ** while (this.bucket < StaticBucketMap.b((StaticBucketMap)this.this$0).length)
            }
lbl22:
            // 1 sources

            return false;
        }

        public Object next() {
            return this.nextEntry();
        }

        public Map.Entry nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = (Map.Entry)this.current.remove(this.current.size() - 1);
            return this.last;
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.this$0.remove(this.last.getKey());
            this.last = null;
        }
    }

    private class ValueIterator
    extends EntryIterator {
        private final StaticBucketMap this$0;

        public ValueIterator(StaticBucketMap staticBucketMap) {
            super(staticBucketMap);
            this.this$0 = staticBucketMap;
        }

        public Object next() {
            return this.nextEntry().getValue();
        }
    }

    private class KeyIterator
    extends EntryIterator {
        private final StaticBucketMap this$0;

        public KeyIterator(StaticBucketMap staticBucketMap) {
            super(staticBucketMap);
            this.this$0 = staticBucketMap;
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    private class EntrySet
    extends AbstractSet {
        private final StaticBucketMap this$0;

        public EntrySet(StaticBucketMap staticBucketMap) {
            this.this$0 = staticBucketMap;
        }

        public void clear() {
            this.this$0.clear();
        }

        public boolean contains(Object object) {
            Map.Entry entry = (Map.Entry)object;
            int n2 = StaticBucketMap.a(this.this$0, entry.getKey());
            Lock lock = StaticBucketMap.a(this.this$0)[n2];
            synchronized (lock) {
                Node node = StaticBucketMap.b(this.this$0)[n2];
                while (node != null) {
                    if (node.equals(entry)) {
                        boolean bl2 = true;
                        Object var6_7 = null;
                        return bl2;
                    }
                    node = node.next;
                }
            }
            return false;
        }

        public Iterator iterator() {
            return new EntryIterator(this.this$0);
        }

        public boolean remove(Object object) {
            Map.Entry entry = (Map.Entry)object;
            int n2 = StaticBucketMap.a(this.this$0, entry.getKey());
            Lock lock = StaticBucketMap.a(this.this$0)[n2];
            synchronized (lock) {
                Node node = StaticBucketMap.b(this.this$0)[n2];
                while (node != null) {
                    if (node.equals(entry)) {
                        this.this$0.remove(node.getKey());
                        boolean bl2 = true;
                        Object var6_7 = null;
                        return bl2;
                    }
                    node = node.next;
                }
            }
            return false;
        }

        public int size() {
            return this.this$0.size();
        }
    }

    private class KeySet
    extends AbstractSet {
        private final StaticBucketMap this$0;

        public KeySet(StaticBucketMap staticBucketMap) {
            this.this$0 = staticBucketMap;
        }

        public void clear() {
            this.this$0.clear();
        }

        public boolean contains(Object object) {
            return this.this$0.containsKey(object);
        }

        public Iterator iterator() {
            return new KeyIterator(this.this$0);
        }

        public boolean remove(Object object) {
            int n2 = StaticBucketMap.a(this.this$0, object);
            Lock lock = StaticBucketMap.a(this.this$0)[n2];
            synchronized (lock) {
                Node node = StaticBucketMap.b(this.this$0)[n2];
                while (node != null) {
                    Object object2 = node.getKey();
                    if (object2 == object || object2 != null && object2.equals(object)) {
                        this.this$0.remove(object2);
                        boolean bl2 = true;
                        Object var5_7 = null;
                        return bl2;
                    }
                    node = node.next;
                }
            }
            return false;
        }

        public int size() {
            return this.this$0.size();
        }
    }

    private class Values
    extends AbstractCollection {
        private final StaticBucketMap this$0;

        public Values(StaticBucketMap staticBucketMap) {
            this.this$0 = staticBucketMap;
        }

        public void clear() {
            this.this$0.clear();
        }

        public Iterator iterator() {
            return new ValueIterator(this.this$0);
        }

        public int size() {
            return this.this$0.size();
        }
    }
}

