/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;

public final class Jdk14Logger
implements Log {
    public Logger logger = null;

    public Jdk14Logger(String string) {
        this.logger = Logger.getLogger(string);
    }

    private void log(Level level, String string, Throwable throwable) {
        Throwable throwable2 = new Throwable();
        StackTraceElement[] stackTraceElementArray = throwable2.getStackTrace();
        String string2 = "unknown";
        String string3 = "unknown";
        if (stackTraceElementArray != null && stackTraceElementArray.length > 2) {
            StackTraceElement stackTraceElement = stackTraceElementArray[2];
            string2 = stackTraceElement.getClassName();
            string3 = stackTraceElement.getMethodName();
        }
        if (throwable == null) {
            this.logger.logp(level, string2, string3, string);
        } else {
            this.logger.logp(level, string2, string3, string, throwable);
        }
    }

    public void debug(Object object) {
        this.log(Level.FINE, String.valueOf(object), null);
    }

    public void debug(Object object, Throwable throwable) {
        this.log(Level.FINE, String.valueOf(object), throwable);
    }

    public void error(Object object) {
        this.log(Level.SEVERE, String.valueOf(object), null);
    }

    public void error(Object object, Throwable throwable) {
        this.log(Level.SEVERE, String.valueOf(object), throwable);
    }

    public void fatal(Object object) {
        this.log(Level.SEVERE, String.valueOf(object), null);
    }

    public void fatal(Object object, Throwable throwable) {
        this.log(Level.SEVERE, String.valueOf(object), throwable);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void info(Object object) {
        this.log(Level.INFO, String.valueOf(object), null);
    }

    public void info(Object object, Throwable throwable) {
        this.log(Level.INFO, String.valueOf(object), throwable);
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public boolean isFatalEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    public void trace(Object object) {
        this.log(Level.FINEST, String.valueOf(object), null);
    }

    public void trace(Object object, Throwable throwable) {
        this.log(Level.FINEST, String.valueOf(object), throwable);
    }

    public void warn(Object object) {
        this.log(Level.WARNING, String.valueOf(object), null);
    }

    public void warn(Object object, Throwable throwable) {
        this.log(Level.WARNING, String.valueOf(object), throwable);
    }
}

