/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.processor;

import java.io.IOException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.xalan.processor.StylesheetHandler;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.transformer.TrAXFilter;
import org.apache.xalan.transformer.TransformerIdentityImpl;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.ref.sax2dtm.SAX2DTM;
import org.apache.xml.utils.DOM2Helper;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.StopParseException;
import org.apache.xml.utils.StylesheetPIHandler;
import org.apache.xml.utils.SystemIDResolver;
import org.apache.xml.utils.TreeWalker;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class TransformerFactoryImpl
extends SAXTransformerFactory {
    public static final String XSLT_PROPERTIES = "org/apache/xalan/res/XSLTInfo.properties";
    public static final String FEATURE_INCREMENTAL = "http://xml.apache.org/xalan/features/incremental";
    public static final String FEATURE_OPTIMIZE = "http://xml.apache.org/xalan/features/optimize";
    public static final String FEATURE_SOURCE_LOCATION = "http://xml.apache.org/xalan/properties/source-location";
    private String m_DOMsystemID = null;
    public static boolean m_optimize = true;
    public static boolean m_source_location = false;
    public URIResolver a;
    private ErrorListener m_errorListener = new DefaultErrorHandler();

    public Templates processFromNode(Node node) throws TransformerConfigurationException {
        try {
            TemplatesHandler templatesHandler = this.newTemplatesHandler();
            TreeWalker treeWalker = new TreeWalker(templatesHandler, new DOM2Helper(), templatesHandler.getSystemId());
            treeWalker.traverse(node);
            return templatesHandler.getTemplates();
        }
        catch (SAXException sAXException) {
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(new TransformerException(sAXException));
                }
                catch (TransformerException transformerException) {
                    throw new TransformerConfigurationException(transformerException);
                }
                return null;
            }
            throw new TransformerConfigurationException(XSLMessages.createMessage("ER_PROCESSFROMNODE_FAILED", null), sAXException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw transformerConfigurationException;
        }
        catch (Exception exception) {
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(new TransformerException(exception));
                }
                catch (TransformerException transformerException) {
                    throw new TransformerConfigurationException(transformerException);
                }
                return null;
            }
            throw new TransformerConfigurationException(XSLMessages.createMessage("ER_PROCESSFROMNODE_FAILED", null), exception);
        }
    }

    public String a() {
        return this.m_DOMsystemID;
    }

    public Templates a(Node node, String string) throws TransformerConfigurationException {
        this.m_DOMsystemID = string;
        return this.processFromNode(node);
    }

    public Source getAssociatedStylesheet(Source source, String string, String string2, String string3) throws TransformerConfigurationException {
        Object object;
        block14: {
            String string4;
            InputSource inputSource = null;
            Node node = null;
            XMLReader xMLReader = null;
            if (source instanceof DOMSource) {
                object = (DOMSource)source;
                node = ((DOMSource)object).getNode();
                string4 = ((DOMSource)object).getSystemId();
            } else {
                inputSource = SAXSource.sourceToInputSource(source);
                string4 = inputSource.getSystemId();
            }
            object = new StylesheetPIHandler(string4, string, string2, string3);
            if (this.a != null) {
                ((StylesheetPIHandler)object).setURIResolver(this.a);
            }
            try {
                if (null != node) {
                    TreeWalker treeWalker = new TreeWalker((ContentHandler)object, new DOM2Helper(), string4);
                    treeWalker.traverse(node);
                    break block14;
                }
                try {
                    SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                    sAXParserFactory.setNamespaceAware(true);
                    SAXParser sAXParser = sAXParserFactory.newSAXParser();
                    xMLReader = sAXParser.getXMLReader();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new SAXException(parserConfigurationException);
                }
                catch (FactoryConfigurationError factoryConfigurationError) {
                    throw new SAXException(factoryConfigurationError.toString());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (AbstractMethodError abstractMethodError) {
                    // empty catch block
                }
                if (null == xMLReader) {
                    xMLReader = XMLReaderFactory.createXMLReader();
                }
                xMLReader.setContentHandler((ContentHandler)object);
                xMLReader.parse(inputSource);
            }
            catch (StopParseException stopParseException) {
            }
            catch (SAXException sAXException) {
                throw new TransformerConfigurationException("getAssociatedStylesheets failed", sAXException);
            }
            catch (IOException iOException) {
                throw new TransformerConfigurationException("getAssociatedStylesheets failed", iOException);
            }
        }
        return ((StylesheetPIHandler)object).getAssociatedStylesheet();
    }

    public TemplatesHandler newTemplatesHandler() throws TransformerConfigurationException {
        return new StylesheetHandler(this);
    }

    public boolean getFeature(String string) {
        if ("http://javax.xml.transform.dom.DOMResult/feature" == string || "http://javax.xml.transform.dom.DOMSource/feature" == string || "http://javax.xml.transform.sax.SAXResult/feature" == string || "http://javax.xml.transform.sax.SAXSource/feature" == string || "http://javax.xml.transform.stream.StreamResult/feature" == string || "http://javax.xml.transform.stream.StreamSource/feature" == string || "http://javax.xml.transform.sax.SAXTransformerFactory/feature" == string || "http://javax.xml.transform.sax.SAXTransformerFactory/feature/xmlfilter" == string) {
            return true;
        }
        return "http://javax.xml.transform.dom.DOMResult/feature".equals(string) || "http://javax.xml.transform.dom.DOMSource/feature".equals(string) || "http://javax.xml.transform.sax.SAXResult/feature".equals(string) || "http://javax.xml.transform.sax.SAXSource/feature".equals(string) || "http://javax.xml.transform.stream.StreamResult/feature".equals(string) || "http://javax.xml.transform.stream.StreamSource/feature".equals(string) || "http://javax.xml.transform.sax.SAXTransformerFactory/feature".equals(string) || "http://javax.xml.transform.sax.SAXTransformerFactory/feature/xmlfilter".equals(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAttribute(String string, Object object) throws IllegalArgumentException {
        if (string.equals(FEATURE_INCREMENTAL)) {
            if (object instanceof Boolean) {
                DTMManager.setIncremental((Boolean)object);
                return;
            } else {
                if (!(object instanceof String)) throw new IllegalArgumentException(XSLMessages.createMessage("ER_BAD_VALUE", new Object[]{string, object}));
                DTMManager.setIncremental(new Boolean((String)object));
            }
            return;
        } else if (string.equals(FEATURE_OPTIMIZE)) {
            if (object instanceof Boolean) {
                m_optimize = (Boolean)object;
                return;
            } else {
                if (!(object instanceof String)) throw new IllegalArgumentException(XSLMessages.createMessage("ER_BAD_VALUE", new Object[]{string, object}));
                m_optimize = new Boolean((String)object);
            }
            return;
        } else {
            if (!string.equals(FEATURE_SOURCE_LOCATION)) throw new IllegalArgumentException(XSLMessages.createMessage("ER_NOT_SUPPORTED", new Object[]{string}));
            if (object instanceof Boolean) {
                m_source_location = (Boolean)object;
                SAX2DTM.setUseSourceLocation(m_source_location);
                return;
            } else {
                if (!(object instanceof String)) throw new IllegalArgumentException(XSLMessages.createMessage("ER_BAD_VALUE", new Object[]{string, object}));
                m_source_location = new Boolean((String)object);
                SAX2DTM.setUseSourceLocation(m_source_location);
            }
        }
    }

    public Object getAttribute(String string) throws IllegalArgumentException {
        if (string.equals(FEATURE_INCREMENTAL)) {
            return new Boolean(DTMManager.getIncremental());
        }
        if (string.equals(FEATURE_OPTIMIZE)) {
            return new Boolean(m_optimize);
        }
        if (string.equals(FEATURE_SOURCE_LOCATION)) {
            return new Boolean(m_source_location);
        }
        throw new IllegalArgumentException(XSLMessages.createMessage("ER_ATTRIB_VALUE_NOT_RECOGNIZED", new Object[]{string}));
    }

    public XMLFilter newXMLFilter(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        if (templates == null) {
            return null;
        }
        return this.newXMLFilter(templates);
    }

    public XMLFilter newXMLFilter(Templates templates) throws TransformerConfigurationException {
        try {
            return new TrAXFilter(templates);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(transformerConfigurationException);
                    return null;
                }
                catch (TransformerException transformerException) {
                    new TransformerConfigurationException(transformerException);
                }
            }
            throw transformerConfigurationException;
        }
    }

    public TransformerHandler newTransformerHandler(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        if (templates == null) {
            return null;
        }
        return this.newTransformerHandler(templates);
    }

    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        try {
            TransformerImpl transformerImpl = (TransformerImpl)templates.newTransformer();
            transformerImpl.setURIResolver(this.a);
            TransformerHandler transformerHandler = (TransformerHandler)transformerImpl.getInputContentHandler(true);
            return transformerHandler;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            TransformerConfigurationException transformerConfigurationException2;
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(transformerConfigurationException);
                    return null;
                }
                catch (TransformerException transformerException) {
                    transformerConfigurationException2 = new TransformerConfigurationException(transformerException);
                }
            }
            throw transformerConfigurationException2;
        }
    }

    public TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        return new TransformerIdentityImpl();
    }

    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        try {
            Templates templates = this.newTemplates(source);
            if (templates == null) {
                return null;
            }
            Transformer transformer = templates.newTransformer();
            transformer.setURIResolver(this.a);
            return transformer;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            TransformerConfigurationException transformerConfigurationException2;
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(transformerConfigurationException);
                    return null;
                }
                catch (TransformerException transformerException) {
                    transformerConfigurationException2 = new TransformerConfigurationException(transformerException);
                }
            }
            throw transformerConfigurationException2;
        }
    }

    public Transformer newTransformer() throws TransformerConfigurationException {
        return new TransformerIdentityImpl();
    }

    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        String string = source.getSystemId();
        if (null != string) {
            string = SystemIDResolver.getAbsoluteURI(string);
        }
        if (source instanceof DOMSource) {
            DOMSource dOMSource = (DOMSource)source;
            Node node = dOMSource.getNode();
            if (null != node) {
                return this.a(node, string);
            }
            String string2 = XSLMessages.createMessage("ER_ILLEGAL_DOMSOURCE_INPUT", null);
            throw new IllegalArgumentException(string2);
        }
        TemplatesHandler templatesHandler = this.newTemplatesHandler();
        templatesHandler.setSystemId(string);
        try {
            InputSource inputSource = SAXSource.sourceToInputSource(source);
            inputSource.setSystemId(string);
            XMLReader xMLReader = null;
            if (source instanceof SAXSource) {
                xMLReader = ((SAXSource)source).getXMLReader();
            }
            if (null == xMLReader) {
                try {
                    SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                    sAXParserFactory.setNamespaceAware(true);
                    SAXParser sAXParser = sAXParserFactory.newSAXParser();
                    xMLReader = sAXParser.getXMLReader();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new SAXException(parserConfigurationException);
                }
                catch (FactoryConfigurationError factoryConfigurationError) {
                    throw new SAXException(factoryConfigurationError.toString());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (AbstractMethodError abstractMethodError) {
                    // empty catch block
                }
            }
            if (null == xMLReader) {
                xMLReader = XMLReaderFactory.createXMLReader();
            }
            xMLReader.setContentHandler(templatesHandler);
            xMLReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(new TransformerException(sAXException));
                }
                catch (TransformerException transformerException) {
                    throw new TransformerConfigurationException(transformerException);
                }
            }
            throw new TransformerConfigurationException(sAXException.getMessage(), sAXException);
        }
        catch (Exception exception) {
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(new TransformerException(exception));
                    return null;
                }
                catch (TransformerException transformerException) {
                    throw new TransformerConfigurationException(transformerException);
                }
            }
            throw new TransformerConfigurationException(exception.getMessage(), exception);
        }
        return templatesHandler.getTemplates();
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.a = uRIResolver;
    }

    public URIResolver getURIResolver() {
        return this.a;
    }

    public ErrorListener getErrorListener() {
        return this.m_errorListener;
    }

    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        if (null == errorListener) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_ERRORLISTENER", null));
        }
        this.m_errorListener = errorListener;
    }
}

